import { attach, createStore, sample } from 'effector';
import { createGate } from 'effector-react';

import { MedicalInsuranceDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';

interface DocumentId {
  id: string;
}

export const DocumentIdGate = createGate<DocumentId>();
export const dialog = createDialogApi('medical-insurance-viewer');

export const $document = createStore<MedicalInsuranceDocument | null>(null);

const getMedicalInsuranceDataFx = attach({
  effect: api.getMedicalInsuranceDataFx,
});

export const $isLoading = getMedicalInsuranceDataFx.pending;

$document.on(getMedicalInsuranceDataFx.doneData, (_, document) => document);

// get init data
sample({
  clock: DocumentIdGate.state,
  filter: (state) => Boolean(state.id),
  target: getMedicalInsuranceDataFx,
});

sample({
  clock: getMedicalInsuranceDataFx.failData,
  target: [dialog.hide, DocumentNotifier.notFound],
});
