import { attach, createEvent, sample } from 'effector';

import { NationalIdDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';
import * as viewerModel from './viewer-model';

export const dialog = createDialogApi();

export const deleteDocumentClicked = createEvent();
export const confirmDeleteDocumentClicked = createEvent();
export const abortDeleteDocumentClicked = createEvent();

const deleteNationalIdFx = attach({
  effect: api.deleteNationalIdFx,
});

export const $isNationalIdDeleting = deleteNationalIdFx.pending;

sample({
  clock: deleteDocumentClicked,
  target: dialog.show,
});

sample({
  clock: abortDeleteDocumentClicked,
  target: dialog.hide,
});

sample({
  clock: confirmDeleteDocumentClicked,
  source: viewerModel.$document,
  filter(document): document is NationalIdDocument {
    return document !== null;
  },
  fn: (document: NationalIdDocument) => ({ id: document.id }),
  target: deleteNationalIdFx,
});

sample({
  clock: deleteNationalIdFx.doneData,
  target: [dialog.hide, viewerModel.dialog.hide],
});

sample({
  clock: deleteNationalIdFx.failData,
  target: [dialog.hide, viewerModel.dialog.hide, DocumentNotifier.internal],
});
