import { BlankFieldData } from '@client/entities/document-viewer';
import { NationalIdDocument } from '@client/shared/api/graphql';

import { FieldType } from '../interface';

export interface GetBlankFieldsParams {
  document: NationalIdDocument;
  generateOnPress: (type: FieldType) => () => void;
}

export function getBlankFields({ document, generateOnPress }: GetBlankFieldsParams) {
  const blankFields: BlankFieldData[] = [];

  if (!document.docNumber) {
    blankFields.push({
      text: 'Серия и номер',
      onPress: generateOnPress('docNumber'),
    });
  }

  if (!document.lastName) {
    blankFields.push({
      text: 'Фамилия',
      onPress: generateOnPress('lastName'),
    });
  }

  if (!document.firstName) {
    blankFields.push({
      text: 'Имя',
      onPress: generateOnPress('firstName'),
    });
  }

  if (!document.middleName) {
    blankFields.push({
      text: 'Отчество',
      onPress: generateOnPress('middleName'),
    });
  }

  if (!document.birthDate) {
    blankFields.push({
      text: 'Дата рождения',
      onPress: generateOnPress('birthDate'),
    });
  }

  if (!document.gender) {
    blankFields.push({
      text: 'Пол',
      onPress: generateOnPress('gender'),
    });
  }

  if (!document.birthPlace) {
    blankFields.push({
      text: 'Место рождения',
      onPress: generateOnPress('birthPlace'),
    });
  }

  if (!document.issuedBy) {
    blankFields.push({
      text: 'Кем выдан',
      onPress: generateOnPress('issuedBy'),
    });
  }

  if (!document.issuerSubdivisionCode) {
    blankFields.push({
      text: 'Код подразделения',
      onPress: generateOnPress('issuerSubdivisionCode'),
    });
  }

  if (!document.issueDate) {
    blankFields.push({
      text: 'Дата выдачи',
      onPress: generateOnPress('issueDate'),
    });
  }

  if (!document.registrationAddress) {
    blankFields.push({
      text: 'Адрес регистрации',
      onPress: generateOnPress('registrationAddress'),
    });
  }

  return blankFields;
}
