import { attach, createEvent, sample } from 'effector';

import { createDialogApi } from '@client/shared/libs/effector-helpers';

import * as api from './api';
import { getFields } from './libs/get-fields';
import * as viewerModel from './viewer-model';

export const dialog = createDialogApi();

export const shareImage = createEvent<number>();

export const shareDocumentClicked = createEvent();
export const abortShareDocumentClicked = createEvent();
export const shareDocumentText = createEvent();
export const shareDocumentImages = createEvent();

export const $shareData = viewerModel.$document.map((val) =>
  val ? { fields: getFields(val), images: val.images } : { images: [], fields: [] },
);

const shareDocumentTextFx = attach({
  effect: api.shareDocumentTextFx,
});

const shareImagesFx = attach({
  effect: api.shareImagesFx,
});

const shareImageFx = attach({
  effect: api.shareImageFx,
});

sample({
  clock: shareDocumentClicked,
  source: $shareData,
  filter: (data) => data.images.length === 0 && data.fields.length > 0,
  fn: (data) => data.fields,
  target: shareDocumentTextFx,
});

sample({
  clock: shareDocumentClicked,
  source: $shareData,
  filter: (data) => data.images.length > 0 && data.fields.length > 0,
  target: dialog.show,
});

sample({
  clock: shareDocumentClicked,
  source: $shareData,
  filter: (data) => data.images.length > 0 && data.fields.length === 0,
  fn: (data) => data.images,
  target: shareImagesFx,
});

sample({
  clock: shareDocumentText,
  source: $shareData,
  fn: (data) => data.fields,
  target: shareDocumentTextFx,
});

sample({
  clock: shareDocumentImages,
  source: $shareData,
  fn: (data) => data.images,
  target: shareImagesFx,
});

sample({
  clock: abortShareDocumentClicked,
  target: dialog.hide,
});

sample({
  clock: shareImage,
  source: $shareData,
  fn: (data, index) => data.images[index],
  target: shareImageFx,
});
