import { attach, createStore, sample } from 'effector';
import { createGate } from 'effector-react';

import { NationalIdDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';

interface DocumentId {
  id: string;
}

export const DocumentIdGate = createGate<DocumentId>();
export const dialog = createDialogApi('passport-viewer');

export const $document = createStore<NationalIdDocument | null>(null);

const getNationalIdDataFx = attach({
  effect: api.getNationalIdDataFx,
});

export const $isLoading = getNationalIdDataFx.pending;

$document.on(getNationalIdDataFx.doneData, (_, document) => document);

// get init data
sample({
  clock: DocumentIdGate.state,
  filter: (state) => Boolean(state.id),
  target: getNationalIdDataFx,
});

sample({
  clock: getNationalIdDataFx.failData,
  target: [dialog.hide, DocumentNotifier.notFound],
});
