import { VFC, useCallback } from 'react';

import { DocumentThumb } from '@client/entities/document-thumb';
import { DocumentHorizontalLeftIcon } from '@client/shared/icons';

import { getFullName } from '../../libs/full-name';
import * as model from './viewer-model';

interface SnilsThumbProps {
  documentId: string;
  firstName?: string | null;
  lastName?: string | null;
}

export const SnilsThumb: VFC<SnilsThumbProps> = (props) => {
  const { documentId, firstName, lastName } = props;

  const handleOnDocumentPress = useCallback(() => {
    model.dialog.setParams({ id: documentId });
    model.dialog.show();
  }, [documentId]);

  // должны показывать Имя + Фамилия,
  // новую функцию не хочется писать,
  // поэтому такой "костыль"
  const fullName = getFullName({
    firstName: lastName,
    lastName: firstName,
    withPatronymic: false,
  });

  return (
    <DocumentThumb
      onPress={handleOnDocumentPress}
      color="green"
      icon={<DocumentHorizontalLeftIcon />}
    >
      <DocumentThumb.Label>СНИЛС</DocumentThumb.Label>
      <DocumentThumb.Description error={!fullName}>
        {fullName || 'Нет ФИО'}
      </DocumentThumb.Description>
    </DocumentThumb>
  );
};
