import { attach, createEvent, sample } from 'effector';

import { SnilsDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';
import * as viewerModel from './viewer-model';

export const dialog = createDialogApi();

export const deleteDocumentClicked = createEvent();
export const confirmDeleteDocumentClicked = createEvent();
export const abortDeleteDocumentClicked = createEvent();

const deleteSnilsFx = attach({
  effect: api.deleteSnilsFx,
});

export const $isSnilsDeleting = deleteSnilsFx.pending;

sample({
  clock: deleteDocumentClicked,
  target: dialog.show,
});

sample({
  clock: abortDeleteDocumentClicked,
  target: dialog.hide,
});

sample({
  clock: confirmDeleteDocumentClicked,
  source: viewerModel.$document,
  filter(document): document is SnilsDocument {
    return document !== null;
  },
  fn: (document: SnilsDocument) => ({ id: document.id }),
  target: deleteSnilsFx,
});

sample({
  clock: deleteSnilsFx.doneData,
  target: [dialog.hide, viewerModel.dialog.hide],
});

sample({
  clock: deleteSnilsFx.failData,
  target: [dialog.hide, viewerModel.dialog.hide, DocumentNotifier.internal],
});
