import { BlankFieldData } from '@client/entities/document-viewer';
import { SnilsDocument } from '@client/shared/api/graphql';

import { FieldType } from '../interface';

export interface GetBlankFieldsParams {
  document: SnilsDocument;
  generateOnPress: (type: FieldType) => () => void;
}

export function getBlankFields(params: GetBlankFieldsParams) {
  const { document, generateOnPress } = params;
  const blankFields: BlankFieldData[] = [];

  if (!document.docNumber) {
    blankFields.push({
      text: 'СНИЛС',
      onPress: generateOnPress('docNumber'),
    });
  }

  if (!document.lastName) {
    blankFields.push({
      text: 'Фамилия',
      onPress: generateOnPress('lastName'),
    });
  }

  if (!document.firstName) {
    blankFields.push({
      text: 'Имя',
      onPress: generateOnPress('firstName'),
    });
  }

  if (!document.middleName) {
    blankFields.push({
      text: 'Отчество',
      onPress: generateOnPress('middleName'),
    });
  }

  if (!document.birthDate) {
    blankFields.push({
      text: 'Дата рождения',
      onPress: generateOnPress('birthDate'),
    });
  }

  if (!document.birthPlace) {
    blankFields.push({
      text: 'Место рождения',
      onPress: generateOnPress('birthPlace'),
    });
  }

  if (!document.gender) {
    blankFields.push({
      text: 'Пол',
      onPress: generateOnPress('gender'),
    });
  }

  if (!document.issueDate) {
    blankFields.push({
      text: 'Дата регистрации',
      onPress: generateOnPress('issueDate'),
    });
  }

  return blankFields;
}
