import { DocumentGender, SnilsDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';

interface Field {
  text: string;
  label: string;
}

interface Section {
  fields: Field[];
  name: string;
}

export function splitFieldsIntoSections(document: SnilsDocument) {
  const sections: Section[] = [];

  const fullName = getFullName({
    firstName: document.firstName,
    lastName: document.lastName,
    middleName: document.middleName,
    withPatronymic: true,
  });

  {
    const fields: Field[] = [];

    if (document.docNumber) {
      fields.push({
        text: document.docNumber,
        label: 'СНИЛС',
      });
    }

    if (fullName) {
      fields.push({
        text: fullName,
        label: 'ФИО',
      });
    }

    if (document.birthDate) {
      fields.push({
        text: formatDateToNormal(document.birthDate),
        label: 'Дата рождения',
      });
    }

    if (document.birthPlace) {
      fields.push({
        text: document.birthPlace,
        label: 'Место рождения',
      });
    }

    if (document.gender) {
      fields.push({
        text: document.gender === DocumentGender.Female ? 'Женский' : 'Мужской',
        label: 'Пол',
      });
    }

    if (document.issueDate) {
      fields.push({
        text: formatDateToNormal(document.issueDate),
        label: 'Дата регистрации',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'first_section',
        fields,
      });
    }
  }

  return sections;
}
