import { SnilsDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';
import { Field } from '../types/field';

export const getFields = (doc: SnilsDocument) => {
  const fields: Field[] = [];
  const gendersMap = {
    MALE: 'Мужской',
    FEMALE: 'Женский',
  };
  const fullName = getFullName({
    firstName: doc.firstName,
    lastName: doc.lastName,
    middleName: doc.middleName,
    withPatronymic: true,
  });

  if (doc.docNumber) {
    fields.push({
      text: doc.docNumber,
      label: 'СНИЛС',
    });
  }
  if (fullName) {
    fields.push({
      text: fullName,
      label: 'ФИО',
    });
  }
  if (doc.birthDate) {
    fields.push({
      text: formatDateToNormal(doc.birthDate),
      label: 'Дата рождения',
    });
  }
  if (doc.gender) {
    fields.push({
      text: gendersMap[doc.gender],
      label: 'Пол',
    });
  }
  if (doc.issueDate) {
    fields.push({
      text: formatDateToNormal(doc.issueDate),
      label: 'Дата регистрации',
    });
  }

  return fields;
};
