import { attach, createStore, sample } from 'effector';
import { createGate } from 'effector-react';

import { SnilsDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';

interface DocumentId {
  id: string;
}

export const DocumentIdGate = createGate<DocumentId>();
export const dialog = createDialogApi('snils-viewer');

export const $document = createStore<SnilsDocument | null>(null);

const getSnilsDataFx = attach({
  effect: api.getSnilsDataFx,
});

export const $isLoading = getSnilsDataFx.pending;

$document.on(getSnilsDataFx.doneData, (_, document) => document);

// get init data
sample({
  clock: DocumentIdGate.state,
  filter: (state) => Boolean(state.id),
  target: getSnilsDataFx,
});

sample({
  clock: getSnilsDataFx.failData,
  target: [dialog.hide, DocumentNotifier.notFound],
});
