import { VFC, useCallback } from 'react';

import { DocumentThumb } from '@client/entities/document-thumb';
import { CarOutlineIcon } from '@client/shared/icons';

import * as viewerModel from './viewer-model';

interface VehicleRegistrationCertificateThumbProps {
  documentId: string;
  model?: string | null;
}

export const VehicleRegistrationCertificateThumb: VFC<VehicleRegistrationCertificateThumbProps> = (
  props,
) => {
  const { documentId, model } = props;

  const handleOnDocumentPress = useCallback(() => {
    viewerModel.dialog.setParams({ id: documentId });
    viewerModel.dialog.show();
  }, [documentId]);

  return (
    <DocumentThumb onPress={handleOnDocumentPress} color="violet" icon={<CarOutlineIcon />}>
      <DocumentThumb.Label>СТС</DocumentThumb.Label>
      <DocumentThumb.Description error={!model}>
        {model || 'Нет данных'}
      </DocumentThumb.Description>
    </DocumentThumb>
  );
};
