import { attach, createEvent, sample } from 'effector';

import { VehicleRegistrationCertificateDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';
import * as viewerModel from './viewer-model';

export const dialog = createDialogApi();

export const deleteDocumentClicked = createEvent();
export const confirmDeleteDocumentClicked = createEvent();
export const abortDeleteDocumentClicked = createEvent();

const deleteVehicleRegistrationCertificateFx = attach({
  effect: api.deleteVehicleRegistrationCertificateFx,
});

export const $isVehicleRegistrationCertificateDeleting =
  deleteVehicleRegistrationCertificateFx.pending;

sample({
  clock: deleteDocumentClicked,
  target: dialog.show,
});

sample({
  clock: abortDeleteDocumentClicked,
  target: dialog.hide,
});

sample({
  clock: confirmDeleteDocumentClicked,
  source: viewerModel.$document,
  filter(document): document is VehicleRegistrationCertificateDocument {
    return document !== null;
  },
  fn: (document: VehicleRegistrationCertificateDocument) => ({ id: document.id }),
  target: deleteVehicleRegistrationCertificateFx,
});

sample({
  clock: deleteVehicleRegistrationCertificateFx.doneData,
  target: [dialog.hide, viewerModel.dialog.hide],
});

sample({
  clock: deleteVehicleRegistrationCertificateFx.failData,
  target: [dialog.hide, viewerModel.dialog.hide, DocumentNotifier.internal],
});
