import { BlankFieldData } from '@client/entities/document-viewer';
import { VehicleRegistrationCertificateDocument } from '@client/shared/api/graphql';

import { FieldType } from '../interface';

export interface GetBlankFieldsParams {
  document: VehicleRegistrationCertificateDocument;
  generateOnPress: (type: FieldType) => () => void;
}

export function getBlankFields(params: GetBlankFieldsParams) {
  const { document, generateOnPress } = params;
  const blankFields: BlankFieldData[] = [];

  if (!document.docNumber) {
    blankFields.push({
      text: 'Серия и номер',
      onPress: generateOnPress('docNumber'),
    });
  }

  if (!document.lastName) {
    blankFields.push({
      text: 'Фамилия',
      onPress: generateOnPress('lastName'),
    });
  }

  if (!document.firstName) {
    blankFields.push({
      text: 'Имя',
      onPress: generateOnPress('firstName'),
    });
  }

  if (!document.middleName) {
    blankFields.push({
      text: 'Отчество',
      onPress: generateOnPress('middleName'),
    });
  }

  if (!document.registrationAddress) {
    blankFields.push({
      text: 'Адрес регистрации',
      onPress: generateOnPress('registrationAddress'),
    });
  }

  if (!document.issuerSubdivisionCode) {
    blankFields.push({
      text: 'Код подразделения (выдано ГИБДД)',
      onPress: generateOnPress('issuerSubdivisionCode'),
    });
  }

  if (!document.issueDate) {
    blankFields.push({
      text: 'Дата выдачи',
      onPress: generateOnPress('issueDate'),
    });
  }

  if (!document.additionalInformation) {
    blankFields.push({
      text: 'Особые отметки',
      onPress: generateOnPress('additionalInformation'),
    });
  }

  if (!document.carNumber) {
    blankFields.push({
      text: 'Регистрационный знак',
      onPress: generateOnPress('carNumber'),
    });
  }

  if (!document.vin) {
    blankFields.push({
      text: 'Идентификационный номер (VIN)',
      onPress: generateOnPress('vin'),
    });
  }

  if (!document.model && !document.modelLat) {
    blankFields.push({
      text: 'Марка, модель',
      onPress: generateOnPress('model'),
    });
  }

  if (!document.vehicleType) {
    blankFields.push({
      text: 'Тип ТС',
      onPress: generateOnPress('vehicleType'),
    });
  }

  if (!document.category) {
    blankFields.push({
      text: 'Категория ТС',
      onPress: generateOnPress('category'),
    });
  }

  if (!document.year) {
    blankFields.push({
      text: 'Год выпуска',
      onPress: generateOnPress('year'),
    });
  }

  if (!document.shasiNumber) {
    blankFields.push({
      text: 'Номер шасси (рамы)',
      onPress: generateOnPress('shasiNumber'),
    });
  }

  if (!document.bodyNumber) {
    blankFields.push({
      text: 'Номер кузова (кабины, прицепа)',
      onPress: generateOnPress('bodyNumber'),
    });
  }

  if (!document.color) {
    blankFields.push({
      text: 'Цвет',
      onPress: generateOnPress('color'),
    });
  }

  if (!document.power) {
    blankFields.push({
      text: 'Мощность двигателя, кВт/л.с.',
      onPress: generateOnPress('power'),
    });
  }

  if (!document.ecoClass) {
    blankFields.push({
      text: 'Экологический класс',
      onPress: generateOnPress('ecoClass'),
    });
  }

  if (!document.maxWeight) {
    blankFields.push({
      text: 'Разрешенная максимальная масса, кг',
      onPress: generateOnPress('maxWeight'),
    });
  }

  if (!document.withoutLoadWeight) {
    blankFields.push({
      text: 'Масса в снаряженном состоянии (без нагрузки), кг',
      onPress: generateOnPress('withoutLoadWeight'),
    });
  }

  if (!document.temporaryReg) {
    blankFields.push({
      text: 'Срок временной регистрации',
      onPress: generateOnPress('temporaryReg'),
    });
  }

  if (!document.pts) {
    blankFields.push({
      text: 'ПТС',
      onPress: generateOnPress('pts'),
    });
  }

  return blankFields;
}
