import { VehicleRegistrationCertificateDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';

interface Field {
  text: string;
  label: string;
}

interface Section {
  fields: Field[];
  name: string;
}

export function splitFieldsIntoSections(document: VehicleRegistrationCertificateDocument) {
  const sections: Section[] = [];

  const fullName = getFullName({
    firstName: document.firstName,
    lastName: document.lastName,
    middleName: document.middleName,
    withPatronymic: true,
  });

  const fullNameLat = getFullName({
    firstName: document.firstNameLat,
    lastName: document.lastNameLat,
    withPatronymic: false,
  });

  {
    const fields: Field[] = [];

    if (document.docNumber) {
      fields.push({
        text: document.docNumber,
        label: 'Серия и номер',
      });
    }

    if (fullName) {
      fields.push({
        text: fullName,
        label: 'ФИО',
      });
    }

    if (fullNameLat) {
      fields.push({
        text: fullNameLat,
        label: 'Фамилия и имя латиницей',
      });
    }

    if (document.registrationAddress) {
      fields.push({
        text: document.registrationAddress,
        label: 'Адрес регистрации',
      });
    }

    if (document.issuerSubdivisionCode) {
      fields.push({
        text: document.issuerSubdivisionCode,
        label: 'Код подразделения (выдано ГИБДД)',
      });
    }

    if (document.issueDate) {
      fields.push({
        text: formatDateToNormal(document.issueDate),
        label: 'Дата выдачи',
      });
    }

    if (document.additionalInformation) {
      fields.push({
        text: document.additionalInformation,
        label: 'Особые отметки',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'first_section',
        fields,
      });
    }
  }

  {
    const fields: Field[] = [];

    if (document.carNumber) {
      fields.push({
        text: document.carNumber,
        label: 'Регистрационный знак',
      });
    }

    if (document.vin) {
      fields.push({
        text: document.vin,
        label: 'Идентификационный номер (VIN)',
      });
    }

    if (document.model) {
      fields.push({
        text: document.model,
        label: 'Марка, модель',
      });
    }

    if (document.modelLat) {
      fields.push({
        text: document.modelLat,
        label: 'Марка, модель латиницей',
      });
    }

    if (document.vehicleType) {
      fields.push({
        text: document.vehicleType,
        label: 'Тип ТС',
      });
    }

    if (document.category) {
      fields.push({
        text: document.category,
        label: 'Категория ТС',
      });
    }

    if (document.shasiNumber) {
      fields.push({
        text: document.shasiNumber,
        label: 'Номер шасси (рамы) ',
      });
    }

    if (document.bodyNumber) {
      fields.push({
        text: document.bodyNumber,
        label: 'Номер кузова (кабины, прицепа)',
      });
    }

    if (document.color) {
      fields.push({
        text: document.color,
        label: 'Цвет',
      });
    }

    if (document.power) {
      fields.push({
        text: document.power,
        label: 'Мощность двигателя, кВт/л.с.',
      });
    }

    if (document.ecoClass) {
      fields.push({
        text: document.ecoClass,
        label: 'Экологический класс',
      });
    }

    if (document.maxWeight) {
      fields.push({
        text: document.maxWeight,
        label: 'Разрешенная максимальная масса, кг',
      });
    }

    if (document.withoutLoadWeight) {
      fields.push({
        text: document.withoutLoadWeight,
        label: 'Масса в снаряженном состоянии (без нагрузки), кг',
      });
    }

    if (document.temporaryReg) {
      fields.push({
        text: document.temporaryReg,
        label: 'Срок временной регистрации',
      });
    }

    if (document.pts) {
      fields.push({
        text: document.pts,
        label: 'ПТС',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'second_section',
        fields,
      });
    }
  }

  return sections;
}
