import { VehicleRegistrationCertificateDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';
import { Field } from '../types/field';

export const getFields = (doc: VehicleRegistrationCertificateDocument) => {
  const fields: Field[] = [];

  const fullName = getFullName({
    firstName: doc.firstName,
    lastName: doc.lastName,
    middleName: doc.middleName,
    withPatronymic: true,
  });
  const fullNameLat = getFullName({
    firstName: doc.firstNameLat,
    lastName: doc.lastNameLat,
    withPatronymic: false,
  });

  if (doc.docNumber) {
    fields.push({
      text: doc.docNumber,
      label: 'Серия и номер',
    });
  }
  if (fullName) {
    fields.push({
      text: fullName,
      label: 'ФИО',
    });
  }
  if (fullNameLat) {
    fields.push({
      text: fullNameLat,
      label: 'Фамилия и имя латиницей',
    });
  }
  if (doc.registrationAddress) {
    fields.push({
      text: doc.registrationAddress,
      label: 'Адрес регистрации',
    });
  }
  if (doc.issuerSubdivisionCode) {
    fields.push({
      text: doc.issuerSubdivisionCode,
      label: 'Код подразделения (выдано ГИБДД)',
    });
  }
  if (doc.issueDate) {
    fields.push({
      text: formatDateToNormal(doc.issueDate),
      label: 'Дата выдачи',
    });
  }
  if (doc.additionalInformation) {
    fields.push({
      text: doc.additionalInformation,
      label: 'Особые отметки',
    });
  }
  if (doc.carNumber) {
    fields.push({
      text: doc.carNumber,
      label: 'Регистрационный знак',
    });
  }
  if (doc.vin) {
    fields.push({
      text: doc.vin,
      label: 'Идентификационный номер (VIN)',
    });
  }
  if (doc.model) {
    fields.push({
      text: doc.model,
      label: 'Марка, модель',
    });
  }
  if (doc.modelLat) {
    fields.push({
      text: doc.modelLat,
      label: 'Марка, модель латиницей',
    });
  }
  if (doc.vehicleType) {
    fields.push({
      text: doc.vehicleType,
      label: 'Тип ТС',
    });
  }
  if (doc.category) {
    fields.push({
      text: doc.category,
      label: 'Категория ТС',
    });
  }
  if (doc.shasiNumber) {
    fields.push({
      text: doc.shasiNumber,
      label: 'Номер шасси (рамы) ',
    });
  }
  if (doc.bodyNumber) {
    fields.push({
      text: doc.bodyNumber,
      label: 'Номер кузова (кабины, прицепа)',
    });
  }
  if (doc.color) {
    fields.push({
      text: doc.color,
      label: 'Цвет',
    });
  }
  if (doc.power) {
    fields.push({
      text: doc.power,
      label: 'Мощность двигателя, кВт/л.с.',
    });
  }
  if (doc.ecoClass) {
    fields.push({
      text: doc.ecoClass,
      label: 'Экологический класс',
    });
  }
  if (doc.maxWeight) {
    fields.push({
      text: doc.maxWeight,
      label: 'Разрешенная максимальная масса, кг',
    });
  }
  if (doc.withoutLoadWeight) {
    fields.push({
      text: doc.withoutLoadWeight,
      label: 'Масса в снаряженном состоянии (без нагрузки), кг',
    });
  }
  if (doc.temporaryReg) {
    fields.push({
      text: doc.temporaryReg,
      label: 'Срок временной регистрации',
    });
  }
  if (doc.pts) {
    fields.push({
      text: doc.pts,
      label: 'ПТС',
    });
  }

  return fields;
};
