import { attach, createStore, sample } from 'effector';
import { createGate } from 'effector-react';

import { VehicleRegistrationCertificateDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';

interface DocumentId {
  id: string;
}

export const DocumentIdGate = createGate<DocumentId>();
export const dialog = createDialogApi('vehicle-registration-certificate-viewer');

export const $document = createStore<VehicleRegistrationCertificateDocument | null>(null);

const getVehicleRegistrationCertificateDataFx = attach({
  effect: api.getVehicleRegistrationCertificateDataFx,
});

export const $isLoading = getVehicleRegistrationCertificateDataFx.pending;

$document.on(getVehicleRegistrationCertificateDataFx.doneData, (_, document) => document);

// get init data
sample({
  clock: DocumentIdGate.state,
  filter: (state) => Boolean(state.id),
  target: getVehicleRegistrationCertificateDataFx,
});

sample({
  clock: getVehicleRegistrationCertificateDataFx.failData,
  target: [dialog.hide, DocumentNotifier.notFound],
});
