import { attach, createEvent, sample } from 'effector';

import { VoluntaryMedicalInsuranceDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';
import * as viewerModel from './viewer-model';

export const dialog = createDialogApi();

export const deleteDocumentClicked = createEvent();
export const confirmDeleteDocumentClicked = createEvent();
export const abortDeleteDocumentClicked = createEvent();

const deleteVoluntaryMedicalInsuranceFx = attach({
  effect: api.deleteVoluntaryMedicalInsuranceFx,
});

export const $isVoluntaryMedicalInsuranceDeleting = deleteVoluntaryMedicalInsuranceFx.pending;

sample({
  clock: deleteDocumentClicked,
  target: dialog.show,
});

sample({
  clock: abortDeleteDocumentClicked,
  target: dialog.hide,
});

sample({
  clock: confirmDeleteDocumentClicked,
  source: viewerModel.$document,
  filter(document): document is VoluntaryMedicalInsuranceDocument {
    return document !== null;
  },
  fn: (document: VoluntaryMedicalInsuranceDocument) => ({ id: document.id }),
  target: deleteVoluntaryMedicalInsuranceFx,
});

sample({
  clock: deleteVoluntaryMedicalInsuranceFx.doneData,
  target: [dialog.hide, viewerModel.dialog.hide],
});

sample({
  clock: deleteVoluntaryMedicalInsuranceFx.failData,
  target: [dialog.hide, viewerModel.dialog.hide, DocumentNotifier.internal],
});
