import { attach, createStore, sample } from 'effector';
import { createGate } from 'effector-react';

import { VoluntaryMedicalInsuranceDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';

interface DocumentId {
  id: string;
}

export const DocumentIdGate = createGate<DocumentId>();
export const dialog = createDialogApi('voluntary-medical-insurance-viewer');

export const $document = createStore<VoluntaryMedicalInsuranceDocument | null>(null);

const getVoluntaryMedicalInsuranceDataFx = attach({
  effect: api.getVoluntaryMedicalInsuranceDataFx,
});

export const $isLoading = getVoluntaryMedicalInsuranceDataFx.pending;

$document.on(getVoluntaryMedicalInsuranceDataFx.doneData, (_, document) => document);

// get init data
sample({
  clock: DocumentIdGate.state,
  filter: (state) => Boolean(state.id),
  target: getVoluntaryMedicalInsuranceDataFx,
});

sample({
  clock: getVoluntaryMedicalInsuranceDataFx.failData,
  target: [dialog.hide, DocumentNotifier.notFound],
});
