import { useRouter } from 'next/router';

import {
  useBillsDataQuery,
  useEdadealDataQuery,
  usePaymentsContextQuery,
} from '@client/shared/api/graphql';
import { useMappedQuery } from '@client/shared/libs/apollo';

export function useEdadealData() {
  return useMappedQuery(useEdadealDataQuery, (data) => {
    return {
      hasBinding: data.edadealData.hasBinding,
      iframeSrc: data.edadealData.iframeSrc,
      url: data.edadealData.url,
      amount: data.edadealData.amount,
    };
  });
}

export function useBillsData() {
  return useMappedQuery(useBillsDataQuery, (data) => data);
}

export function usePaymentsContext() {
  const { query } = useRouter();
  const { data, loading, error } = usePaymentsContextQuery({
    variables: { familyMode: query.family === '1' },
  });

  return {
    data: {
      services: data?.paymentsContext.services,
      plusServiceData: data?.paymentsContext.plusServiceData,
      familyData: data?.paymentsContext.familyData,
    },
    error,
    isLoading: loading,
  };
}
