import { useEffect, useState } from 'react';

import { useIdPaths } from '@client/shared/paths';

interface Props {
  url?: string;
}

export const useEdadealConnectUrl = ({ url }: Props) => {
  const [connectUrl, setConnectUrl] = useState<string | undefined>(undefined);
  const { pay } = useIdPaths();

  useEffect(() => {
    if (!url) {
      return;
    }

    const urlObject = new URL(url);

    urlObject.searchParams.append('referer', window.location.href);
    urlObject.searchParams.append('ret_path', window.location.origin + pay);

    setConnectUrl(urlObject.href);
  }, [url, pay]);

  return connectUrl;
};
