import {
  AddBillsDocumentInput,
  AddGibddDocumentDocument,
  AddGibddDocumentMutation,
  AddGibddDocumentMutationVariables,
  CreateOrderBillDocument,
  CreateOrderBillInput,
  CreateOrderBillMutation,
  CreateOrderBillMutationVariables,
  DeleteBillsDocumentInput,
  DeleteGibddDocumentDocument,
  DeleteGibddDocumentMutation,
  DeleteGibddDocumentMutationVariables,
  GetTransactionBillDocument,
  GetTransactionBillMutation,
  GetTransactionBillMutationVariables,
  GetTransactionInput,
  RestartBillsSearchDocument,
  RestartBillsSearchMutation,
  RestartBillsSearchMutationVariables,
  StartOrderBillDocument,
  StartOrderBillInput,
  StartOrderBillMutation,
  StartOrderBillMutationVariables,
  UpdateBillsDocumentInput,
  UpdateGibddDocumentDocument,
  UpdateGibddDocumentMutation,
  UpdateGibddDocumentMutationVariables,
} from '@client/shared/api/graphql';
import { getOrCreateClient } from '@client/shared/libs/apollo';

export async function addGibddDocument(input: AddBillsDocumentInput) {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<AddGibddDocumentMutation, AddGibddDocumentMutationVariables>({
    mutation: AddGibddDocumentDocument,
    variables: { input },
  });

  return Promise.resolve(result.data?.addBillsDocument);
}

export async function updateGibddDocument(input: UpdateBillsDocumentInput) {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<
    UpdateGibddDocumentMutation,
    UpdateGibddDocumentMutationVariables
  >({
    mutation: UpdateGibddDocumentDocument,
    variables: { input },
  });

  return Promise.resolve(result.data?.updateBillsDocument);
}

export async function deleteGibddDocument(input: DeleteBillsDocumentInput) {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<
    DeleteGibddDocumentMutation,
    DeleteGibddDocumentMutationVariables
  >({
    mutation: DeleteGibddDocumentDocument,
    variables: { input },
  });

  return Promise.resolve(result.data?.deleteBillsDocument);
}

export async function restartBillsSearch() {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<
    RestartBillsSearchMutation,
    RestartBillsSearchMutationVariables
  >({
    mutation: RestartBillsSearchDocument,
    variables: {},
  });

  return Promise.resolve(result.data?.restartBillsSearch);
}

export async function createOrderBill(input: CreateOrderBillInput) {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<CreateOrderBillMutation, CreateOrderBillMutationVariables>({
    mutation: CreateOrderBillDocument,
    variables: { input },
  });

  return Promise.resolve(result.data?.createOrderBill);
}

export async function startOrderBill(input: StartOrderBillInput) {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<StartOrderBillMutation, StartOrderBillMutationVariables>({
    mutation: StartOrderBillDocument,
    variables: { input },
  });

  return Promise.resolve(result.data?.startOrderBill);
}

export async function getTransaction(input: GetTransactionInput) {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<
    GetTransactionBillMutation,
    GetTransactionBillMutationVariables
  >({
    mutation: GetTransactionBillDocument,
    variables: { input },
  });

  return Promise.resolve(result.data?.getTransaction);
}
