import { GibddDataQuery } from '@client/shared/api/graphql';

export type GibddBill = GibddDataQuery['bills']['bills'][0];

export const isExpired = (bill: GibddBill) => {
  const till = bill.payment_deadline ? Date.parse(bill.payment_deadline) : 0;
  const now = Date.now();

  return now - till > 0;
};

export const getBillsSum = (bills: GibddBill[]) =>
  bills.reduce((total, bill) => total + bill.discounted_amount, 0);

export const getFee = (bills: GibddBill[]) =>
  bills.reduce((total, bill) => total + bill.fee_amount, 0);

export const getPrice = (amount: number) => amount.toFixed(2);
