import { createEvent, createStore } from 'effector';

import { BillPaymentAuth3ds } from './types';

export const $paymentState = createStore<string | null>(null);
export const $paymentId = createStore<string | null>(null);
export const $payment3ds = createStore<BillPaymentAuth3ds | null>(null);

export const waitPayment = createEvent();
export const failPayment = createEvent();
export const successPayment = createEvent();
export const cancelPayment = createEvent();
export const resetPayment = createEvent();
export const startAuth3ds = createEvent<BillPaymentAuth3ds>();

export const processPayment = createEvent<string>();

$paymentState.on(waitPayment, () => 'wait');
$paymentState.on(failPayment, () => 'fail');
$paymentState.on(successPayment, () => 'success');
$paymentState.on(cancelPayment, () => 'cancel');
$paymentState.on(startAuth3ds, () => 'auth-3ds');

$paymentId.on(processPayment, (_, id) => id);
$payment3ds.on(startAuth3ds, (_, data) => data);

$paymentId.on(resetPayment, () => null);
$paymentState.on(resetPayment, () => null);
$payment3ds.on(resetPayment, () => null);
