import { useCallback } from 'react';

import { StartOrderBillMutation } from '@client/shared/api/graphql';

import { startOrderBill } from './api/store';
import { billsPayAuthReturnUrl, billsPayTokenType } from './constants';
import { failPayment, processPayment, startAuth3ds } from './model';
import { BillPaymentAuth3ds } from './types';

function getAuth3dsData(data: StartOrderBillMutation['startOrderBill']): null | BillPaymentAuth3ds {
  const url3ds = data.transaction.acs_url;

  if (!url3ds) {
    return null;
  }

  return {
    method: 'post',
    url: url3ds,
  };
}

const getClientMpiInfo = () => {
  return {
    window_height: window.outerHeight,
    window_width: window.outerWidth,
    browser_screen_height: window.screen.height,
    browser_screen_width: window.screen.width,
    browser_color_depth: window.screen.colorDepth,
    browser_tz: String(new Date().getTimezoneOffset()),
  };
};

export const useBillsPayment = () => {
  const startPaymentFn = useCallback((id: string, paymentToken: string, userName: string) => {
    startOrderBill({
      id,
      payment_token: paymentToken,
      payer_full_name: userName,
      mpi_3ds_info: getClientMpiInfo(),
      payment_method: billsPayTokenType,
      return_url: billsPayAuthReturnUrl(),
    }).then(
      (data) => {
        if (!data) {
          return;
        }

        const auth3ds = getAuth3dsData(data);

        processPayment(data.transaction.transaction_id);

        if (auth3ds) {
          startAuth3ds(auth3ds);
        }
      },
      () => {
        failPayment();
      },
    );
  }, []);

  return {
    startPayment: startPaymentFn,
  };
};
