import { useStore } from 'effector-react';
import { useRouter } from 'next/router';
import { useEffect, useRef } from 'react';

import { TransactionStatus, useGibddDataQuery } from '@client/shared/api/graphql';

import { getTransaction } from './api/store';
import { $paymentId, failPayment, successPayment } from './model';

const PAYMENT_STATUS_POOL_INTERVAL = 5 * 1000;

export const useBillsPaymentPolling = () => {
  const router = useRouter();
  const { refetch } = useGibddDataQuery();
  const paymentId = useStore($paymentId);

  const pollStatusTimer = useRef<NodeJS.Timeout>();

  useEffect(() => {
    const stopPool = () => {
      if (pollStatusTimer.current) {
        clearTimeout(pollStatusTimer.current);
        pollStatusTimer.current = undefined;
      }
    };

    const poolPayment = () => {
      if (paymentId) {
        getTransaction({ id: paymentId }).then((data) => {
          if (data?.status === TransactionStatus.New) {
            pollStatusTimer.current = setTimeout(poolPayment, PAYMENT_STATUS_POOL_INTERVAL);
          } else if (data?.status === TransactionStatus.Paid) {
            successPayment();
            // Сделал reload потому что пока без него не получается оплатить еще штрафы без перезагрузки
            // Нужно покопать и понять почему кнопка yandex pay не обновляется
            router.reload();
          } else {
            failPayment();
          }
        });
      } else {
        stopPool();
      }
    };

    if (paymentId) {
      poolPayment();
    }

    return stopPool;
  }, [paymentId, refetch, router]);
};
