import { createEffect, createEvent, forward } from 'effector';

import { createDialogApi } from '@client/shared/libs/effector-helpers';
import { Rect } from '@client/shared/ui-kit';

export const { show, hide, $isVisible } = createDialogApi();
export const cropAvatar = createEvent<{ image: HTMLImageElement; rect: Rect; type?: string }>();

export const cropAvatarFx = createEffect(
  (params: { image: HTMLImageElement; rect: Rect; type?: string }) => {
    const { image, rect, type } = params;
    const canvas = document.createElement('canvas');

    canvas.width = rect.width;
    canvas.height = rect.height;
    const ctx = canvas.getContext('2d');

    if (!ctx) {
      return null;
    }

    ctx.drawImage(
      image,
      rect.left,
      rect.top,
      rect.width,
      rect.height,
      0,
      0,
      rect.width,
      rect.height,
    );

    return new Promise<Blob>(async (resolve) => {
      canvas.toBlob((blob) => {
        resolve(blob ?? new Blob());
      }, type);
    });
  },
);

forward({ from: cropAvatar, to: cropAvatarFx });
forward({ from: cropAvatarFx.doneData, to: hide });
