import { createNotifier } from '@client/shared/libs/notifications';

import { i18n } from './i18n';

const notifier = createNotifier();

export const avatarSizeError = notifier.error.prepend(() => {
  return i18n('Загрузите картинку не меньше 200x200px', {
    context: 'Текст ошибки, если пользователь загрузил аватарку слишком низкого разрешения',
  });
});

export const avatarFileSizeError = notifier.error.prepend(() => {
  return i18n('Размер картинки не может превышать 7МБ', {
    context: 'Текст ошибки, если пользователь загрузил аватарку слишком большого размера',
  });
});

export const personalDataError = notifier.error.prepend(() => {
  return i18n('Произошла ошибка при обновлении персональных данных, повторите ваш запрос позже.', {
    context: 'Текст ошибки, если произошла ошибка при обновлении персональных данных',
  });
});

export const deleteAvatarError = notifier.error.prepend(() => {
  return i18n('Произошла ошибка при удалении аватарки, повторите ваш запрос позже.', {
    context: 'Текст ошибки, если произошла ошибка при удалении аватарки',
  });
});
