import { VFC, useCallback } from 'react';

import { usePersonalPublicIdQuery } from '@client/shared/api/graphql';
import { Link } from '@client/shared/icons';
import { logProps } from '@client/shared/libs/metrika';
import { ListItemAction } from '@client/shared/ui-kit';

import { PublicIdModal } from './PublicIdModal';
import { i18n } from './i18n';
import * as model from './model';

export const PublicIdListItem: VFC = () => {
  const { data, loading: isLoading } = usePersonalPublicIdQuery();

  const hasPublicId = data?.viewer.hasPublicIdSet;
  const publicId = data?.viewer.publicId;

  const handleOnPress = useCallback(() => {
    model.show();
  }, []);

  if (isLoading) {
    return null;
  }

  return (
    <>
      <ListItemAction
        {...logProps('listitem-link.public-id')}
        type={hasPublicId ? 'link' : 'add'}
        icon={<Link />}
        text={hasPublicId ? i18n('Публичный адрес') : i18n('Добавить публичный адрес')}
        description={hasPublicId ? `.../${publicId}` : i18n('Для ваших страниц в Яндексе')}
        onPress={handleOnPress}
      />
      <PublicIdModal />
    </>
  );
};
