import {
  PersonalPublicIdDocument,
  PersonalPublicIdQuery,
  PersonalPublicIdQueryVariables,
  PublicIdSuggestDocument,
  PublicIdSuggestInput,
  PublicIdSuggestMutation,
  PublicIdSuggestMutationVariables,
  PublicIdUpdateDocument,
  PublicIdUpdateInput,
  PublicIdUpdateMutation,
  PublicIdUpdateMutationVariables,
  PublicIdValidateDocument,
  PublicIdValidateInput,
  PublicIdValidateMutation,
  PublicIdValidateMutationVariables,
} from '@client/shared/api/graphql';
import { getOrCreateClient } from '@client/shared/libs/apollo';

export const validatePublicId = async (input: PublicIdValidateInput, abort?: AbortSignal) => {
  const apollo = getOrCreateClient();

  const result = await apollo.mutate<PublicIdValidateMutation, PublicIdValidateMutationVariables>({
    mutation: PublicIdValidateDocument,
    variables: { input },
    context: { fetchOptions: { signal: abort } },
  });

  if (result.data?.validatePublicId.__typename === 'PublicIdValidateProblem') {
    return result.data.validatePublicId.reason;
  }

  return 'ok';
};

export const updatePublicId = async (input: PublicIdUpdateInput) => {
  const apollo = getOrCreateClient();

  const result = await apollo.mutate<PublicIdUpdateMutation, PublicIdUpdateMutationVariables>({
    mutation: PublicIdUpdateDocument,
    variables: { input },
  });

  if (result.data?.updatePublicId.__typename === 'PublicIdUpdateProblem') {
    return result.data.updatePublicId.reason;
  }

  return 'ok';
};

export const suggestPublicId = async (input: PublicIdSuggestInput) => {
  const apollo = getOrCreateClient();

  const result = await apollo.mutate<PublicIdSuggestMutation, PublicIdSuggestMutationVariables>({
    mutation: PublicIdSuggestDocument,
    variables: { input },
  });

  switch (result.data?.suggestPublicId.__typename) {
    case 'PublicIdSuggestProblem':
      return [];
    case 'PublicIdSuggestPayload':
      return result.data.suggestPublicId.logins;
    default:
      return [];
  }
};

export const getViewerData = async () => {
  const apollo = getOrCreateClient();

  const result = await apollo.query<PersonalPublicIdQuery, PersonalPublicIdQueryVariables>({
    query: PersonalPublicIdDocument,
  });

  return result.data;
};
