import { VFC, useEffect, useRef, useState } from 'react';

import { FormState } from '@client/shared/libs/effector-forms';
import { Modal } from '@client/shared/ui-kit';

import {
  PhoneBinding,
  PhoneBindingFormData,
  PhoneBindingPayload,
  SmsCodeConfirmation,
  SmsCodeConfirmationFormData,
} from './ui';

import styles from './BindPrimaryPhone.module.css';

export interface BindPrimaryPhonePayload {
  trackId: string;
}

export interface BindPrimaryPhoneProps {
  visible?: boolean;
  onCompleted: (payload: BindPrimaryPhonePayload) => void;
  onClose?: () => void;
}

export const BindPrimaryPhone: VFC<BindPrimaryPhoneProps> = (props) => {
  const { visible, onClose, onCompleted } = props;
  const [data, setData] = useState<PhoneBindingPayload | null>(null);
  const phoneBindingRef = useRef<FormState<PhoneBindingFormData>>(null);
  const smsCodeRef = useRef<FormState<SmsCodeConfirmationFormData>>(null);

  useEffect(() => {
    if (!visible) {
      return;
    }

    const phoneForm = phoneBindingRef.current;
    const codeForm = phoneBindingRef.current;

    return () => {
      setData(null);
      phoneForm?.reset();
      codeForm?.reset();
    };
  }, [visible]);

  return (
    <Modal visible={visible} onClose={onClose}>
      <div className={styles.content}>
        {data ? (
          <SmsCodeConfirmation formRef={smsCodeRef} {...data} onCompleted={onCompleted} />
        ) : (
          <PhoneBinding formRef={phoneBindingRef} onCompleted={setData} />
        )}
      </div>
    </Modal>
  );
};
