import { createNotifier } from '@client/shared/libs/notifications';

import { i18n } from './i18n';

const notifier = createNotifier();

export const BindPrimaryPhoneNotifier = {
  hide: notifier.hide,
  smsLimitExceeded: notifier.error.prepend(() => {
    return i18n('Отправили слишком много смс, попробуйте ещё раз позже');
  }),
  confirmationsLimitExceeded: notifier.error.prepend(() => {
    return i18n('Закончился лимит смс, попробуйте ещё раз позже');
  }),
  internal: notifier.error.prepend(() => {
    return i18n('Что-то пошло не так, попробуйте ещё раз позже');
  }),
  codeNotSent: notifier.error.prepend(() => {
    return i18n('Не удалось отправить код, попробуйте ещё раз');
  }),
  phoneNumberBlocked: notifier.error.prepend(() => {
    return i18n('Нельзя использовать этот номер');
  }),
};
