import { VFC, useEffect, useRef, useState } from 'react';

import { FormState } from '@client/shared/libs/effector-forms';
import { Dialog, Modal } from '@client/shared/ui-kit';

import {
  PhoneConfirmation,
  PhoneConfirmationPayload,
  SmsCodeConfirmation,
  SmsCodeConfirmationFormData,
} from './ui';

import styles from './ConfirmBySms.module.css';

export interface ConfirmPhoneBySmsPayload {
  trackId: string;
}

export interface ConfirmPhoneBySmsProps {
  number: string;
  visible?: boolean;
  onClose: () => void;
  onCompleted: (payload: ConfirmPhoneBySmsPayload) => void;
}

export const ConfirmPhoneBySms: VFC<ConfirmPhoneBySmsProps> = (props) => {
  const { visible, number, onClose, onCompleted } = props;
  const [data, setData] = useState<PhoneConfirmationPayload | null>(null);
  const smsCodeRef = useRef<FormState<SmsCodeConfirmationFormData>>(null);

  useEffect(() => {
    if (!visible) {
      return;
    }

    const smsCodeForm = smsCodeRef.current;

    return () => {
      setData(null);

      smsCodeForm?.reset();
    };
  }, [visible]);

  if (data) {
    return (
      <Modal visible={visible} onClose={onClose}>
        <div className={styles.content}>
          <SmsCodeConfirmation formRef={smsCodeRef} {...data} onCompleted={onCompleted} />
        </div>
      </Modal>
    );
  }

  return (
    <Dialog visible={visible} onClose={onClose}>
      <div className={styles.content}>
        <PhoneConfirmation number={number} onCompleted={setData} onClose={onClose} />
      </div>
    </Dialog>
  );
};
