import { VFC, useCallback } from 'react';

import phoneFilledImageSrc from '@client/shared/assets/phone-filled.png';
import { Button, CardTemplate, ImageIcon, Text } from '@client/shared/ui-kit';

import { i18n } from './i18n';
import { PhoneConfirmationFormEvent, PhoneConfirmationFormEventType } from './types';

export interface PhoneConfirmationFormProps {
  number: string;
  loading?: boolean;
  onAction: (event: PhoneConfirmationFormEvent) => void;
}

export const PhoneConfirmationForm: VFC<PhoneConfirmationFormProps> = (props) => {
  const { number, loading, onAction } = props;

  const handleSendCode = useCallback(() => {
    onAction({ type: PhoneConfirmationFormEventType.SEND_CODE });
  }, [onAction]);

  const handleCancel = useCallback(() => {
    onAction({ type: PhoneConfirmationFormEventType.CANCEL });
  }, [onAction]);

  return (
    <CardTemplate>
      <CardTemplate.Media>
        <ImageIcon src={phoneFilledImageSrc} size={120} />
      </CardTemplate.Media>
      <CardTemplate.Content>
        <Text variant="text-l-long">
          {i18n('Для подтверждения мы пришлём смс с кодом на этот номер:')}
        </Text>
        <Text variant="heading-l" weight="bold">
          {number}
        </Text>
      </CardTemplate.Content>
      <CardTemplate.Actions>
        <Button variant="action" size="xl" onPress={handleSendCode} disabled={loading}>
          {i18n('Отправить смс')}
        </Button>
        <Button variant="clear" size="xl" onPress={handleCancel}>
          {i18n('Оставить всё как есть')}
        </Button>
      </CardTemplate.Actions>
    </CardTemplate>
  );
};
