import { useEvent, useStore } from 'effector-react';
import { FC, useEffect, useState } from 'react';

import { useClientHeight } from '@client/shared/libs/use-client-height';
import { Modal, Spinner } from '@client/shared/ui-kit';

import * as model from '../../model';

import styles from './SplitDialog.module.css';

export interface SplitDialogProps {
  url: string;
}

export const SplitDialog: FC<SplitDialogProps> = (props) => {
  const { url } = props;
  const isVisible = useStore(model.$isVisible);
  const hide = useEvent(model.hide);
  const [isLoading, setIsLoading] = useState(true);
  const [iframeHeight, setIframeHeight] = useState(0);
  const clientHeight = useClientHeight();

  useEffect(() => {
    const handler = (event: MessageEvent) => {
      if (event.data.type === 'bnpl-payment-cancelled') {
        hide();
      }

      if (event.data.type === 'bnpl-loaded') {
        setIsLoading(false);
      }

      if (event.data.type === 'bnpl-resize') {
        setIframeHeight(event.data.height);
      }
    };

    window.addEventListener('message', handler);

    return () => window.removeEventListener('message', handler);
  }, [hide]);

  return (
    <Modal visible={isVisible} hasClose={false} className={styles.root} onClose={hide}>
      {isLoading && <Spinner size={36} className={styles.loader} />}
      <iframe
        src={url}
        className={styles.content}
        style={{
          height: iframeHeight || '80vh',
          maxHeight: clientHeight ? `${clientHeight - 32}px` : clientHeight,
        }}
      />{' '}
      {/* 32px это верхний паддинг     */}
    </Modal>
  );
};
