import { gql } from '@apollo/client';
import * as Apollo from '@apollo/client';
import { FieldPolicy, FieldReadFunction, TypePolicies, TypePolicy } from '@apollo/client/cache';

export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
const defaultOptions = {} as const;

/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string;
  String: string;
  Boolean: boolean;
  Int: number;
  Float: number;
  /** `Date` type as integer. Type represents date and time as number of milliseconds from start of UNIX epoch. */
  Timestamp: number;
};

export type Account = {
  __typename?: 'Account';
  authType?: Maybe<AuthType>;
  canLoginWithQR: Scalars['Boolean'];
  emails: Array<Email>;
  id: Scalars['ID'];
  passwordInfo?: Maybe<PasswordInfo>;
  phones: Array<Phone>;
  publicId: Scalars['String'];
  question?: Maybe<Question>;
  type: AccountType;
};

export type AccountBindBankCardInput = {
  domainSfx: Scalars['String'];
  lang: Scalars['String'];
  returnPath: Scalars['String'];
  templateTag: Scalars['String'];
  trackId: Scalars['String'];
};

export type AccountCreateBindBankCardResponse = {
  __typename?: 'AccountCreateBindBankCardResponse';
  status: Scalars['String'];
  url?: Maybe<Scalars['String']>;
};

export enum AccountType {
  Federal = 'FEDERAL',
  Kiddish = 'KIDDISH',
  Kinopoisk = 'KINOPOISK',
  Kolonkish = 'KOLONKISH',
  Lite = 'LITE',
  Mailish = 'MAILISH',
  Neophonish = 'NEOPHONISH',
  Normal = 'NORMAL',
  Pdd = 'PDD',
  Phonish = 'PHONISH',
  Scholar = 'SCHOLAR',
  Social = 'SOCIAL',
  Superlite = 'SUPERLITE',
  Uber = 'UBER',
  Yambot = 'YAMBOT',
}

export type AccountUnbindBankdCardResponse = {
  __typename?: 'AccountUnbindBankdCardResponse';
  status: Scalars['String'];
};

export type AddBillsDocumentInput = {
  title: Scalars['String'];
  type: Scalars['String'];
  value: Scalars['String'];
};

export type AddBirthCertificateInput = {
  birthAkt?: InputMaybe<Scalars['String']>;
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  fatherBirthDate?: InputMaybe<Scalars['String']>;
  fatherCitizenship?: InputMaybe<Scalars['String']>;
  fatherFirstName?: InputMaybe<Scalars['String']>;
  fatherLastName?: InputMaybe<Scalars['String']>;
  fatherMiddleName?: InputMaybe<Scalars['String']>;
  fatherNationality?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuePlace?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  motherBirthDate?: InputMaybe<Scalars['String']>;
  motherCitizenship?: InputMaybe<Scalars['String']>;
  motherFirstName?: InputMaybe<Scalars['String']>;
  motherLastName?: InputMaybe<Scalars['String']>;
  motherMiddleName?: InputMaybe<Scalars['String']>;
  motherNationality?: InputMaybe<Scalars['String']>;
  registrationPlace?: InputMaybe<Scalars['String']>;
  series?: InputMaybe<Scalars['String']>;
};

export type AddDocumentInput = {
  birthCertificateInput?: InputMaybe<AddBirthCertificateInput>;
  driverLicenseInput?: InputMaybe<AddDriverLicenseInput>;
  innInput?: InputMaybe<AddInnInput>;
  internationalIdInput?: InputMaybe<AddInternationalIdInput>;
  medicalInsuranceInput?: InputMaybe<AddMedicalInsuranceInput>;
  nationalIdInput?: InputMaybe<AddNationalIdInput>;
  snilsInput?: InputMaybe<AddSnilsInput>;
  type: DocumentType;
  vehicleRegistrationCertificateInput?: InputMaybe<AddVehicleRegistrationCertificateInput>;
  voluntaryMedicalInsuranceInput?: InputMaybe<AddVoluntaryMedicalInsuranceInput>;
};

export type AddDocumentPayload = {
  __typename?: 'AddDocumentPayload';
  query: Query;
};

export type AddDocumentProblem = {
  __typename?: 'AddDocumentProblem';
  reason: AddDocumentProblemReason;
};

export enum AddDocumentProblemReason {
  Internal = 'INTERNAL',
}

export type AddDocumentResult = AddDocumentPayload | AddDocumentProblem;

export type AddDriverLicenseInput = {
  additionalInformation?: InputMaybe<Scalars['String']>;
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  birthPlaceLat?: InputMaybe<Scalars['String']>;
  category?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  endDate?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  firstNameLat?: InputMaybe<Scalars['String']>;
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuedBy?: InputMaybe<Scalars['String']>;
  issuedByLat?: InputMaybe<Scalars['String']>;
  issuedCity?: InputMaybe<Scalars['String']>;
  issuedCityLat?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  lastNameLat?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  middleNameLat?: InputMaybe<Scalars['String']>;
};

export type AddInnInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuedBy?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
};

export type AddInternationalIdInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  birthPlaceLat?: InputMaybe<Scalars['String']>;
  citizenship?: InputMaybe<Scalars['String']>;
  citizenshipLat?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  endDate?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  firstNameLat?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuedBy?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  lastNameLat?: InputMaybe<Scalars['String']>;
};

export type AddMedicalInsuranceInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  blank?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  images: Array<DocumentImageInput>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
};

export type AddNationalIdInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuedBy?: InputMaybe<Scalars['String']>;
  issuerSubdivisionCode?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  registrationAddress?: InputMaybe<Scalars['String']>;
};

export type AddRecoveryEmailInput = {
  email: Scalars['String'];
  redirectUrl: Scalars['String'];
  trackId?: InputMaybe<Scalars['String']>;
  validationUrl: Scalars['String'];
};

export type AddRecoveryEmailPayload = {
  __typename?: 'AddRecoveryEmailPayload';
  query: Query;
  trackId: Scalars['String'];
};

export type AddRecoveryEmailProblem = {
  __typename?: 'AddRecoveryEmailProblem';
  reason: AddRecoveryEmailProblemKind;
  trackId: Scalars['String'];
};

export enum AddRecoveryEmailProblemKind {
  AlreadyConfirmed = 'ALREADY_CONFIRMED',
  EmailInvalid = 'EMAIL_INVALID',
  Internal = 'INTERNAL',
  IsNative = 'IS_NATIVE',
  PasswordRequired = 'PASSWORD_REQUIRED',
  TooManyRequests = 'TOO_MANY_REQUESTS',
}

export type AddRecoveryEmailResult = AddRecoveryEmailPayload | AddRecoveryEmailProblem;

export type AddSnilsInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
};

export type AddVehicleRegistrationCertificateInput = {
  additionalInformation?: InputMaybe<Scalars['String']>;
  bodyNumber?: InputMaybe<Scalars['String']>;
  carNumber?: InputMaybe<Scalars['String']>;
  category?: InputMaybe<Scalars['String']>;
  color?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  ecoClass?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  firstNameLat?: InputMaybe<Scalars['String']>;
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuerSubdivisionCode?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  lastNameLat?: InputMaybe<Scalars['String']>;
  maxWeight?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  model?: InputMaybe<Scalars['String']>;
  modelLat?: InputMaybe<Scalars['String']>;
  power?: InputMaybe<Scalars['String']>;
  pts?: InputMaybe<Scalars['String']>;
  registrationAddress?: InputMaybe<Scalars['String']>;
  shasiNumber?: InputMaybe<Scalars['String']>;
  temporaryReg?: InputMaybe<Scalars['String']>;
  vehicleType?: InputMaybe<Scalars['String']>;
  vin?: InputMaybe<Scalars['String']>;
  withoutLoadWeight?: InputMaybe<Scalars['String']>;
  year?: InputMaybe<Scalars['String']>;
};

export type AddVoluntaryMedicalInsuranceInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  endDate?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  images: Array<DocumentImageInput>;
  insurerOrg?: InputMaybe<Scalars['String']>;
  issueDate?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
};

export type Address = {
  __typename?: 'Address';
  comment?: Maybe<Scalars['String']>;
  entrance?: Maybe<Scalars['String']>;
  floor?: Maybe<Scalars['String']>;
  fullText?: Maybe<Scalars['String']>;
  id: Scalars['String'];
  intercom?: Maybe<Scalars['String']>;
  previewUrl: Scalars['String'];
  region?: Maybe<Scalars['String']>;
  room?: Maybe<Scalars['String']>;
  shortText: Scalars['String'];
  street?: Maybe<Scalars['String']>;
  type: AddressType;
};

export enum AddressType {
  Home = 'Home',
  Other = 'Other',
  Work = 'Work',
}

export enum AuthType {
  PasswordAndSms = 'PASSWORD_AND_SMS',
  PasswordOnly = 'PASSWORD_ONLY',
  SmsOnly = 'SMS_ONLY',
  YandexKey = 'YANDEX_KEY',
}

export type AvailableQuestion = {
  __typename?: 'AvailableQuestion';
  id: Scalars['ID'];
  text: Scalars['String'];
};

export type BankCard = {
  __typename?: 'BankCard';
  cardId: Scalars['String'];
  familyAdminUid?: Maybe<Scalars['Int']>;
  id: Scalars['String'];
  isFamilyCard?: Maybe<Scalars['Boolean']>;
  name: Scalars['String'];
  number: Scalars['String'];
  proto: Scalars['String'];
  system: Scalars['String'];
};

export type BankCardsData = {
  __typename?: 'BankCardsData';
  cards: Array<BankCard>;
  status: Scalars['String'];
  trackId: Scalars['String'];
};

export type Bill = {
  __typename?: 'Bill';
  account_number?: Maybe<Scalars['String']>;
  amount: Scalars['Float'];
  amount_to_pay: Scalars['Float'];
  bik?: Maybe<Scalars['String']>;
  bill_date: Scalars['String'];
  bill_id: Scalars['String'];
  dep_type: Scalars['String'];
  discount_date: Scalars['String'];
  discount_size: Scalars['String'];
  discounted_amount: Scalars['Float'];
  div_id: Scalars['Int'];
  document_id: Scalars['String'];
  fee_amount: Scalars['Float'];
  inn?: Maybe<Scalars['String']>;
  kbk: Scalars['String'];
  kpp?: Maybe<Scalars['String']>;
  legal_act?: Maybe<Scalars['String']>;
  offense_date?: Maybe<Scalars['String']>;
  offense_name?: Maybe<Scalars['String']>;
  offense_place?: Maybe<Scalars['String']>;
  oktmo?: Maybe<Scalars['String']>;
  paid_amount?: Maybe<Scalars['Float']>;
  paid_date?: Maybe<Scalars['String']>;
  payee_name?: Maybe<Scalars['String']>;
  payer_name?: Maybe<Scalars['String']>;
  payment_deadline: Scalars['String'];
  purpose?: Maybe<Scalars['String']>;
  status: Scalars['String'];
  supplier_bill_id: Scalars['String'];
  treasure_branch: Scalars['String'];
  uid?: Maybe<Scalars['Int']>;
};

export type BillTransactionResponse = {
  __typename?: 'BillTransactionResponse';
  status: TransactionStatus;
  transaction_id: Scalars['String'];
};

export type BillsData = {
  __typename?: 'BillsData';
  bills: Array<Bill>;
  state: Scalars['String'];
};

export type BillsDocument = {
  __typename?: 'BillsDocument';
  created: Scalars['String'];
  document_id: Scalars['String'];
  title: Scalars['String'];
  type: BillsDocumentType;
  updated: Scalars['String'];
  value: Scalars['String'];
};

export enum BillsDocumentType {
  DriverLicense = 'DRIVER_LICENSE',
  VehicleRegistrationCertificate = 'VEHICLE_REGISTRATION_CERTIFICATE',
}

export enum BillsStatus {
  Completed = 'completed',
  Syncing = 'syncing',
  Unregistered = 'unregistered',
}

export type BirthCertificateDocument = IDocument & {
  __typename?: 'BirthCertificateDocument';
  birthAkt?: Maybe<Scalars['String']>;
  birthDate?: Maybe<Scalars['String']>;
  birthPlace?: Maybe<Scalars['String']>;
  docNumber?: Maybe<Scalars['String']>;
  fatherBirthDate?: Maybe<Scalars['String']>;
  fatherCitizenship?: Maybe<Scalars['String']>;
  fatherFirstName?: Maybe<Scalars['String']>;
  fatherLastName?: Maybe<Scalars['String']>;
  fatherMiddleName?: Maybe<Scalars['String']>;
  fatherNationality?: Maybe<Scalars['String']>;
  firstName?: Maybe<Scalars['String']>;
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  issueDate?: Maybe<Scalars['String']>;
  issuePlace?: Maybe<Scalars['String']>;
  lastName?: Maybe<Scalars['String']>;
  middleName?: Maybe<Scalars['String']>;
  motherBirthDate?: Maybe<Scalars['String']>;
  motherCitizenship?: Maybe<Scalars['String']>;
  motherFirstName?: Maybe<Scalars['String']>;
  motherLastName?: Maybe<Scalars['String']>;
  motherMiddleName?: Maybe<Scalars['String']>;
  motherNationality?: Maybe<Scalars['String']>;
  originalUrl?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  registrationPlace?: Maybe<Scalars['String']>;
  section: DocumentSection;
  series?: Maybe<Scalars['String']>;
  type: DocumentType;
  verificationStatus?: Maybe<Scalars['String']>;
};

export type CardInfo = {
  __typename?: 'CardInfo';
  bound: Scalars['Boolean'];
  cardId: Scalars['String'];
  currency: Scalars['String'];
  maskedNumber: Scalars['String'];
  paySystem: Scalars['String'];
};

export type ClientMpiInfoInput = {
  browser_color_depth: Scalars['Int'];
  browser_screen_height: Scalars['Int'];
  browser_screen_width: Scalars['Int'];
  browser_tz: Scalars['String'];
  window_height: Scalars['Int'];
  window_width: Scalars['Int'];
};

export type ConfirmByPasswordInput = {
  password: Scalars['String'];
  trackId: Scalars['String'];
};

export type ConfirmByPasswordPayload = {
  __typename?: 'ConfirmByPasswordPayload';
  successful: Scalars['Boolean'];
};

export type ConfirmByPasswordProblem = {
  __typename?: 'ConfirmByPasswordProblem';
  raw: Scalars['String'];
  reason: ConfirmByPasswordProblemKind;
};

export enum ConfirmByPasswordProblemKind {
  CaptchaRequired = 'CAPTCHA_REQUIRED',
  Internal = 'INTERNAL',
  PasswordNotMatched = 'PASSWORD_NOT_MATCHED',
}

export type ConfirmByPasswordResult = ConfirmByPasswordPayload | ConfirmByPasswordProblem;

export type ConfirmRecoveryEmailByCodeInput = {
  code: Scalars['String'];
  trackId: Scalars['String'];
};

export type ConfirmRecoveryEmailByCodePayload = {
  __typename?: 'ConfirmRecoveryEmailByCodePayload';
  query: Query;
};

export type ConfirmRecoveryEmailByCodeProblem = {
  __typename?: 'ConfirmRecoveryEmailByCodeProblem';
  reason: ConfirmRecoveryEmailByCodeProblemKind;
};

export enum ConfirmRecoveryEmailByCodeProblemKind {
  AlreadyConfirmed = 'ALREADY_CONFIRMED',
  IncorrectKey = 'INCORRECT_KEY',
  Internal = 'INTERNAL',
  KeyCheckLimitExceeded = 'KEY_CHECK_LIMIT_EXCEEDED',
}

export type ConfirmRecoveryEmailByCodeResult =
  | ConfirmRecoveryEmailByCodePayload
  | ConfirmRecoveryEmailByCodeProblem;

export type ConfirmRecoveryEmailByLinkInput = {
  code: Scalars['String'];
};

export type ConfirmRecoveryEmailByLinkPayload = {
  __typename?: 'ConfirmRecoveryEmailByLinkPayload';
  query: Query;
};

export type ConfirmRecoveryEmailByLinkProblem = {
  __typename?: 'ConfirmRecoveryEmailByLinkProblem';
  reason: ConfirmRecoveryEmailByLinkProblemKind;
};

export enum ConfirmRecoveryEmailByLinkProblemKind {
  AlreadyConfirmed = 'ALREADY_CONFIRMED',
  IncorrectKey = 'INCORRECT_KEY',
  Internal = 'INTERNAL',
}

export type ConfirmRecoveryEmailByLinkResult =
  | ConfirmRecoveryEmailByLinkPayload
  | ConfirmRecoveryEmailByLinkProblem;

export type CopyDocumentsFromDiskInput = {
  paths: Array<Scalars['String']>;
};

export type CopyDocumentsFromDiskPayload = {
  __typename?: 'CopyDocumentsFromDiskPayload';
  query: Query;
};

export type CountryOption = {
  __typename?: 'CountryOption';
  code: Scalars['String'];
  name: Scalars['String'];
};

export type CreateOrUpdateAddressInput = {
  comment?: InputMaybe<Scalars['String']>;
  entrance?: InputMaybe<Scalars['String']>;
  floor?: InputMaybe<Scalars['String']>;
  fullText: Scalars['String'];
  id?: InputMaybe<Scalars['ID']>;
  intercom?: InputMaybe<Scalars['String']>;
  room?: InputMaybe<Scalars['String']>;
  type: AddressType;
};

export type CreateOrUpdateAddressPayload = {
  __typename?: 'CreateOrUpdateAddressPayload';
  query: Query;
};

export type CreateOrUpdateAddressProblem = {
  __typename?: 'CreateOrUpdateAddressProblem';
  reason: CreateOrUpdateAddressProblemKind;
};

export enum CreateOrUpdateAddressProblemKind {
  Internal = 'INTERNAL',
}

export type CreateOrUpdateAddressResult =
  | CreateOrUpdateAddressPayload
  | CreateOrUpdateAddressProblem;

export type CreateOrderBillInput = {
  ids: Array<Scalars['String']>;
};

export type CreateOrderResponse = {
  __typename?: 'CreateOrderResponse';
  created: Scalars['String'];
  order_id: Scalars['String'];
  status: Scalars['String'];
  updated: Scalars['String'];
};

export type DefaultResponse = {
  __typename?: 'DefaultResponse';
  status: Scalars['String'];
};

export type DeleteAddressInput = {
  id: Scalars['ID'];
};

export type DeleteAddressPayload = {
  __typename?: 'DeleteAddressPayload';
  query: Query;
};

export type DeleteAddressProblem = {
  __typename?: 'DeleteAddressProblem';
  reason: DeleteAddressProblemKind;
};

export enum DeleteAddressProblemKind {
  Internal = 'INTERNAL',
}

export type DeleteAddressResult = DeleteAddressPayload | DeleteAddressProblem;

export type DeleteBillsDocumentInput = {
  id: Scalars['String'];
};

export type DeleteDocumentInput = {
  id: Scalars['String'];
};

export type DeleteDocumentPayload = {
  __typename?: 'DeleteDocumentPayload';
  query: Query;
};

export type DeleteDocumentProblem = {
  __typename?: 'DeleteDocumentProblem';
  reason: DeleteDocumentProblemReason;
};

export enum DeleteDocumentProblemReason {
  Internal = 'INTERNAL',
}

export type DeleteDocumentResult = DeleteDocumentPayload | DeleteDocumentProblem;

export type DisableLoginWithQrPayload = {
  __typename?: 'DisableLoginWithQRPayload';
  account: Account;
};

export type DiskItem = {
  __typename?: 'DiskItem';
  name: Scalars['String'];
  path: Scalars['String'];
  preview: Scalars['String'];
};

export type DisplayName = {
  __typename?: 'DisplayName';
  defaultAvatar?: Maybe<Scalars['String']>;
  name?: Maybe<Scalars['String']>;
};

export type Document =
  | BirthCertificateDocument
  | DriverLicenseDocument
  | InnDocument
  | InternationalIdDocument
  | MedicalInsuranceDocument
  | NationalIdDocument
  | SnilsDocument
  | VehicleRegistrationCertificateDocument
  | VoluntaryMedicalInsuranceDocument;

export type DocumentByIdProblem = {
  __typename?: 'DocumentByIdProblem';
  reason: DocumentByIdProblemReason;
};

export enum DocumentByIdProblemReason {
  NotFound = 'NOT_FOUND',
}

export type DocumentByIdResult =
  | BirthCertificateDocument
  | DocumentByIdProblem
  | DriverLicenseDocument
  | InnDocument
  | InternationalIdDocument
  | MedicalInsuranceDocument
  | NationalIdDocument
  | SnilsDocument
  | VehicleRegistrationCertificateDocument
  | VoluntaryMedicalInsuranceDocument;

export enum DocumentGender {
  Female = 'FEMALE',
  Male = 'MALE',
}

export type DocumentImage = {
  __typename?: 'DocumentImage';
  id: Scalars['ID'];
  originalHeight?: Maybe<Scalars['Int']>;
  originalUri?: Maybe<Scalars['String']>;
  originalUrl: Scalars['String'];
  originalWidth?: Maybe<Scalars['Int']>;
  previewHeight?: Maybe<Scalars['Int']>;
  previewUri?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  previewWidth?: Maybe<Scalars['Int']>;
};

export type DocumentImageInput = {
  id: Scalars['ID'];
  originalHeight?: InputMaybe<Scalars['Int']>;
  originalUri?: InputMaybe<Scalars['String']>;
  originalUrl: Scalars['String'];
  originalWidth?: InputMaybe<Scalars['Int']>;
  previewHeight?: InputMaybe<Scalars['Int']>;
  previewUri?: InputMaybe<Scalars['String']>;
  previewUrl?: InputMaybe<Scalars['String']>;
  previewWidth?: InputMaybe<Scalars['Int']>;
};

export enum DocumentSection {
  Finance = 'FINANCE',
  Health = 'HEALTH',
  Personal = 'PERSONAL',
  Transport = 'TRANSPORT',
}

export enum DocumentType {
  BirthCertificate = 'BIRTH_CERTIFICATE',
  DriverLicense = 'DRIVER_LICENSE',
  Inn = 'INN',
  InternationalId = 'INTERNATIONAL_ID',
  MedicalInsurance = 'MEDICAL_INSURANCE',
  NationalId = 'NATIONAL_ID',
  Snils = 'SNILS',
  VehicleRegistrationCertificate = 'VEHICLE_REGISTRATION_CERTIFICATE',
  VoluntaryMedicalInsurance = 'VOLUNTARY_MEDICAL_INSURANCE',
}

export type DriverLicenseDocument = IDocument & {
  __typename?: 'DriverLicenseDocument';
  additionalInformation?: Maybe<Scalars['String']>;
  birthDate?: Maybe<Scalars['String']>;
  birthPlace?: Maybe<Scalars['String']>;
  birthPlaceLat?: Maybe<Scalars['String']>;
  category?: Maybe<Scalars['String']>;
  docNumber?: Maybe<Scalars['String']>;
  endDate?: Maybe<Scalars['String']>;
  firstName?: Maybe<Scalars['String']>;
  firstNameLat?: Maybe<Scalars['String']>;
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  issueDate?: Maybe<Scalars['String']>;
  issuedBy?: Maybe<Scalars['String']>;
  issuedByLat?: Maybe<Scalars['String']>;
  issuedCity?: Maybe<Scalars['String']>;
  issuedCityLat?: Maybe<Scalars['String']>;
  lastName?: Maybe<Scalars['String']>;
  lastNameLat?: Maybe<Scalars['String']>;
  middleName?: Maybe<Scalars['String']>;
  middleNameLat?: Maybe<Scalars['String']>;
  originalUrl?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Maybe<Scalars['String']>;
};

export type EdadealData = {
  __typename?: 'EdadealData';
  amount?: Maybe<Scalars['Float']>;
  hasBinding: Scalars['Boolean'];
  iframeSrc: Scalars['String'];
  url: Scalars['String'];
};

export type Email = {
  __typename?: 'Email';
  address: Scalars['String'];
  email: Scalars['String'];
  isConfirmed: Scalars['Boolean'];
  isPrimary: Scalars['Boolean'];
  isUnsafe: Scalars['Boolean'];
  type: EmailType;
};

export enum EmailType {
  External = 'EXTERNAL',
  Native = 'NATIVE',
}

export type EnableLoginWithQrPayload = {
  __typename?: 'EnableLoginWithQRPayload';
  account: Account;
};

export type ExternalAccount = {
  __typename?: 'ExternalAccount';
  allowAuth: Scalars['Boolean'];
  displayName: Scalars['String'];
  firstName?: Maybe<Scalars['String']>;
  id: Scalars['ID'];
  lastName?: Maybe<Scalars['String']>;
  provider: ExternalAccountProvider;
};

export type ExternalAccountProvider = {
  __typename?: 'ExternalAccountProvider';
  id: Scalars['ID'];
  name: ExternalAccountProviderName;
};

export enum ExternalAccountProviderName {
  Apple = 'APPLE',
  Esia = 'ESIA',
  Facebook = 'FACEBOOK',
  Google = 'GOOGLE',
  Mailru = 'MAILRU',
  Odnoklassniki = 'ODNOKLASSNIKI',
  Twitter = 'TWITTER',
  Vk = 'VK',
}

export type Family = {
  __typename?: 'Family';
  info?: Maybe<FamilyInfo>;
  invites: Array<FamilyInvite>;
  kids: Array<FamilyKid>;
  members: Array<FamilyMember>;
  pay?: Maybe<FamilyPay>;
  settings?: Maybe<FamilySettings>;
};

export type FamilyInfo = {
  __typename?: 'FamilyInfo';
  adminUid: Scalars['String'];
  id: Scalars['String'];
};

export type FamilyInvite = {
  __typename?: 'FamilyInvite';
  contact: Scalars['String'];
  id: Scalars['String'];
  sendMethod: Scalars['String'];
};

export type FamilyKid = {
  __typename?: 'FamilyKid';
  avatar?: Maybe<Scalars['String']>;
  birthday?: Maybe<Scalars['String']>;
  contentRating: Scalars['Int'];
  gender?: Maybe<Scalars['Int']>;
  musicRating: Scalars['Int'];
  name?: Maybe<Scalars['String']>;
  placeId: Scalars['String'];
  uid: Scalars['String'];
  videoRating: Scalars['Int'];
};

export type FamilyMember = {
  __typename?: 'FamilyMember';
  avatar: Scalars['String'];
  hasPlus: Scalars['Boolean'];
  hasSecurePhone?: Maybe<Scalars['Boolean']>;
  isAdmin: Scalars['Boolean'];
  name: Scalars['String'];
  placeId: Scalars['String'];
  uid: Scalars['String'];
};

export type FamilyPay = {
  __typename?: 'FamilyPay';
  cardInfo?: Maybe<CardInfo>;
  userRestrictions: Array<Restriction>;
};

export type FamilySettings = {
  __typename?: 'FamilySettings';
  maxCapacity: Scalars['Int'];
  maxKids: Scalars['Int'];
};

export type FamilyUser = {
  __typename?: 'FamilyUser';
  avatar: Scalars['String'];
  name: Scalars['String'];
  uid: Scalars['String'];
};

export type FuturePayment = {
  __typename?: 'FuturePayment';
  amount: Scalars['Float'];
  id?: Maybe<Scalars['ID']>;
  iframeUrl?: Maybe<Scalars['String']>;
  nextPaymentAt: Scalars['String'];
  service: Scalars['String'];
  type: FuturePaymentType;
};

export enum FuturePaymentType {
  Split = 'SPLIT',
}

export type IDocument = {
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  originalUrl?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Maybe<Scalars['String']>;
};

export type InnDocument = IDocument & {
  __typename?: 'InnDocument';
  birthDate?: Maybe<Scalars['String']>;
  docNumber?: Maybe<Scalars['String']>;
  firstName?: Maybe<Scalars['String']>;
  gender?: Maybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  issueDate?: Maybe<Scalars['String']>;
  issuedBy?: Maybe<Scalars['String']>;
  lastName?: Maybe<Scalars['String']>;
  middleName?: Maybe<Scalars['String']>;
  originalUrl?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Maybe<Scalars['String']>;
};

export type InternationalIdDocument = IDocument & {
  __typename?: 'InternationalIdDocument';
  birthDate?: Maybe<Scalars['String']>;
  birthPlace?: Maybe<Scalars['String']>;
  birthPlaceLat?: Maybe<Scalars['String']>;
  citizenship?: Maybe<Scalars['String']>;
  citizenshipLat?: Maybe<Scalars['String']>;
  docNumber?: Maybe<Scalars['String']>;
  endDate?: Maybe<Scalars['String']>;
  firstName?: Maybe<Scalars['String']>;
  firstNameLat?: Maybe<Scalars['String']>;
  gender?: Maybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  issueDate?: Maybe<Scalars['String']>;
  issuedBy?: Maybe<Scalars['String']>;
  lastName?: Maybe<Scalars['String']>;
  lastNameLat?: Maybe<Scalars['String']>;
  originalUrl?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Maybe<Scalars['String']>;
};

export type Limit = {
  __typename?: 'Limit';
  limitMode: Scalars['String'];
  value: Scalars['Int'];
};

export type LocationsOptions = {
  __typename?: 'LocationsOptions';
  countries: Array<CountryOption>;
  timezones: Array<TimezoneOption>;
};

export type MedicalInsuranceDocument = IDocument & {
  __typename?: 'MedicalInsuranceDocument';
  birthDate?: Maybe<Scalars['String']>;
  blank?: Maybe<Scalars['String']>;
  docNumber?: Maybe<Scalars['String']>;
  firstName?: Maybe<Scalars['String']>;
  gender?: Maybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  lastName?: Maybe<Scalars['String']>;
  middleName?: Maybe<Scalars['String']>;
  originalUrl?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Maybe<Scalars['String']>;
};

export type Mpi3dsInfo = {
  __typename?: 'Mpi3dsInfo';
  browser_accept_header?: Maybe<Scalars['String']>;
  browser_color_depth: Scalars['Int'];
  browser_ip: Scalars['String'];
  browser_javascript_enabled: Scalars['Boolean'];
  browser_language: Scalars['String'];
  browser_screen_height: Scalars['Int'];
  browser_screen_width: Scalars['Int'];
  browser_tz: Scalars['String'];
  browser_user_agent: Scalars['String'];
  window_height: Scalars['Int'];
  window_width: Scalars['Int'];
};

export type Mutation = {
  __typename?: 'Mutation';
  accountAddRecoveryEmail: AddRecoveryEmailResult;
  accountBindBankCard: AccountCreateBindBankCardResponse;
  accountConfirmRecoveryEmailByCode: ConfirmRecoveryEmailByCodeResult;
  accountConfirmRecoveryEmailByLink: ConfirmRecoveryEmailByLinkResult;
  accountDisableLoginWithPasswordAndSms: ToggleLoginWithPasswordAndSmsResult;
  accountDisableLoginWithQR: DisableLoginWithQrPayload;
  accountEnableLoginWithPasswordAndSms: ToggleLoginWithPasswordAndSmsResult;
  accountEnableLoginWithQR: EnableLoginWithQrPayload;
  accountRemoveRecoveryEmail: RemoveRecoveryEmailResult;
  accountSetQuestion: SetQuestionResult;
  accountUnbindBankCard: AccountUnbindBankdCardResponse;
  addBillsDocument: BillsDocument;
  addDocument: AddDocumentResult;
  confirmByPassword: ConfirmByPasswordResult;
  copyDocumentsFromDisk: CopyDocumentsFromDiskPayload;
  createOrUpdateAddress: CreateOrUpdateAddressResult;
  createOrderBill: CreateOrderResponse;
  deleteAddress: DeleteAddressResult;
  deleteBillsDocument: DefaultResponse;
  deleteDocument: DeleteDocumentResult;
  getTransaction: BillTransactionResponse;
  profileUpdate: ProfileUpdateResult;
  restartBillsSearch: DefaultResponse;
  sendCodeToBindPrimaryPhone: SendCodeToBindPrimaryPhoneResult;
  sendCodeToConfirmPhone: SendCodeToConfirmPhoneResult;
  startOrderBill: StartOrderBillResponse;
  suggestPublicId: PublicIdSuggestResult;
  toggleLoginWithExternalAccount: ToggleLoginWithExternalAccountResult;
  unbindExternalAccount: UnbindExternalAccountResult;
  updateBillsDocument: BillsDocument;
  updateDocument: UpdateDocumentResult;
  updatePublicId: PublicIdUpdateResult;
  validatePublicId: PublicIdValidateResult;
  verifyCodeToBindPrimaryPhone: VerifyCodeToBindPrimaryPhoneResult;
  verifyCodeToConfirmPhone: VerifyCodeToConfirmPhoneResult;
  viewerUpdatePersonalInfo: UpdatePersonalInfoResult;
  viewerValidatePersonalInfoField: ProfileFieldValidationResult;
};

export type MutationAccountAddRecoveryEmailArgs = {
  input: AddRecoveryEmailInput;
};

export type MutationAccountBindBankCardArgs = {
  input: AccountBindBankCardInput;
};

export type MutationAccountConfirmRecoveryEmailByCodeArgs = {
  input: ConfirmRecoveryEmailByCodeInput;
};

export type MutationAccountConfirmRecoveryEmailByLinkArgs = {
  input: ConfirmRecoveryEmailByLinkInput;
};

export type MutationAccountDisableLoginWithPasswordAndSmsArgs = {
  input: ToggleLoginWithPasswordAndSmsInput;
};

export type MutationAccountEnableLoginWithPasswordAndSmsArgs = {
  input: ToggleLoginWithPasswordAndSmsInput;
};

export type MutationAccountRemoveRecoveryEmailArgs = {
  input: RemoveRecoveryEmailInput;
};

export type MutationAccountSetQuestionArgs = {
  input: SetQuestionInput;
};

export type MutationAccountUnbindBankCardArgs = {
  cardId: Scalars['String'];
};

export type MutationAddBillsDocumentArgs = {
  input: AddBillsDocumentInput;
};

export type MutationAddDocumentArgs = {
  input: AddDocumentInput;
};

export type MutationConfirmByPasswordArgs = {
  input: ConfirmByPasswordInput;
};

export type MutationCopyDocumentsFromDiskArgs = {
  input: CopyDocumentsFromDiskInput;
  type: DocumentType;
};

export type MutationCreateOrUpdateAddressArgs = {
  input: CreateOrUpdateAddressInput;
};

export type MutationCreateOrderBillArgs = {
  input: CreateOrderBillInput;
};

export type MutationDeleteAddressArgs = {
  input: DeleteAddressInput;
};

export type MutationDeleteBillsDocumentArgs = {
  input: DeleteBillsDocumentInput;
};

export type MutationDeleteDocumentArgs = {
  input: DeleteDocumentInput;
};

export type MutationGetTransactionArgs = {
  input: GetTransactionInput;
};

export type MutationProfileUpdateArgs = {
  input: ProfileUpdateInput;
};

export type MutationSendCodeToBindPrimaryPhoneArgs = {
  input: SendCodeToBindPrimaryPhoneInput;
};

export type MutationSendCodeToConfirmPhoneArgs = {
  input: SendCodeToConfirmPhoneInput;
};

export type MutationStartOrderBillArgs = {
  input: StartOrderBillInput;
};

export type MutationSuggestPublicIdArgs = {
  input: PublicIdSuggestInput;
};

export type MutationToggleLoginWithExternalAccountArgs = {
  input: ToggleLoginWithExternalAccountInput;
};

export type MutationUnbindExternalAccountArgs = {
  input: UnbindExternalAccountInput;
};

export type MutationUpdateBillsDocumentArgs = {
  input: UpdateBillsDocumentInput;
};

export type MutationUpdateDocumentArgs = {
  input: UpdateDocumentInput;
};

export type MutationUpdatePublicIdArgs = {
  input: PublicIdUpdateInput;
};

export type MutationValidatePublicIdArgs = {
  input: PublicIdValidateInput;
};

export type MutationVerifyCodeToBindPrimaryPhoneArgs = {
  input: VerifyCodeToBindPrimaryPhoneInput;
};

export type MutationVerifyCodeToConfirmPhoneArgs = {
  input: VerifyCodeToConfirmPhoneInput;
};

export type MutationViewerUpdatePersonalInfoArgs = {
  input: UpdatePersonalInfoInput;
};

export type MutationViewerValidatePersonalInfoFieldArgs = {
  input: ProfileFieldValidationInput;
};

export type NationalIdDocument = IDocument & {
  __typename?: 'NationalIdDocument';
  birthDate?: Maybe<Scalars['String']>;
  birthPlace?: Maybe<Scalars['String']>;
  docNumber?: Maybe<Scalars['String']>;
  firstName?: Maybe<Scalars['String']>;
  gender?: Maybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  issueDate?: Maybe<Scalars['String']>;
  issuedBy?: Maybe<Scalars['String']>;
  issuerSubdivisionCode?: Maybe<Scalars['String']>;
  lastName?: Maybe<Scalars['String']>;
  middleName?: Maybe<Scalars['String']>;
  originalUrl?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  registrationAddress?: Maybe<Scalars['String']>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Maybe<Scalars['String']>;
};

export type PageInfo = {
  __typename?: 'PageInfo';
  endCursor?: Maybe<Scalars['String']>;
  hasNextPage: Scalars['Boolean'];
  hasPreviousPage: Scalars['Boolean'];
  startCursor?: Maybe<Scalars['String']>;
};

export type PasswordInfo = {
  __typename?: 'PasswordInfo';
  updatedAt: Scalars['Timestamp'];
};

export type Payment = {
  __typename?: 'Payment';
  cashback?: Maybe<Scalars['Float']>;
  created: Scalars['String'];
  currency: Scalars['String'];
  fake?: Maybe<Scalars['Boolean']>;
  initiatorUid?: Maybe<Scalars['String']>;
  isReceipt?: Maybe<Scalars['Boolean']>;
  items?: Maybe<Array<PaymentItem>>;
  orderId: Scalars['String'];
  paymentId: Scalars['String'];
  paymentTypes?: Maybe<Array<PaymentType>>;
  plus?: Maybe<Scalars['Float']>;
  purchaseToken: Scalars['String'];
  receiptUrl?: Maybe<Scalars['String']>;
  receiptsEnabled: Scalars['Boolean'];
  refundOnly?: Maybe<Scalars['Boolean']>;
  refunds?: Maybe<Array<PaymentRefund>>;
  retailerIcon?: Maybe<Scalars['String']>;
  retailerName?: Maybe<Scalars['String']>;
  service: Service;
  serviceId: Scalars['String'];
  source?: Maybe<Scalars['String']>;
  status: Scalars['String'];
  total: Scalars['Float'];
};

export type PaymentItem = {
  __typename?: 'PaymentItem';
  alias?: Maybe<Scalars['String']>;
  amount: Scalars['String'];
  currency: Scalars['String'];
  hidden?: Maybe<Scalars['Boolean']>;
  name: Scalars['String'];
  nds: Scalars['String'];
  price: Scalars['Float'];
};

export type PaymentRefund = {
  __typename?: 'PaymentRefund';
  account?: Maybe<Scalars['String']>;
  currency: Scalars['String'];
  items?: Maybe<Array<PaymentItem>>;
  paymentMethod: Scalars['String'];
  total: Scalars['Float'];
};

export type PaymentType = {
  __typename?: 'PaymentType';
  account?: Maybe<Scalars['String']>;
  currency?: Maybe<Scalars['String']>;
  method: Scalars['String'];
  price: Scalars['Float'];
};

export type PaymentsContext = {
  __typename?: 'PaymentsContext';
  familyData?: Maybe<Array<FamilyUser>>;
  plusServiceData: PlusService;
  services: Array<Service>;
};

export type PaymentsData = {
  __typename?: 'PaymentsData';
  edges: Array<Payment>;
  pageInfo: PageInfo;
};

export type Phone = {
  __typename?: 'Phone';
  id: Scalars['ID'];
  isDefault: Scalars['Boolean'];
  isPrimary: Scalars['Boolean'];
  number: Scalars['String'];
  operation?: Maybe<PhoneOperation>;
};

export type PhoneOperation = {
  __typename?: 'PhoneOperation';
  finishedAt: Scalars['Timestamp'];
  id: Scalars['ID'];
  inQuarantine: Scalars['Boolean'];
  isOwner: Scalars['Boolean'];
  startedAt: Scalars['Timestamp'];
  type: PhoneOperationType;
};

export enum PhoneOperationType {
  Aliasify = 'ALIASIFY',
  Bind = 'BIND',
  Dealiasify = 'DEALIASIFY',
  Mark = 'MARK',
  Remove = 'REMOVE',
  Replace = 'REPLACE',
  Securify = 'SECURIFY',
}

export type PlusService = {
  __typename?: 'PlusService';
  iconUrl: Scalars['String'];
  serviceName: Scalars['String'];
  splashUrl: Scalars['String'];
};

export enum ProfileFieldName {
  DisplayName = 'DISPLAY_NAME',
  Firstname = 'FIRSTNAME',
  Lastname = 'LASTNAME',
}

export type ProfileFieldValidationInput = {
  fieldName: ProfileFieldName;
  fieldValue: Scalars['String'];
};

export type ProfileFieldValidationResult = {
  __typename?: 'ProfileFieldValidationResult';
  code: ProfileFieldValidationResultCode;
};

export enum ProfileFieldValidationResultCode {
  Internal = 'INTERNAL',
  Invalid = 'INVALID',
  Ok = 'OK',
}

export type ProfileUpdateInput = {
  publicId?: InputMaybe<Scalars['String']>;
  trackId?: InputMaybe<Scalars['String']>;
};

export type ProfileUpdatePayload = {
  __typename?: 'ProfileUpdatePayload';
  query: Query;
};

export type ProfileUpdateProblem = {
  __typename?: 'ProfileUpdateProblem';
  reason: Scalars['String'];
};

export type ProfileUpdateResult = ProfileUpdatePayload | ProfileUpdateProblem;

export type PublicIdSuggestInput = {
  firstName?: InputMaybe<Scalars['String']>;
  language?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  login?: InputMaybe<Scalars['String']>;
  trackId?: InputMaybe<Scalars['String']>;
};

export type PublicIdSuggestPayload = {
  __typename?: 'PublicIdSuggestPayload';
  logins: Array<Scalars['String']>;
  trackId: Scalars['String'];
};

export type PublicIdSuggestProblem = {
  __typename?: 'PublicIdSuggestProblem';
  reason: Scalars['String'];
};

export type PublicIdSuggestResult = PublicIdSuggestPayload | PublicIdSuggestProblem;

export type PublicIdUpdateInput = {
  publicId: Scalars['String'];
  trackId?: InputMaybe<Scalars['String']>;
};

export type PublicIdUpdatePayload = {
  __typename?: 'PublicIdUpdatePayload';
  query: Query;
};

export type PublicIdUpdateProblem = {
  __typename?: 'PublicIdUpdateProblem';
  reason: Scalars['String'];
};

export type PublicIdUpdateResult = PublicIdUpdatePayload | PublicIdUpdateProblem;

export type PublicIdValidateInput = {
  publicId: Scalars['String'];
  trackId?: InputMaybe<Scalars['String']>;
};

export type PublicIdValidatePayload = {
  __typename?: 'PublicIdValidatePayload';
  trackId: Scalars['String'];
};

export type PublicIdValidateProblem = {
  __typename?: 'PublicIdValidateProblem';
  reason: Scalars['String'];
};

export type PublicIdValidateResult = PublicIdValidatePayload | PublicIdValidateProblem;

export type Query = {
  __typename?: 'Query';
  account: Account;
  accountAvailableQuestions: Array<AvailableQuestion>;
  accountBankCards: BankCardsData;
  addresses: Array<Address>;
  bills: BillsData;
  billsDocuments: Array<BillsDocument>;
  document: DocumentByIdResult;
  documents: Array<IDocument>;
  edadealData: EdadealData;
  externalAccountProviders: Array<ExternalAccountProvider>;
  externalAccounts: Array<ExternalAccount>;
  family: Family;
  findDocuments: Array<DiskItem>;
  futurePayments: Array<FuturePayment>;
  locationOptions: LocationsOptions;
  paymentById: PaymentsData;
  paymentsContext: PaymentsContext;
  paymentsData: PaymentsData;
  receiptsByToken: Array<Receipt>;
  viewer: Viewer;
};

export type QueryDocumentArgs = {
  id: Scalars['ID'];
};

export type QueryDocumentsArgs = {
  type?: InputMaybe<DocumentType>;
};

export type QueryFindDocumentsArgs = {
  type: DocumentType;
};

export type QueryPaymentByIdArgs = {
  paymentId: Scalars['String'];
};

export type QueryPaymentsContextArgs = {
  familyMode?: InputMaybe<Scalars['Boolean']>;
};

export type QueryPaymentsDataArgs = {
  after?: InputMaybe<Scalars['String']>;
  alias?: InputMaybe<Scalars['String']>;
  user?: InputMaybe<Scalars['String']>;
};

export type QueryReceiptsByTokenArgs = {
  purchaseToken: Scalars['String'];
};

export type Question = {
  __typename?: 'Question';
  id: Scalars['ID'];
  text: Scalars['String'];
};

export type Receipt = {
  __typename?: 'Receipt';
  amount?: Maybe<Array<Scalars['Float']>>;
  timestamp?: Maybe<Scalars['String']>;
  type?: Maybe<Scalars['String']>;
  url: Scalars['String'];
};

export type RemoveRecoveryEmailInput = {
  email: Scalars['String'];
  trackId?: InputMaybe<Scalars['String']>;
};

export type RemoveRecoveryEmailPayload = {
  __typename?: 'RemoveRecoveryEmailPayload';
  query: Query;
};

export type RemoveRecoveryEmailProblem = {
  __typename?: 'RemoveRecoveryEmailProblem';
  reason: RemoveRecoveryEmailProblemKind;
  trackId: Scalars['String'];
};

export enum RemoveRecoveryEmailProblemKind {
  Internal = 'INTERNAL',
  PasswordRequired = 'PASSWORD_REQUIRED',
}

export type RemoveRecoveryEmailResult = RemoveRecoveryEmailPayload | RemoveRecoveryEmailProblem;

export type Restriction = {
  __typename?: 'Restriction';
  allowAllServices: Scalars['Boolean'];
  balance: Scalars['Int'];
  enabled: Scalars['Boolean'];
  hasSecurePhone: Scalars['Boolean'];
  limit: Limit;
  limitCurrency: Scalars['String'];
  uid: Scalars['String'];
  unlim: Scalars['Boolean'];
};

export type SendCodeToBindPrimaryPhoneInput = {
  number: Scalars['String'];
  trackId?: InputMaybe<Scalars['String']>;
};

export type SendCodeToBindPrimaryPhonePayload = {
  __typename?: 'SendCodeToBindPrimaryPhonePayload';
  expiryTimestamp: Scalars['Timestamp'];
  number: Scalars['String'];
  trackId: Scalars['String'];
};

export type SendCodeToBindPrimaryPhoneProblem = {
  __typename?: 'SendCodeToBindPrimaryPhoneProblem';
  reason: SendCodeToBindPrimaryPhoneProblemReason;
};

export enum SendCodeToBindPrimaryPhoneProblemReason {
  Internal = 'INTERNAL',
  PhoneNumberBlocked = 'PHONE_NUMBER_BLOCKED',
  PhoneNumberInvalid = 'PHONE_NUMBER_INVALID',
  SmsLimitExceeded = 'SMS_LIMIT_EXCEEDED',
}

export type SendCodeToBindPrimaryPhoneResult =
  | SendCodeToBindPrimaryPhonePayload
  | SendCodeToBindPrimaryPhoneProblem;

export type SendCodeToConfirmPhoneInput = {
  number: Scalars['String'];
  trackId?: InputMaybe<Scalars['String']>;
};

export type SendCodeToConfirmPhonePayload = {
  __typename?: 'SendCodeToConfirmPhonePayload';
  expiryTimestamp: Scalars['Timestamp'];
  number: Scalars['String'];
  trackId: Scalars['String'];
};

export type SendCodeToConfirmPhoneProblem = {
  __typename?: 'SendCodeToConfirmPhoneProblem';
  reason: SendCodeToConfirmPhoneProblemReason;
};

export enum SendCodeToConfirmPhoneProblemReason {
  Internal = 'INTERNAL',
  PhoneNumberBlocked = 'PHONE_NUMBER_BLOCKED',
  PhoneNumberInvalid = 'PHONE_NUMBER_INVALID',
  SmsLimitExceeded = 'SMS_LIMIT_EXCEEDED',
}

export type SendCodeToConfirmPhoneResult =
  | SendCodeToConfirmPhonePayload
  | SendCodeToConfirmPhoneProblem;

export type Service = {
  __typename?: 'Service';
  help?: Maybe<Scalars['String']>;
  i18nKeyName?: Maybe<Scalars['String']>;
  iconUrl: Scalars['String'];
  id: Scalars['String'];
  name: Scalars['String'];
  splashUrl?: Maybe<Scalars['String']>;
  url?: Maybe<Scalars['String']>;
};

export type SetQuestionInput = {
  newAnswer: Scalars['String'];
  newQuestion: Scalars['String'];
  oldAnswer: Scalars['String'];
  questionId: Scalars['String'];
  trackId?: InputMaybe<Scalars['String']>;
};

export type SetQuestionPayload = {
  __typename?: 'SetQuestionPayload';
  query: Query;
};

export type SetQuestionProblem = {
  __typename?: 'SetQuestionProblem';
  reason: SetQuestionProblemKind;
  trackId: Scalars['String'];
};

export enum SetQuestionProblemKind {
  CompareNotMatched = 'COMPARE_NOT_MATCHED',
  Internal = 'INTERNAL',
  PasswordRequired = 'PASSWORD_REQUIRED',
}

export type SetQuestionResult = SetQuestionPayload | SetQuestionProblem;

export type SnilsDocument = IDocument & {
  __typename?: 'SnilsDocument';
  birthDate?: Maybe<Scalars['String']>;
  birthPlace?: Maybe<Scalars['String']>;
  docNumber?: Maybe<Scalars['String']>;
  firstName?: Maybe<Scalars['String']>;
  gender?: Maybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  issueDate?: Maybe<Scalars['String']>;
  lastName?: Maybe<Scalars['String']>;
  middleName?: Maybe<Scalars['String']>;
  originalUrl?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Maybe<Scalars['String']>;
};

export type StartOrderBillInput = {
  id: Scalars['String'];
  mpi_3ds_info: ClientMpiInfoInput;
  payer_full_name: Scalars['String'];
  payment_method: Scalars['String'];
  payment_token: Scalars['String'];
  return_url: Scalars['String'];
};

export type StartOrderBillResponse = {
  __typename?: 'StartOrderBillResponse';
  transaction: Trancsaction;
};

export type TimezoneOption = {
  __typename?: 'TimezoneOption';
  code: Scalars['String'];
  name: Scalars['String'];
};

export type ToggleLoginWithExternalAccountInput = {
  enabled: Scalars['Boolean'];
  id: Scalars['ID'];
};

export type ToggleLoginWithExternalAccountPayload = {
  __typename?: 'ToggleLoginWithExternalAccountPayload';
  query: Query;
};

export type ToggleLoginWithExternalAccountProblem = {
  __typename?: 'ToggleLoginWithExternalAccountProblem';
  reason: ToggleLoginWithExternalAccountReason;
};

export enum ToggleLoginWithExternalAccountReason {
  Internal = 'INTERNAL',
}

export type ToggleLoginWithExternalAccountResult =
  | ToggleLoginWithExternalAccountPayload
  | ToggleLoginWithExternalAccountProblem;

export type ToggleLoginWithPasswordAndSmsInput = {
  trackId: Scalars['String'];
};

export type ToggleLoginWithPasswordAndSmsPayload = {
  __typename?: 'ToggleLoginWithPasswordAndSmsPayload';
  account: Account;
};

export type ToggleLoginWithPasswordAndSmsProblem = {
  __typename?: 'ToggleLoginWithPasswordAndSmsProblem';
  reason: ToggleLoginWithPasswordAndSmsProblemReason;
};

export enum ToggleLoginWithPasswordAndSmsProblemReason {
  Internal = 'INTERNAL',
  PrimaryPhoneNotBound = 'PRIMARY_PHONE_NOT_BOUND',
  PrimaryPhoneNotConfirmed = 'PRIMARY_PHONE_NOT_CONFIRMED',
  TrackIdInvalid = 'TRACK_ID_INVALID',
  TrackInvalidState = 'TRACK_INVALID_STATE',
}

export type ToggleLoginWithPasswordAndSmsResult =
  | ToggleLoginWithPasswordAndSmsPayload
  | ToggleLoginWithPasswordAndSmsProblem;

export type Trancsaction = {
  __typename?: 'Trancsaction';
  acs_url: Scalars['String'];
  amount: Scalars['Int'];
  created: Scalars['String'];
  mpi_3ds_info: Mpi3dsInfo;
  order_id: Scalars['String'];
  payer_full_name: Scalars['String'];
  payment_method: Scalars['String'];
  payment_token: Scalars['String'];
  return_url: Scalars['String'];
  status: TransactionStatus;
  transaction_id: Scalars['String'];
  updated: Scalars['String'];
};

export enum TransactionStatus {
  Cancelled = 'CANCELLED',
  New = 'NEW',
  Paid = 'PAID',
  Refunded = 'REFUNDED',
}

export type UnbindExternalAccountInput = {
  id: Scalars['ID'];
};

export type UnbindExternalAccountPayload = {
  __typename?: 'UnbindExternalAccountPayload';
  query: Query;
};

export type UnbindExternalAccountProblem = {
  __typename?: 'UnbindExternalAccountProblem';
  reason: UnbindExternalAccountReason;
};

export enum UnbindExternalAccountReason {
  Internal = 'INTERNAL',
}

export type UnbindExternalAccountResult =
  | UnbindExternalAccountPayload
  | UnbindExternalAccountProblem;

export type UpdateBillsDocumentInput = {
  id: Scalars['String'];
  title: Scalars['String'];
  type: Scalars['String'];
  value: Scalars['String'];
};

export type UpdateBirthCertificateInput = {
  birthAkt?: InputMaybe<Scalars['String']>;
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  fatherBirthDate?: InputMaybe<Scalars['String']>;
  fatherCitizenship?: InputMaybe<Scalars['String']>;
  fatherFirstName?: InputMaybe<Scalars['String']>;
  fatherLastName?: InputMaybe<Scalars['String']>;
  fatherMiddleName?: InputMaybe<Scalars['String']>;
  fatherNationality?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  id: Scalars['ID'];
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuePlace?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  motherBirthDate?: InputMaybe<Scalars['String']>;
  motherCitizenship?: InputMaybe<Scalars['String']>;
  motherFirstName?: InputMaybe<Scalars['String']>;
  motherLastName?: InputMaybe<Scalars['String']>;
  motherMiddleName?: InputMaybe<Scalars['String']>;
  motherNationality?: InputMaybe<Scalars['String']>;
  registrationPlace?: InputMaybe<Scalars['String']>;
  series?: InputMaybe<Scalars['String']>;
  verificationStatus?: InputMaybe<Scalars['String']>;
};

export type UpdateDocumentInput = {
  birthCertificateInput?: InputMaybe<UpdateBirthCertificateInput>;
  driverLicenseInput?: InputMaybe<UpdateDriverLicenseInput>;
  innInput?: InputMaybe<UpdateInnInput>;
  internationalIdInput?: InputMaybe<UpdateInternationalIdInput>;
  medicalInsuranceInput?: InputMaybe<UpdateMedicalInsuranceInput>;
  nationalIdInput?: InputMaybe<UpdateNationalIdInput>;
  snilsInput?: InputMaybe<UpdateSnilsInput>;
  type: DocumentType;
  vehicleRegistrationCertificateInput?: InputMaybe<UpdateVehicleRegistrationCertificateInput>;
  voluntaryMedicalInsuranceInput?: InputMaybe<UpdateVoluntaryMedicalInsuranceInput>;
};

export type UpdateDocumentPayload = {
  __typename?: 'UpdateDocumentPayload';
  query: Query;
};

export type UpdateDocumentProblem = {
  __typename?: 'UpdateDocumentProblem';
  reason: UpdateDocumentProblemReason;
};

export enum UpdateDocumentProblemReason {
  Internal = 'INTERNAL',
}

export type UpdateDocumentResult = UpdateDocumentPayload | UpdateDocumentProblem;

export type UpdateDriverLicenseInput = {
  additionalInformation?: InputMaybe<Scalars['String']>;
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  birthPlaceLat?: InputMaybe<Scalars['String']>;
  category?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  endDate?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  firstNameLat?: InputMaybe<Scalars['String']>;
  id: Scalars['ID'];
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuedBy?: InputMaybe<Scalars['String']>;
  issuedByLat?: InputMaybe<Scalars['String']>;
  issuedCity?: InputMaybe<Scalars['String']>;
  issuedCityLat?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  lastNameLat?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  middleNameLat?: InputMaybe<Scalars['String']>;
  verificationStatus?: InputMaybe<Scalars['String']>;
};

export type UpdateInnInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuedBy?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  verificationStatus?: InputMaybe<Scalars['String']>;
};

export type UpdateInternationalIdInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  birthPlaceLat?: InputMaybe<Scalars['String']>;
  citizenship?: InputMaybe<Scalars['String']>;
  citizenshipLat?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  endDate?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  firstNameLat?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuedBy?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  lastNameLat?: InputMaybe<Scalars['String']>;
  verificationStatus?: InputMaybe<Scalars['String']>;
};

export type UpdateMedicalInsuranceInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  blank?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImageInput>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  verificationStatus?: InputMaybe<Scalars['String']>;
};

export type UpdateNationalIdInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuedBy?: InputMaybe<Scalars['String']>;
  issuerSubdivisionCode?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  registrationAddress?: InputMaybe<Scalars['String']>;
  verificationStatus?: InputMaybe<Scalars['String']>;
};

export type UpdatePersonalInfoInput = {
  birthday?: InputMaybe<Scalars['String']>;
  city?: InputMaybe<Scalars['String']>;
  country: Scalars['String'];
  deleteAvatar?: InputMaybe<Scalars['Boolean']>;
  displayName: Scalars['String'];
  firstname: Scalars['String'];
  gender: Scalars['String'];
  lastname: Scalars['String'];
  timezone: Scalars['String'];
};

export type UpdatePersonalInfoPayload = {
  __typename?: 'UpdatePersonalInfoPayload';
  query: Query;
};

export type UpdatePersonalInfoProblem = {
  __typename?: 'UpdatePersonalInfoProblem';
  reason: UpdatePersonalInfoProblemKind;
};

export enum UpdatePersonalInfoProblemKind {
  DeleteAvatarInternal = 'DELETE_AVATAR_INTERNAL',
  UpdateDataInternal = 'UPDATE_DATA_INTERNAL',
}

export type UpdatePersonalInfoResult = UpdatePersonalInfoPayload | UpdatePersonalInfoProblem;

export type UpdateSnilsInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  birthPlace?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  verificationStatus?: InputMaybe<Scalars['String']>;
};

export type UpdateVehicleRegistrationCertificateInput = {
  additionalInformation?: InputMaybe<Scalars['String']>;
  bodyNumber?: InputMaybe<Scalars['String']>;
  carNumber?: InputMaybe<Scalars['String']>;
  category?: InputMaybe<Scalars['String']>;
  color?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  ecoClass?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  firstNameLat?: InputMaybe<Scalars['String']>;
  id: Scalars['ID'];
  images: Array<DocumentImageInput>;
  issueDate?: InputMaybe<Scalars['String']>;
  issuerSubdivisionCode?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  lastNameLat?: InputMaybe<Scalars['String']>;
  maxWeight?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  model?: InputMaybe<Scalars['String']>;
  modelLat?: InputMaybe<Scalars['String']>;
  power?: InputMaybe<Scalars['String']>;
  pts?: InputMaybe<Scalars['String']>;
  registrationAddress?: InputMaybe<Scalars['String']>;
  shasiNumber?: InputMaybe<Scalars['String']>;
  temporaryReg?: InputMaybe<Scalars['String']>;
  vehicleType?: InputMaybe<Scalars['String']>;
  verificationStatus?: InputMaybe<Scalars['String']>;
  vin?: InputMaybe<Scalars['String']>;
  withoutLoadWeight?: InputMaybe<Scalars['String']>;
  year?: InputMaybe<Scalars['String']>;
};

export type UpdateVoluntaryMedicalInsuranceInput = {
  birthDate?: InputMaybe<Scalars['String']>;
  docNumber?: InputMaybe<Scalars['String']>;
  endDate?: InputMaybe<Scalars['String']>;
  firstName?: InputMaybe<Scalars['String']>;
  gender?: InputMaybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImageInput>;
  insurerOrg?: InputMaybe<Scalars['String']>;
  issueDate?: InputMaybe<Scalars['String']>;
  lastName?: InputMaybe<Scalars['String']>;
  middleName?: InputMaybe<Scalars['String']>;
  verificationStatus?: InputMaybe<Scalars['String']>;
};

export type VehicleRegistrationCertificateDocument = IDocument & {
  __typename?: 'VehicleRegistrationCertificateDocument';
  additionalInformation?: Maybe<Scalars['String']>;
  bodyNumber?: Maybe<Scalars['String']>;
  carNumber?: Maybe<Scalars['String']>;
  category?: Maybe<Scalars['String']>;
  color?: Maybe<Scalars['String']>;
  docNumber?: Maybe<Scalars['String']>;
  ecoClass?: Maybe<Scalars['String']>;
  firstName?: Maybe<Scalars['String']>;
  firstNameLat?: Maybe<Scalars['String']>;
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  issueDate?: Maybe<Scalars['String']>;
  issuerSubdivisionCode?: Maybe<Scalars['String']>;
  lastName?: Maybe<Scalars['String']>;
  lastNameLat?: Maybe<Scalars['String']>;
  maxWeight?: Maybe<Scalars['String']>;
  middleName?: Maybe<Scalars['String']>;
  model?: Maybe<Scalars['String']>;
  modelLat?: Maybe<Scalars['String']>;
  originalUrl?: Maybe<Scalars['String']>;
  power?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  pts?: Maybe<Scalars['String']>;
  registrationAddress?: Maybe<Scalars['String']>;
  section: DocumentSection;
  shasiNumber?: Maybe<Scalars['String']>;
  temporaryReg?: Maybe<Scalars['String']>;
  type: DocumentType;
  vehicleType?: Maybe<Scalars['String']>;
  verificationStatus?: Maybe<Scalars['String']>;
  vin?: Maybe<Scalars['String']>;
  withoutLoadWeight?: Maybe<Scalars['String']>;
  year?: Maybe<Scalars['String']>;
};

export type VerifyCodeToBindPrimaryPhoneInput = {
  code: Scalars['String'];
  trackId: Scalars['String'];
};

export type VerifyCodeToBindPrimaryPhonePayload = {
  __typename?: 'VerifyCodeToBindPrimaryPhonePayload';
  query: Query;
  trackId: Scalars['String'];
};

export type VerifyCodeToBindPrimaryPhoneProblem = {
  __typename?: 'VerifyCodeToBindPrimaryPhoneProblem';
  reason: VerifyCodeToBindPrimaryPhoneProblemReason;
};

export enum VerifyCodeToBindPrimaryPhoneProblemReason {
  CodeEmpty = 'CODE_EMPTY',
  CodeInvalid = 'CODE_INVALID',
  CodeNotSent = 'CODE_NOT_SENT',
  ConfirmationsLimitExceeded = 'CONFIRMATIONS_LIMIT_EXCEEDED',
  Internal = 'INTERNAL',
  TrackIdInvalid = 'TRACK_ID_INVALID',
}

export type VerifyCodeToBindPrimaryPhoneResult =
  | VerifyCodeToBindPrimaryPhonePayload
  | VerifyCodeToBindPrimaryPhoneProblem;

export type VerifyCodeToConfirmPhoneInput = {
  code: Scalars['String'];
  trackId: Scalars['String'];
};

export type VerifyCodeToConfirmPhonePayload = {
  __typename?: 'VerifyCodeToConfirmPhonePayload';
  trackId: Scalars['String'];
};

export type VerifyCodeToConfirmPhoneProblem = {
  __typename?: 'VerifyCodeToConfirmPhoneProblem';
  reason: VerifyCodeToConfirmPhoneProblemReason;
};

export enum VerifyCodeToConfirmPhoneProblemReason {
  CodeInvalid = 'CODE_INVALID',
  CodeNotSent = 'CODE_NOT_SENT',
  ConfirmationsLimitExceeded = 'CONFIRMATIONS_LIMIT_EXCEEDED',
  Internal = 'INTERNAL',
  TrackIdInvalid = 'TRACK_ID_INVALID',
}

export type VerifyCodeToConfirmPhoneResult =
  | VerifyCodeToConfirmPhonePayload
  | VerifyCodeToConfirmPhoneProblem;

export type Viewer = {
  __typename?: 'Viewer';
  avatarId: Scalars['String'];
  birthdate?: Maybe<Scalars['String']>;
  city?: Maybe<Scalars['String']>;
  country: Scalars['String'];
  displayName: Scalars['String'];
  firstName?: Maybe<Scalars['String']>;
  fullName?: Maybe<Scalars['String']>;
  gender: Scalars['String'];
  hasFamilyPlus: Scalars['Boolean'];
  hasPublicIdSet?: Maybe<Scalars['Boolean']>;
  havePlus: Scalars['Boolean'];
  id: Scalars['ID'];
  isChild: Scalars['Boolean'];
  lastName?: Maybe<Scalars['String']>;
  publicId?: Maybe<Scalars['String']>;
  timezone: Scalars['String'];
};

export type VoluntaryMedicalInsuranceDocument = IDocument & {
  __typename?: 'VoluntaryMedicalInsuranceDocument';
  birthDate?: Maybe<Scalars['String']>;
  docNumber?: Maybe<Scalars['String']>;
  endDate?: Maybe<Scalars['String']>;
  firstName?: Maybe<Scalars['String']>;
  gender?: Maybe<DocumentGender>;
  id: Scalars['ID'];
  images: Array<DocumentImage>;
  insurerOrg?: Maybe<Scalars['String']>;
  issueDate?: Maybe<Scalars['String']>;
  lastName?: Maybe<Scalars['String']>;
  middleName?: Maybe<Scalars['String']>;
  originalUrl?: Maybe<Scalars['String']>;
  previewUrl?: Maybe<Scalars['String']>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Maybe<Scalars['String']>;
};

export type GetTransactionInput = {
  id: Scalars['String'];
};

export type ControlQuestionAccountFragment = {
  __typename?: 'Account';
  id: string;
  question?: { __typename?: 'Question'; id: string; text: string } | null;
};

export type CurrentQuestionQueryVariables = Exact<{ [key: string]: never }>;

export type CurrentQuestionQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    question?: { __typename?: 'Question'; id: string; text: string } | null;
  };
};

export type AvailableQuestionsQueryVariables = Exact<{ [key: string]: never }>;

export type AvailableQuestionsQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    question?: { __typename?: 'Question'; id: string; text: string } | null;
  };
  accountAvailableQuestions: Array<{ __typename?: 'AvailableQuestion'; id: string; text: string }>;
};

export type SetQuestionMutationVariables = Exact<{
  input: SetQuestionInput;
}>;

export type SetQuestionMutation = {
  __typename?: 'Mutation';
  accountSetQuestion:
    | {
        __typename?: 'SetQuestionPayload';
        query: {
          __typename?: 'Query';
          account: {
            __typename?: 'Account';
            id: string;
            question?: { __typename?: 'Question'; id: string; text: string } | null;
          };
        };
      }
    | { __typename?: 'SetQuestionProblem'; reason: SetQuestionProblemKind; trackId: string };
};

export type AccountRecoveryEmailsFragment = {
  __typename?: 'Account';
  id: string;
  emails: Array<{
    __typename?: 'Email';
    address: string;
    type: EmailType;
    isPrimary: boolean;
    isConfirmed: boolean;
  }>;
};

export type RecoveryEmailsQueryVariables = Exact<{ [key: string]: never }>;

export type RecoveryEmailsQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    emails: Array<{
      __typename?: 'Email';
      address: string;
      type: EmailType;
      isPrimary: boolean;
      isConfirmed: boolean;
    }>;
  };
};

export type AccountAddRecoveryEmailMutationVariables = Exact<{
  input: AddRecoveryEmailInput;
}>;

export type AccountAddRecoveryEmailMutation = {
  __typename?: 'Mutation';
  accountAddRecoveryEmail:
    | {
        __typename?: 'AddRecoveryEmailPayload';
        trackId: string;
        query: {
          __typename?: 'Query';
          account: {
            __typename?: 'Account';
            id: string;
            emails: Array<{
              __typename?: 'Email';
              address: string;
              type: EmailType;
              isPrimary: boolean;
              isConfirmed: boolean;
            }>;
          };
        };
      }
    | {
        __typename?: 'AddRecoveryEmailProblem';
        trackId: string;
        reason: AddRecoveryEmailProblemKind;
      };
};

export type AccountRemoveRecoveryEmailMutationVariables = Exact<{
  input: RemoveRecoveryEmailInput;
}>;

export type AccountRemoveRecoveryEmailMutation = {
  __typename?: 'Mutation';
  accountRemoveRecoveryEmail:
    | {
        __typename?: 'RemoveRecoveryEmailPayload';
        query: {
          __typename?: 'Query';
          account: {
            __typename?: 'Account';
            id: string;
            emails: Array<{
              __typename?: 'Email';
              address: string;
              type: EmailType;
              isPrimary: boolean;
              isConfirmed: boolean;
            }>;
          };
        };
      }
    | {
        __typename?: 'RemoveRecoveryEmailProblem';
        trackId: string;
        reason: RemoveRecoveryEmailProblemKind;
      };
};

export type AccountConfirmRecoveryEmailByLinkMutationVariables = Exact<{
  input: ConfirmRecoveryEmailByLinkInput;
}>;

export type AccountConfirmRecoveryEmailByLinkMutation = {
  __typename?: 'Mutation';
  accountConfirmRecoveryEmailByLink:
    | {
        __typename?: 'ConfirmRecoveryEmailByLinkPayload';
        query: {
          __typename?: 'Query';
          account: {
            __typename?: 'Account';
            id: string;
            emails: Array<{
              __typename?: 'Email';
              address: string;
              type: EmailType;
              isPrimary: boolean;
              isConfirmed: boolean;
            }>;
          };
        };
      }
    | {
        __typename?: 'ConfirmRecoveryEmailByLinkProblem';
        reason: ConfirmRecoveryEmailByLinkProblemKind;
      };
};

export type AccountConfirmRecoveryEmailByCodeMutationVariables = Exact<{
  input: ConfirmRecoveryEmailByCodeInput;
}>;

export type AccountConfirmRecoveryEmailByCodeMutation = {
  __typename?: 'Mutation';
  accountConfirmRecoveryEmailByCode:
    | {
        __typename?: 'ConfirmRecoveryEmailByCodePayload';
        query: {
          __typename?: 'Query';
          account: {
            __typename?: 'Account';
            id: string;
            emails: Array<{
              __typename?: 'Email';
              address: string;
              type: EmailType;
              isPrimary: boolean;
              isConfirmed: boolean;
            }>;
          };
        };
      }
    | {
        __typename?: 'ConfirmRecoveryEmailByCodeProblem';
        reason: ConfirmRecoveryEmailByCodeProblemKind;
      };
};

export type AddressDetailsFragment = {
  __typename?: 'Address';
  id: string;
  comment?: string | null;
  entrance?: string | null;
  floor?: string | null;
  fullText?: string | null;
  intercom?: string | null;
  region?: string | null;
  room?: string | null;
  shortText: string;
  street?: string | null;
  type: AddressType;
};

export type CreateOrUpdateAddressMutationVariables = Exact<{
  input: CreateOrUpdateAddressInput;
}>;

export type CreateOrUpdateAddressMutation = {
  __typename?: 'Mutation';
  response:
    | {
        __typename?: 'CreateOrUpdateAddressPayload';
        query: {
          __typename?: 'Query';
          addresses: Array<{
            __typename?: 'Address';
            id: string;
            comment?: string | null;
            entrance?: string | null;
            floor?: string | null;
            fullText?: string | null;
            intercom?: string | null;
            region?: string | null;
            room?: string | null;
            shortText: string;
            street?: string | null;
            type: AddressType;
          }>;
        };
      }
    | { __typename?: 'CreateOrUpdateAddressProblem'; reason: CreateOrUpdateAddressProblemKind };
};

export type DeleteAddressMutationVariables = Exact<{
  input: DeleteAddressInput;
}>;

export type DeleteAddressMutation = {
  __typename?: 'Mutation';
  response:
    | {
        __typename?: 'DeleteAddressPayload';
        query: {
          __typename?: 'Query';
          addresses: Array<{
            __typename?: 'Address';
            id: string;
            comment?: string | null;
            entrance?: string | null;
            floor?: string | null;
            fullText?: string | null;
            intercom?: string | null;
            region?: string | null;
            room?: string | null;
            shortText: string;
            street?: string | null;
            type: AddressType;
          }>;
        };
      }
    | { __typename?: 'DeleteAddressProblem'; reason: DeleteAddressProblemKind };
};

export type ConfirmByPasswordMutationVariables = Exact<{
  input: ConfirmByPasswordInput;
}>;

export type ConfirmByPasswordMutation = {
  __typename?: 'Mutation';
  confirmByPassword:
    | { __typename: 'ConfirmByPasswordPayload'; successful: boolean }
    | { __typename: 'ConfirmByPasswordProblem'; reason: ConfirmByPasswordProblemKind };
};

export type BirthCertificateFullFragmentFragment = {
  __typename?: 'BirthCertificateDocument';
  id: string;
  type: DocumentType;
  section: DocumentSection;
  verificationStatus?: string | null;
  series?: string | null;
  docNumber?: string | null;
  firstName?: string | null;
  lastName?: string | null;
  middleName?: string | null;
  birthDate?: string | null;
  birthPlace?: string | null;
  birthAkt?: string | null;
  fatherLastName?: string | null;
  fatherFirstName?: string | null;
  fatherMiddleName?: string | null;
  fatherCitizenship?: string | null;
  fatherBirthDate?: string | null;
  fatherNationality?: string | null;
  motherLastName?: string | null;
  motherFirstName?: string | null;
  motherMiddleName?: string | null;
  motherCitizenship?: string | null;
  motherBirthDate?: string | null;
  motherNationality?: string | null;
  registrationPlace?: string | null;
  issuePlace?: string | null;
  issueDate?: string | null;
  images: Array<{
    __typename?: 'DocumentImage';
    id: string;
    originalUri?: string | null;
    originalUrl: string;
    originalWidth?: number | null;
    originalHeight?: number | null;
    previewUri?: string | null;
    previewUrl?: string | null;
    previewWidth?: number | null;
    previewHeight?: number | null;
  }>;
};

export type GetBirthCertificateByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;

export type GetBirthCertificateByIdQuery = {
  __typename?: 'Query';
  document:
    | {
        __typename?: 'BirthCertificateDocument';
        id: string;
        type: DocumentType;
        section: DocumentSection;
        verificationStatus?: string | null;
        series?: string | null;
        docNumber?: string | null;
        firstName?: string | null;
        lastName?: string | null;
        middleName?: string | null;
        birthDate?: string | null;
        birthPlace?: string | null;
        birthAkt?: string | null;
        fatherLastName?: string | null;
        fatherFirstName?: string | null;
        fatherMiddleName?: string | null;
        fatherCitizenship?: string | null;
        fatherBirthDate?: string | null;
        fatherNationality?: string | null;
        motherLastName?: string | null;
        motherFirstName?: string | null;
        motherMiddleName?: string | null;
        motherCitizenship?: string | null;
        motherBirthDate?: string | null;
        motherNationality?: string | null;
        registrationPlace?: string | null;
        issuePlace?: string | null;
        issueDate?: string | null;
        images: Array<{
          __typename?: 'DocumentImage';
          id: string;
          originalUri?: string | null;
          originalUrl: string;
          originalWidth?: number | null;
          originalHeight?: number | null;
          previewUri?: string | null;
          previewUrl?: string | null;
          previewWidth?: number | null;
          previewHeight?: number | null;
        }>;
      }
    | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
    | { __typename?: 'DriverLicenseDocument' }
    | { __typename?: 'InnDocument' }
    | { __typename?: 'InternationalIdDocument' }
    | { __typename?: 'MedicalInsuranceDocument' }
    | { __typename?: 'NationalIdDocument' }
    | { __typename?: 'SnilsDocument' }
    | { __typename?: 'VehicleRegistrationCertificateDocument' }
    | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
};

export type AddBirthCertificateMutationVariables = Exact<{
  input: AddDocumentInput;
}>;

export type AddBirthCertificateMutation = {
  __typename?: 'Mutation';
  addDocument:
    | {
        __typename?: 'AddDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                firstName?: string | null;
                lastName?: string | null;
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
          >;
        };
      }
    | { __typename?: 'AddDocumentProblem'; reason: AddDocumentProblemReason };
};

export type UpdateBirthCertificateMutationVariables = Exact<{
  input: UpdateDocumentInput;
  id: Scalars['ID'];
}>;

export type UpdateBirthCertificateMutation = {
  __typename?: 'Mutation';
  updateDocument:
    | {
        __typename?: 'UpdateDocumentPayload';
        query: {
          __typename?: 'Query';
          document:
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
                verificationStatus?: string | null;
                series?: string | null;
                docNumber?: string | null;
                firstName?: string | null;
                lastName?: string | null;
                middleName?: string | null;
                birthDate?: string | null;
                birthPlace?: string | null;
                birthAkt?: string | null;
                fatherLastName?: string | null;
                fatherFirstName?: string | null;
                fatherMiddleName?: string | null;
                fatherCitizenship?: string | null;
                fatherBirthDate?: string | null;
                fatherNationality?: string | null;
                motherLastName?: string | null;
                motherFirstName?: string | null;
                motherMiddleName?: string | null;
                motherCitizenship?: string | null;
                motherBirthDate?: string | null;
                motherNationality?: string | null;
                registrationPlace?: string | null;
                issuePlace?: string | null;
                issueDate?: string | null;
                images: Array<{
                  __typename?: 'DocumentImage';
                  id: string;
                  originalUri?: string | null;
                  originalUrl: string;
                  originalWidth?: number | null;
                  originalHeight?: number | null;
                  previewUri?: string | null;
                  previewUrl?: string | null;
                  previewWidth?: number | null;
                  previewHeight?: number | null;
                }>;
              }
            | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
            | { __typename?: 'DriverLicenseDocument' }
            | { __typename?: 'InnDocument' }
            | { __typename?: 'InternationalIdDocument' }
            | { __typename?: 'MedicalInsuranceDocument' }
            | { __typename?: 'NationalIdDocument' }
            | { __typename?: 'SnilsDocument' }
            | { __typename?: 'VehicleRegistrationCertificateDocument' }
            | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
        };
      }
    | { __typename?: 'UpdateDocumentProblem'; reason: UpdateDocumentProblemReason };
};

export type DeleteBirthCertificateDocumentMutationVariables = Exact<{
  input: DeleteDocumentInput;
}>;

export type DeleteBirthCertificateDocumentMutation = {
  __typename?: 'Mutation';
  deleteDocument:
    | {
        __typename?: 'DeleteDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
          >;
        };
      }
    | { __typename?: 'DeleteDocumentProblem'; reason: DeleteDocumentProblemReason };
};

export type DriverLicenseFullFragmentFragment = {
  __typename?: 'DriverLicenseDocument';
  id: string;
  type: DocumentType;
  section: DocumentSection;
  verificationStatus?: string | null;
  lastName?: string | null;
  lastNameLat?: string | null;
  firstName?: string | null;
  firstNameLat?: string | null;
  middleName?: string | null;
  middleNameLat?: string | null;
  birthDate?: string | null;
  birthPlace?: string | null;
  birthPlaceLat?: string | null;
  issueDate?: string | null;
  endDate?: string | null;
  issuedBy?: string | null;
  issuedByLat?: string | null;
  docNumber?: string | null;
  issuedCity?: string | null;
  issuedCityLat?: string | null;
  category?: string | null;
  additionalInformation?: string | null;
  images: Array<{
    __typename?: 'DocumentImage';
    id: string;
    originalUri?: string | null;
    originalUrl: string;
    originalWidth?: number | null;
    originalHeight?: number | null;
    previewUri?: string | null;
    previewUrl?: string | null;
    previewWidth?: number | null;
    previewHeight?: number | null;
  }>;
};

export type GetDriverLicenseByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;

export type GetDriverLicenseByIdQuery = {
  __typename?: 'Query';
  document:
    | { __typename?: 'BirthCertificateDocument' }
    | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
    | {
        __typename?: 'DriverLicenseDocument';
        id: string;
        type: DocumentType;
        section: DocumentSection;
        verificationStatus?: string | null;
        lastName?: string | null;
        lastNameLat?: string | null;
        firstName?: string | null;
        firstNameLat?: string | null;
        middleName?: string | null;
        middleNameLat?: string | null;
        birthDate?: string | null;
        birthPlace?: string | null;
        birthPlaceLat?: string | null;
        issueDate?: string | null;
        endDate?: string | null;
        issuedBy?: string | null;
        issuedByLat?: string | null;
        docNumber?: string | null;
        issuedCity?: string | null;
        issuedCityLat?: string | null;
        category?: string | null;
        additionalInformation?: string | null;
        images: Array<{
          __typename?: 'DocumentImage';
          id: string;
          originalUri?: string | null;
          originalUrl: string;
          originalWidth?: number | null;
          originalHeight?: number | null;
          previewUri?: string | null;
          previewUrl?: string | null;
          previewWidth?: number | null;
          previewHeight?: number | null;
        }>;
      }
    | { __typename?: 'InnDocument' }
    | { __typename?: 'InternationalIdDocument' }
    | { __typename?: 'MedicalInsuranceDocument' }
    | { __typename?: 'NationalIdDocument' }
    | { __typename?: 'SnilsDocument' }
    | { __typename?: 'VehicleRegistrationCertificateDocument' }
    | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
};

export type AddDriverLicenseMutationVariables = Exact<{
  input: AddDocumentInput;
}>;

export type AddDriverLicenseMutation = {
  __typename?: 'Mutation';
  addDocument:
    | {
        __typename?: 'AddDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                firstName?: string | null;
                lastName?: string | null;
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
          >;
        };
      }
    | { __typename?: 'AddDocumentProblem'; reason: AddDocumentProblemReason };
};

export type UpdateDriverLicenseMutationVariables = Exact<{
  input: UpdateDocumentInput;
  id: Scalars['ID'];
}>;

export type UpdateDriverLicenseMutation = {
  __typename?: 'Mutation';
  updateDocument:
    | {
        __typename?: 'UpdateDocumentPayload';
        query: {
          __typename?: 'Query';
          document:
            | { __typename?: 'BirthCertificateDocument' }
            | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
                verificationStatus?: string | null;
                lastName?: string | null;
                lastNameLat?: string | null;
                firstName?: string | null;
                firstNameLat?: string | null;
                middleName?: string | null;
                middleNameLat?: string | null;
                birthDate?: string | null;
                birthPlace?: string | null;
                birthPlaceLat?: string | null;
                issueDate?: string | null;
                endDate?: string | null;
                issuedBy?: string | null;
                issuedByLat?: string | null;
                docNumber?: string | null;
                issuedCity?: string | null;
                issuedCityLat?: string | null;
                category?: string | null;
                additionalInformation?: string | null;
                images: Array<{
                  __typename?: 'DocumentImage';
                  id: string;
                  originalUri?: string | null;
                  originalUrl: string;
                  originalWidth?: number | null;
                  originalHeight?: number | null;
                  previewUri?: string | null;
                  previewUrl?: string | null;
                  previewWidth?: number | null;
                  previewHeight?: number | null;
                }>;
              }
            | { __typename?: 'InnDocument' }
            | { __typename?: 'InternationalIdDocument' }
            | { __typename?: 'MedicalInsuranceDocument' }
            | { __typename?: 'NationalIdDocument' }
            | { __typename?: 'SnilsDocument' }
            | { __typename?: 'VehicleRegistrationCertificateDocument' }
            | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
        };
      }
    | { __typename?: 'UpdateDocumentProblem'; reason: UpdateDocumentProblemReason };
};

export type DeleteDriverLicenseDocumentMutationVariables = Exact<{
  input: DeleteDocumentInput;
}>;

export type DeleteDriverLicenseDocumentMutation = {
  __typename?: 'Mutation';
  deleteDocument:
    | {
        __typename?: 'DeleteDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
          >;
        };
      }
    | { __typename?: 'DeleteDocumentProblem'; reason: DeleteDocumentProblemReason };
};

export type InnFullFragmentFragment = {
  __typename?: 'InnDocument';
  id: string;
  type: DocumentType;
  section: DocumentSection;
  verificationStatus?: string | null;
  docNumber?: string | null;
  firstName?: string | null;
  lastName?: string | null;
  middleName?: string | null;
  birthDate?: string | null;
  gender?: DocumentGender | null;
  issuedBy?: string | null;
  issueDate?: string | null;
  images: Array<{
    __typename?: 'DocumentImage';
    id: string;
    originalUri?: string | null;
    originalUrl: string;
    originalWidth?: number | null;
    originalHeight?: number | null;
    previewUri?: string | null;
    previewUrl?: string | null;
    previewWidth?: number | null;
    previewHeight?: number | null;
  }>;
};

export type GetInnByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;

export type GetInnByIdQuery = {
  __typename?: 'Query';
  document:
    | { __typename?: 'BirthCertificateDocument' }
    | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
    | { __typename?: 'DriverLicenseDocument' }
    | {
        __typename?: 'InnDocument';
        id: string;
        type: DocumentType;
        section: DocumentSection;
        verificationStatus?: string | null;
        docNumber?: string | null;
        firstName?: string | null;
        lastName?: string | null;
        middleName?: string | null;
        birthDate?: string | null;
        gender?: DocumentGender | null;
        issuedBy?: string | null;
        issueDate?: string | null;
        images: Array<{
          __typename?: 'DocumentImage';
          id: string;
          originalUri?: string | null;
          originalUrl: string;
          originalWidth?: number | null;
          originalHeight?: number | null;
          previewUri?: string | null;
          previewUrl?: string | null;
          previewWidth?: number | null;
          previewHeight?: number | null;
        }>;
      }
    | { __typename?: 'InternationalIdDocument' }
    | { __typename?: 'MedicalInsuranceDocument' }
    | { __typename?: 'NationalIdDocument' }
    | { __typename?: 'SnilsDocument' }
    | { __typename?: 'VehicleRegistrationCertificateDocument' }
    | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
};

export type AddInnMutationVariables = Exact<{
  input: AddDocumentInput;
}>;

export type AddInnMutation = {
  __typename?: 'Mutation';
  addDocument:
    | {
        __typename?: 'AddDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InnDocument';
                firstName?: string | null;
                lastName?: string | null;
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
          >;
        };
      }
    | { __typename?: 'AddDocumentProblem'; reason: AddDocumentProblemReason };
};

export type UpdateInnMutationVariables = Exact<{
  input: UpdateDocumentInput;
  id: Scalars['ID'];
}>;

export type UpdateInnMutation = {
  __typename?: 'Mutation';
  updateDocument:
    | {
        __typename?: 'UpdateDocumentPayload';
        query: {
          __typename?: 'Query';
          document:
            | { __typename?: 'BirthCertificateDocument' }
            | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
            | { __typename?: 'DriverLicenseDocument' }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
                verificationStatus?: string | null;
                docNumber?: string | null;
                firstName?: string | null;
                lastName?: string | null;
                middleName?: string | null;
                birthDate?: string | null;
                gender?: DocumentGender | null;
                issuedBy?: string | null;
                issueDate?: string | null;
                images: Array<{
                  __typename?: 'DocumentImage';
                  id: string;
                  originalUri?: string | null;
                  originalUrl: string;
                  originalWidth?: number | null;
                  originalHeight?: number | null;
                  previewUri?: string | null;
                  previewUrl?: string | null;
                  previewWidth?: number | null;
                  previewHeight?: number | null;
                }>;
              }
            | { __typename?: 'InternationalIdDocument' }
            | { __typename?: 'MedicalInsuranceDocument' }
            | { __typename?: 'NationalIdDocument' }
            | { __typename?: 'SnilsDocument' }
            | { __typename?: 'VehicleRegistrationCertificateDocument' }
            | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
        };
      }
    | { __typename?: 'UpdateDocumentProblem'; reason: UpdateDocumentProblemReason };
};

export type DeleteInnDocumentMutationVariables = Exact<{
  input: DeleteDocumentInput;
}>;

export type DeleteInnDocumentMutation = {
  __typename?: 'Mutation';
  deleteDocument:
    | {
        __typename?: 'DeleteDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
          >;
        };
      }
    | { __typename?: 'DeleteDocumentProblem'; reason: DeleteDocumentProblemReason };
};

export type InternationalIdFullFragmentFragment = {
  __typename?: 'InternationalIdDocument';
  id: string;
  type: DocumentType;
  section: DocumentSection;
  verificationStatus?: string | null;
  docNumber?: string | null;
  lastName?: string | null;
  lastNameLat?: string | null;
  firstName?: string | null;
  firstNameLat?: string | null;
  citizenship?: string | null;
  citizenshipLat?: string | null;
  birthDate?: string | null;
  gender?: DocumentGender | null;
  birthPlace?: string | null;
  birthPlaceLat?: string | null;
  issueDate?: string | null;
  endDate?: string | null;
  issuedBy?: string | null;
  images: Array<{
    __typename?: 'DocumentImage';
    id: string;
    originalUri?: string | null;
    originalUrl: string;
    originalWidth?: number | null;
    originalHeight?: number | null;
    previewUri?: string | null;
    previewUrl?: string | null;
    previewWidth?: number | null;
    previewHeight?: number | null;
  }>;
};

export type GetInternationalIdByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;

export type GetInternationalIdByIdQuery = {
  __typename?: 'Query';
  document:
    | { __typename?: 'BirthCertificateDocument' }
    | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
    | { __typename?: 'DriverLicenseDocument' }
    | { __typename?: 'InnDocument' }
    | {
        __typename?: 'InternationalIdDocument';
        id: string;
        type: DocumentType;
        section: DocumentSection;
        verificationStatus?: string | null;
        docNumber?: string | null;
        lastName?: string | null;
        lastNameLat?: string | null;
        firstName?: string | null;
        firstNameLat?: string | null;
        citizenship?: string | null;
        citizenshipLat?: string | null;
        birthDate?: string | null;
        gender?: DocumentGender | null;
        birthPlace?: string | null;
        birthPlaceLat?: string | null;
        issueDate?: string | null;
        endDate?: string | null;
        issuedBy?: string | null;
        images: Array<{
          __typename?: 'DocumentImage';
          id: string;
          originalUri?: string | null;
          originalUrl: string;
          originalWidth?: number | null;
          originalHeight?: number | null;
          previewUri?: string | null;
          previewUrl?: string | null;
          previewWidth?: number | null;
          previewHeight?: number | null;
        }>;
      }
    | { __typename?: 'MedicalInsuranceDocument' }
    | { __typename?: 'NationalIdDocument' }
    | { __typename?: 'SnilsDocument' }
    | { __typename?: 'VehicleRegistrationCertificateDocument' }
    | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
};

export type AddInternationalIdMutationVariables = Exact<{
  input: AddDocumentInput;
}>;

export type AddInternationalIdMutation = {
  __typename?: 'Mutation';
  addDocument:
    | {
        __typename?: 'AddDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InternationalIdDocument';
                firstName?: string | null;
                lastName?: string | null;
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
          >;
        };
      }
    | { __typename?: 'AddDocumentProblem'; reason: AddDocumentProblemReason };
};

export type UpdateInternationalIdMutationVariables = Exact<{
  input: UpdateDocumentInput;
  id: Scalars['ID'];
}>;

export type UpdateInternationalIdMutation = {
  __typename?: 'Mutation';
  updateDocument:
    | {
        __typename?: 'UpdateDocumentPayload';
        query: {
          __typename?: 'Query';
          document:
            | { __typename?: 'BirthCertificateDocument' }
            | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
            | { __typename?: 'DriverLicenseDocument' }
            | { __typename?: 'InnDocument' }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
                verificationStatus?: string | null;
                docNumber?: string | null;
                lastName?: string | null;
                lastNameLat?: string | null;
                firstName?: string | null;
                firstNameLat?: string | null;
                citizenship?: string | null;
                citizenshipLat?: string | null;
                birthDate?: string | null;
                gender?: DocumentGender | null;
                birthPlace?: string | null;
                birthPlaceLat?: string | null;
                issueDate?: string | null;
                endDate?: string | null;
                issuedBy?: string | null;
                images: Array<{
                  __typename?: 'DocumentImage';
                  id: string;
                  originalUri?: string | null;
                  originalUrl: string;
                  originalWidth?: number | null;
                  originalHeight?: number | null;
                  previewUri?: string | null;
                  previewUrl?: string | null;
                  previewWidth?: number | null;
                  previewHeight?: number | null;
                }>;
              }
            | { __typename?: 'MedicalInsuranceDocument' }
            | { __typename?: 'NationalIdDocument' }
            | { __typename?: 'SnilsDocument' }
            | { __typename?: 'VehicleRegistrationCertificateDocument' }
            | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
        };
      }
    | { __typename?: 'UpdateDocumentProblem'; reason: UpdateDocumentProblemReason };
};

export type DeleteInternationalIdDocumentMutationVariables = Exact<{
  input: DeleteDocumentInput;
}>;

export type DeleteInternationalIdDocumentMutation = {
  __typename?: 'Mutation';
  deleteDocument:
    | {
        __typename?: 'DeleteDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
          >;
        };
      }
    | { __typename?: 'DeleteDocumentProblem'; reason: DeleteDocumentProblemReason };
};

export type MedicalInsuranceFullFragmentFragment = {
  __typename?: 'MedicalInsuranceDocument';
  id: string;
  type: DocumentType;
  section: DocumentSection;
  verificationStatus?: string | null;
  docNumber?: string | null;
  firstName?: string | null;
  lastName?: string | null;
  middleName?: string | null;
  birthDate?: string | null;
  gender?: DocumentGender | null;
  blank?: string | null;
  images: Array<{
    __typename?: 'DocumentImage';
    id: string;
    originalUri?: string | null;
    originalUrl: string;
    originalWidth?: number | null;
    originalHeight?: number | null;
    previewUri?: string | null;
    previewUrl?: string | null;
    previewWidth?: number | null;
    previewHeight?: number | null;
  }>;
};

export type GetMedicalInsuranceByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;

export type GetMedicalInsuranceByIdQuery = {
  __typename?: 'Query';
  document:
    | { __typename?: 'BirthCertificateDocument' }
    | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
    | { __typename?: 'DriverLicenseDocument' }
    | { __typename?: 'InnDocument' }
    | { __typename?: 'InternationalIdDocument' }
    | {
        __typename?: 'MedicalInsuranceDocument';
        id: string;
        type: DocumentType;
        section: DocumentSection;
        verificationStatus?: string | null;
        docNumber?: string | null;
        firstName?: string | null;
        lastName?: string | null;
        middleName?: string | null;
        birthDate?: string | null;
        gender?: DocumentGender | null;
        blank?: string | null;
        images: Array<{
          __typename?: 'DocumentImage';
          id: string;
          originalUri?: string | null;
          originalUrl: string;
          originalWidth?: number | null;
          originalHeight?: number | null;
          previewUri?: string | null;
          previewUrl?: string | null;
          previewWidth?: number | null;
          previewHeight?: number | null;
        }>;
      }
    | { __typename?: 'NationalIdDocument' }
    | { __typename?: 'SnilsDocument' }
    | { __typename?: 'VehicleRegistrationCertificateDocument' }
    | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
};

export type AddMedicalInsuranceMutationVariables = Exact<{
  input: AddDocumentInput;
}>;

export type AddMedicalInsuranceMutation = {
  __typename?: 'Mutation';
  addDocument:
    | {
        __typename?: 'AddDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                firstName?: string | null;
                lastName?: string | null;
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
          >;
        };
      }
    | { __typename?: 'AddDocumentProblem'; reason: AddDocumentProblemReason };
};

export type UpdateMedicalInsuranceMutationVariables = Exact<{
  input: UpdateDocumentInput;
  id: Scalars['ID'];
}>;

export type UpdateMedicalInsuranceMutation = {
  __typename?: 'Mutation';
  updateDocument:
    | {
        __typename?: 'UpdateDocumentPayload';
        query: {
          __typename?: 'Query';
          document:
            | { __typename?: 'BirthCertificateDocument' }
            | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
            | { __typename?: 'DriverLicenseDocument' }
            | { __typename?: 'InnDocument' }
            | { __typename?: 'InternationalIdDocument' }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
                verificationStatus?: string | null;
                docNumber?: string | null;
                firstName?: string | null;
                lastName?: string | null;
                middleName?: string | null;
                birthDate?: string | null;
                gender?: DocumentGender | null;
                blank?: string | null;
                images: Array<{
                  __typename?: 'DocumentImage';
                  id: string;
                  originalUri?: string | null;
                  originalUrl: string;
                  originalWidth?: number | null;
                  originalHeight?: number | null;
                  previewUri?: string | null;
                  previewUrl?: string | null;
                  previewWidth?: number | null;
                  previewHeight?: number | null;
                }>;
              }
            | { __typename?: 'NationalIdDocument' }
            | { __typename?: 'SnilsDocument' }
            | { __typename?: 'VehicleRegistrationCertificateDocument' }
            | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
        };
      }
    | { __typename?: 'UpdateDocumentProblem'; reason: UpdateDocumentProblemReason };
};

export type DeleteMedicalInsuranceDocumentMutationVariables = Exact<{
  input: DeleteDocumentInput;
}>;

export type DeleteMedicalInsuranceDocumentMutation = {
  __typename?: 'Mutation';
  deleteDocument:
    | {
        __typename?: 'DeleteDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
          >;
        };
      }
    | { __typename?: 'DeleteDocumentProblem'; reason: DeleteDocumentProblemReason };
};

export type NationalIdFullFragmentFragment = {
  __typename?: 'NationalIdDocument';
  id: string;
  type: DocumentType;
  section: DocumentSection;
  verificationStatus?: string | null;
  docNumber?: string | null;
  firstName?: string | null;
  lastName?: string | null;
  middleName?: string | null;
  birthDate?: string | null;
  gender?: DocumentGender | null;
  birthPlace?: string | null;
  issuedBy?: string | null;
  issuerSubdivisionCode?: string | null;
  issueDate?: string | null;
  registrationAddress?: string | null;
  images: Array<{
    __typename?: 'DocumentImage';
    id: string;
    originalUri?: string | null;
    originalUrl: string;
    originalWidth?: number | null;
    originalHeight?: number | null;
    previewUri?: string | null;
    previewUrl?: string | null;
    previewWidth?: number | null;
    previewHeight?: number | null;
  }>;
};

export type GetNationalIdByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;

export type GetNationalIdByIdQuery = {
  __typename?: 'Query';
  document:
    | { __typename?: 'BirthCertificateDocument' }
    | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
    | { __typename?: 'DriverLicenseDocument' }
    | { __typename?: 'InnDocument' }
    | { __typename?: 'InternationalIdDocument' }
    | { __typename?: 'MedicalInsuranceDocument' }
    | {
        __typename?: 'NationalIdDocument';
        id: string;
        type: DocumentType;
        section: DocumentSection;
        verificationStatus?: string | null;
        docNumber?: string | null;
        firstName?: string | null;
        lastName?: string | null;
        middleName?: string | null;
        birthDate?: string | null;
        gender?: DocumentGender | null;
        birthPlace?: string | null;
        issuedBy?: string | null;
        issuerSubdivisionCode?: string | null;
        issueDate?: string | null;
        registrationAddress?: string | null;
        images: Array<{
          __typename?: 'DocumentImage';
          id: string;
          originalUri?: string | null;
          originalUrl: string;
          originalWidth?: number | null;
          originalHeight?: number | null;
          previewUri?: string | null;
          previewUrl?: string | null;
          previewWidth?: number | null;
          previewHeight?: number | null;
        }>;
      }
    | { __typename?: 'SnilsDocument' }
    | { __typename?: 'VehicleRegistrationCertificateDocument' }
    | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
};

export type AddNationalIdMutationVariables = Exact<{
  input: AddDocumentInput;
}>;

export type AddNationalIdMutation = {
  __typename?: 'Mutation';
  addDocument:
    | {
        __typename?: 'AddDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'NationalIdDocument';
                firstName?: string | null;
                lastName?: string | null;
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
          >;
        };
      }
    | { __typename?: 'AddDocumentProblem'; reason: AddDocumentProblemReason };
};

export type UpdateNationalIdMutationVariables = Exact<{
  input: UpdateDocumentInput;
  id: Scalars['ID'];
}>;

export type UpdateNationalIdMutation = {
  __typename?: 'Mutation';
  updateDocument:
    | {
        __typename?: 'UpdateDocumentPayload';
        query: {
          __typename?: 'Query';
          document:
            | { __typename?: 'BirthCertificateDocument' }
            | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
            | { __typename?: 'DriverLicenseDocument' }
            | { __typename?: 'InnDocument' }
            | { __typename?: 'InternationalIdDocument' }
            | { __typename?: 'MedicalInsuranceDocument' }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
                verificationStatus?: string | null;
                docNumber?: string | null;
                firstName?: string | null;
                lastName?: string | null;
                middleName?: string | null;
                birthDate?: string | null;
                gender?: DocumentGender | null;
                birthPlace?: string | null;
                issuedBy?: string | null;
                issuerSubdivisionCode?: string | null;
                issueDate?: string | null;
                registrationAddress?: string | null;
                images: Array<{
                  __typename?: 'DocumentImage';
                  id: string;
                  originalUri?: string | null;
                  originalUrl: string;
                  originalWidth?: number | null;
                  originalHeight?: number | null;
                  previewUri?: string | null;
                  previewUrl?: string | null;
                  previewWidth?: number | null;
                  previewHeight?: number | null;
                }>;
              }
            | { __typename?: 'SnilsDocument' }
            | { __typename?: 'VehicleRegistrationCertificateDocument' }
            | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
        };
      }
    | { __typename?: 'UpdateDocumentProblem'; reason: UpdateDocumentProblemReason };
};

export type DeleteNationalIdDocumentMutationVariables = Exact<{
  input: DeleteDocumentInput;
}>;

export type DeleteNationalIdDocumentMutation = {
  __typename?: 'Mutation';
  deleteDocument:
    | {
        __typename?: 'DeleteDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
          >;
        };
      }
    | { __typename?: 'DeleteDocumentProblem'; reason: DeleteDocumentProblemReason };
};

export type SnilsFullFragmentFragment = {
  __typename?: 'SnilsDocument';
  id: string;
  type: DocumentType;
  section: DocumentSection;
  verificationStatus?: string | null;
  docNumber?: string | null;
  firstName?: string | null;
  lastName?: string | null;
  middleName?: string | null;
  birthDate?: string | null;
  birthPlace?: string | null;
  gender?: DocumentGender | null;
  issueDate?: string | null;
  images: Array<{
    __typename?: 'DocumentImage';
    id: string;
    originalUri?: string | null;
    originalUrl: string;
    originalWidth?: number | null;
    originalHeight?: number | null;
    previewUri?: string | null;
    previewUrl?: string | null;
    previewWidth?: number | null;
    previewHeight?: number | null;
  }>;
};

export type GetSnilsByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;

export type GetSnilsByIdQuery = {
  __typename?: 'Query';
  document:
    | { __typename?: 'BirthCertificateDocument' }
    | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
    | { __typename?: 'DriverLicenseDocument' }
    | { __typename?: 'InnDocument' }
    | { __typename?: 'InternationalIdDocument' }
    | { __typename?: 'MedicalInsuranceDocument' }
    | { __typename?: 'NationalIdDocument' }
    | {
        __typename?: 'SnilsDocument';
        id: string;
        type: DocumentType;
        section: DocumentSection;
        verificationStatus?: string | null;
        docNumber?: string | null;
        firstName?: string | null;
        lastName?: string | null;
        middleName?: string | null;
        birthDate?: string | null;
        birthPlace?: string | null;
        gender?: DocumentGender | null;
        issueDate?: string | null;
        images: Array<{
          __typename?: 'DocumentImage';
          id: string;
          originalUri?: string | null;
          originalUrl: string;
          originalWidth?: number | null;
          originalHeight?: number | null;
          previewUri?: string | null;
          previewUrl?: string | null;
          previewWidth?: number | null;
          previewHeight?: number | null;
        }>;
      }
    | { __typename?: 'VehicleRegistrationCertificateDocument' }
    | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
};

export type AddSnilsMutationVariables = Exact<{
  input: AddDocumentInput;
}>;

export type AddSnilsMutation = {
  __typename?: 'Mutation';
  addDocument:
    | {
        __typename?: 'AddDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'SnilsDocument';
                firstName?: string | null;
                lastName?: string | null;
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
          >;
        };
      }
    | { __typename?: 'AddDocumentProblem'; reason: AddDocumentProblemReason };
};

export type UpdateSnilsMutationVariables = Exact<{
  input: UpdateDocumentInput;
  id: Scalars['ID'];
}>;

export type UpdateSnilsMutation = {
  __typename?: 'Mutation';
  updateDocument:
    | {
        __typename?: 'UpdateDocumentPayload';
        query: {
          __typename?: 'Query';
          document:
            | { __typename?: 'BirthCertificateDocument' }
            | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
            | { __typename?: 'DriverLicenseDocument' }
            | { __typename?: 'InnDocument' }
            | { __typename?: 'InternationalIdDocument' }
            | { __typename?: 'MedicalInsuranceDocument' }
            | { __typename?: 'NationalIdDocument' }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
                verificationStatus?: string | null;
                docNumber?: string | null;
                firstName?: string | null;
                lastName?: string | null;
                middleName?: string | null;
                birthDate?: string | null;
                birthPlace?: string | null;
                gender?: DocumentGender | null;
                issueDate?: string | null;
                images: Array<{
                  __typename?: 'DocumentImage';
                  id: string;
                  originalUri?: string | null;
                  originalUrl: string;
                  originalWidth?: number | null;
                  originalHeight?: number | null;
                  previewUri?: string | null;
                  previewUrl?: string | null;
                  previewWidth?: number | null;
                  previewHeight?: number | null;
                }>;
              }
            | { __typename?: 'VehicleRegistrationCertificateDocument' }
            | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
        };
      }
    | { __typename?: 'UpdateDocumentProblem'; reason: UpdateDocumentProblemReason };
};

export type DeleteSnilsDocumentMutationVariables = Exact<{
  input: DeleteDocumentInput;
}>;

export type DeleteSnilsDocumentMutation = {
  __typename?: 'Mutation';
  deleteDocument:
    | {
        __typename?: 'DeleteDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
          >;
        };
      }
    | { __typename?: 'DeleteDocumentProblem'; reason: DeleteDocumentProblemReason };
};

export type VehicleRegistrationCertificateFullFragmentFragment = {
  __typename?: 'VehicleRegistrationCertificateDocument';
  id: string;
  type: DocumentType;
  section: DocumentSection;
  verificationStatus?: string | null;
  docNumber?: string | null;
  lastName?: string | null;
  lastNameLat?: string | null;
  firstName?: string | null;
  firstNameLat?: string | null;
  middleName?: string | null;
  registrationAddress?: string | null;
  issuerSubdivisionCode?: string | null;
  issueDate?: string | null;
  additionalInformation?: string | null;
  carNumber?: string | null;
  vin?: string | null;
  model?: string | null;
  modelLat?: string | null;
  vehicleType?: string | null;
  category?: string | null;
  year?: string | null;
  shasiNumber?: string | null;
  bodyNumber?: string | null;
  color?: string | null;
  power?: string | null;
  ecoClass?: string | null;
  maxWeight?: string | null;
  withoutLoadWeight?: string | null;
  temporaryReg?: string | null;
  pts?: string | null;
  images: Array<{
    __typename?: 'DocumentImage';
    id: string;
    originalUri?: string | null;
    originalUrl: string;
    originalWidth?: number | null;
    originalHeight?: number | null;
    previewUri?: string | null;
    previewUrl?: string | null;
    previewWidth?: number | null;
    previewHeight?: number | null;
  }>;
};

export type GetVehicleRegistrationCertificateByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;

export type GetVehicleRegistrationCertificateByIdQuery = {
  __typename?: 'Query';
  document:
    | { __typename?: 'BirthCertificateDocument' }
    | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
    | { __typename?: 'DriverLicenseDocument' }
    | { __typename?: 'InnDocument' }
    | { __typename?: 'InternationalIdDocument' }
    | { __typename?: 'MedicalInsuranceDocument' }
    | { __typename?: 'NationalIdDocument' }
    | { __typename?: 'SnilsDocument' }
    | {
        __typename?: 'VehicleRegistrationCertificateDocument';
        id: string;
        type: DocumentType;
        section: DocumentSection;
        verificationStatus?: string | null;
        docNumber?: string | null;
        lastName?: string | null;
        lastNameLat?: string | null;
        firstName?: string | null;
        firstNameLat?: string | null;
        middleName?: string | null;
        registrationAddress?: string | null;
        issuerSubdivisionCode?: string | null;
        issueDate?: string | null;
        additionalInformation?: string | null;
        carNumber?: string | null;
        vin?: string | null;
        model?: string | null;
        modelLat?: string | null;
        vehicleType?: string | null;
        category?: string | null;
        year?: string | null;
        shasiNumber?: string | null;
        bodyNumber?: string | null;
        color?: string | null;
        power?: string | null;
        ecoClass?: string | null;
        maxWeight?: string | null;
        withoutLoadWeight?: string | null;
        temporaryReg?: string | null;
        pts?: string | null;
        images: Array<{
          __typename?: 'DocumentImage';
          id: string;
          originalUri?: string | null;
          originalUrl: string;
          originalWidth?: number | null;
          originalHeight?: number | null;
          previewUri?: string | null;
          previewUrl?: string | null;
          previewWidth?: number | null;
          previewHeight?: number | null;
        }>;
      }
    | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
};

export type AddVehicleRegistrationCertificateMutationVariables = Exact<{
  input: AddDocumentInput;
}>;

export type AddVehicleRegistrationCertificateMutation = {
  __typename?: 'Mutation';
  addDocument:
    | {
        __typename?: 'AddDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                firstName?: string | null;
                lastName?: string | null;
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
          >;
        };
      }
    | { __typename?: 'AddDocumentProblem'; reason: AddDocumentProblemReason };
};

export type UpdateVehicleRegistrationCertificateMutationVariables = Exact<{
  input: UpdateDocumentInput;
  id: Scalars['ID'];
}>;

export type UpdateVehicleRegistrationCertificateMutation = {
  __typename?: 'Mutation';
  updateDocument:
    | {
        __typename?: 'UpdateDocumentPayload';
        query: {
          __typename?: 'Query';
          document:
            | { __typename?: 'BirthCertificateDocument' }
            | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
            | { __typename?: 'DriverLicenseDocument' }
            | { __typename?: 'InnDocument' }
            | { __typename?: 'InternationalIdDocument' }
            | { __typename?: 'MedicalInsuranceDocument' }
            | { __typename?: 'NationalIdDocument' }
            | { __typename?: 'SnilsDocument' }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
                verificationStatus?: string | null;
                docNumber?: string | null;
                lastName?: string | null;
                lastNameLat?: string | null;
                firstName?: string | null;
                firstNameLat?: string | null;
                middleName?: string | null;
                registrationAddress?: string | null;
                issuerSubdivisionCode?: string | null;
                issueDate?: string | null;
                additionalInformation?: string | null;
                carNumber?: string | null;
                vin?: string | null;
                model?: string | null;
                modelLat?: string | null;
                vehicleType?: string | null;
                category?: string | null;
                year?: string | null;
                shasiNumber?: string | null;
                bodyNumber?: string | null;
                color?: string | null;
                power?: string | null;
                ecoClass?: string | null;
                maxWeight?: string | null;
                withoutLoadWeight?: string | null;
                temporaryReg?: string | null;
                pts?: string | null;
                images: Array<{
                  __typename?: 'DocumentImage';
                  id: string;
                  originalUri?: string | null;
                  originalUrl: string;
                  originalWidth?: number | null;
                  originalHeight?: number | null;
                  previewUri?: string | null;
                  previewUrl?: string | null;
                  previewWidth?: number | null;
                  previewHeight?: number | null;
                }>;
              }
            | { __typename?: 'VoluntaryMedicalInsuranceDocument' };
        };
      }
    | { __typename?: 'UpdateDocumentProblem'; reason: UpdateDocumentProblemReason };
};

export type DeleteVehicleRegistrationCertificateDocumentMutationVariables = Exact<{
  input: DeleteDocumentInput;
}>;

export type DeleteVehicleRegistrationCertificateDocumentMutation = {
  __typename?: 'Mutation';
  deleteDocument:
    | {
        __typename?: 'DeleteDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
          >;
        };
      }
    | { __typename?: 'DeleteDocumentProblem'; reason: DeleteDocumentProblemReason };
};

export type VoluntaryMedicalInsuranceFullFragmentFragment = {
  __typename?: 'VoluntaryMedicalInsuranceDocument';
  id: string;
  type: DocumentType;
  section: DocumentSection;
  verificationStatus?: string | null;
  docNumber?: string | null;
  firstName?: string | null;
  lastName?: string | null;
  middleName?: string | null;
  birthDate?: string | null;
  gender?: DocumentGender | null;
  issueDate?: string | null;
  endDate?: string | null;
  insurerOrg?: string | null;
  images: Array<{
    __typename?: 'DocumentImage';
    id: string;
    originalUri?: string | null;
    originalUrl: string;
    originalWidth?: number | null;
    originalHeight?: number | null;
    previewUri?: string | null;
    previewUrl?: string | null;
    previewWidth?: number | null;
    previewHeight?: number | null;
  }>;
};

export type GetVoluntaryMedicalInsuranceByIdQueryVariables = Exact<{
  id: Scalars['ID'];
}>;

export type GetVoluntaryMedicalInsuranceByIdQuery = {
  __typename?: 'Query';
  document:
    | { __typename?: 'BirthCertificateDocument' }
    | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
    | { __typename?: 'DriverLicenseDocument' }
    | { __typename?: 'InnDocument' }
    | { __typename?: 'InternationalIdDocument' }
    | { __typename?: 'MedicalInsuranceDocument' }
    | { __typename?: 'NationalIdDocument' }
    | { __typename?: 'SnilsDocument' }
    | { __typename?: 'VehicleRegistrationCertificateDocument' }
    | {
        __typename?: 'VoluntaryMedicalInsuranceDocument';
        id: string;
        type: DocumentType;
        section: DocumentSection;
        verificationStatus?: string | null;
        docNumber?: string | null;
        firstName?: string | null;
        lastName?: string | null;
        middleName?: string | null;
        birthDate?: string | null;
        gender?: DocumentGender | null;
        issueDate?: string | null;
        endDate?: string | null;
        insurerOrg?: string | null;
        images: Array<{
          __typename?: 'DocumentImage';
          id: string;
          originalUri?: string | null;
          originalUrl: string;
          originalWidth?: number | null;
          originalHeight?: number | null;
          previewUri?: string | null;
          previewUrl?: string | null;
          previewWidth?: number | null;
          previewHeight?: number | null;
        }>;
      };
};

export type AddVoluntaryMedicalInsuranceMutationVariables = Exact<{
  input: AddDocumentInput;
}>;

export type AddVoluntaryMedicalInsuranceMutation = {
  __typename?: 'Mutation';
  addDocument:
    | {
        __typename?: 'AddDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                firstName?: string | null;
                lastName?: string | null;
                id: string;
                type: DocumentType;
                section: DocumentSection;
              }
          >;
        };
      }
    | { __typename?: 'AddDocumentProblem'; reason: AddDocumentProblemReason };
};

export type UpdateVoluntaryMedicalInsuranceMutationVariables = Exact<{
  input: UpdateDocumentInput;
  id: Scalars['ID'];
}>;

export type UpdateVoluntaryMedicalInsuranceMutation = {
  __typename?: 'Mutation';
  updateDocument:
    | {
        __typename?: 'UpdateDocumentPayload';
        query: {
          __typename?: 'Query';
          document:
            | { __typename?: 'BirthCertificateDocument' }
            | { __typename?: 'DocumentByIdProblem'; reason: DocumentByIdProblemReason }
            | { __typename?: 'DriverLicenseDocument' }
            | { __typename?: 'InnDocument' }
            | { __typename?: 'InternationalIdDocument' }
            | { __typename?: 'MedicalInsuranceDocument' }
            | { __typename?: 'NationalIdDocument' }
            | { __typename?: 'SnilsDocument' }
            | { __typename?: 'VehicleRegistrationCertificateDocument' }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                section: DocumentSection;
                verificationStatus?: string | null;
                docNumber?: string | null;
                firstName?: string | null;
                lastName?: string | null;
                middleName?: string | null;
                birthDate?: string | null;
                gender?: DocumentGender | null;
                issueDate?: string | null;
                endDate?: string | null;
                insurerOrg?: string | null;
                images: Array<{
                  __typename?: 'DocumentImage';
                  id: string;
                  originalUri?: string | null;
                  originalUrl: string;
                  originalWidth?: number | null;
                  originalHeight?: number | null;
                  previewUri?: string | null;
                  previewUrl?: string | null;
                  previewWidth?: number | null;
                  previewHeight?: number | null;
                }>;
              };
        };
      }
    | { __typename?: 'UpdateDocumentProblem'; reason: UpdateDocumentProblemReason };
};

export type DeleteVoluntaryMedicalInsuranceDocumentMutationVariables = Exact<{
  input: DeleteDocumentInput;
}>;

export type DeleteVoluntaryMedicalInsuranceDocumentMutation = {
  __typename?: 'Mutation';
  deleteDocument:
    | {
        __typename?: 'DeleteDocumentPayload';
        query: {
          __typename?: 'Query';
          documents: Array<
            | {
                __typename?: 'BirthCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'DriverLicenseDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InnDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'InternationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'MedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'NationalIdDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'SnilsDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VehicleRegistrationCertificateDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
            | {
                __typename?: 'VoluntaryMedicalInsuranceDocument';
                id: string;
                type: DocumentType;
                previewUrl?: string | null;
                originalUrl?: string | null;
              }
          >;
        };
      }
    | { __typename?: 'DeleteDocumentProblem'; reason: DeleteDocumentProblemReason };
};

export type EdadealDataQueryVariables = Exact<{ [key: string]: never }>;

export type EdadealDataQuery = {
  __typename?: 'Query';
  edadealData: {
    __typename?: 'EdadealData';
    hasBinding: boolean;
    url: string;
    iframeSrc: string;
    amount?: number | null;
  };
};

export type PaymentsContextQueryVariables = Exact<{
  familyMode?: InputMaybe<Scalars['Boolean']>;
}>;

export type PaymentsContextQuery = {
  __typename?: 'Query';
  paymentsContext: {
    __typename?: 'PaymentsContext';
    services: Array<{
      __typename?: 'Service';
      id: string;
      i18nKeyName?: string | null;
      iconUrl: string;
      name: string;
    }>;
    plusServiceData: { __typename?: 'PlusService'; iconUrl: string };
    familyData?: Array<{
      __typename?: 'FamilyUser';
      uid: string;
      name: string;
      avatar: string;
    }> | null;
  };
};

export type PaymentReceiptsQueryVariables = Exact<{
  purchaseToken: Scalars['String'];
}>;

export type PaymentReceiptsQuery = {
  __typename?: 'Query';
  receiptsByToken: Array<{
    __typename?: 'Receipt';
    url: string;
    amount?: Array<number> | null;
    timestamp?: string | null;
    type?: string | null;
  }>;
};

export type PaymentsHistoryQueryVariables = Exact<{
  alias?: InputMaybe<Scalars['String']>;
  user?: InputMaybe<Scalars['String']>;
  after?: InputMaybe<Scalars['String']>;
}>;

export type PaymentsHistoryQuery = {
  __typename?: 'Query';
  paymentsData: {
    __typename?: 'PaymentsData';
    edges: Array<{
      __typename?: 'Payment';
      total: number;
      plus?: number | null;
      cashback?: number | null;
      currency: string;
      orderId: string;
      created: string;
      status: string;
      isReceipt?: boolean | null;
      source?: string | null;
      retailerName?: string | null;
      retailerIcon?: string | null;
      purchaseToken: string;
      receiptsEnabled: boolean;
      receiptUrl?: string | null;
      initiatorUid?: string | null;
      service: {
        __typename?: 'Service';
        iconUrl: string;
        i18nKeyName?: string | null;
        name: string;
        splashUrl?: string | null;
        url?: string | null;
        help?: string | null;
      };
      items?: Array<{
        __typename?: 'PaymentItem';
        price: number;
        hidden?: boolean | null;
        alias?: string | null;
        name: string;
      }> | null;
      paymentTypes?: Array<{
        __typename?: 'PaymentType';
        price: number;
        account?: string | null;
        currency?: string | null;
        method: string;
      }> | null;
    }>;
    pageInfo: { __typename?: 'PageInfo'; endCursor?: string | null; hasNextPage: boolean };
  };
};

export type BillsDataQueryVariables = Exact<{ [key: string]: never }>;

export type BillsDataQuery = {
  __typename?: 'Query';
  bills: { __typename?: 'BillsData'; state: string };
  billsDocuments: Array<{ __typename?: 'BillsDocument'; document_id: string }>;
};

export type GibddDataQueryVariables = Exact<{ [key: string]: never }>;

export type GibddDataQuery = {
  __typename?: 'Query';
  bills: {
    __typename?: 'BillsData';
    state: string;
    bills: Array<{
      __typename?: 'Bill';
      bill_id: string;
      document_id: string;
      payment_deadline: string;
      amount: number;
      supplier_bill_id: string;
      purpose?: string | null;
      legal_act?: string | null;
      offense_place?: string | null;
      payer_name?: string | null;
      payee_name?: string | null;
      account_number?: string | null;
      fee_amount: number;
      inn?: string | null;
      kpp?: string | null;
      bik?: string | null;
      oktmo?: string | null;
      bill_date: string;
      discounted_amount: number;
    }>;
  };
  billsDocuments: Array<{
    __typename?: 'BillsDocument';
    type: BillsDocumentType;
    title: string;
    document_id: string;
    value: string;
  }>;
};

export type AddGibddDocumentMutationVariables = Exact<{
  input: AddBillsDocumentInput;
}>;

export type AddGibddDocumentMutation = {
  __typename?: 'Mutation';
  addBillsDocument: { __typename?: 'BillsDocument'; document_id: string };
};

export type UpdateGibddDocumentMutationVariables = Exact<{
  input: UpdateBillsDocumentInput;
}>;

export type UpdateGibddDocumentMutation = {
  __typename?: 'Mutation';
  updateBillsDocument: { __typename?: 'BillsDocument'; document_id: string };
};

export type DeleteGibddDocumentMutationVariables = Exact<{
  input: DeleteBillsDocumentInput;
}>;

export type DeleteGibddDocumentMutation = {
  __typename?: 'Mutation';
  deleteBillsDocument: { __typename?: 'DefaultResponse'; status: string };
};

export type RestartBillsSearchMutationVariables = Exact<{ [key: string]: never }>;

export type RestartBillsSearchMutation = {
  __typename?: 'Mutation';
  restartBillsSearch: { __typename?: 'DefaultResponse'; status: string };
};

export type CreateOrderBillMutationVariables = Exact<{
  input: CreateOrderBillInput;
}>;

export type CreateOrderBillMutation = {
  __typename?: 'Mutation';
  createOrderBill: { __typename?: 'CreateOrderResponse'; status: string; order_id: string };
};

export type StartOrderBillMutationVariables = Exact<{
  input: StartOrderBillInput;
}>;

export type StartOrderBillMutation = {
  __typename?: 'Mutation';
  startOrderBill: {
    __typename?: 'StartOrderBillResponse';
    transaction: {
      __typename?: 'Trancsaction';
      transaction_id: string;
      acs_url: string;
      status: TransactionStatus;
    };
  };
};

export type GetTransactionBillMutationVariables = Exact<{
  input: GetTransactionInput;
}>;

export type GetTransactionBillMutation = {
  __typename?: 'Mutation';
  getTransaction: { __typename?: 'BillTransactionResponse'; status: TransactionStatus };
};

export type UpdatePersonalInfoMutationVariables = Exact<{
  input: UpdatePersonalInfoInput;
}>;

export type UpdatePersonalInfoMutation = {
  __typename?: 'Mutation';
  viewerUpdatePersonalInfo:
    | {
        __typename?: 'UpdatePersonalInfoPayload';
        query: {
          __typename?: 'Query';
          viewer: {
            __typename?: 'Viewer';
            firstName?: string | null;
            lastName?: string | null;
            displayName: string;
            city?: string | null;
            birthdate?: string | null;
          };
        };
      }
    | { __typename?: 'UpdatePersonalInfoProblem'; reason: UpdatePersonalInfoProblemKind };
};

export type ValidatePersonalInfoFieldMutationVariables = Exact<{
  input: ProfileFieldValidationInput;
}>;

export type ValidatePersonalInfoFieldMutation = {
  __typename?: 'Mutation';
  viewerValidatePersonalInfoField: {
    __typename?: 'ProfileFieldValidationResult';
    code: ProfileFieldValidationResultCode;
  };
};

export type PersonalInfoFormDataQueryVariables = Exact<{ [key: string]: never }>;

export type PersonalInfoFormDataQuery = {
  __typename?: 'Query';
  viewer: {
    __typename?: 'Viewer';
    id: string;
    firstName?: string | null;
    lastName?: string | null;
    birthdate?: string | null;
    gender: string;
    city?: string | null;
    displayName: string;
    avatarId: string;
    country: string;
    timezone: string;
  };
  locationOptions: {
    __typename?: 'LocationsOptions';
    countries: Array<{ __typename?: 'CountryOption'; name: string; code: string }>;
    timezones: Array<{ __typename?: 'TimezoneOption'; code: string; name: string }>;
  };
};

export type PublicIdValidateMutationVariables = Exact<{
  input: PublicIdValidateInput;
}>;

export type PublicIdValidateMutation = {
  __typename?: 'Mutation';
  validatePublicId:
    | { __typename?: 'PublicIdValidatePayload' }
    | { __typename?: 'PublicIdValidateProblem'; reason: string };
};

export type PublicIdUpdateMutationVariables = Exact<{
  input: PublicIdUpdateInput;
}>;

export type PublicIdUpdateMutation = {
  __typename?: 'Mutation';
  updatePublicId:
    | {
        __typename?: 'PublicIdUpdatePayload';
        query: {
          __typename?: 'Query';
          viewer: { __typename?: 'Viewer'; id: string; publicId?: string | null };
        };
      }
    | { __typename?: 'PublicIdUpdateProblem'; reason: string };
};

export type PublicIdSuggestMutationVariables = Exact<{
  input: PublicIdSuggestInput;
}>;

export type PublicIdSuggestMutation = {
  __typename?: 'Mutation';
  suggestPublicId:
    | { __typename?: 'PublicIdSuggestPayload'; logins: Array<string> }
    | { __typename?: 'PublicIdSuggestProblem'; reason: string };
};

export type PersonalPublicIdQueryVariables = Exact<{ [key: string]: never }>;

export type PersonalPublicIdQuery = {
  __typename?: 'Query';
  viewer: {
    __typename?: 'Viewer';
    id: string;
    publicId?: string | null;
    hasPublicIdSet?: boolean | null;
    firstName?: string | null;
    lastName?: string | null;
  };
};

export type BindPrimaryPhoneAccountFragment = {
  __typename?: 'Account';
  id: string;
  phones: Array<{ __typename?: 'Phone'; id: string; isPrimary: boolean }>;
};

export type SendCodeToBindPrimaryPhoneMutationVariables = Exact<{
  input: SendCodeToBindPrimaryPhoneInput;
}>;

export type SendCodeToBindPrimaryPhoneMutation = {
  __typename?: 'Mutation';
  response:
    | {
        __typename: 'SendCodeToBindPrimaryPhonePayload';
        trackId: string;
        number: string;
        expiryTimestamp: number;
      }
    | {
        __typename: 'SendCodeToBindPrimaryPhoneProblem';
        reason: SendCodeToBindPrimaryPhoneProblemReason;
      };
};

export type VerifyCodeToBindPrimaryPhoneMutationVariables = Exact<{
  input: VerifyCodeToBindPrimaryPhoneInput;
}>;

export type VerifyCodeToBindPrimaryPhoneMutation = {
  __typename?: 'Mutation';
  response:
    | {
        __typename: 'VerifyCodeToBindPrimaryPhonePayload';
        trackId: string;
        query: {
          __typename?: 'Query';
          account: {
            __typename?: 'Account';
            id: string;
            phones: Array<{ __typename?: 'Phone'; id: string; isPrimary: boolean }>;
          };
        };
      }
    | {
        __typename: 'VerifyCodeToBindPrimaryPhoneProblem';
        reason: VerifyCodeToBindPrimaryPhoneProblemReason;
      };
};

export type SendCodeToConfirmPhoneMutationVariables = Exact<{
  input: SendCodeToConfirmPhoneInput;
}>;

export type SendCodeToConfirmPhoneMutation = {
  __typename?: 'Mutation';
  response:
    | {
        __typename: 'SendCodeToConfirmPhonePayload';
        trackId: string;
        number: string;
        expiryTimestamp: number;
      }
    | { __typename: 'SendCodeToConfirmPhoneProblem'; reason: SendCodeToConfirmPhoneProblemReason };
};

export type VerifyCodeToConfirmPhoneMutationVariables = Exact<{
  input: VerifyCodeToConfirmPhoneInput;
}>;

export type VerifyCodeToConfirmPhoneMutation = {
  __typename?: 'Mutation';
  response:
    | { __typename: 'VerifyCodeToConfirmPhonePayload'; trackId: string }
    | {
        __typename: 'VerifyCodeToConfirmPhoneProblem';
        reason: VerifyCodeToConfirmPhoneProblemReason;
      };
};

export type PasswordAndSmsSwitchAccountFragment = {
  __typename?: 'Account';
  id: string;
  authType?: AuthType | null;
  canLoginWithQR: boolean;
  phones: Array<{ __typename?: 'Phone'; id: string; isPrimary: boolean; number: string }>;
};

type ToggleLoginWithPasswordAndSms_ToggleLoginWithPasswordAndSmsPayload_Fragment = {
  __typename: 'ToggleLoginWithPasswordAndSmsPayload';
  account: {
    __typename?: 'Account';
    id: string;
    authType?: AuthType | null;
    canLoginWithQR: boolean;
    phones: Array<{ __typename?: 'Phone'; id: string; isPrimary: boolean; number: string }>;
  };
};

type ToggleLoginWithPasswordAndSms_ToggleLoginWithPasswordAndSmsProblem_Fragment = {
  __typename: 'ToggleLoginWithPasswordAndSmsProblem';
  reason: ToggleLoginWithPasswordAndSmsProblemReason;
};

export type ToggleLoginWithPasswordAndSmsFragment =
  | ToggleLoginWithPasswordAndSms_ToggleLoginWithPasswordAndSmsPayload_Fragment
  | ToggleLoginWithPasswordAndSms_ToggleLoginWithPasswordAndSmsProblem_Fragment;

export type AuthTypesQueryVariables = Exact<{ [key: string]: never }>;

export type AuthTypesQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    authType?: AuthType | null;
    canLoginWithQR: boolean;
    phones: Array<{ __typename?: 'Phone'; id: string; isPrimary: boolean; number: string }>;
  };
};

export type EnableLoginWithPasswordAndSmsMutationVariables = Exact<{
  input: ToggleLoginWithPasswordAndSmsInput;
}>;

export type EnableLoginWithPasswordAndSmsMutation = {
  __typename?: 'Mutation';
  response:
    | {
        __typename: 'ToggleLoginWithPasswordAndSmsPayload';
        account: {
          __typename?: 'Account';
          id: string;
          authType?: AuthType | null;
          canLoginWithQR: boolean;
          phones: Array<{ __typename?: 'Phone'; id: string; isPrimary: boolean; number: string }>;
        };
      }
    | {
        __typename: 'ToggleLoginWithPasswordAndSmsProblem';
        reason: ToggleLoginWithPasswordAndSmsProblemReason;
      };
};

export type DisableLoginWithPasswordAndSmsMutationVariables = Exact<{
  input: ToggleLoginWithPasswordAndSmsInput;
}>;

export type DisableLoginWithPasswordAndSmsMutation = {
  __typename?: 'Mutation';
  response:
    | {
        __typename: 'ToggleLoginWithPasswordAndSmsPayload';
        account: {
          __typename?: 'Account';
          id: string;
          authType?: AuthType | null;
          canLoginWithQR: boolean;
          phones: Array<{ __typename?: 'Phone'; id: string; isPrimary: boolean; number: string }>;
        };
      }
    | {
        __typename: 'ToggleLoginWithPasswordAndSmsProblem';
        reason: ToggleLoginWithPasswordAndSmsProblemReason;
      };
};

export type BankCardsQueryVariables = Exact<{ [key: string]: never }>;

export type BankCardsQuery = {
  __typename?: 'Query';
  accountBankCards: {
    __typename?: 'BankCardsData';
    status: string;
    trackId: string;
    cards: Array<{
      __typename?: 'BankCard';
      system: string;
      number: string;
      cardId: string;
      isFamilyCard?: boolean | null;
      name: string;
      proto: string;
      id: string;
    }>;
  };
};

export type UnbindBankCardMutationVariables = Exact<{
  cardId: Scalars['String'];
}>;

export type UnbindBankCardMutation = {
  __typename?: 'Mutation';
  accountUnbindBankCard: { __typename?: 'AccountUnbindBankdCardResponse'; status: string };
};

export type CreateBindingMutationVariables = Exact<{
  input: AccountBindBankCardInput;
}>;

export type CreateBindingMutation = {
  __typename?: 'Mutation';
  accountBindBankCard: {
    __typename?: 'AccountCreateBindBankCardResponse';
    status: string;
    url?: string | null;
  };
};

export type BonusCardsWidgetQueryVariables = Exact<{ [key: string]: never }>;

export type BonusCardsWidgetQuery = {
  __typename?: 'Query';
  viewer: { __typename?: 'Viewer'; id: string; avatarId: string };
};

export type ContactsQueryVariables = Exact<{ [key: string]: never }>;

export type ContactsQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    phones: Array<{ __typename?: 'Phone'; id: string; number: string; isPrimary: boolean }>;
    emails: Array<{ __typename?: 'Email'; address: string; type: EmailType; isPrimary: boolean }>;
  };
  externalAccounts: Array<{ __typename?: 'ExternalAccount'; id: string }>;
};

export type DocumentsThumbListQueryVariables = Exact<{ [key: string]: never }>;

export type DocumentsThumbListQuery = {
  __typename?: 'Query';
  documents: Array<
    | {
        __typename?: 'BirthCertificateDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'DriverLicenseDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'InnDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'InternationalIdDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'MedicalInsuranceDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'NationalIdDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'SnilsDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'VehicleRegistrationCertificateDocument';
        model?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'VoluntaryMedicalInsuranceDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
  >;
};

export type EnterMethodsQueryVariables = Exact<{ [key: string]: never }>;

export type EnterMethodsQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    type: AccountType;
    authType?: AuthType | null;
    passwordInfo?: { __typename?: 'PasswordInfo'; updatedAt: number } | null;
    phones: Array<{
      __typename?: 'Phone';
      id: string;
      number: string;
      isDefault: boolean;
      isPrimary: boolean;
    }>;
  };
};

export type ExternalAccessesQueryVariables = Exact<{ [key: string]: never }>;

export type ExternalAccessesQuery = {
  __typename?: 'Query';
  externalAccounts: Array<{ __typename?: 'ExternalAccount'; id: string }>;
};

export type ExternalAccountProvidersWidgetQueryVariables = Exact<{ [key: string]: never }>;

export type ExternalAccountProvidersWidgetQuery = {
  __typename?: 'Query';
  providers: Array<{
    __typename?: 'ExternalAccountProvider';
    id: string;
    name: ExternalAccountProviderName;
  }>;
};

export type ExternalAccountsWidgetQueryVariables = Exact<{ [key: string]: never }>;

export type ExternalAccountsWidgetQuery = {
  __typename?: 'Query';
  externalAccounts: Array<{
    __typename?: 'ExternalAccount';
    id: string;
    displayName: string;
    allowAuth: boolean;
    provider: {
      __typename?: 'ExternalAccountProvider';
      id: string;
      name: ExternalAccountProviderName;
    };
  }>;
};

export type FamilyMembersWidgetQueryVariables = Exact<{ [key: string]: never }>;

export type FamilyMembersWidgetQuery = {
  __typename?: 'Query';
  family: {
    __typename?: 'Family';
    info?: { __typename?: 'FamilyInfo'; id: string; adminUid: string } | null;
    members: Array<{
      __typename?: 'FamilyMember';
      avatar: string;
      name: string;
      isAdmin: boolean;
      uid: string;
      hasSecurePhone?: boolean | null;
    }>;
    kids: Array<{
      __typename?: 'FamilyKid';
      avatar?: string | null;
      name?: string | null;
      uid: string;
    }>;
    invites: Array<{ __typename?: 'FamilyInvite'; contact: string; id: string }>;
    pay?: {
      __typename?: 'FamilyPay';
      userRestrictions: Array<{
        __typename?: 'Restriction';
        balance: number;
        enabled: boolean;
        uid: string;
        unlim: boolean;
        limitCurrency: string;
        limit: { __typename?: 'Limit'; value: number; limitMode: string };
      }>;
    } | null;
  };
  viewer: { __typename?: 'Viewer'; avatarId: string; displayName: string; id: string };
};

export type FamilyShortuctsWidgetQueryVariables = Exact<{ [key: string]: never }>;

export type FamilyShortuctsWidgetQuery = {
  __typename?: 'Query';
  family: {
    __typename?: 'Family';
    info?: { __typename?: 'FamilyInfo'; id: string; adminUid: string } | null;
    members: Array<{
      __typename?: 'FamilyMember';
      avatar: string;
      name: string;
      isAdmin: boolean;
      uid: string;
    }>;
    invites: Array<{ __typename?: 'FamilyInvite'; contact: string; id: string }>;
    pay?: {
      __typename?: 'FamilyPay';
      cardInfo?: { __typename?: 'CardInfo'; maskedNumber: string; bound: boolean } | null;
      userRestrictions: Array<{
        __typename?: 'Restriction';
        balance: number;
        enabled: boolean;
        hasSecurePhone: boolean;
        limitCurrency: string;
        unlim: boolean;
        uid: string;
        limit: { __typename?: 'Limit'; limitMode: string; value: number };
      }>;
    } | null;
  };
  viewer: { __typename?: 'Viewer'; id: string; hasFamilyPlus: boolean };
};

export type FinanceShortcutsWidgetQueryVariables = Exact<{ [key: string]: never }>;

export type FinanceShortcutsWidgetQuery = {
  __typename?: 'Query';
  bills: { __typename?: 'BillsData'; state: string };
  billsDocuments: Array<{ __typename?: 'BillsDocument'; document_id: string }>;
  family: {
    __typename?: 'Family';
    info?: { __typename?: 'FamilyInfo'; id: string; adminUid: string } | null;
    pay?: {
      __typename?: 'FamilyPay';
      cardInfo?: { __typename?: 'CardInfo'; maskedNumber: string; bound: boolean } | null;
      userRestrictions: Array<{
        __typename?: 'Restriction';
        balance: number;
        enabled: boolean;
        hasSecurePhone: boolean;
        limitCurrency: string;
        unlim: boolean;
        uid: string;
      }>;
    } | null;
  };
  account: { __typename?: 'Account'; id: string };
};

export type FuturePaymentsWidgetQueryVariables = Exact<{ [key: string]: never }>;

export type FuturePaymentsWidgetQuery = {
  __typename?: 'Query';
  futurePayments: Array<{
    __typename?: 'FuturePayment';
    id?: string | null;
    type: FuturePaymentType;
    service: string;
    nextPaymentAt: string;
    amount: number;
    iframeUrl?: string | null;
  }>;
};

export type HeaderQueryVariables = Exact<{ [key: string]: never }>;

export type HeaderQuery = {
  __typename?: 'Query';
  viewer: { __typename?: 'Viewer'; id: string; avatarId: string; havePlus: boolean };
};

export type LoginWithExternalAccountsQueryVariables = Exact<{ [key: string]: never }>;

export type LoginWithExternalAccountsQuery = {
  __typename?: 'Query';
  account: { __typename?: 'Account'; id: string; authType?: AuthType | null };
  externalAccounts: Array<{ __typename?: 'ExternalAccount'; id: string; allowAuth: boolean }>;
};

export type LoginWithQrAccountFragment = {
  __typename?: 'Account';
  id: string;
  authType?: AuthType | null;
  canLoginWithQR: boolean;
};

export type LoginWithQrQueryVariables = Exact<{ [key: string]: never }>;

export type LoginWithQrQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    authType?: AuthType | null;
    canLoginWithQR: boolean;
  };
};

export type EnableLoginWithQrMutationVariables = Exact<{ [key: string]: never }>;

export type EnableLoginWithQrMutation = {
  __typename?: 'Mutation';
  accountEnableLoginWithQR: {
    __typename?: 'EnableLoginWithQRPayload';
    account: {
      __typename?: 'Account';
      id: string;
      authType?: AuthType | null;
      canLoginWithQR: boolean;
    };
  };
};

export type DisableLoginWithQrMutationVariables = Exact<{ [key: string]: never }>;

export type DisableLoginWithQrMutation = {
  __typename?: 'Mutation';
  accountDisableLoginWithQR: {
    __typename?: 'DisableLoginWithQRPayload';
    account: {
      __typename?: 'Account';
      id: string;
      authType?: AuthType | null;
      canLoginWithQR: boolean;
    };
  };
};

export type ProfileWidgetQueryVariables = Exact<{ [key: string]: never }>;

export type ProfileWidgetQuery = {
  __typename?: 'Query';
  viewer: {
    __typename?: 'Viewer';
    id: string;
    avatarId: string;
    displayName: string;
    fullName?: string | null;
    havePlus: boolean;
    isChild: boolean;
    city?: string | null;
    firstName?: string | null;
    lastName?: string | null;
    birthdate?: string | null;
  };
};

export type ProfileFillQueryVariables = Exact<{ [key: string]: never }>;

export type ProfileFillQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    phones: Array<{ __typename?: 'Phone'; id: string }>;
  };
  viewer: {
    __typename?: 'Viewer';
    id: string;
    avatarId: string;
    displayName: string;
    fullName?: string | null;
    havePlus: boolean;
    isChild: boolean;
    city?: string | null;
    firstName?: string | null;
    lastName?: string | null;
    birthdate?: string | null;
  };
  addresses: Array<{ __typename?: 'Address'; id: string }>;
};

export type RecoveryMethodsQueryVariables = Exact<{ [key: string]: never }>;

export type RecoveryMethodsQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    question?: { __typename?: 'Question'; id: string; text: string } | null;
    phones: Array<{
      __typename?: 'Phone';
      id: string;
      number: string;
      isPrimary: boolean;
      operation?: {
        __typename?: 'PhoneOperation';
        id: string;
        type: PhoneOperationType;
        inQuarantine: boolean;
        finishedAt: number;
      } | null;
    }>;
    emails: Array<{
      __typename?: 'Email';
      address: string;
      type: EmailType;
      isPrimary: boolean;
      isConfirmed: boolean;
    }>;
  };
};

export type SecurityShortcutsQueryVariables = Exact<{ [key: string]: never }>;

export type SecurityShortcutsQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    authType?: AuthType | null;
    phones: Array<{ __typename?: 'Phone'; id: string; isPrimary: boolean; isDefault: boolean }>;
    question?: { __typename?: 'Question'; id: string; text: string } | null;
  };
};

export type WebsitePasswordsWidgetQueryVariables = Exact<{ [key: string]: never }>;

export type WebsitePasswordsWidgetQuery = {
  __typename?: 'Query';
  viewer: { __typename?: 'Viewer'; avatarId: string };
};

export type AddressesCardsWidgetDataQueryVariables = Exact<{ [key: string]: never }>;

export type AddressesCardsWidgetDataQuery = {
  __typename?: 'Query';
  addresses: Array<{
    __typename?: 'Address';
    id: string;
    comment?: string | null;
    entrance?: string | null;
    floor?: string | null;
    fullText?: string | null;
    intercom?: string | null;
    previewUrl: string;
    region?: string | null;
    room?: string | null;
    shortText: string;
    street?: string | null;
    type: AddressType;
  }>;
};

export type AddressesListWidgetDataQueryVariables = Exact<{ [key: string]: never }>;

export type AddressesListWidgetDataQuery = {
  __typename?: 'Query';
  addresses: Array<{
    __typename?: 'Address';
    id: string;
    comment?: string | null;
    entrance?: string | null;
    floor?: string | null;
    fullText?: string | null;
    intercom?: string | null;
    region?: string | null;
    room?: string | null;
    shortText: string;
    street?: string | null;
    type: AddressType;
  }>;
};

export type DocumentsThumbsWidgetDataQueryVariables = Exact<{ [key: string]: never }>;

export type DocumentsThumbsWidgetDataQuery = {
  __typename?: 'Query';
  documents: Array<
    | {
        __typename?: 'BirthCertificateDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'DriverLicenseDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'InnDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'InternationalIdDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'MedicalInsuranceDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'NationalIdDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'SnilsDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'VehicleRegistrationCertificateDocument';
        model?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
    | {
        __typename?: 'VoluntaryMedicalInsuranceDocument';
        firstName?: string | null;
        lastName?: string | null;
        id: string;
        type: DocumentType;
        section: DocumentSection;
      }
  >;
};

export type SecurityBannerDataQueryVariables = Exact<{ [key: string]: never }>;

export type SecurityBannerDataQuery = {
  __typename?: 'Query';
  account: {
    __typename?: 'Account';
    id: string;
    authType?: AuthType | null;
    question?: { __typename?: 'Question'; id: string } | null;
    phones: Array<{ __typename?: 'Phone'; id: string; isPrimary: boolean }>;
    emails: Array<{
      __typename?: 'Email';
      address: string;
      type: EmailType;
      isPrimary: boolean;
      isConfirmed: boolean;
    }>;
  };
};

export const ControlQuestionAccountFragmentDoc = gql`
  fragment ControlQuestionAccount on Account {
    id
    question {
      id
      text
    }
  }
`;
export const AccountRecoveryEmailsFragmentDoc = gql`
  fragment AccountRecoveryEmails on Account {
    id
    emails {
      address
      type
      isPrimary
      isConfirmed
    }
  }
`;
export const AddressDetailsFragmentDoc = gql`
  fragment AddressDetails on Address {
    id
    comment
    entrance
    floor
    fullText
    intercom
    region
    room
    shortText
    street
    type
  }
`;
export const BirthCertificateFullFragmentFragmentDoc = gql`
  fragment BirthCertificateFullFragment on BirthCertificateDocument {
    id
    type
    section
    verificationStatus
    series
    docNumber
    firstName
    lastName
    middleName
    birthDate
    birthPlace
    birthAkt
    fatherLastName
    fatherFirstName
    fatherMiddleName
    fatherCitizenship
    fatherBirthDate
    fatherNationality
    motherLastName
    motherFirstName
    motherMiddleName
    motherCitizenship
    motherBirthDate
    motherNationality
    registrationPlace
    issuePlace
    issueDate
    images {
      id
      originalUri
      originalUrl
      originalWidth
      originalHeight
      previewUri
      previewUrl
      previewWidth
      previewHeight
    }
  }
`;
export const DriverLicenseFullFragmentFragmentDoc = gql`
  fragment DriverLicenseFullFragment on DriverLicenseDocument {
    id
    type
    section
    verificationStatus
    lastName
    lastNameLat
    firstName
    firstNameLat
    middleName
    middleNameLat
    birthDate
    birthPlace
    birthPlaceLat
    issueDate
    endDate
    issuedBy
    issuedByLat
    docNumber
    issuedCity
    issuedCityLat
    category
    additionalInformation
    images {
      id
      originalUri
      originalUrl
      originalWidth
      originalHeight
      previewUri
      previewUrl
      previewWidth
      previewHeight
    }
  }
`;
export const InnFullFragmentFragmentDoc = gql`
  fragment InnFullFragment on InnDocument {
    id
    type
    section
    verificationStatus
    docNumber
    firstName
    lastName
    middleName
    birthDate
    gender
    issuedBy
    issueDate
    images {
      id
      originalUri
      originalUrl
      originalWidth
      originalHeight
      previewUri
      previewUrl
      previewWidth
      previewHeight
    }
  }
`;
export const InternationalIdFullFragmentFragmentDoc = gql`
  fragment InternationalIdFullFragment on InternationalIdDocument {
    id
    type
    section
    verificationStatus
    docNumber
    lastName
    lastNameLat
    firstName
    firstNameLat
    citizenship
    citizenshipLat
    birthDate
    gender
    birthPlace
    birthPlaceLat
    issueDate
    endDate
    issuedBy
    images {
      id
      originalUri
      originalUrl
      originalWidth
      originalHeight
      previewUri
      previewUrl
      previewWidth
      previewHeight
    }
  }
`;
export const MedicalInsuranceFullFragmentFragmentDoc = gql`
  fragment MedicalInsuranceFullFragment on MedicalInsuranceDocument {
    id
    type
    section
    verificationStatus
    docNumber
    firstName
    lastName
    middleName
    birthDate
    gender
    blank
    images {
      id
      originalUri
      originalUrl
      originalWidth
      originalHeight
      previewUri
      previewUrl
      previewWidth
      previewHeight
    }
  }
`;
export const NationalIdFullFragmentFragmentDoc = gql`
  fragment NationalIdFullFragment on NationalIdDocument {
    id
    type
    section
    verificationStatus
    docNumber
    firstName
    lastName
    middleName
    birthDate
    gender
    birthPlace
    issuedBy
    issuerSubdivisionCode
    issueDate
    registrationAddress
    images {
      id
      originalUri
      originalUrl
      originalWidth
      originalHeight
      previewUri
      previewUrl
      previewWidth
      previewHeight
    }
  }
`;
export const SnilsFullFragmentFragmentDoc = gql`
  fragment SnilsFullFragment on SnilsDocument {
    id
    type
    section
    verificationStatus
    docNumber
    firstName
    lastName
    middleName
    birthDate
    birthPlace
    gender
    issueDate
    images {
      id
      originalUri
      originalUrl
      originalWidth
      originalHeight
      previewUri
      previewUrl
      previewWidth
      previewHeight
    }
  }
`;
export const VehicleRegistrationCertificateFullFragmentFragmentDoc = gql`
  fragment VehicleRegistrationCertificateFullFragment on VehicleRegistrationCertificateDocument {
    id
    type
    section
    verificationStatus
    docNumber
    lastName
    lastNameLat
    firstName
    firstNameLat
    middleName
    registrationAddress
    issuerSubdivisionCode
    issueDate
    additionalInformation
    carNumber
    vin
    model
    modelLat
    vehicleType
    category
    year
    shasiNumber
    bodyNumber
    color
    power
    ecoClass
    maxWeight
    withoutLoadWeight
    temporaryReg
    pts
    images {
      id
      originalUri
      originalUrl
      originalWidth
      originalHeight
      previewUri
      previewUrl
      previewWidth
      previewHeight
    }
  }
`;
export const VoluntaryMedicalInsuranceFullFragmentFragmentDoc = gql`
  fragment VoluntaryMedicalInsuranceFullFragment on VoluntaryMedicalInsuranceDocument {
    id
    type
    section
    verificationStatus
    docNumber
    firstName
    lastName
    middleName
    birthDate
    gender
    issueDate
    endDate
    insurerOrg
    images {
      id
      originalUri
      originalUrl
      originalWidth
      originalHeight
      previewUri
      previewUrl
      previewWidth
      previewHeight
    }
  }
`;
export const BindPrimaryPhoneAccountFragmentDoc = gql`
  fragment BindPrimaryPhoneAccount on Account {
    id
    phones {
      id
      isPrimary
    }
  }
`;
export const PasswordAndSmsSwitchAccountFragmentDoc = gql`
  fragment PasswordAndSmsSwitchAccount on Account {
    id
    authType
    canLoginWithQR
    phones {
      id
      isPrimary
      number
    }
  }
`;
export const ToggleLoginWithPasswordAndSmsFragmentDoc = gql`
  fragment ToggleLoginWithPasswordAndSms on ToggleLoginWithPasswordAndSmsResult {
    __typename
    ... on ToggleLoginWithPasswordAndSmsPayload {
      account {
        ...PasswordAndSmsSwitchAccount
      }
    }
    ... on ToggleLoginWithPasswordAndSmsProblem {
      reason
    }
  }
  ${PasswordAndSmsSwitchAccountFragmentDoc}
`;
export const LoginWithQrAccountFragmentDoc = gql`
  fragment LoginWithQRAccount on Account {
    id
    authType
    canLoginWithQR
  }
`;
export const CurrentQuestionDocument = gql`
  query CurrentQuestion {
    account {
      ...ControlQuestionAccount
    }
  }
  ${ControlQuestionAccountFragmentDoc}
`;

/**
 * __useCurrentQuestionQuery__
 *
 * To run a query within a React component, call `useCurrentQuestionQuery` and pass it any options that fit your needs.
 * When your component renders, `useCurrentQuestionQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useCurrentQuestionQuery({
 *   variables: {
 *   },
 * });
 */
export function useCurrentQuestionQuery(
  baseOptions?: Apollo.QueryHookOptions<CurrentQuestionQuery, CurrentQuestionQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<CurrentQuestionQuery, CurrentQuestionQueryVariables>(
    CurrentQuestionDocument,
    options,
  );
}
export function useCurrentQuestionLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<CurrentQuestionQuery, CurrentQuestionQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<CurrentQuestionQuery, CurrentQuestionQueryVariables>(
    CurrentQuestionDocument,
    options,
  );
}
export type CurrentQuestionQueryHookResult = ReturnType<typeof useCurrentQuestionQuery>;
export type CurrentQuestionLazyQueryHookResult = ReturnType<typeof useCurrentQuestionLazyQuery>;
export type CurrentQuestionQueryResult = Apollo.QueryResult<
  CurrentQuestionQuery,
  CurrentQuestionQueryVariables
>;
export const AvailableQuestionsDocument = gql`
  query AvailableQuestions {
    account {
      ...ControlQuestionAccount
    }
    accountAvailableQuestions {
      id
      text
    }
  }
  ${ControlQuestionAccountFragmentDoc}
`;

/**
 * __useAvailableQuestionsQuery__
 *
 * To run a query within a React component, call `useAvailableQuestionsQuery` and pass it any options that fit your needs.
 * When your component renders, `useAvailableQuestionsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAvailableQuestionsQuery({
 *   variables: {
 *   },
 * });
 */
export function useAvailableQuestionsQuery(
  baseOptions?: Apollo.QueryHookOptions<AvailableQuestionsQuery, AvailableQuestionsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<AvailableQuestionsQuery, AvailableQuestionsQueryVariables>(
    AvailableQuestionsDocument,
    options,
  );
}
export function useAvailableQuestionsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    AvailableQuestionsQuery,
    AvailableQuestionsQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<AvailableQuestionsQuery, AvailableQuestionsQueryVariables>(
    AvailableQuestionsDocument,
    options,
  );
}
export type AvailableQuestionsQueryHookResult = ReturnType<typeof useAvailableQuestionsQuery>;
export type AvailableQuestionsLazyQueryHookResult = ReturnType<
  typeof useAvailableQuestionsLazyQuery
>;
export type AvailableQuestionsQueryResult = Apollo.QueryResult<
  AvailableQuestionsQuery,
  AvailableQuestionsQueryVariables
>;
export const SetQuestionDocument = gql`
  mutation SetQuestion($input: SetQuestionInput!) {
    accountSetQuestion(input: $input) {
      ... on SetQuestionProblem {
        reason
        trackId
      }
      ... on SetQuestionPayload {
        query {
          account {
            ...ControlQuestionAccount
          }
        }
      }
    }
  }
  ${ControlQuestionAccountFragmentDoc}
`;
export type SetQuestionMutationFn = Apollo.MutationFunction<
  SetQuestionMutation,
  SetQuestionMutationVariables
>;

/**
 * __useSetQuestionMutation__
 *
 * To run a mutation, you first call `useSetQuestionMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useSetQuestionMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [setQuestionMutation, { data, loading, error }] = useSetQuestionMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useSetQuestionMutation(
  baseOptions?: Apollo.MutationHookOptions<SetQuestionMutation, SetQuestionMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<SetQuestionMutation, SetQuestionMutationVariables>(
    SetQuestionDocument,
    options,
  );
}
export type SetQuestionMutationHookResult = ReturnType<typeof useSetQuestionMutation>;
export type SetQuestionMutationResult = Apollo.MutationResult<SetQuestionMutation>;
export type SetQuestionMutationOptions = Apollo.BaseMutationOptions<
  SetQuestionMutation,
  SetQuestionMutationVariables
>;
export const RecoveryEmailsDocument = gql`
  query RecoveryEmails {
    account {
      ...AccountRecoveryEmails
    }
  }
  ${AccountRecoveryEmailsFragmentDoc}
`;

/**
 * __useRecoveryEmailsQuery__
 *
 * To run a query within a React component, call `useRecoveryEmailsQuery` and pass it any options that fit your needs.
 * When your component renders, `useRecoveryEmailsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useRecoveryEmailsQuery({
 *   variables: {
 *   },
 * });
 */
export function useRecoveryEmailsQuery(
  baseOptions?: Apollo.QueryHookOptions<RecoveryEmailsQuery, RecoveryEmailsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<RecoveryEmailsQuery, RecoveryEmailsQueryVariables>(
    RecoveryEmailsDocument,
    options,
  );
}
export function useRecoveryEmailsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<RecoveryEmailsQuery, RecoveryEmailsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<RecoveryEmailsQuery, RecoveryEmailsQueryVariables>(
    RecoveryEmailsDocument,
    options,
  );
}
export type RecoveryEmailsQueryHookResult = ReturnType<typeof useRecoveryEmailsQuery>;
export type RecoveryEmailsLazyQueryHookResult = ReturnType<typeof useRecoveryEmailsLazyQuery>;
export type RecoveryEmailsQueryResult = Apollo.QueryResult<
  RecoveryEmailsQuery,
  RecoveryEmailsQueryVariables
>;
export const AccountAddRecoveryEmailDocument = gql`
  mutation AccountAddRecoveryEmail($input: AddRecoveryEmailInput!) {
    accountAddRecoveryEmail(input: $input) {
      ... on AddRecoveryEmailPayload {
        trackId
        query {
          account {
            ...AccountRecoveryEmails
          }
        }
      }
      ... on AddRecoveryEmailProblem {
        trackId
        reason
      }
    }
  }
  ${AccountRecoveryEmailsFragmentDoc}
`;
export type AccountAddRecoveryEmailMutationFn = Apollo.MutationFunction<
  AccountAddRecoveryEmailMutation,
  AccountAddRecoveryEmailMutationVariables
>;

/**
 * __useAccountAddRecoveryEmailMutation__
 *
 * To run a mutation, you first call `useAccountAddRecoveryEmailMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAccountAddRecoveryEmailMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [accountAddRecoveryEmailMutation, { data, loading, error }] = useAccountAddRecoveryEmailMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAccountAddRecoveryEmailMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AccountAddRecoveryEmailMutation,
    AccountAddRecoveryEmailMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    AccountAddRecoveryEmailMutation,
    AccountAddRecoveryEmailMutationVariables
  >(AccountAddRecoveryEmailDocument, options);
}
export type AccountAddRecoveryEmailMutationHookResult = ReturnType<
  typeof useAccountAddRecoveryEmailMutation
>;
export type AccountAddRecoveryEmailMutationResult =
  Apollo.MutationResult<AccountAddRecoveryEmailMutation>;
export type AccountAddRecoveryEmailMutationOptions = Apollo.BaseMutationOptions<
  AccountAddRecoveryEmailMutation,
  AccountAddRecoveryEmailMutationVariables
>;
export const AccountRemoveRecoveryEmailDocument = gql`
  mutation AccountRemoveRecoveryEmail($input: RemoveRecoveryEmailInput!) {
    accountRemoveRecoveryEmail(input: $input) {
      ... on RemoveRecoveryEmailPayload {
        query {
          account {
            ...AccountRecoveryEmails
          }
        }
      }
      ... on RemoveRecoveryEmailProblem {
        trackId
        reason
      }
    }
  }
  ${AccountRecoveryEmailsFragmentDoc}
`;
export type AccountRemoveRecoveryEmailMutationFn = Apollo.MutationFunction<
  AccountRemoveRecoveryEmailMutation,
  AccountRemoveRecoveryEmailMutationVariables
>;

/**
 * __useAccountRemoveRecoveryEmailMutation__
 *
 * To run a mutation, you first call `useAccountRemoveRecoveryEmailMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAccountRemoveRecoveryEmailMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [accountRemoveRecoveryEmailMutation, { data, loading, error }] = useAccountRemoveRecoveryEmailMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAccountRemoveRecoveryEmailMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AccountRemoveRecoveryEmailMutation,
    AccountRemoveRecoveryEmailMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    AccountRemoveRecoveryEmailMutation,
    AccountRemoveRecoveryEmailMutationVariables
  >(AccountRemoveRecoveryEmailDocument, options);
}
export type AccountRemoveRecoveryEmailMutationHookResult = ReturnType<
  typeof useAccountRemoveRecoveryEmailMutation
>;
export type AccountRemoveRecoveryEmailMutationResult =
  Apollo.MutationResult<AccountRemoveRecoveryEmailMutation>;
export type AccountRemoveRecoveryEmailMutationOptions = Apollo.BaseMutationOptions<
  AccountRemoveRecoveryEmailMutation,
  AccountRemoveRecoveryEmailMutationVariables
>;
export const AccountConfirmRecoveryEmailByLinkDocument = gql`
  mutation AccountConfirmRecoveryEmailByLink($input: ConfirmRecoveryEmailByLinkInput!) {
    accountConfirmRecoveryEmailByLink(input: $input) {
      ... on ConfirmRecoveryEmailByLinkPayload {
        query {
          account {
            ...AccountRecoveryEmails
          }
        }
      }
      ... on ConfirmRecoveryEmailByLinkProblem {
        reason
      }
    }
  }
  ${AccountRecoveryEmailsFragmentDoc}
`;
export type AccountConfirmRecoveryEmailByLinkMutationFn = Apollo.MutationFunction<
  AccountConfirmRecoveryEmailByLinkMutation,
  AccountConfirmRecoveryEmailByLinkMutationVariables
>;

/**
 * __useAccountConfirmRecoveryEmailByLinkMutation__
 *
 * To run a mutation, you first call `useAccountConfirmRecoveryEmailByLinkMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAccountConfirmRecoveryEmailByLinkMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [accountConfirmRecoveryEmailByLinkMutation, { data, loading, error }] = useAccountConfirmRecoveryEmailByLinkMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAccountConfirmRecoveryEmailByLinkMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AccountConfirmRecoveryEmailByLinkMutation,
    AccountConfirmRecoveryEmailByLinkMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    AccountConfirmRecoveryEmailByLinkMutation,
    AccountConfirmRecoveryEmailByLinkMutationVariables
  >(AccountConfirmRecoveryEmailByLinkDocument, options);
}
export type AccountConfirmRecoveryEmailByLinkMutationHookResult = ReturnType<
  typeof useAccountConfirmRecoveryEmailByLinkMutation
>;
export type AccountConfirmRecoveryEmailByLinkMutationResult =
  Apollo.MutationResult<AccountConfirmRecoveryEmailByLinkMutation>;
export type AccountConfirmRecoveryEmailByLinkMutationOptions = Apollo.BaseMutationOptions<
  AccountConfirmRecoveryEmailByLinkMutation,
  AccountConfirmRecoveryEmailByLinkMutationVariables
>;
export const AccountConfirmRecoveryEmailByCodeDocument = gql`
  mutation AccountConfirmRecoveryEmailByCode($input: ConfirmRecoveryEmailByCodeInput!) {
    accountConfirmRecoveryEmailByCode(input: $input) {
      ... on ConfirmRecoveryEmailByCodePayload {
        query {
          account {
            ...AccountRecoveryEmails
          }
        }
      }
      ... on ConfirmRecoveryEmailByCodeProblem {
        reason
      }
    }
  }
  ${AccountRecoveryEmailsFragmentDoc}
`;
export type AccountConfirmRecoveryEmailByCodeMutationFn = Apollo.MutationFunction<
  AccountConfirmRecoveryEmailByCodeMutation,
  AccountConfirmRecoveryEmailByCodeMutationVariables
>;

/**
 * __useAccountConfirmRecoveryEmailByCodeMutation__
 *
 * To run a mutation, you first call `useAccountConfirmRecoveryEmailByCodeMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAccountConfirmRecoveryEmailByCodeMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [accountConfirmRecoveryEmailByCodeMutation, { data, loading, error }] = useAccountConfirmRecoveryEmailByCodeMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAccountConfirmRecoveryEmailByCodeMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AccountConfirmRecoveryEmailByCodeMutation,
    AccountConfirmRecoveryEmailByCodeMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    AccountConfirmRecoveryEmailByCodeMutation,
    AccountConfirmRecoveryEmailByCodeMutationVariables
  >(AccountConfirmRecoveryEmailByCodeDocument, options);
}
export type AccountConfirmRecoveryEmailByCodeMutationHookResult = ReturnType<
  typeof useAccountConfirmRecoveryEmailByCodeMutation
>;
export type AccountConfirmRecoveryEmailByCodeMutationResult =
  Apollo.MutationResult<AccountConfirmRecoveryEmailByCodeMutation>;
export type AccountConfirmRecoveryEmailByCodeMutationOptions = Apollo.BaseMutationOptions<
  AccountConfirmRecoveryEmailByCodeMutation,
  AccountConfirmRecoveryEmailByCodeMutationVariables
>;
export const CreateOrUpdateAddressDocument = gql`
  mutation CreateOrUpdateAddress($input: CreateOrUpdateAddressInput!) {
    response: createOrUpdateAddress(input: $input) {
      ... on CreateOrUpdateAddressPayload {
        query {
          addresses {
            ...AddressDetails
          }
        }
      }
      ... on CreateOrUpdateAddressProblem {
        reason
      }
    }
  }
  ${AddressDetailsFragmentDoc}
`;
export type CreateOrUpdateAddressMutationFn = Apollo.MutationFunction<
  CreateOrUpdateAddressMutation,
  CreateOrUpdateAddressMutationVariables
>;

/**
 * __useCreateOrUpdateAddressMutation__
 *
 * To run a mutation, you first call `useCreateOrUpdateAddressMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateOrUpdateAddressMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createOrUpdateAddressMutation, { data, loading, error }] = useCreateOrUpdateAddressMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useCreateOrUpdateAddressMutation(
  baseOptions?: Apollo.MutationHookOptions<
    CreateOrUpdateAddressMutation,
    CreateOrUpdateAddressMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<CreateOrUpdateAddressMutation, CreateOrUpdateAddressMutationVariables>(
    CreateOrUpdateAddressDocument,
    options,
  );
}
export type CreateOrUpdateAddressMutationHookResult = ReturnType<
  typeof useCreateOrUpdateAddressMutation
>;
export type CreateOrUpdateAddressMutationResult =
  Apollo.MutationResult<CreateOrUpdateAddressMutation>;
export type CreateOrUpdateAddressMutationOptions = Apollo.BaseMutationOptions<
  CreateOrUpdateAddressMutation,
  CreateOrUpdateAddressMutationVariables
>;
export const DeleteAddressDocument = gql`
  mutation DeleteAddress($input: DeleteAddressInput!) {
    response: deleteAddress(input: $input) {
      ... on DeleteAddressPayload {
        query {
          addresses {
            ...AddressDetails
          }
        }
      }
      ... on DeleteAddressProblem {
        reason
      }
    }
  }
  ${AddressDetailsFragmentDoc}
`;
export type DeleteAddressMutationFn = Apollo.MutationFunction<
  DeleteAddressMutation,
  DeleteAddressMutationVariables
>;

/**
 * __useDeleteAddressMutation__
 *
 * To run a mutation, you first call `useDeleteAddressMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteAddressMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteAddressMutation, { data, loading, error }] = useDeleteAddressMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteAddressMutation(
  baseOptions?: Apollo.MutationHookOptions<DeleteAddressMutation, DeleteAddressMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<DeleteAddressMutation, DeleteAddressMutationVariables>(
    DeleteAddressDocument,
    options,
  );
}
export type DeleteAddressMutationHookResult = ReturnType<typeof useDeleteAddressMutation>;
export type DeleteAddressMutationResult = Apollo.MutationResult<DeleteAddressMutation>;
export type DeleteAddressMutationOptions = Apollo.BaseMutationOptions<
  DeleteAddressMutation,
  DeleteAddressMutationVariables
>;
export const ConfirmByPasswordDocument = gql`
  mutation ConfirmByPassword($input: ConfirmByPasswordInput!) {
    confirmByPassword(input: $input) {
      __typename
      ... on ConfirmByPasswordPayload {
        successful
      }
      ... on ConfirmByPasswordProblem {
        reason
      }
    }
  }
`;
export type ConfirmByPasswordMutationFn = Apollo.MutationFunction<
  ConfirmByPasswordMutation,
  ConfirmByPasswordMutationVariables
>;

/**
 * __useConfirmByPasswordMutation__
 *
 * To run a mutation, you first call `useConfirmByPasswordMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useConfirmByPasswordMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [confirmByPasswordMutation, { data, loading, error }] = useConfirmByPasswordMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useConfirmByPasswordMutation(
  baseOptions?: Apollo.MutationHookOptions<
    ConfirmByPasswordMutation,
    ConfirmByPasswordMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<ConfirmByPasswordMutation, ConfirmByPasswordMutationVariables>(
    ConfirmByPasswordDocument,
    options,
  );
}
export type ConfirmByPasswordMutationHookResult = ReturnType<typeof useConfirmByPasswordMutation>;
export type ConfirmByPasswordMutationResult = Apollo.MutationResult<ConfirmByPasswordMutation>;
export type ConfirmByPasswordMutationOptions = Apollo.BaseMutationOptions<
  ConfirmByPasswordMutation,
  ConfirmByPasswordMutationVariables
>;
export const GetBirthCertificateByIdDocument = gql`
  query GetBirthCertificateById($id: ID!) {
    document(id: $id) {
      ... on BirthCertificateDocument {
        ...BirthCertificateFullFragment
      }
      ... on DocumentByIdProblem {
        reason
      }
    }
  }
  ${BirthCertificateFullFragmentFragmentDoc}
`;

/**
 * __useGetBirthCertificateByIdQuery__
 *
 * To run a query within a React component, call `useGetBirthCertificateByIdQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetBirthCertificateByIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetBirthCertificateByIdQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetBirthCertificateByIdQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetBirthCertificateByIdQuery,
    GetBirthCertificateByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<GetBirthCertificateByIdQuery, GetBirthCertificateByIdQueryVariables>(
    GetBirthCertificateByIdDocument,
    options,
  );
}
export function useGetBirthCertificateByIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetBirthCertificateByIdQuery,
    GetBirthCertificateByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<GetBirthCertificateByIdQuery, GetBirthCertificateByIdQueryVariables>(
    GetBirthCertificateByIdDocument,
    options,
  );
}
export type GetBirthCertificateByIdQueryHookResult = ReturnType<
  typeof useGetBirthCertificateByIdQuery
>;
export type GetBirthCertificateByIdLazyQueryHookResult = ReturnType<
  typeof useGetBirthCertificateByIdLazyQuery
>;
export type GetBirthCertificateByIdQueryResult = Apollo.QueryResult<
  GetBirthCertificateByIdQuery,
  GetBirthCertificateByIdQueryVariables
>;
export const AddBirthCertificateDocument = gql`
  mutation AddBirthCertificate($input: AddDocumentInput!) {
    addDocument(input: $input) {
      ... on AddDocumentPayload {
        query {
          documents {
            id
            type
            section
            ... on BirthCertificateDocument {
              firstName
              lastName
            }
          }
        }
      }
      ... on AddDocumentProblem {
        reason
      }
    }
  }
`;
export type AddBirthCertificateMutationFn = Apollo.MutationFunction<
  AddBirthCertificateMutation,
  AddBirthCertificateMutationVariables
>;

/**
 * __useAddBirthCertificateMutation__
 *
 * To run a mutation, you first call `useAddBirthCertificateMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddBirthCertificateMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addBirthCertificateMutation, { data, loading, error }] = useAddBirthCertificateMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddBirthCertificateMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddBirthCertificateMutation,
    AddBirthCertificateMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<AddBirthCertificateMutation, AddBirthCertificateMutationVariables>(
    AddBirthCertificateDocument,
    options,
  );
}
export type AddBirthCertificateMutationHookResult = ReturnType<
  typeof useAddBirthCertificateMutation
>;
export type AddBirthCertificateMutationResult = Apollo.MutationResult<AddBirthCertificateMutation>;
export type AddBirthCertificateMutationOptions = Apollo.BaseMutationOptions<
  AddBirthCertificateMutation,
  AddBirthCertificateMutationVariables
>;
export const UpdateBirthCertificateDocument = gql`
  mutation UpdateBirthCertificate($input: UpdateDocumentInput!, $id: ID!) {
    updateDocument(input: $input) {
      ... on UpdateDocumentPayload {
        query {
          document(id: $id) {
            ... on BirthCertificateDocument {
              ...BirthCertificateFullFragment
            }
            ... on DocumentByIdProblem {
              reason
            }
          }
        }
      }
      ... on UpdateDocumentProblem {
        reason
      }
    }
  }
  ${BirthCertificateFullFragmentFragmentDoc}
`;
export type UpdateBirthCertificateMutationFn = Apollo.MutationFunction<
  UpdateBirthCertificateMutation,
  UpdateBirthCertificateMutationVariables
>;

/**
 * __useUpdateBirthCertificateMutation__
 *
 * To run a mutation, you first call `useUpdateBirthCertificateMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateBirthCertificateMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateBirthCertificateMutation, { data, loading, error }] = useUpdateBirthCertificateMutation({
 *   variables: {
 *      input: // value for 'input'
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUpdateBirthCertificateMutation(
  baseOptions?: Apollo.MutationHookOptions<
    UpdateBirthCertificateMutation,
    UpdateBirthCertificateMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    UpdateBirthCertificateMutation,
    UpdateBirthCertificateMutationVariables
  >(UpdateBirthCertificateDocument, options);
}
export type UpdateBirthCertificateMutationHookResult = ReturnType<
  typeof useUpdateBirthCertificateMutation
>;
export type UpdateBirthCertificateMutationResult =
  Apollo.MutationResult<UpdateBirthCertificateMutation>;
export type UpdateBirthCertificateMutationOptions = Apollo.BaseMutationOptions<
  UpdateBirthCertificateMutation,
  UpdateBirthCertificateMutationVariables
>;
export const DeleteBirthCertificateDocumentDocument = gql`
  mutation DeleteBirthCertificateDocument($input: DeleteDocumentInput!) {
    deleteDocument(input: $input) {
      ... on DeleteDocumentPayload {
        query {
          documents {
            id
            type
            previewUrl
            originalUrl
          }
        }
      }
      ... on DeleteDocumentProblem {
        reason
      }
    }
  }
`;
export type DeleteBirthCertificateDocumentMutationFn = Apollo.MutationFunction<
  DeleteBirthCertificateDocumentMutation,
  DeleteBirthCertificateDocumentMutationVariables
>;

/**
 * __useDeleteBirthCertificateDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteBirthCertificateDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteBirthCertificateDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteBirthCertificateDocumentMutation, { data, loading, error }] = useDeleteBirthCertificateDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteBirthCertificateDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteBirthCertificateDocumentMutation,
    DeleteBirthCertificateDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    DeleteBirthCertificateDocumentMutation,
    DeleteBirthCertificateDocumentMutationVariables
  >(DeleteBirthCertificateDocumentDocument, options);
}
export type DeleteBirthCertificateDocumentMutationHookResult = ReturnType<
  typeof useDeleteBirthCertificateDocumentMutation
>;
export type DeleteBirthCertificateDocumentMutationResult =
  Apollo.MutationResult<DeleteBirthCertificateDocumentMutation>;
export type DeleteBirthCertificateDocumentMutationOptions = Apollo.BaseMutationOptions<
  DeleteBirthCertificateDocumentMutation,
  DeleteBirthCertificateDocumentMutationVariables
>;
export const GetDriverLicenseByIdDocument = gql`
  query GetDriverLicenseById($id: ID!) {
    document(id: $id) {
      ... on DriverLicenseDocument {
        ...DriverLicenseFullFragment
      }
      ... on DocumentByIdProblem {
        reason
      }
    }
  }
  ${DriverLicenseFullFragmentFragmentDoc}
`;

/**
 * __useGetDriverLicenseByIdQuery__
 *
 * To run a query within a React component, call `useGetDriverLicenseByIdQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetDriverLicenseByIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetDriverLicenseByIdQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetDriverLicenseByIdQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetDriverLicenseByIdQuery,
    GetDriverLicenseByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<GetDriverLicenseByIdQuery, GetDriverLicenseByIdQueryVariables>(
    GetDriverLicenseByIdDocument,
    options,
  );
}
export function useGetDriverLicenseByIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetDriverLicenseByIdQuery,
    GetDriverLicenseByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<GetDriverLicenseByIdQuery, GetDriverLicenseByIdQueryVariables>(
    GetDriverLicenseByIdDocument,
    options,
  );
}
export type GetDriverLicenseByIdQueryHookResult = ReturnType<typeof useGetDriverLicenseByIdQuery>;
export type GetDriverLicenseByIdLazyQueryHookResult = ReturnType<
  typeof useGetDriverLicenseByIdLazyQuery
>;
export type GetDriverLicenseByIdQueryResult = Apollo.QueryResult<
  GetDriverLicenseByIdQuery,
  GetDriverLicenseByIdQueryVariables
>;
export const AddDriverLicenseDocument = gql`
  mutation AddDriverLicense($input: AddDocumentInput!) {
    addDocument(input: $input) {
      ... on AddDocumentPayload {
        query {
          documents {
            id
            type
            section
            ... on DriverLicenseDocument {
              firstName
              lastName
            }
          }
        }
      }
      ... on AddDocumentProblem {
        reason
      }
    }
  }
`;
export type AddDriverLicenseMutationFn = Apollo.MutationFunction<
  AddDriverLicenseMutation,
  AddDriverLicenseMutationVariables
>;

/**
 * __useAddDriverLicenseMutation__
 *
 * To run a mutation, you first call `useAddDriverLicenseMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddDriverLicenseMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addDriverLicenseMutation, { data, loading, error }] = useAddDriverLicenseMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddDriverLicenseMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddDriverLicenseMutation,
    AddDriverLicenseMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<AddDriverLicenseMutation, AddDriverLicenseMutationVariables>(
    AddDriverLicenseDocument,
    options,
  );
}
export type AddDriverLicenseMutationHookResult = ReturnType<typeof useAddDriverLicenseMutation>;
export type AddDriverLicenseMutationResult = Apollo.MutationResult<AddDriverLicenseMutation>;
export type AddDriverLicenseMutationOptions = Apollo.BaseMutationOptions<
  AddDriverLicenseMutation,
  AddDriverLicenseMutationVariables
>;
export const UpdateDriverLicenseDocument = gql`
  mutation UpdateDriverLicense($input: UpdateDocumentInput!, $id: ID!) {
    updateDocument(input: $input) {
      ... on UpdateDocumentPayload {
        query {
          document(id: $id) {
            ... on DriverLicenseDocument {
              ...DriverLicenseFullFragment
            }
            ... on DocumentByIdProblem {
              reason
            }
          }
        }
      }
      ... on UpdateDocumentProblem {
        reason
      }
    }
  }
  ${DriverLicenseFullFragmentFragmentDoc}
`;
export type UpdateDriverLicenseMutationFn = Apollo.MutationFunction<
  UpdateDriverLicenseMutation,
  UpdateDriverLicenseMutationVariables
>;

/**
 * __useUpdateDriverLicenseMutation__
 *
 * To run a mutation, you first call `useUpdateDriverLicenseMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateDriverLicenseMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateDriverLicenseMutation, { data, loading, error }] = useUpdateDriverLicenseMutation({
 *   variables: {
 *      input: // value for 'input'
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUpdateDriverLicenseMutation(
  baseOptions?: Apollo.MutationHookOptions<
    UpdateDriverLicenseMutation,
    UpdateDriverLicenseMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<UpdateDriverLicenseMutation, UpdateDriverLicenseMutationVariables>(
    UpdateDriverLicenseDocument,
    options,
  );
}
export type UpdateDriverLicenseMutationHookResult = ReturnType<
  typeof useUpdateDriverLicenseMutation
>;
export type UpdateDriverLicenseMutationResult = Apollo.MutationResult<UpdateDriverLicenseMutation>;
export type UpdateDriverLicenseMutationOptions = Apollo.BaseMutationOptions<
  UpdateDriverLicenseMutation,
  UpdateDriverLicenseMutationVariables
>;
export const DeleteDriverLicenseDocumentDocument = gql`
  mutation DeleteDriverLicenseDocument($input: DeleteDocumentInput!) {
    deleteDocument(input: $input) {
      ... on DeleteDocumentPayload {
        query {
          documents {
            id
            type
            previewUrl
            originalUrl
          }
        }
      }
      ... on DeleteDocumentProblem {
        reason
      }
    }
  }
`;
export type DeleteDriverLicenseDocumentMutationFn = Apollo.MutationFunction<
  DeleteDriverLicenseDocumentMutation,
  DeleteDriverLicenseDocumentMutationVariables
>;

/**
 * __useDeleteDriverLicenseDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteDriverLicenseDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteDriverLicenseDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteDriverLicenseDocumentMutation, { data, loading, error }] = useDeleteDriverLicenseDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteDriverLicenseDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteDriverLicenseDocumentMutation,
    DeleteDriverLicenseDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    DeleteDriverLicenseDocumentMutation,
    DeleteDriverLicenseDocumentMutationVariables
  >(DeleteDriverLicenseDocumentDocument, options);
}
export type DeleteDriverLicenseDocumentMutationHookResult = ReturnType<
  typeof useDeleteDriverLicenseDocumentMutation
>;
export type DeleteDriverLicenseDocumentMutationResult =
  Apollo.MutationResult<DeleteDriverLicenseDocumentMutation>;
export type DeleteDriverLicenseDocumentMutationOptions = Apollo.BaseMutationOptions<
  DeleteDriverLicenseDocumentMutation,
  DeleteDriverLicenseDocumentMutationVariables
>;
export const GetInnByIdDocument = gql`
  query GetInnById($id: ID!) {
    document(id: $id) {
      ... on InnDocument {
        ...InnFullFragment
      }
      ... on DocumentByIdProblem {
        reason
      }
    }
  }
  ${InnFullFragmentFragmentDoc}
`;

/**
 * __useGetInnByIdQuery__
 *
 * To run a query within a React component, call `useGetInnByIdQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetInnByIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetInnByIdQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetInnByIdQuery(
  baseOptions: Apollo.QueryHookOptions<GetInnByIdQuery, GetInnByIdQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<GetInnByIdQuery, GetInnByIdQueryVariables>(GetInnByIdDocument, options);
}
export function useGetInnByIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<GetInnByIdQuery, GetInnByIdQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<GetInnByIdQuery, GetInnByIdQueryVariables>(
    GetInnByIdDocument,
    options,
  );
}
export type GetInnByIdQueryHookResult = ReturnType<typeof useGetInnByIdQuery>;
export type GetInnByIdLazyQueryHookResult = ReturnType<typeof useGetInnByIdLazyQuery>;
export type GetInnByIdQueryResult = Apollo.QueryResult<GetInnByIdQuery, GetInnByIdQueryVariables>;
export const AddInnDocument = gql`
  mutation AddInn($input: AddDocumentInput!) {
    addDocument(input: $input) {
      ... on AddDocumentPayload {
        query {
          documents {
            id
            type
            section
            ... on InnDocument {
              firstName
              lastName
            }
          }
        }
      }
      ... on AddDocumentProblem {
        reason
      }
    }
  }
`;
export type AddInnMutationFn = Apollo.MutationFunction<AddInnMutation, AddInnMutationVariables>;

/**
 * __useAddInnMutation__
 *
 * To run a mutation, you first call `useAddInnMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddInnMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addInnMutation, { data, loading, error }] = useAddInnMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddInnMutation(
  baseOptions?: Apollo.MutationHookOptions<AddInnMutation, AddInnMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<AddInnMutation, AddInnMutationVariables>(AddInnDocument, options);
}
export type AddInnMutationHookResult = ReturnType<typeof useAddInnMutation>;
export type AddInnMutationResult = Apollo.MutationResult<AddInnMutation>;
export type AddInnMutationOptions = Apollo.BaseMutationOptions<
  AddInnMutation,
  AddInnMutationVariables
>;
export const UpdateInnDocument = gql`
  mutation UpdateInn($input: UpdateDocumentInput!, $id: ID!) {
    updateDocument(input: $input) {
      ... on UpdateDocumentPayload {
        query {
          document(id: $id) {
            ... on InnDocument {
              ...InnFullFragment
            }
            ... on DocumentByIdProblem {
              reason
            }
          }
        }
      }
      ... on UpdateDocumentProblem {
        reason
      }
    }
  }
  ${InnFullFragmentFragmentDoc}
`;
export type UpdateInnMutationFn = Apollo.MutationFunction<
  UpdateInnMutation,
  UpdateInnMutationVariables
>;

/**
 * __useUpdateInnMutation__
 *
 * To run a mutation, you first call `useUpdateInnMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateInnMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateInnMutation, { data, loading, error }] = useUpdateInnMutation({
 *   variables: {
 *      input: // value for 'input'
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUpdateInnMutation(
  baseOptions?: Apollo.MutationHookOptions<UpdateInnMutation, UpdateInnMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<UpdateInnMutation, UpdateInnMutationVariables>(
    UpdateInnDocument,
    options,
  );
}
export type UpdateInnMutationHookResult = ReturnType<typeof useUpdateInnMutation>;
export type UpdateInnMutationResult = Apollo.MutationResult<UpdateInnMutation>;
export type UpdateInnMutationOptions = Apollo.BaseMutationOptions<
  UpdateInnMutation,
  UpdateInnMutationVariables
>;
export const DeleteInnDocumentDocument = gql`
  mutation DeleteInnDocument($input: DeleteDocumentInput!) {
    deleteDocument(input: $input) {
      ... on DeleteDocumentPayload {
        query {
          documents {
            id
            type
            previewUrl
            originalUrl
          }
        }
      }
      ... on DeleteDocumentProblem {
        reason
      }
    }
  }
`;
export type DeleteInnDocumentMutationFn = Apollo.MutationFunction<
  DeleteInnDocumentMutation,
  DeleteInnDocumentMutationVariables
>;

/**
 * __useDeleteInnDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteInnDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteInnDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteInnDocumentMutation, { data, loading, error }] = useDeleteInnDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteInnDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteInnDocumentMutation,
    DeleteInnDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<DeleteInnDocumentMutation, DeleteInnDocumentMutationVariables>(
    DeleteInnDocumentDocument,
    options,
  );
}
export type DeleteInnDocumentMutationHookResult = ReturnType<typeof useDeleteInnDocumentMutation>;
export type DeleteInnDocumentMutationResult = Apollo.MutationResult<DeleteInnDocumentMutation>;
export type DeleteInnDocumentMutationOptions = Apollo.BaseMutationOptions<
  DeleteInnDocumentMutation,
  DeleteInnDocumentMutationVariables
>;
export const GetInternationalIdByIdDocument = gql`
  query GetInternationalIdById($id: ID!) {
    document(id: $id) {
      ... on InternationalIdDocument {
        ...InternationalIdFullFragment
      }
      ... on DocumentByIdProblem {
        reason
      }
    }
  }
  ${InternationalIdFullFragmentFragmentDoc}
`;

/**
 * __useGetInternationalIdByIdQuery__
 *
 * To run a query within a React component, call `useGetInternationalIdByIdQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetInternationalIdByIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetInternationalIdByIdQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetInternationalIdByIdQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetInternationalIdByIdQuery,
    GetInternationalIdByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<GetInternationalIdByIdQuery, GetInternationalIdByIdQueryVariables>(
    GetInternationalIdByIdDocument,
    options,
  );
}
export function useGetInternationalIdByIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetInternationalIdByIdQuery,
    GetInternationalIdByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<GetInternationalIdByIdQuery, GetInternationalIdByIdQueryVariables>(
    GetInternationalIdByIdDocument,
    options,
  );
}
export type GetInternationalIdByIdQueryHookResult = ReturnType<
  typeof useGetInternationalIdByIdQuery
>;
export type GetInternationalIdByIdLazyQueryHookResult = ReturnType<
  typeof useGetInternationalIdByIdLazyQuery
>;
export type GetInternationalIdByIdQueryResult = Apollo.QueryResult<
  GetInternationalIdByIdQuery,
  GetInternationalIdByIdQueryVariables
>;
export const AddInternationalIdDocument = gql`
  mutation AddInternationalId($input: AddDocumentInput!) {
    addDocument(input: $input) {
      ... on AddDocumentPayload {
        query {
          documents {
            id
            type
            section
            ... on InternationalIdDocument {
              firstName
              lastName
            }
          }
        }
      }
      ... on AddDocumentProblem {
        reason
      }
    }
  }
`;
export type AddInternationalIdMutationFn = Apollo.MutationFunction<
  AddInternationalIdMutation,
  AddInternationalIdMutationVariables
>;

/**
 * __useAddInternationalIdMutation__
 *
 * To run a mutation, you first call `useAddInternationalIdMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddInternationalIdMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addInternationalIdMutation, { data, loading, error }] = useAddInternationalIdMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddInternationalIdMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddInternationalIdMutation,
    AddInternationalIdMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<AddInternationalIdMutation, AddInternationalIdMutationVariables>(
    AddInternationalIdDocument,
    options,
  );
}
export type AddInternationalIdMutationHookResult = ReturnType<typeof useAddInternationalIdMutation>;
export type AddInternationalIdMutationResult = Apollo.MutationResult<AddInternationalIdMutation>;
export type AddInternationalIdMutationOptions = Apollo.BaseMutationOptions<
  AddInternationalIdMutation,
  AddInternationalIdMutationVariables
>;
export const UpdateInternationalIdDocument = gql`
  mutation UpdateInternationalId($input: UpdateDocumentInput!, $id: ID!) {
    updateDocument(input: $input) {
      ... on UpdateDocumentPayload {
        query {
          document(id: $id) {
            ... on InternationalIdDocument {
              ...InternationalIdFullFragment
            }
            ... on DocumentByIdProblem {
              reason
            }
          }
        }
      }
      ... on UpdateDocumentProblem {
        reason
      }
    }
  }
  ${InternationalIdFullFragmentFragmentDoc}
`;
export type UpdateInternationalIdMutationFn = Apollo.MutationFunction<
  UpdateInternationalIdMutation,
  UpdateInternationalIdMutationVariables
>;

/**
 * __useUpdateInternationalIdMutation__
 *
 * To run a mutation, you first call `useUpdateInternationalIdMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateInternationalIdMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateInternationalIdMutation, { data, loading, error }] = useUpdateInternationalIdMutation({
 *   variables: {
 *      input: // value for 'input'
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUpdateInternationalIdMutation(
  baseOptions?: Apollo.MutationHookOptions<
    UpdateInternationalIdMutation,
    UpdateInternationalIdMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<UpdateInternationalIdMutation, UpdateInternationalIdMutationVariables>(
    UpdateInternationalIdDocument,
    options,
  );
}
export type UpdateInternationalIdMutationHookResult = ReturnType<
  typeof useUpdateInternationalIdMutation
>;
export type UpdateInternationalIdMutationResult =
  Apollo.MutationResult<UpdateInternationalIdMutation>;
export type UpdateInternationalIdMutationOptions = Apollo.BaseMutationOptions<
  UpdateInternationalIdMutation,
  UpdateInternationalIdMutationVariables
>;
export const DeleteInternationalIdDocumentDocument = gql`
  mutation DeleteInternationalIdDocument($input: DeleteDocumentInput!) {
    deleteDocument(input: $input) {
      ... on DeleteDocumentPayload {
        query {
          documents {
            id
            type
            previewUrl
            originalUrl
          }
        }
      }
      ... on DeleteDocumentProblem {
        reason
      }
    }
  }
`;
export type DeleteInternationalIdDocumentMutationFn = Apollo.MutationFunction<
  DeleteInternationalIdDocumentMutation,
  DeleteInternationalIdDocumentMutationVariables
>;

/**
 * __useDeleteInternationalIdDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteInternationalIdDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteInternationalIdDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteInternationalIdDocumentMutation, { data, loading, error }] = useDeleteInternationalIdDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteInternationalIdDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteInternationalIdDocumentMutation,
    DeleteInternationalIdDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    DeleteInternationalIdDocumentMutation,
    DeleteInternationalIdDocumentMutationVariables
  >(DeleteInternationalIdDocumentDocument, options);
}
export type DeleteInternationalIdDocumentMutationHookResult = ReturnType<
  typeof useDeleteInternationalIdDocumentMutation
>;
export type DeleteInternationalIdDocumentMutationResult =
  Apollo.MutationResult<DeleteInternationalIdDocumentMutation>;
export type DeleteInternationalIdDocumentMutationOptions = Apollo.BaseMutationOptions<
  DeleteInternationalIdDocumentMutation,
  DeleteInternationalIdDocumentMutationVariables
>;
export const GetMedicalInsuranceByIdDocument = gql`
  query GetMedicalInsuranceById($id: ID!) {
    document(id: $id) {
      ... on MedicalInsuranceDocument {
        ...MedicalInsuranceFullFragment
      }
      ... on DocumentByIdProblem {
        reason
      }
    }
  }
  ${MedicalInsuranceFullFragmentFragmentDoc}
`;

/**
 * __useGetMedicalInsuranceByIdQuery__
 *
 * To run a query within a React component, call `useGetMedicalInsuranceByIdQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetMedicalInsuranceByIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetMedicalInsuranceByIdQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetMedicalInsuranceByIdQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetMedicalInsuranceByIdQuery,
    GetMedicalInsuranceByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<GetMedicalInsuranceByIdQuery, GetMedicalInsuranceByIdQueryVariables>(
    GetMedicalInsuranceByIdDocument,
    options,
  );
}
export function useGetMedicalInsuranceByIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetMedicalInsuranceByIdQuery,
    GetMedicalInsuranceByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<GetMedicalInsuranceByIdQuery, GetMedicalInsuranceByIdQueryVariables>(
    GetMedicalInsuranceByIdDocument,
    options,
  );
}
export type GetMedicalInsuranceByIdQueryHookResult = ReturnType<
  typeof useGetMedicalInsuranceByIdQuery
>;
export type GetMedicalInsuranceByIdLazyQueryHookResult = ReturnType<
  typeof useGetMedicalInsuranceByIdLazyQuery
>;
export type GetMedicalInsuranceByIdQueryResult = Apollo.QueryResult<
  GetMedicalInsuranceByIdQuery,
  GetMedicalInsuranceByIdQueryVariables
>;
export const AddMedicalInsuranceDocument = gql`
  mutation AddMedicalInsurance($input: AddDocumentInput!) {
    addDocument(input: $input) {
      ... on AddDocumentPayload {
        query {
          documents {
            id
            type
            section
            ... on MedicalInsuranceDocument {
              firstName
              lastName
            }
          }
        }
      }
      ... on AddDocumentProblem {
        reason
      }
    }
  }
`;
export type AddMedicalInsuranceMutationFn = Apollo.MutationFunction<
  AddMedicalInsuranceMutation,
  AddMedicalInsuranceMutationVariables
>;

/**
 * __useAddMedicalInsuranceMutation__
 *
 * To run a mutation, you first call `useAddMedicalInsuranceMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddMedicalInsuranceMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addMedicalInsuranceMutation, { data, loading, error }] = useAddMedicalInsuranceMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddMedicalInsuranceMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddMedicalInsuranceMutation,
    AddMedicalInsuranceMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<AddMedicalInsuranceMutation, AddMedicalInsuranceMutationVariables>(
    AddMedicalInsuranceDocument,
    options,
  );
}
export type AddMedicalInsuranceMutationHookResult = ReturnType<
  typeof useAddMedicalInsuranceMutation
>;
export type AddMedicalInsuranceMutationResult = Apollo.MutationResult<AddMedicalInsuranceMutation>;
export type AddMedicalInsuranceMutationOptions = Apollo.BaseMutationOptions<
  AddMedicalInsuranceMutation,
  AddMedicalInsuranceMutationVariables
>;
export const UpdateMedicalInsuranceDocument = gql`
  mutation UpdateMedicalInsurance($input: UpdateDocumentInput!, $id: ID!) {
    updateDocument(input: $input) {
      ... on UpdateDocumentPayload {
        query {
          document(id: $id) {
            ... on MedicalInsuranceDocument {
              ...MedicalInsuranceFullFragment
            }
            ... on DocumentByIdProblem {
              reason
            }
          }
        }
      }
      ... on UpdateDocumentProblem {
        reason
      }
    }
  }
  ${MedicalInsuranceFullFragmentFragmentDoc}
`;
export type UpdateMedicalInsuranceMutationFn = Apollo.MutationFunction<
  UpdateMedicalInsuranceMutation,
  UpdateMedicalInsuranceMutationVariables
>;

/**
 * __useUpdateMedicalInsuranceMutation__
 *
 * To run a mutation, you first call `useUpdateMedicalInsuranceMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateMedicalInsuranceMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateMedicalInsuranceMutation, { data, loading, error }] = useUpdateMedicalInsuranceMutation({
 *   variables: {
 *      input: // value for 'input'
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUpdateMedicalInsuranceMutation(
  baseOptions?: Apollo.MutationHookOptions<
    UpdateMedicalInsuranceMutation,
    UpdateMedicalInsuranceMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    UpdateMedicalInsuranceMutation,
    UpdateMedicalInsuranceMutationVariables
  >(UpdateMedicalInsuranceDocument, options);
}
export type UpdateMedicalInsuranceMutationHookResult = ReturnType<
  typeof useUpdateMedicalInsuranceMutation
>;
export type UpdateMedicalInsuranceMutationResult =
  Apollo.MutationResult<UpdateMedicalInsuranceMutation>;
export type UpdateMedicalInsuranceMutationOptions = Apollo.BaseMutationOptions<
  UpdateMedicalInsuranceMutation,
  UpdateMedicalInsuranceMutationVariables
>;
export const DeleteMedicalInsuranceDocumentDocument = gql`
  mutation DeleteMedicalInsuranceDocument($input: DeleteDocumentInput!) {
    deleteDocument(input: $input) {
      ... on DeleteDocumentPayload {
        query {
          documents {
            id
            type
            previewUrl
            originalUrl
          }
        }
      }
      ... on DeleteDocumentProblem {
        reason
      }
    }
  }
`;
export type DeleteMedicalInsuranceDocumentMutationFn = Apollo.MutationFunction<
  DeleteMedicalInsuranceDocumentMutation,
  DeleteMedicalInsuranceDocumentMutationVariables
>;

/**
 * __useDeleteMedicalInsuranceDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteMedicalInsuranceDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteMedicalInsuranceDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteMedicalInsuranceDocumentMutation, { data, loading, error }] = useDeleteMedicalInsuranceDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteMedicalInsuranceDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteMedicalInsuranceDocumentMutation,
    DeleteMedicalInsuranceDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    DeleteMedicalInsuranceDocumentMutation,
    DeleteMedicalInsuranceDocumentMutationVariables
  >(DeleteMedicalInsuranceDocumentDocument, options);
}
export type DeleteMedicalInsuranceDocumentMutationHookResult = ReturnType<
  typeof useDeleteMedicalInsuranceDocumentMutation
>;
export type DeleteMedicalInsuranceDocumentMutationResult =
  Apollo.MutationResult<DeleteMedicalInsuranceDocumentMutation>;
export type DeleteMedicalInsuranceDocumentMutationOptions = Apollo.BaseMutationOptions<
  DeleteMedicalInsuranceDocumentMutation,
  DeleteMedicalInsuranceDocumentMutationVariables
>;
export const GetNationalIdByIdDocument = gql`
  query GetNationalIdById($id: ID!) {
    document(id: $id) {
      ... on NationalIdDocument {
        ...NationalIdFullFragment
      }
      ... on DocumentByIdProblem {
        reason
      }
    }
  }
  ${NationalIdFullFragmentFragmentDoc}
`;

/**
 * __useGetNationalIdByIdQuery__
 *
 * To run a query within a React component, call `useGetNationalIdByIdQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetNationalIdByIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetNationalIdByIdQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetNationalIdByIdQuery(
  baseOptions: Apollo.QueryHookOptions<GetNationalIdByIdQuery, GetNationalIdByIdQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<GetNationalIdByIdQuery, GetNationalIdByIdQueryVariables>(
    GetNationalIdByIdDocument,
    options,
  );
}
export function useGetNationalIdByIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetNationalIdByIdQuery,
    GetNationalIdByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<GetNationalIdByIdQuery, GetNationalIdByIdQueryVariables>(
    GetNationalIdByIdDocument,
    options,
  );
}
export type GetNationalIdByIdQueryHookResult = ReturnType<typeof useGetNationalIdByIdQuery>;
export type GetNationalIdByIdLazyQueryHookResult = ReturnType<typeof useGetNationalIdByIdLazyQuery>;
export type GetNationalIdByIdQueryResult = Apollo.QueryResult<
  GetNationalIdByIdQuery,
  GetNationalIdByIdQueryVariables
>;
export const AddNationalIdDocument = gql`
  mutation AddNationalId($input: AddDocumentInput!) {
    addDocument(input: $input) {
      ... on AddDocumentPayload {
        query {
          documents {
            id
            type
            section
            ... on NationalIdDocument {
              firstName
              lastName
            }
          }
        }
      }
      ... on AddDocumentProblem {
        reason
      }
    }
  }
`;
export type AddNationalIdMutationFn = Apollo.MutationFunction<
  AddNationalIdMutation,
  AddNationalIdMutationVariables
>;

/**
 * __useAddNationalIdMutation__
 *
 * To run a mutation, you first call `useAddNationalIdMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddNationalIdMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addNationalIdMutation, { data, loading, error }] = useAddNationalIdMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddNationalIdMutation(
  baseOptions?: Apollo.MutationHookOptions<AddNationalIdMutation, AddNationalIdMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<AddNationalIdMutation, AddNationalIdMutationVariables>(
    AddNationalIdDocument,
    options,
  );
}
export type AddNationalIdMutationHookResult = ReturnType<typeof useAddNationalIdMutation>;
export type AddNationalIdMutationResult = Apollo.MutationResult<AddNationalIdMutation>;
export type AddNationalIdMutationOptions = Apollo.BaseMutationOptions<
  AddNationalIdMutation,
  AddNationalIdMutationVariables
>;
export const UpdateNationalIdDocument = gql`
  mutation UpdateNationalId($input: UpdateDocumentInput!, $id: ID!) {
    updateDocument(input: $input) {
      ... on UpdateDocumentPayload {
        query {
          document(id: $id) {
            ... on NationalIdDocument {
              ...NationalIdFullFragment
            }
            ... on DocumentByIdProblem {
              reason
            }
          }
        }
      }
      ... on UpdateDocumentProblem {
        reason
      }
    }
  }
  ${NationalIdFullFragmentFragmentDoc}
`;
export type UpdateNationalIdMutationFn = Apollo.MutationFunction<
  UpdateNationalIdMutation,
  UpdateNationalIdMutationVariables
>;

/**
 * __useUpdateNationalIdMutation__
 *
 * To run a mutation, you first call `useUpdateNationalIdMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateNationalIdMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateNationalIdMutation, { data, loading, error }] = useUpdateNationalIdMutation({
 *   variables: {
 *      input: // value for 'input'
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUpdateNationalIdMutation(
  baseOptions?: Apollo.MutationHookOptions<
    UpdateNationalIdMutation,
    UpdateNationalIdMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<UpdateNationalIdMutation, UpdateNationalIdMutationVariables>(
    UpdateNationalIdDocument,
    options,
  );
}
export type UpdateNationalIdMutationHookResult = ReturnType<typeof useUpdateNationalIdMutation>;
export type UpdateNationalIdMutationResult = Apollo.MutationResult<UpdateNationalIdMutation>;
export type UpdateNationalIdMutationOptions = Apollo.BaseMutationOptions<
  UpdateNationalIdMutation,
  UpdateNationalIdMutationVariables
>;
export const DeleteNationalIdDocumentDocument = gql`
  mutation DeleteNationalIdDocument($input: DeleteDocumentInput!) {
    deleteDocument(input: $input) {
      ... on DeleteDocumentPayload {
        query {
          documents {
            id
            type
            previewUrl
            originalUrl
          }
        }
      }
      ... on DeleteDocumentProblem {
        reason
      }
    }
  }
`;
export type DeleteNationalIdDocumentMutationFn = Apollo.MutationFunction<
  DeleteNationalIdDocumentMutation,
  DeleteNationalIdDocumentMutationVariables
>;

/**
 * __useDeleteNationalIdDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteNationalIdDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteNationalIdDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteNationalIdDocumentMutation, { data, loading, error }] = useDeleteNationalIdDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteNationalIdDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteNationalIdDocumentMutation,
    DeleteNationalIdDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    DeleteNationalIdDocumentMutation,
    DeleteNationalIdDocumentMutationVariables
  >(DeleteNationalIdDocumentDocument, options);
}
export type DeleteNationalIdDocumentMutationHookResult = ReturnType<
  typeof useDeleteNationalIdDocumentMutation
>;
export type DeleteNationalIdDocumentMutationResult =
  Apollo.MutationResult<DeleteNationalIdDocumentMutation>;
export type DeleteNationalIdDocumentMutationOptions = Apollo.BaseMutationOptions<
  DeleteNationalIdDocumentMutation,
  DeleteNationalIdDocumentMutationVariables
>;
export const GetSnilsByIdDocument = gql`
  query GetSnilsById($id: ID!) {
    document(id: $id) {
      ... on SnilsDocument {
        ...SnilsFullFragment
      }
      ... on DocumentByIdProblem {
        reason
      }
    }
  }
  ${SnilsFullFragmentFragmentDoc}
`;

/**
 * __useGetSnilsByIdQuery__
 *
 * To run a query within a React component, call `useGetSnilsByIdQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetSnilsByIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetSnilsByIdQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetSnilsByIdQuery(
  baseOptions: Apollo.QueryHookOptions<GetSnilsByIdQuery, GetSnilsByIdQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<GetSnilsByIdQuery, GetSnilsByIdQueryVariables>(
    GetSnilsByIdDocument,
    options,
  );
}
export function useGetSnilsByIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<GetSnilsByIdQuery, GetSnilsByIdQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<GetSnilsByIdQuery, GetSnilsByIdQueryVariables>(
    GetSnilsByIdDocument,
    options,
  );
}
export type GetSnilsByIdQueryHookResult = ReturnType<typeof useGetSnilsByIdQuery>;
export type GetSnilsByIdLazyQueryHookResult = ReturnType<typeof useGetSnilsByIdLazyQuery>;
export type GetSnilsByIdQueryResult = Apollo.QueryResult<
  GetSnilsByIdQuery,
  GetSnilsByIdQueryVariables
>;
export const AddSnilsDocument = gql`
  mutation AddSnils($input: AddDocumentInput!) {
    addDocument(input: $input) {
      ... on AddDocumentPayload {
        query {
          documents {
            id
            type
            section
            ... on SnilsDocument {
              firstName
              lastName
            }
          }
        }
      }
      ... on AddDocumentProblem {
        reason
      }
    }
  }
`;
export type AddSnilsMutationFn = Apollo.MutationFunction<
  AddSnilsMutation,
  AddSnilsMutationVariables
>;

/**
 * __useAddSnilsMutation__
 *
 * To run a mutation, you first call `useAddSnilsMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddSnilsMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addSnilsMutation, { data, loading, error }] = useAddSnilsMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddSnilsMutation(
  baseOptions?: Apollo.MutationHookOptions<AddSnilsMutation, AddSnilsMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<AddSnilsMutation, AddSnilsMutationVariables>(AddSnilsDocument, options);
}
export type AddSnilsMutationHookResult = ReturnType<typeof useAddSnilsMutation>;
export type AddSnilsMutationResult = Apollo.MutationResult<AddSnilsMutation>;
export type AddSnilsMutationOptions = Apollo.BaseMutationOptions<
  AddSnilsMutation,
  AddSnilsMutationVariables
>;
export const UpdateSnilsDocument = gql`
  mutation UpdateSnils($input: UpdateDocumentInput!, $id: ID!) {
    updateDocument(input: $input) {
      ... on UpdateDocumentPayload {
        query {
          document(id: $id) {
            ... on SnilsDocument {
              ...SnilsFullFragment
            }
            ... on DocumentByIdProblem {
              reason
            }
          }
        }
      }
      ... on UpdateDocumentProblem {
        reason
      }
    }
  }
  ${SnilsFullFragmentFragmentDoc}
`;
export type UpdateSnilsMutationFn = Apollo.MutationFunction<
  UpdateSnilsMutation,
  UpdateSnilsMutationVariables
>;

/**
 * __useUpdateSnilsMutation__
 *
 * To run a mutation, you first call `useUpdateSnilsMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateSnilsMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateSnilsMutation, { data, loading, error }] = useUpdateSnilsMutation({
 *   variables: {
 *      input: // value for 'input'
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUpdateSnilsMutation(
  baseOptions?: Apollo.MutationHookOptions<UpdateSnilsMutation, UpdateSnilsMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<UpdateSnilsMutation, UpdateSnilsMutationVariables>(
    UpdateSnilsDocument,
    options,
  );
}
export type UpdateSnilsMutationHookResult = ReturnType<typeof useUpdateSnilsMutation>;
export type UpdateSnilsMutationResult = Apollo.MutationResult<UpdateSnilsMutation>;
export type UpdateSnilsMutationOptions = Apollo.BaseMutationOptions<
  UpdateSnilsMutation,
  UpdateSnilsMutationVariables
>;
export const DeleteSnilsDocumentDocument = gql`
  mutation DeleteSnilsDocument($input: DeleteDocumentInput!) {
    deleteDocument(input: $input) {
      ... on DeleteDocumentPayload {
        query {
          documents {
            id
            type
            previewUrl
            originalUrl
          }
        }
      }
      ... on DeleteDocumentProblem {
        reason
      }
    }
  }
`;
export type DeleteSnilsDocumentMutationFn = Apollo.MutationFunction<
  DeleteSnilsDocumentMutation,
  DeleteSnilsDocumentMutationVariables
>;

/**
 * __useDeleteSnilsDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteSnilsDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteSnilsDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteSnilsDocumentMutation, { data, loading, error }] = useDeleteSnilsDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteSnilsDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteSnilsDocumentMutation,
    DeleteSnilsDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<DeleteSnilsDocumentMutation, DeleteSnilsDocumentMutationVariables>(
    DeleteSnilsDocumentDocument,
    options,
  );
}
export type DeleteSnilsDocumentMutationHookResult = ReturnType<
  typeof useDeleteSnilsDocumentMutation
>;
export type DeleteSnilsDocumentMutationResult = Apollo.MutationResult<DeleteSnilsDocumentMutation>;
export type DeleteSnilsDocumentMutationOptions = Apollo.BaseMutationOptions<
  DeleteSnilsDocumentMutation,
  DeleteSnilsDocumentMutationVariables
>;
export const GetVehicleRegistrationCertificateByIdDocument = gql`
  query GetVehicleRegistrationCertificateById($id: ID!) {
    document(id: $id) {
      ... on VehicleRegistrationCertificateDocument {
        ...VehicleRegistrationCertificateFullFragment
      }
      ... on DocumentByIdProblem {
        reason
      }
    }
  }
  ${VehicleRegistrationCertificateFullFragmentFragmentDoc}
`;

/**
 * __useGetVehicleRegistrationCertificateByIdQuery__
 *
 * To run a query within a React component, call `useGetVehicleRegistrationCertificateByIdQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetVehicleRegistrationCertificateByIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetVehicleRegistrationCertificateByIdQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetVehicleRegistrationCertificateByIdQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetVehicleRegistrationCertificateByIdQuery,
    GetVehicleRegistrationCertificateByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<
    GetVehicleRegistrationCertificateByIdQuery,
    GetVehicleRegistrationCertificateByIdQueryVariables
  >(GetVehicleRegistrationCertificateByIdDocument, options);
}
export function useGetVehicleRegistrationCertificateByIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetVehicleRegistrationCertificateByIdQuery,
    GetVehicleRegistrationCertificateByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<
    GetVehicleRegistrationCertificateByIdQuery,
    GetVehicleRegistrationCertificateByIdQueryVariables
  >(GetVehicleRegistrationCertificateByIdDocument, options);
}
export type GetVehicleRegistrationCertificateByIdQueryHookResult = ReturnType<
  typeof useGetVehicleRegistrationCertificateByIdQuery
>;
export type GetVehicleRegistrationCertificateByIdLazyQueryHookResult = ReturnType<
  typeof useGetVehicleRegistrationCertificateByIdLazyQuery
>;
export type GetVehicleRegistrationCertificateByIdQueryResult = Apollo.QueryResult<
  GetVehicleRegistrationCertificateByIdQuery,
  GetVehicleRegistrationCertificateByIdQueryVariables
>;
export const AddVehicleRegistrationCertificateDocument = gql`
  mutation AddVehicleRegistrationCertificate($input: AddDocumentInput!) {
    addDocument(input: $input) {
      ... on AddDocumentPayload {
        query {
          documents {
            id
            type
            section
            ... on VehicleRegistrationCertificateDocument {
              firstName
              lastName
            }
          }
        }
      }
      ... on AddDocumentProblem {
        reason
      }
    }
  }
`;
export type AddVehicleRegistrationCertificateMutationFn = Apollo.MutationFunction<
  AddVehicleRegistrationCertificateMutation,
  AddVehicleRegistrationCertificateMutationVariables
>;

/**
 * __useAddVehicleRegistrationCertificateMutation__
 *
 * To run a mutation, you first call `useAddVehicleRegistrationCertificateMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddVehicleRegistrationCertificateMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addVehicleRegistrationCertificateMutation, { data, loading, error }] = useAddVehicleRegistrationCertificateMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddVehicleRegistrationCertificateMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddVehicleRegistrationCertificateMutation,
    AddVehicleRegistrationCertificateMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    AddVehicleRegistrationCertificateMutation,
    AddVehicleRegistrationCertificateMutationVariables
  >(AddVehicleRegistrationCertificateDocument, options);
}
export type AddVehicleRegistrationCertificateMutationHookResult = ReturnType<
  typeof useAddVehicleRegistrationCertificateMutation
>;
export type AddVehicleRegistrationCertificateMutationResult =
  Apollo.MutationResult<AddVehicleRegistrationCertificateMutation>;
export type AddVehicleRegistrationCertificateMutationOptions = Apollo.BaseMutationOptions<
  AddVehicleRegistrationCertificateMutation,
  AddVehicleRegistrationCertificateMutationVariables
>;
export const UpdateVehicleRegistrationCertificateDocument = gql`
  mutation UpdateVehicleRegistrationCertificate($input: UpdateDocumentInput!, $id: ID!) {
    updateDocument(input: $input) {
      ... on UpdateDocumentPayload {
        query {
          document(id: $id) {
            ... on VehicleRegistrationCertificateDocument {
              ...VehicleRegistrationCertificateFullFragment
            }
            ... on DocumentByIdProblem {
              reason
            }
          }
        }
      }
      ... on UpdateDocumentProblem {
        reason
      }
    }
  }
  ${VehicleRegistrationCertificateFullFragmentFragmentDoc}
`;
export type UpdateVehicleRegistrationCertificateMutationFn = Apollo.MutationFunction<
  UpdateVehicleRegistrationCertificateMutation,
  UpdateVehicleRegistrationCertificateMutationVariables
>;

/**
 * __useUpdateVehicleRegistrationCertificateMutation__
 *
 * To run a mutation, you first call `useUpdateVehicleRegistrationCertificateMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateVehicleRegistrationCertificateMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateVehicleRegistrationCertificateMutation, { data, loading, error }] = useUpdateVehicleRegistrationCertificateMutation({
 *   variables: {
 *      input: // value for 'input'
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUpdateVehicleRegistrationCertificateMutation(
  baseOptions?: Apollo.MutationHookOptions<
    UpdateVehicleRegistrationCertificateMutation,
    UpdateVehicleRegistrationCertificateMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    UpdateVehicleRegistrationCertificateMutation,
    UpdateVehicleRegistrationCertificateMutationVariables
  >(UpdateVehicleRegistrationCertificateDocument, options);
}
export type UpdateVehicleRegistrationCertificateMutationHookResult = ReturnType<
  typeof useUpdateVehicleRegistrationCertificateMutation
>;
export type UpdateVehicleRegistrationCertificateMutationResult =
  Apollo.MutationResult<UpdateVehicleRegistrationCertificateMutation>;
export type UpdateVehicleRegistrationCertificateMutationOptions = Apollo.BaseMutationOptions<
  UpdateVehicleRegistrationCertificateMutation,
  UpdateVehicleRegistrationCertificateMutationVariables
>;
export const DeleteVehicleRegistrationCertificateDocumentDocument = gql`
  mutation DeleteVehicleRegistrationCertificateDocument($input: DeleteDocumentInput!) {
    deleteDocument(input: $input) {
      ... on DeleteDocumentPayload {
        query {
          documents {
            id
            type
            previewUrl
            originalUrl
          }
        }
      }
      ... on DeleteDocumentProblem {
        reason
      }
    }
  }
`;
export type DeleteVehicleRegistrationCertificateDocumentMutationFn = Apollo.MutationFunction<
  DeleteVehicleRegistrationCertificateDocumentMutation,
  DeleteVehicleRegistrationCertificateDocumentMutationVariables
>;

/**
 * __useDeleteVehicleRegistrationCertificateDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteVehicleRegistrationCertificateDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteVehicleRegistrationCertificateDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteVehicleRegistrationCertificateDocumentMutation, { data, loading, error }] = useDeleteVehicleRegistrationCertificateDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteVehicleRegistrationCertificateDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteVehicleRegistrationCertificateDocumentMutation,
    DeleteVehicleRegistrationCertificateDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    DeleteVehicleRegistrationCertificateDocumentMutation,
    DeleteVehicleRegistrationCertificateDocumentMutationVariables
  >(DeleteVehicleRegistrationCertificateDocumentDocument, options);
}
export type DeleteVehicleRegistrationCertificateDocumentMutationHookResult = ReturnType<
  typeof useDeleteVehicleRegistrationCertificateDocumentMutation
>;
export type DeleteVehicleRegistrationCertificateDocumentMutationResult =
  Apollo.MutationResult<DeleteVehicleRegistrationCertificateDocumentMutation>;
export type DeleteVehicleRegistrationCertificateDocumentMutationOptions =
  Apollo.BaseMutationOptions<
    DeleteVehicleRegistrationCertificateDocumentMutation,
    DeleteVehicleRegistrationCertificateDocumentMutationVariables
  >;
export const GetVoluntaryMedicalInsuranceByIdDocument = gql`
  query GetVoluntaryMedicalInsuranceById($id: ID!) {
    document(id: $id) {
      ... on VoluntaryMedicalInsuranceDocument {
        ...VoluntaryMedicalInsuranceFullFragment
      }
      ... on DocumentByIdProblem {
        reason
      }
    }
  }
  ${VoluntaryMedicalInsuranceFullFragmentFragmentDoc}
`;

/**
 * __useGetVoluntaryMedicalInsuranceByIdQuery__
 *
 * To run a query within a React component, call `useGetVoluntaryMedicalInsuranceByIdQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetVoluntaryMedicalInsuranceByIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetVoluntaryMedicalInsuranceByIdQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetVoluntaryMedicalInsuranceByIdQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetVoluntaryMedicalInsuranceByIdQuery,
    GetVoluntaryMedicalInsuranceByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<
    GetVoluntaryMedicalInsuranceByIdQuery,
    GetVoluntaryMedicalInsuranceByIdQueryVariables
  >(GetVoluntaryMedicalInsuranceByIdDocument, options);
}
export function useGetVoluntaryMedicalInsuranceByIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetVoluntaryMedicalInsuranceByIdQuery,
    GetVoluntaryMedicalInsuranceByIdQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<
    GetVoluntaryMedicalInsuranceByIdQuery,
    GetVoluntaryMedicalInsuranceByIdQueryVariables
  >(GetVoluntaryMedicalInsuranceByIdDocument, options);
}
export type GetVoluntaryMedicalInsuranceByIdQueryHookResult = ReturnType<
  typeof useGetVoluntaryMedicalInsuranceByIdQuery
>;
export type GetVoluntaryMedicalInsuranceByIdLazyQueryHookResult = ReturnType<
  typeof useGetVoluntaryMedicalInsuranceByIdLazyQuery
>;
export type GetVoluntaryMedicalInsuranceByIdQueryResult = Apollo.QueryResult<
  GetVoluntaryMedicalInsuranceByIdQuery,
  GetVoluntaryMedicalInsuranceByIdQueryVariables
>;
export const AddVoluntaryMedicalInsuranceDocument = gql`
  mutation AddVoluntaryMedicalInsurance($input: AddDocumentInput!) {
    addDocument(input: $input) {
      ... on AddDocumentPayload {
        query {
          documents {
            id
            type
            section
            ... on VoluntaryMedicalInsuranceDocument {
              firstName
              lastName
            }
          }
        }
      }
      ... on AddDocumentProblem {
        reason
      }
    }
  }
`;
export type AddVoluntaryMedicalInsuranceMutationFn = Apollo.MutationFunction<
  AddVoluntaryMedicalInsuranceMutation,
  AddVoluntaryMedicalInsuranceMutationVariables
>;

/**
 * __useAddVoluntaryMedicalInsuranceMutation__
 *
 * To run a mutation, you first call `useAddVoluntaryMedicalInsuranceMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddVoluntaryMedicalInsuranceMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addVoluntaryMedicalInsuranceMutation, { data, loading, error }] = useAddVoluntaryMedicalInsuranceMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddVoluntaryMedicalInsuranceMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddVoluntaryMedicalInsuranceMutation,
    AddVoluntaryMedicalInsuranceMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    AddVoluntaryMedicalInsuranceMutation,
    AddVoluntaryMedicalInsuranceMutationVariables
  >(AddVoluntaryMedicalInsuranceDocument, options);
}
export type AddVoluntaryMedicalInsuranceMutationHookResult = ReturnType<
  typeof useAddVoluntaryMedicalInsuranceMutation
>;
export type AddVoluntaryMedicalInsuranceMutationResult =
  Apollo.MutationResult<AddVoluntaryMedicalInsuranceMutation>;
export type AddVoluntaryMedicalInsuranceMutationOptions = Apollo.BaseMutationOptions<
  AddVoluntaryMedicalInsuranceMutation,
  AddVoluntaryMedicalInsuranceMutationVariables
>;
export const UpdateVoluntaryMedicalInsuranceDocument = gql`
  mutation UpdateVoluntaryMedicalInsurance($input: UpdateDocumentInput!, $id: ID!) {
    updateDocument(input: $input) {
      ... on UpdateDocumentPayload {
        query {
          document(id: $id) {
            ... on VoluntaryMedicalInsuranceDocument {
              ...VoluntaryMedicalInsuranceFullFragment
            }
            ... on DocumentByIdProblem {
              reason
            }
          }
        }
      }
      ... on UpdateDocumentProblem {
        reason
      }
    }
  }
  ${VoluntaryMedicalInsuranceFullFragmentFragmentDoc}
`;
export type UpdateVoluntaryMedicalInsuranceMutationFn = Apollo.MutationFunction<
  UpdateVoluntaryMedicalInsuranceMutation,
  UpdateVoluntaryMedicalInsuranceMutationVariables
>;

/**
 * __useUpdateVoluntaryMedicalInsuranceMutation__
 *
 * To run a mutation, you first call `useUpdateVoluntaryMedicalInsuranceMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateVoluntaryMedicalInsuranceMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateVoluntaryMedicalInsuranceMutation, { data, loading, error }] = useUpdateVoluntaryMedicalInsuranceMutation({
 *   variables: {
 *      input: // value for 'input'
 *      id: // value for 'id'
 *   },
 * });
 */
export function useUpdateVoluntaryMedicalInsuranceMutation(
  baseOptions?: Apollo.MutationHookOptions<
    UpdateVoluntaryMedicalInsuranceMutation,
    UpdateVoluntaryMedicalInsuranceMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    UpdateVoluntaryMedicalInsuranceMutation,
    UpdateVoluntaryMedicalInsuranceMutationVariables
  >(UpdateVoluntaryMedicalInsuranceDocument, options);
}
export type UpdateVoluntaryMedicalInsuranceMutationHookResult = ReturnType<
  typeof useUpdateVoluntaryMedicalInsuranceMutation
>;
export type UpdateVoluntaryMedicalInsuranceMutationResult =
  Apollo.MutationResult<UpdateVoluntaryMedicalInsuranceMutation>;
export type UpdateVoluntaryMedicalInsuranceMutationOptions = Apollo.BaseMutationOptions<
  UpdateVoluntaryMedicalInsuranceMutation,
  UpdateVoluntaryMedicalInsuranceMutationVariables
>;
export const DeleteVoluntaryMedicalInsuranceDocumentDocument = gql`
  mutation DeleteVoluntaryMedicalInsuranceDocument($input: DeleteDocumentInput!) {
    deleteDocument(input: $input) {
      ... on DeleteDocumentPayload {
        query {
          documents {
            id
            type
            previewUrl
            originalUrl
          }
        }
      }
      ... on DeleteDocumentProblem {
        reason
      }
    }
  }
`;
export type DeleteVoluntaryMedicalInsuranceDocumentMutationFn = Apollo.MutationFunction<
  DeleteVoluntaryMedicalInsuranceDocumentMutation,
  DeleteVoluntaryMedicalInsuranceDocumentMutationVariables
>;

/**
 * __useDeleteVoluntaryMedicalInsuranceDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteVoluntaryMedicalInsuranceDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteVoluntaryMedicalInsuranceDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteVoluntaryMedicalInsuranceDocumentMutation, { data, loading, error }] = useDeleteVoluntaryMedicalInsuranceDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteVoluntaryMedicalInsuranceDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteVoluntaryMedicalInsuranceDocumentMutation,
    DeleteVoluntaryMedicalInsuranceDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    DeleteVoluntaryMedicalInsuranceDocumentMutation,
    DeleteVoluntaryMedicalInsuranceDocumentMutationVariables
  >(DeleteVoluntaryMedicalInsuranceDocumentDocument, options);
}
export type DeleteVoluntaryMedicalInsuranceDocumentMutationHookResult = ReturnType<
  typeof useDeleteVoluntaryMedicalInsuranceDocumentMutation
>;
export type DeleteVoluntaryMedicalInsuranceDocumentMutationResult =
  Apollo.MutationResult<DeleteVoluntaryMedicalInsuranceDocumentMutation>;
export type DeleteVoluntaryMedicalInsuranceDocumentMutationOptions = Apollo.BaseMutationOptions<
  DeleteVoluntaryMedicalInsuranceDocumentMutation,
  DeleteVoluntaryMedicalInsuranceDocumentMutationVariables
>;
export const EdadealDataDocument = gql`
  query EdadealData {
    edadealData {
      hasBinding
      url
      iframeSrc
      amount
    }
  }
`;

/**
 * __useEdadealDataQuery__
 *
 * To run a query within a React component, call `useEdadealDataQuery` and pass it any options that fit your needs.
 * When your component renders, `useEdadealDataQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useEdadealDataQuery({
 *   variables: {
 *   },
 * });
 */
export function useEdadealDataQuery(
  baseOptions?: Apollo.QueryHookOptions<EdadealDataQuery, EdadealDataQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<EdadealDataQuery, EdadealDataQueryVariables>(EdadealDataDocument, options);
}
export function useEdadealDataLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<EdadealDataQuery, EdadealDataQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<EdadealDataQuery, EdadealDataQueryVariables>(
    EdadealDataDocument,
    options,
  );
}
export type EdadealDataQueryHookResult = ReturnType<typeof useEdadealDataQuery>;
export type EdadealDataLazyQueryHookResult = ReturnType<typeof useEdadealDataLazyQuery>;
export type EdadealDataQueryResult = Apollo.QueryResult<
  EdadealDataQuery,
  EdadealDataQueryVariables
>;
export const PaymentsContextDocument = gql`
  query PaymentsContext($familyMode: Boolean) {
    paymentsContext(familyMode: $familyMode) {
      services {
        id
        i18nKeyName
        iconUrl
        name
      }
      plusServiceData {
        iconUrl
      }
      familyData {
        uid
        name
        avatar
      }
    }
  }
`;

/**
 * __usePaymentsContextQuery__
 *
 * To run a query within a React component, call `usePaymentsContextQuery` and pass it any options that fit your needs.
 * When your component renders, `usePaymentsContextQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = usePaymentsContextQuery({
 *   variables: {
 *      familyMode: // value for 'familyMode'
 *   },
 * });
 */
export function usePaymentsContextQuery(
  baseOptions?: Apollo.QueryHookOptions<PaymentsContextQuery, PaymentsContextQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<PaymentsContextQuery, PaymentsContextQueryVariables>(
    PaymentsContextDocument,
    options,
  );
}
export function usePaymentsContextLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<PaymentsContextQuery, PaymentsContextQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<PaymentsContextQuery, PaymentsContextQueryVariables>(
    PaymentsContextDocument,
    options,
  );
}
export type PaymentsContextQueryHookResult = ReturnType<typeof usePaymentsContextQuery>;
export type PaymentsContextLazyQueryHookResult = ReturnType<typeof usePaymentsContextLazyQuery>;
export type PaymentsContextQueryResult = Apollo.QueryResult<
  PaymentsContextQuery,
  PaymentsContextQueryVariables
>;
export const PaymentReceiptsDocument = gql`
  query PaymentReceipts($purchaseToken: String!) {
    receiptsByToken(purchaseToken: $purchaseToken) {
      url
      amount
      timestamp
      type
    }
  }
`;

/**
 * __usePaymentReceiptsQuery__
 *
 * To run a query within a React component, call `usePaymentReceiptsQuery` and pass it any options that fit your needs.
 * When your component renders, `usePaymentReceiptsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = usePaymentReceiptsQuery({
 *   variables: {
 *      purchaseToken: // value for 'purchaseToken'
 *   },
 * });
 */
export function usePaymentReceiptsQuery(
  baseOptions: Apollo.QueryHookOptions<PaymentReceiptsQuery, PaymentReceiptsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<PaymentReceiptsQuery, PaymentReceiptsQueryVariables>(
    PaymentReceiptsDocument,
    options,
  );
}
export function usePaymentReceiptsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<PaymentReceiptsQuery, PaymentReceiptsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<PaymentReceiptsQuery, PaymentReceiptsQueryVariables>(
    PaymentReceiptsDocument,
    options,
  );
}
export type PaymentReceiptsQueryHookResult = ReturnType<typeof usePaymentReceiptsQuery>;
export type PaymentReceiptsLazyQueryHookResult = ReturnType<typeof usePaymentReceiptsLazyQuery>;
export type PaymentReceiptsQueryResult = Apollo.QueryResult<
  PaymentReceiptsQuery,
  PaymentReceiptsQueryVariables
>;
export const PaymentsHistoryDocument = gql`
  query PaymentsHistory($alias: String, $user: String, $after: String) {
    paymentsData(alias: $alias, user: $user, after: $after) {
      edges {
        service {
          iconUrl
          i18nKeyName
          name
          splashUrl
          url
          help
        }
        total
        plus
        cashback
        currency
        orderId
        created
        status
        isReceipt
        source
        retailerName
        retailerIcon
        purchaseToken
        receiptsEnabled
        receiptUrl
        initiatorUid
        items {
          price
          hidden
          alias
          hidden
          name
        }
        paymentTypes {
          price
          account
          currency
          method
        }
      }
      pageInfo {
        endCursor
        hasNextPage
      }
    }
  }
`;

/**
 * __usePaymentsHistoryQuery__
 *
 * To run a query within a React component, call `usePaymentsHistoryQuery` and pass it any options that fit your needs.
 * When your component renders, `usePaymentsHistoryQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = usePaymentsHistoryQuery({
 *   variables: {
 *      alias: // value for 'alias'
 *      user: // value for 'user'
 *      after: // value for 'after'
 *   },
 * });
 */
export function usePaymentsHistoryQuery(
  baseOptions?: Apollo.QueryHookOptions<PaymentsHistoryQuery, PaymentsHistoryQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<PaymentsHistoryQuery, PaymentsHistoryQueryVariables>(
    PaymentsHistoryDocument,
    options,
  );
}
export function usePaymentsHistoryLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<PaymentsHistoryQuery, PaymentsHistoryQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<PaymentsHistoryQuery, PaymentsHistoryQueryVariables>(
    PaymentsHistoryDocument,
    options,
  );
}
export type PaymentsHistoryQueryHookResult = ReturnType<typeof usePaymentsHistoryQuery>;
export type PaymentsHistoryLazyQueryHookResult = ReturnType<typeof usePaymentsHistoryLazyQuery>;
export type PaymentsHistoryQueryResult = Apollo.QueryResult<
  PaymentsHistoryQuery,
  PaymentsHistoryQueryVariables
>;
export const BillsDataDocument = gql`
  query BillsData {
    bills {
      state
    }
    billsDocuments {
      document_id
    }
  }
`;

/**
 * __useBillsDataQuery__
 *
 * To run a query within a React component, call `useBillsDataQuery` and pass it any options that fit your needs.
 * When your component renders, `useBillsDataQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useBillsDataQuery({
 *   variables: {
 *   },
 * });
 */
export function useBillsDataQuery(
  baseOptions?: Apollo.QueryHookOptions<BillsDataQuery, BillsDataQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<BillsDataQuery, BillsDataQueryVariables>(BillsDataDocument, options);
}
export function useBillsDataLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<BillsDataQuery, BillsDataQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<BillsDataQuery, BillsDataQueryVariables>(BillsDataDocument, options);
}
export type BillsDataQueryHookResult = ReturnType<typeof useBillsDataQuery>;
export type BillsDataLazyQueryHookResult = ReturnType<typeof useBillsDataLazyQuery>;
export type BillsDataQueryResult = Apollo.QueryResult<BillsDataQuery, BillsDataQueryVariables>;
export const GibddDataDocument = gql`
  query GibddData {
    bills {
      state
      bills {
        bill_id
        document_id
        payment_deadline
        amount
        supplier_bill_id
        purpose
        legal_act
        offense_place
        payer_name
        payee_name
        account_number
        fee_amount
        inn
        kpp
        bik
        oktmo
        bill_date
        discounted_amount
      }
    }
    billsDocuments {
      type
      title
      document_id
      value
    }
  }
`;

/**
 * __useGibddDataQuery__
 *
 * To run a query within a React component, call `useGibddDataQuery` and pass it any options that fit your needs.
 * When your component renders, `useGibddDataQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGibddDataQuery({
 *   variables: {
 *   },
 * });
 */
export function useGibddDataQuery(
  baseOptions?: Apollo.QueryHookOptions<GibddDataQuery, GibddDataQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<GibddDataQuery, GibddDataQueryVariables>(GibddDataDocument, options);
}
export function useGibddDataLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<GibddDataQuery, GibddDataQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<GibddDataQuery, GibddDataQueryVariables>(GibddDataDocument, options);
}
export type GibddDataQueryHookResult = ReturnType<typeof useGibddDataQuery>;
export type GibddDataLazyQueryHookResult = ReturnType<typeof useGibddDataLazyQuery>;
export type GibddDataQueryResult = Apollo.QueryResult<GibddDataQuery, GibddDataQueryVariables>;
export const AddGibddDocumentDocument = gql`
  mutation AddGibddDocument($input: AddBillsDocumentInput!) {
    addBillsDocument(input: $input) {
      document_id
    }
  }
`;
export type AddGibddDocumentMutationFn = Apollo.MutationFunction<
  AddGibddDocumentMutation,
  AddGibddDocumentMutationVariables
>;

/**
 * __useAddGibddDocumentMutation__
 *
 * To run a mutation, you first call `useAddGibddDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddGibddDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addGibddDocumentMutation, { data, loading, error }] = useAddGibddDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useAddGibddDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddGibddDocumentMutation,
    AddGibddDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<AddGibddDocumentMutation, AddGibddDocumentMutationVariables>(
    AddGibddDocumentDocument,
    options,
  );
}
export type AddGibddDocumentMutationHookResult = ReturnType<typeof useAddGibddDocumentMutation>;
export type AddGibddDocumentMutationResult = Apollo.MutationResult<AddGibddDocumentMutation>;
export type AddGibddDocumentMutationOptions = Apollo.BaseMutationOptions<
  AddGibddDocumentMutation,
  AddGibddDocumentMutationVariables
>;
export const UpdateGibddDocumentDocument = gql`
  mutation UpdateGibddDocument($input: UpdateBillsDocumentInput!) {
    updateBillsDocument(input: $input) {
      document_id
    }
  }
`;
export type UpdateGibddDocumentMutationFn = Apollo.MutationFunction<
  UpdateGibddDocumentMutation,
  UpdateGibddDocumentMutationVariables
>;

/**
 * __useUpdateGibddDocumentMutation__
 *
 * To run a mutation, you first call `useUpdateGibddDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdateGibddDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updateGibddDocumentMutation, { data, loading, error }] = useUpdateGibddDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useUpdateGibddDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    UpdateGibddDocumentMutation,
    UpdateGibddDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<UpdateGibddDocumentMutation, UpdateGibddDocumentMutationVariables>(
    UpdateGibddDocumentDocument,
    options,
  );
}
export type UpdateGibddDocumentMutationHookResult = ReturnType<
  typeof useUpdateGibddDocumentMutation
>;
export type UpdateGibddDocumentMutationResult = Apollo.MutationResult<UpdateGibddDocumentMutation>;
export type UpdateGibddDocumentMutationOptions = Apollo.BaseMutationOptions<
  UpdateGibddDocumentMutation,
  UpdateGibddDocumentMutationVariables
>;
export const DeleteGibddDocumentDocument = gql`
  mutation DeleteGibddDocument($input: DeleteBillsDocumentInput!) {
    deleteBillsDocument(input: $input) {
      status
    }
  }
`;
export type DeleteGibddDocumentMutationFn = Apollo.MutationFunction<
  DeleteGibddDocumentMutation,
  DeleteGibddDocumentMutationVariables
>;

/**
 * __useDeleteGibddDocumentMutation__
 *
 * To run a mutation, you first call `useDeleteGibddDocumentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteGibddDocumentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteGibddDocumentMutation, { data, loading, error }] = useDeleteGibddDocumentMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDeleteGibddDocumentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteGibddDocumentMutation,
    DeleteGibddDocumentMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<DeleteGibddDocumentMutation, DeleteGibddDocumentMutationVariables>(
    DeleteGibddDocumentDocument,
    options,
  );
}
export type DeleteGibddDocumentMutationHookResult = ReturnType<
  typeof useDeleteGibddDocumentMutation
>;
export type DeleteGibddDocumentMutationResult = Apollo.MutationResult<DeleteGibddDocumentMutation>;
export type DeleteGibddDocumentMutationOptions = Apollo.BaseMutationOptions<
  DeleteGibddDocumentMutation,
  DeleteGibddDocumentMutationVariables
>;
export const RestartBillsSearchDocument = gql`
  mutation RestartBillsSearch {
    restartBillsSearch {
      status
    }
  }
`;
export type RestartBillsSearchMutationFn = Apollo.MutationFunction<
  RestartBillsSearchMutation,
  RestartBillsSearchMutationVariables
>;

/**
 * __useRestartBillsSearchMutation__
 *
 * To run a mutation, you first call `useRestartBillsSearchMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useRestartBillsSearchMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [restartBillsSearchMutation, { data, loading, error }] = useRestartBillsSearchMutation({
 *   variables: {
 *   },
 * });
 */
export function useRestartBillsSearchMutation(
  baseOptions?: Apollo.MutationHookOptions<
    RestartBillsSearchMutation,
    RestartBillsSearchMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<RestartBillsSearchMutation, RestartBillsSearchMutationVariables>(
    RestartBillsSearchDocument,
    options,
  );
}
export type RestartBillsSearchMutationHookResult = ReturnType<typeof useRestartBillsSearchMutation>;
export type RestartBillsSearchMutationResult = Apollo.MutationResult<RestartBillsSearchMutation>;
export type RestartBillsSearchMutationOptions = Apollo.BaseMutationOptions<
  RestartBillsSearchMutation,
  RestartBillsSearchMutationVariables
>;
export const CreateOrderBillDocument = gql`
  mutation CreateOrderBill($input: CreateOrderBillInput!) {
    createOrderBill(input: $input) {
      status
      order_id
    }
  }
`;
export type CreateOrderBillMutationFn = Apollo.MutationFunction<
  CreateOrderBillMutation,
  CreateOrderBillMutationVariables
>;

/**
 * __useCreateOrderBillMutation__
 *
 * To run a mutation, you first call `useCreateOrderBillMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateOrderBillMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createOrderBillMutation, { data, loading, error }] = useCreateOrderBillMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useCreateOrderBillMutation(
  baseOptions?: Apollo.MutationHookOptions<
    CreateOrderBillMutation,
    CreateOrderBillMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<CreateOrderBillMutation, CreateOrderBillMutationVariables>(
    CreateOrderBillDocument,
    options,
  );
}
export type CreateOrderBillMutationHookResult = ReturnType<typeof useCreateOrderBillMutation>;
export type CreateOrderBillMutationResult = Apollo.MutationResult<CreateOrderBillMutation>;
export type CreateOrderBillMutationOptions = Apollo.BaseMutationOptions<
  CreateOrderBillMutation,
  CreateOrderBillMutationVariables
>;
export const StartOrderBillDocument = gql`
  mutation StartOrderBill($input: StartOrderBillInput!) {
    startOrderBill(input: $input) {
      transaction {
        transaction_id
        acs_url
        status
      }
    }
  }
`;
export type StartOrderBillMutationFn = Apollo.MutationFunction<
  StartOrderBillMutation,
  StartOrderBillMutationVariables
>;

/**
 * __useStartOrderBillMutation__
 *
 * To run a mutation, you first call `useStartOrderBillMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useStartOrderBillMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [startOrderBillMutation, { data, loading, error }] = useStartOrderBillMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useStartOrderBillMutation(
  baseOptions?: Apollo.MutationHookOptions<StartOrderBillMutation, StartOrderBillMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<StartOrderBillMutation, StartOrderBillMutationVariables>(
    StartOrderBillDocument,
    options,
  );
}
export type StartOrderBillMutationHookResult = ReturnType<typeof useStartOrderBillMutation>;
export type StartOrderBillMutationResult = Apollo.MutationResult<StartOrderBillMutation>;
export type StartOrderBillMutationOptions = Apollo.BaseMutationOptions<
  StartOrderBillMutation,
  StartOrderBillMutationVariables
>;
export const GetTransactionBillDocument = gql`
  mutation getTransactionBill($input: getTransactionInput!) {
    getTransaction(input: $input) {
      status
    }
  }
`;
export type GetTransactionBillMutationFn = Apollo.MutationFunction<
  GetTransactionBillMutation,
  GetTransactionBillMutationVariables
>;

/**
 * __useGetTransactionBillMutation__
 *
 * To run a mutation, you first call `useGetTransactionBillMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useGetTransactionBillMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [getTransactionBillMutation, { data, loading, error }] = useGetTransactionBillMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useGetTransactionBillMutation(
  baseOptions?: Apollo.MutationHookOptions<
    GetTransactionBillMutation,
    GetTransactionBillMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<GetTransactionBillMutation, GetTransactionBillMutationVariables>(
    GetTransactionBillDocument,
    options,
  );
}
export type GetTransactionBillMutationHookResult = ReturnType<typeof useGetTransactionBillMutation>;
export type GetTransactionBillMutationResult = Apollo.MutationResult<GetTransactionBillMutation>;
export type GetTransactionBillMutationOptions = Apollo.BaseMutationOptions<
  GetTransactionBillMutation,
  GetTransactionBillMutationVariables
>;
export const UpdatePersonalInfoDocument = gql`
  mutation UpdatePersonalInfo($input: UpdatePersonalInfoInput!) {
    viewerUpdatePersonalInfo(input: $input) {
      ... on UpdatePersonalInfoPayload {
        query {
          viewer {
            firstName
            lastName
            displayName
            city
            birthdate
          }
        }
      }
      ... on UpdatePersonalInfoProblem {
        reason
      }
    }
  }
`;
export type UpdatePersonalInfoMutationFn = Apollo.MutationFunction<
  UpdatePersonalInfoMutation,
  UpdatePersonalInfoMutationVariables
>;

/**
 * __useUpdatePersonalInfoMutation__
 *
 * To run a mutation, you first call `useUpdatePersonalInfoMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUpdatePersonalInfoMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [updatePersonalInfoMutation, { data, loading, error }] = useUpdatePersonalInfoMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useUpdatePersonalInfoMutation(
  baseOptions?: Apollo.MutationHookOptions<
    UpdatePersonalInfoMutation,
    UpdatePersonalInfoMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<UpdatePersonalInfoMutation, UpdatePersonalInfoMutationVariables>(
    UpdatePersonalInfoDocument,
    options,
  );
}
export type UpdatePersonalInfoMutationHookResult = ReturnType<typeof useUpdatePersonalInfoMutation>;
export type UpdatePersonalInfoMutationResult = Apollo.MutationResult<UpdatePersonalInfoMutation>;
export type UpdatePersonalInfoMutationOptions = Apollo.BaseMutationOptions<
  UpdatePersonalInfoMutation,
  UpdatePersonalInfoMutationVariables
>;
export const ValidatePersonalInfoFieldDocument = gql`
  mutation ValidatePersonalInfoField($input: ProfileFieldValidationInput!) {
    viewerValidatePersonalInfoField(input: $input) {
      code
    }
  }
`;
export type ValidatePersonalInfoFieldMutationFn = Apollo.MutationFunction<
  ValidatePersonalInfoFieldMutation,
  ValidatePersonalInfoFieldMutationVariables
>;

/**
 * __useValidatePersonalInfoFieldMutation__
 *
 * To run a mutation, you first call `useValidatePersonalInfoFieldMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useValidatePersonalInfoFieldMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [validatePersonalInfoFieldMutation, { data, loading, error }] = useValidatePersonalInfoFieldMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useValidatePersonalInfoFieldMutation(
  baseOptions?: Apollo.MutationHookOptions<
    ValidatePersonalInfoFieldMutation,
    ValidatePersonalInfoFieldMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    ValidatePersonalInfoFieldMutation,
    ValidatePersonalInfoFieldMutationVariables
  >(ValidatePersonalInfoFieldDocument, options);
}
export type ValidatePersonalInfoFieldMutationHookResult = ReturnType<
  typeof useValidatePersonalInfoFieldMutation
>;
export type ValidatePersonalInfoFieldMutationResult =
  Apollo.MutationResult<ValidatePersonalInfoFieldMutation>;
export type ValidatePersonalInfoFieldMutationOptions = Apollo.BaseMutationOptions<
  ValidatePersonalInfoFieldMutation,
  ValidatePersonalInfoFieldMutationVariables
>;
export const PersonalInfoFormDataDocument = gql`
  query PersonalInfoFormData {
    viewer {
      id
      firstName
      lastName
      birthdate
      gender
      city
      displayName
      avatarId
      country
      timezone
    }
    locationOptions {
      countries {
        name
        code
      }
      timezones {
        code
        name
      }
    }
  }
`;

/**
 * __usePersonalInfoFormDataQuery__
 *
 * To run a query within a React component, call `usePersonalInfoFormDataQuery` and pass it any options that fit your needs.
 * When your component renders, `usePersonalInfoFormDataQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = usePersonalInfoFormDataQuery({
 *   variables: {
 *   },
 * });
 */
export function usePersonalInfoFormDataQuery(
  baseOptions?: Apollo.QueryHookOptions<
    PersonalInfoFormDataQuery,
    PersonalInfoFormDataQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<PersonalInfoFormDataQuery, PersonalInfoFormDataQueryVariables>(
    PersonalInfoFormDataDocument,
    options,
  );
}
export function usePersonalInfoFormDataLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    PersonalInfoFormDataQuery,
    PersonalInfoFormDataQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<PersonalInfoFormDataQuery, PersonalInfoFormDataQueryVariables>(
    PersonalInfoFormDataDocument,
    options,
  );
}
export type PersonalInfoFormDataQueryHookResult = ReturnType<typeof usePersonalInfoFormDataQuery>;
export type PersonalInfoFormDataLazyQueryHookResult = ReturnType<
  typeof usePersonalInfoFormDataLazyQuery
>;
export type PersonalInfoFormDataQueryResult = Apollo.QueryResult<
  PersonalInfoFormDataQuery,
  PersonalInfoFormDataQueryVariables
>;
export const PublicIdValidateDocument = gql`
  mutation PublicIdValidate($input: PublicIdValidateInput!) {
    validatePublicId(input: $input) {
      ... on PublicIdValidateProblem {
        reason
      }
    }
  }
`;
export type PublicIdValidateMutationFn = Apollo.MutationFunction<
  PublicIdValidateMutation,
  PublicIdValidateMutationVariables
>;

/**
 * __usePublicIdValidateMutation__
 *
 * To run a mutation, you first call `usePublicIdValidateMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `usePublicIdValidateMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [publicIdValidateMutation, { data, loading, error }] = usePublicIdValidateMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function usePublicIdValidateMutation(
  baseOptions?: Apollo.MutationHookOptions<
    PublicIdValidateMutation,
    PublicIdValidateMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<PublicIdValidateMutation, PublicIdValidateMutationVariables>(
    PublicIdValidateDocument,
    options,
  );
}
export type PublicIdValidateMutationHookResult = ReturnType<typeof usePublicIdValidateMutation>;
export type PublicIdValidateMutationResult = Apollo.MutationResult<PublicIdValidateMutation>;
export type PublicIdValidateMutationOptions = Apollo.BaseMutationOptions<
  PublicIdValidateMutation,
  PublicIdValidateMutationVariables
>;
export const PublicIdUpdateDocument = gql`
  mutation PublicIdUpdate($input: PublicIdUpdateInput!) {
    updatePublicId(input: $input) {
      ... on PublicIdUpdateProblem {
        reason
      }
      ... on PublicIdUpdatePayload {
        query {
          viewer {
            id
            publicId
          }
        }
      }
    }
  }
`;
export type PublicIdUpdateMutationFn = Apollo.MutationFunction<
  PublicIdUpdateMutation,
  PublicIdUpdateMutationVariables
>;

/**
 * __usePublicIdUpdateMutation__
 *
 * To run a mutation, you first call `usePublicIdUpdateMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `usePublicIdUpdateMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [publicIdUpdateMutation, { data, loading, error }] = usePublicIdUpdateMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function usePublicIdUpdateMutation(
  baseOptions?: Apollo.MutationHookOptions<PublicIdUpdateMutation, PublicIdUpdateMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<PublicIdUpdateMutation, PublicIdUpdateMutationVariables>(
    PublicIdUpdateDocument,
    options,
  );
}
export type PublicIdUpdateMutationHookResult = ReturnType<typeof usePublicIdUpdateMutation>;
export type PublicIdUpdateMutationResult = Apollo.MutationResult<PublicIdUpdateMutation>;
export type PublicIdUpdateMutationOptions = Apollo.BaseMutationOptions<
  PublicIdUpdateMutation,
  PublicIdUpdateMutationVariables
>;
export const PublicIdSuggestDocument = gql`
  mutation PublicIdSuggest($input: PublicIdSuggestInput!) {
    suggestPublicId(input: $input) {
      ... on PublicIdSuggestProblem {
        reason
      }
      ... on PublicIdSuggestPayload {
        logins
      }
    }
  }
`;
export type PublicIdSuggestMutationFn = Apollo.MutationFunction<
  PublicIdSuggestMutation,
  PublicIdSuggestMutationVariables
>;

/**
 * __usePublicIdSuggestMutation__
 *
 * To run a mutation, you first call `usePublicIdSuggestMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `usePublicIdSuggestMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [publicIdSuggestMutation, { data, loading, error }] = usePublicIdSuggestMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function usePublicIdSuggestMutation(
  baseOptions?: Apollo.MutationHookOptions<
    PublicIdSuggestMutation,
    PublicIdSuggestMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<PublicIdSuggestMutation, PublicIdSuggestMutationVariables>(
    PublicIdSuggestDocument,
    options,
  );
}
export type PublicIdSuggestMutationHookResult = ReturnType<typeof usePublicIdSuggestMutation>;
export type PublicIdSuggestMutationResult = Apollo.MutationResult<PublicIdSuggestMutation>;
export type PublicIdSuggestMutationOptions = Apollo.BaseMutationOptions<
  PublicIdSuggestMutation,
  PublicIdSuggestMutationVariables
>;
export const PersonalPublicIdDocument = gql`
  query PersonalPublicId {
    viewer {
      id
      publicId
      hasPublicIdSet
      firstName
      lastName
    }
  }
`;

/**
 * __usePersonalPublicIdQuery__
 *
 * To run a query within a React component, call `usePersonalPublicIdQuery` and pass it any options that fit your needs.
 * When your component renders, `usePersonalPublicIdQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = usePersonalPublicIdQuery({
 *   variables: {
 *   },
 * });
 */
export function usePersonalPublicIdQuery(
  baseOptions?: Apollo.QueryHookOptions<PersonalPublicIdQuery, PersonalPublicIdQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<PersonalPublicIdQuery, PersonalPublicIdQueryVariables>(
    PersonalPublicIdDocument,
    options,
  );
}
export function usePersonalPublicIdLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<PersonalPublicIdQuery, PersonalPublicIdQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<PersonalPublicIdQuery, PersonalPublicIdQueryVariables>(
    PersonalPublicIdDocument,
    options,
  );
}
export type PersonalPublicIdQueryHookResult = ReturnType<typeof usePersonalPublicIdQuery>;
export type PersonalPublicIdLazyQueryHookResult = ReturnType<typeof usePersonalPublicIdLazyQuery>;
export type PersonalPublicIdQueryResult = Apollo.QueryResult<
  PersonalPublicIdQuery,
  PersonalPublicIdQueryVariables
>;
export const SendCodeToBindPrimaryPhoneDocument = gql`
  mutation SendCodeToBindPrimaryPhone($input: SendCodeToBindPrimaryPhoneInput!) {
    response: sendCodeToBindPrimaryPhone(input: $input) {
      __typename
      ... on SendCodeToBindPrimaryPhonePayload {
        trackId
        number
        expiryTimestamp
      }
      ... on SendCodeToBindPrimaryPhoneProblem {
        reason
      }
    }
  }
`;
export type SendCodeToBindPrimaryPhoneMutationFn = Apollo.MutationFunction<
  SendCodeToBindPrimaryPhoneMutation,
  SendCodeToBindPrimaryPhoneMutationVariables
>;

/**
 * __useSendCodeToBindPrimaryPhoneMutation__
 *
 * To run a mutation, you first call `useSendCodeToBindPrimaryPhoneMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useSendCodeToBindPrimaryPhoneMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [sendCodeToBindPrimaryPhoneMutation, { data, loading, error }] = useSendCodeToBindPrimaryPhoneMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useSendCodeToBindPrimaryPhoneMutation(
  baseOptions?: Apollo.MutationHookOptions<
    SendCodeToBindPrimaryPhoneMutation,
    SendCodeToBindPrimaryPhoneMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    SendCodeToBindPrimaryPhoneMutation,
    SendCodeToBindPrimaryPhoneMutationVariables
  >(SendCodeToBindPrimaryPhoneDocument, options);
}
export type SendCodeToBindPrimaryPhoneMutationHookResult = ReturnType<
  typeof useSendCodeToBindPrimaryPhoneMutation
>;
export type SendCodeToBindPrimaryPhoneMutationResult =
  Apollo.MutationResult<SendCodeToBindPrimaryPhoneMutation>;
export type SendCodeToBindPrimaryPhoneMutationOptions = Apollo.BaseMutationOptions<
  SendCodeToBindPrimaryPhoneMutation,
  SendCodeToBindPrimaryPhoneMutationVariables
>;
export const VerifyCodeToBindPrimaryPhoneDocument = gql`
  mutation VerifyCodeToBindPrimaryPhone($input: VerifyCodeToBindPrimaryPhoneInput!) {
    response: verifyCodeToBindPrimaryPhone(input: $input) {
      __typename
      ... on VerifyCodeToBindPrimaryPhonePayload {
        trackId
        query {
          account {
            ...BindPrimaryPhoneAccount
          }
        }
      }
      ... on VerifyCodeToBindPrimaryPhoneProblem {
        reason
      }
    }
  }
  ${BindPrimaryPhoneAccountFragmentDoc}
`;
export type VerifyCodeToBindPrimaryPhoneMutationFn = Apollo.MutationFunction<
  VerifyCodeToBindPrimaryPhoneMutation,
  VerifyCodeToBindPrimaryPhoneMutationVariables
>;

/**
 * __useVerifyCodeToBindPrimaryPhoneMutation__
 *
 * To run a mutation, you first call `useVerifyCodeToBindPrimaryPhoneMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useVerifyCodeToBindPrimaryPhoneMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [verifyCodeToBindPrimaryPhoneMutation, { data, loading, error }] = useVerifyCodeToBindPrimaryPhoneMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useVerifyCodeToBindPrimaryPhoneMutation(
  baseOptions?: Apollo.MutationHookOptions<
    VerifyCodeToBindPrimaryPhoneMutation,
    VerifyCodeToBindPrimaryPhoneMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    VerifyCodeToBindPrimaryPhoneMutation,
    VerifyCodeToBindPrimaryPhoneMutationVariables
  >(VerifyCodeToBindPrimaryPhoneDocument, options);
}
export type VerifyCodeToBindPrimaryPhoneMutationHookResult = ReturnType<
  typeof useVerifyCodeToBindPrimaryPhoneMutation
>;
export type VerifyCodeToBindPrimaryPhoneMutationResult =
  Apollo.MutationResult<VerifyCodeToBindPrimaryPhoneMutation>;
export type VerifyCodeToBindPrimaryPhoneMutationOptions = Apollo.BaseMutationOptions<
  VerifyCodeToBindPrimaryPhoneMutation,
  VerifyCodeToBindPrimaryPhoneMutationVariables
>;
export const SendCodeToConfirmPhoneDocument = gql`
  mutation SendCodeToConfirmPhone($input: SendCodeToConfirmPhoneInput!) {
    response: sendCodeToConfirmPhone(input: $input) {
      __typename
      ... on SendCodeToConfirmPhonePayload {
        trackId
        number
        expiryTimestamp
      }
      ... on SendCodeToConfirmPhoneProblem {
        reason
      }
    }
  }
`;
export type SendCodeToConfirmPhoneMutationFn = Apollo.MutationFunction<
  SendCodeToConfirmPhoneMutation,
  SendCodeToConfirmPhoneMutationVariables
>;

/**
 * __useSendCodeToConfirmPhoneMutation__
 *
 * To run a mutation, you first call `useSendCodeToConfirmPhoneMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useSendCodeToConfirmPhoneMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [sendCodeToConfirmPhoneMutation, { data, loading, error }] = useSendCodeToConfirmPhoneMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useSendCodeToConfirmPhoneMutation(
  baseOptions?: Apollo.MutationHookOptions<
    SendCodeToConfirmPhoneMutation,
    SendCodeToConfirmPhoneMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    SendCodeToConfirmPhoneMutation,
    SendCodeToConfirmPhoneMutationVariables
  >(SendCodeToConfirmPhoneDocument, options);
}
export type SendCodeToConfirmPhoneMutationHookResult = ReturnType<
  typeof useSendCodeToConfirmPhoneMutation
>;
export type SendCodeToConfirmPhoneMutationResult =
  Apollo.MutationResult<SendCodeToConfirmPhoneMutation>;
export type SendCodeToConfirmPhoneMutationOptions = Apollo.BaseMutationOptions<
  SendCodeToConfirmPhoneMutation,
  SendCodeToConfirmPhoneMutationVariables
>;
export const VerifyCodeToConfirmPhoneDocument = gql`
  mutation VerifyCodeToConfirmPhone($input: VerifyCodeToConfirmPhoneInput!) {
    response: verifyCodeToConfirmPhone(input: $input) {
      __typename
      ... on VerifyCodeToConfirmPhonePayload {
        trackId
      }
      ... on VerifyCodeToConfirmPhoneProblem {
        reason
      }
    }
  }
`;
export type VerifyCodeToConfirmPhoneMutationFn = Apollo.MutationFunction<
  VerifyCodeToConfirmPhoneMutation,
  VerifyCodeToConfirmPhoneMutationVariables
>;

/**
 * __useVerifyCodeToConfirmPhoneMutation__
 *
 * To run a mutation, you first call `useVerifyCodeToConfirmPhoneMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useVerifyCodeToConfirmPhoneMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [verifyCodeToConfirmPhoneMutation, { data, loading, error }] = useVerifyCodeToConfirmPhoneMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useVerifyCodeToConfirmPhoneMutation(
  baseOptions?: Apollo.MutationHookOptions<
    VerifyCodeToConfirmPhoneMutation,
    VerifyCodeToConfirmPhoneMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    VerifyCodeToConfirmPhoneMutation,
    VerifyCodeToConfirmPhoneMutationVariables
  >(VerifyCodeToConfirmPhoneDocument, options);
}
export type VerifyCodeToConfirmPhoneMutationHookResult = ReturnType<
  typeof useVerifyCodeToConfirmPhoneMutation
>;
export type VerifyCodeToConfirmPhoneMutationResult =
  Apollo.MutationResult<VerifyCodeToConfirmPhoneMutation>;
export type VerifyCodeToConfirmPhoneMutationOptions = Apollo.BaseMutationOptions<
  VerifyCodeToConfirmPhoneMutation,
  VerifyCodeToConfirmPhoneMutationVariables
>;
export const AuthTypesDocument = gql`
  query AuthTypes {
    account {
      ...PasswordAndSmsSwitchAccount
    }
  }
  ${PasswordAndSmsSwitchAccountFragmentDoc}
`;

/**
 * __useAuthTypesQuery__
 *
 * To run a query within a React component, call `useAuthTypesQuery` and pass it any options that fit your needs.
 * When your component renders, `useAuthTypesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAuthTypesQuery({
 *   variables: {
 *   },
 * });
 */
export function useAuthTypesQuery(
  baseOptions?: Apollo.QueryHookOptions<AuthTypesQuery, AuthTypesQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<AuthTypesQuery, AuthTypesQueryVariables>(AuthTypesDocument, options);
}
export function useAuthTypesLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<AuthTypesQuery, AuthTypesQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<AuthTypesQuery, AuthTypesQueryVariables>(AuthTypesDocument, options);
}
export type AuthTypesQueryHookResult = ReturnType<typeof useAuthTypesQuery>;
export type AuthTypesLazyQueryHookResult = ReturnType<typeof useAuthTypesLazyQuery>;
export type AuthTypesQueryResult = Apollo.QueryResult<AuthTypesQuery, AuthTypesQueryVariables>;
export const EnableLoginWithPasswordAndSmsDocument = gql`
  mutation EnableLoginWithPasswordAndSms($input: ToggleLoginWithPasswordAndSmsInput!) {
    response: accountEnableLoginWithPasswordAndSms(input: $input) {
      ...ToggleLoginWithPasswordAndSms
    }
  }
  ${ToggleLoginWithPasswordAndSmsFragmentDoc}
`;
export type EnableLoginWithPasswordAndSmsMutationFn = Apollo.MutationFunction<
  EnableLoginWithPasswordAndSmsMutation,
  EnableLoginWithPasswordAndSmsMutationVariables
>;

/**
 * __useEnableLoginWithPasswordAndSmsMutation__
 *
 * To run a mutation, you first call `useEnableLoginWithPasswordAndSmsMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEnableLoginWithPasswordAndSmsMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [enableLoginWithPasswordAndSmsMutation, { data, loading, error }] = useEnableLoginWithPasswordAndSmsMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useEnableLoginWithPasswordAndSmsMutation(
  baseOptions?: Apollo.MutationHookOptions<
    EnableLoginWithPasswordAndSmsMutation,
    EnableLoginWithPasswordAndSmsMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    EnableLoginWithPasswordAndSmsMutation,
    EnableLoginWithPasswordAndSmsMutationVariables
  >(EnableLoginWithPasswordAndSmsDocument, options);
}
export type EnableLoginWithPasswordAndSmsMutationHookResult = ReturnType<
  typeof useEnableLoginWithPasswordAndSmsMutation
>;
export type EnableLoginWithPasswordAndSmsMutationResult =
  Apollo.MutationResult<EnableLoginWithPasswordAndSmsMutation>;
export type EnableLoginWithPasswordAndSmsMutationOptions = Apollo.BaseMutationOptions<
  EnableLoginWithPasswordAndSmsMutation,
  EnableLoginWithPasswordAndSmsMutationVariables
>;
export const DisableLoginWithPasswordAndSmsDocument = gql`
  mutation DisableLoginWithPasswordAndSms($input: ToggleLoginWithPasswordAndSmsInput!) {
    response: accountDisableLoginWithPasswordAndSms(input: $input) {
      ...ToggleLoginWithPasswordAndSms
    }
  }
  ${ToggleLoginWithPasswordAndSmsFragmentDoc}
`;
export type DisableLoginWithPasswordAndSmsMutationFn = Apollo.MutationFunction<
  DisableLoginWithPasswordAndSmsMutation,
  DisableLoginWithPasswordAndSmsMutationVariables
>;

/**
 * __useDisableLoginWithPasswordAndSmsMutation__
 *
 * To run a mutation, you first call `useDisableLoginWithPasswordAndSmsMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDisableLoginWithPasswordAndSmsMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [disableLoginWithPasswordAndSmsMutation, { data, loading, error }] = useDisableLoginWithPasswordAndSmsMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useDisableLoginWithPasswordAndSmsMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DisableLoginWithPasswordAndSmsMutation,
    DisableLoginWithPasswordAndSmsMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<
    DisableLoginWithPasswordAndSmsMutation,
    DisableLoginWithPasswordAndSmsMutationVariables
  >(DisableLoginWithPasswordAndSmsDocument, options);
}
export type DisableLoginWithPasswordAndSmsMutationHookResult = ReturnType<
  typeof useDisableLoginWithPasswordAndSmsMutation
>;
export type DisableLoginWithPasswordAndSmsMutationResult =
  Apollo.MutationResult<DisableLoginWithPasswordAndSmsMutation>;
export type DisableLoginWithPasswordAndSmsMutationOptions = Apollo.BaseMutationOptions<
  DisableLoginWithPasswordAndSmsMutation,
  DisableLoginWithPasswordAndSmsMutationVariables
>;
export const BankCardsDocument = gql`
  query BankCards {
    accountBankCards {
      status
      cards {
        system
        number
        cardId
        isFamilyCard
        name
        proto
        id
      }
      trackId
    }
  }
`;

/**
 * __useBankCardsQuery__
 *
 * To run a query within a React component, call `useBankCardsQuery` and pass it any options that fit your needs.
 * When your component renders, `useBankCardsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useBankCardsQuery({
 *   variables: {
 *   },
 * });
 */
export function useBankCardsQuery(
  baseOptions?: Apollo.QueryHookOptions<BankCardsQuery, BankCardsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<BankCardsQuery, BankCardsQueryVariables>(BankCardsDocument, options);
}
export function useBankCardsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<BankCardsQuery, BankCardsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<BankCardsQuery, BankCardsQueryVariables>(BankCardsDocument, options);
}
export type BankCardsQueryHookResult = ReturnType<typeof useBankCardsQuery>;
export type BankCardsLazyQueryHookResult = ReturnType<typeof useBankCardsLazyQuery>;
export type BankCardsQueryResult = Apollo.QueryResult<BankCardsQuery, BankCardsQueryVariables>;
export const UnbindBankCardDocument = gql`
  mutation UnbindBankCard($cardId: String!) {
    accountUnbindBankCard(cardId: $cardId) {
      status
    }
  }
`;
export type UnbindBankCardMutationFn = Apollo.MutationFunction<
  UnbindBankCardMutation,
  UnbindBankCardMutationVariables
>;

/**
 * __useUnbindBankCardMutation__
 *
 * To run a mutation, you first call `useUnbindBankCardMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useUnbindBankCardMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [unbindBankCardMutation, { data, loading, error }] = useUnbindBankCardMutation({
 *   variables: {
 *      cardId: // value for 'cardId'
 *   },
 * });
 */
export function useUnbindBankCardMutation(
  baseOptions?: Apollo.MutationHookOptions<UnbindBankCardMutation, UnbindBankCardMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<UnbindBankCardMutation, UnbindBankCardMutationVariables>(
    UnbindBankCardDocument,
    options,
  );
}
export type UnbindBankCardMutationHookResult = ReturnType<typeof useUnbindBankCardMutation>;
export type UnbindBankCardMutationResult = Apollo.MutationResult<UnbindBankCardMutation>;
export type UnbindBankCardMutationOptions = Apollo.BaseMutationOptions<
  UnbindBankCardMutation,
  UnbindBankCardMutationVariables
>;
export const CreateBindingDocument = gql`
  mutation CreateBinding($input: AccountBindBankCardInput!) {
    accountBindBankCard(input: $input) {
      status
      url
    }
  }
`;
export type CreateBindingMutationFn = Apollo.MutationFunction<
  CreateBindingMutation,
  CreateBindingMutationVariables
>;

/**
 * __useCreateBindingMutation__
 *
 * To run a mutation, you first call `useCreateBindingMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateBindingMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createBindingMutation, { data, loading, error }] = useCreateBindingMutation({
 *   variables: {
 *      input: // value for 'input'
 *   },
 * });
 */
export function useCreateBindingMutation(
  baseOptions?: Apollo.MutationHookOptions<CreateBindingMutation, CreateBindingMutationVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<CreateBindingMutation, CreateBindingMutationVariables>(
    CreateBindingDocument,
    options,
  );
}
export type CreateBindingMutationHookResult = ReturnType<typeof useCreateBindingMutation>;
export type CreateBindingMutationResult = Apollo.MutationResult<CreateBindingMutation>;
export type CreateBindingMutationOptions = Apollo.BaseMutationOptions<
  CreateBindingMutation,
  CreateBindingMutationVariables
>;
export const BonusCardsWidgetDocument = gql`
  query BonusCardsWidget {
    viewer {
      id
      avatarId
    }
  }
`;

/**
 * __useBonusCardsWidgetQuery__
 *
 * To run a query within a React component, call `useBonusCardsWidgetQuery` and pass it any options that fit your needs.
 * When your component renders, `useBonusCardsWidgetQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useBonusCardsWidgetQuery({
 *   variables: {
 *   },
 * });
 */
export function useBonusCardsWidgetQuery(
  baseOptions?: Apollo.QueryHookOptions<BonusCardsWidgetQuery, BonusCardsWidgetQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<BonusCardsWidgetQuery, BonusCardsWidgetQueryVariables>(
    BonusCardsWidgetDocument,
    options,
  );
}
export function useBonusCardsWidgetLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<BonusCardsWidgetQuery, BonusCardsWidgetQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<BonusCardsWidgetQuery, BonusCardsWidgetQueryVariables>(
    BonusCardsWidgetDocument,
    options,
  );
}
export type BonusCardsWidgetQueryHookResult = ReturnType<typeof useBonusCardsWidgetQuery>;
export type BonusCardsWidgetLazyQueryHookResult = ReturnType<typeof useBonusCardsWidgetLazyQuery>;
export type BonusCardsWidgetQueryResult = Apollo.QueryResult<
  BonusCardsWidgetQuery,
  BonusCardsWidgetQueryVariables
>;
export const ContactsDocument = gql`
  query Contacts {
    account {
      id
      phones {
        id
        number
        isPrimary
      }
      emails {
        address
        type
        isPrimary
      }
    }
    externalAccounts {
      id
    }
  }
`;

/**
 * __useContactsQuery__
 *
 * To run a query within a React component, call `useContactsQuery` and pass it any options that fit your needs.
 * When your component renders, `useContactsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useContactsQuery({
 *   variables: {
 *   },
 * });
 */
export function useContactsQuery(
  baseOptions?: Apollo.QueryHookOptions<ContactsQuery, ContactsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<ContactsQuery, ContactsQueryVariables>(ContactsDocument, options);
}
export function useContactsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<ContactsQuery, ContactsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<ContactsQuery, ContactsQueryVariables>(ContactsDocument, options);
}
export type ContactsQueryHookResult = ReturnType<typeof useContactsQuery>;
export type ContactsLazyQueryHookResult = ReturnType<typeof useContactsLazyQuery>;
export type ContactsQueryResult = Apollo.QueryResult<ContactsQuery, ContactsQueryVariables>;
export const DocumentsThumbListDocument = gql`
  query DocumentsThumbList {
    documents {
      id
      type
      section
      ... on BirthCertificateDocument {
        firstName
        lastName
      }
      ... on NationalIdDocument {
        firstName
        lastName
      }
      ... on InternationalIdDocument {
        firstName
        lastName
      }
      ... on InnDocument {
        firstName
        lastName
      }
      ... on SnilsDocument {
        firstName
        lastName
      }
      ... on DriverLicenseDocument {
        firstName
        lastName
      }
      ... on MedicalInsuranceDocument {
        firstName
        lastName
      }
      ... on VoluntaryMedicalInsuranceDocument {
        firstName
        lastName
      }
      ... on VehicleRegistrationCertificateDocument {
        model
      }
    }
  }
`;

/**
 * __useDocumentsThumbListQuery__
 *
 * To run a query within a React component, call `useDocumentsThumbListQuery` and pass it any options that fit your needs.
 * When your component renders, `useDocumentsThumbListQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDocumentsThumbListQuery({
 *   variables: {
 *   },
 * });
 */
export function useDocumentsThumbListQuery(
  baseOptions?: Apollo.QueryHookOptions<DocumentsThumbListQuery, DocumentsThumbListQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<DocumentsThumbListQuery, DocumentsThumbListQueryVariables>(
    DocumentsThumbListDocument,
    options,
  );
}
export function useDocumentsThumbListLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    DocumentsThumbListQuery,
    DocumentsThumbListQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<DocumentsThumbListQuery, DocumentsThumbListQueryVariables>(
    DocumentsThumbListDocument,
    options,
  );
}
export type DocumentsThumbListQueryHookResult = ReturnType<typeof useDocumentsThumbListQuery>;
export type DocumentsThumbListLazyQueryHookResult = ReturnType<
  typeof useDocumentsThumbListLazyQuery
>;
export type DocumentsThumbListQueryResult = Apollo.QueryResult<
  DocumentsThumbListQuery,
  DocumentsThumbListQueryVariables
>;
export const EnterMethodsDocument = gql`
  query EnterMethods {
    account {
      id
      type
      authType
      passwordInfo {
        updatedAt
      }
      phones {
        id
        number
        isDefault
        isPrimary
      }
    }
  }
`;

/**
 * __useEnterMethodsQuery__
 *
 * To run a query within a React component, call `useEnterMethodsQuery` and pass it any options that fit your needs.
 * When your component renders, `useEnterMethodsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useEnterMethodsQuery({
 *   variables: {
 *   },
 * });
 */
export function useEnterMethodsQuery(
  baseOptions?: Apollo.QueryHookOptions<EnterMethodsQuery, EnterMethodsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<EnterMethodsQuery, EnterMethodsQueryVariables>(
    EnterMethodsDocument,
    options,
  );
}
export function useEnterMethodsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<EnterMethodsQuery, EnterMethodsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<EnterMethodsQuery, EnterMethodsQueryVariables>(
    EnterMethodsDocument,
    options,
  );
}
export type EnterMethodsQueryHookResult = ReturnType<typeof useEnterMethodsQuery>;
export type EnterMethodsLazyQueryHookResult = ReturnType<typeof useEnterMethodsLazyQuery>;
export type EnterMethodsQueryResult = Apollo.QueryResult<
  EnterMethodsQuery,
  EnterMethodsQueryVariables
>;
export const ExternalAccessesDocument = gql`
  query ExternalAccesses {
    externalAccounts {
      id
    }
  }
`;

/**
 * __useExternalAccessesQuery__
 *
 * To run a query within a React component, call `useExternalAccessesQuery` and pass it any options that fit your needs.
 * When your component renders, `useExternalAccessesQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useExternalAccessesQuery({
 *   variables: {
 *   },
 * });
 */
export function useExternalAccessesQuery(
  baseOptions?: Apollo.QueryHookOptions<ExternalAccessesQuery, ExternalAccessesQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<ExternalAccessesQuery, ExternalAccessesQueryVariables>(
    ExternalAccessesDocument,
    options,
  );
}
export function useExternalAccessesLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<ExternalAccessesQuery, ExternalAccessesQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<ExternalAccessesQuery, ExternalAccessesQueryVariables>(
    ExternalAccessesDocument,
    options,
  );
}
export type ExternalAccessesQueryHookResult = ReturnType<typeof useExternalAccessesQuery>;
export type ExternalAccessesLazyQueryHookResult = ReturnType<typeof useExternalAccessesLazyQuery>;
export type ExternalAccessesQueryResult = Apollo.QueryResult<
  ExternalAccessesQuery,
  ExternalAccessesQueryVariables
>;
export const ExternalAccountProvidersWidgetDocument = gql`
  query ExternalAccountProvidersWidget {
    providers: externalAccountProviders {
      id
      name
    }
  }
`;

/**
 * __useExternalAccountProvidersWidgetQuery__
 *
 * To run a query within a React component, call `useExternalAccountProvidersWidgetQuery` and pass it any options that fit your needs.
 * When your component renders, `useExternalAccountProvidersWidgetQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useExternalAccountProvidersWidgetQuery({
 *   variables: {
 *   },
 * });
 */
export function useExternalAccountProvidersWidgetQuery(
  baseOptions?: Apollo.QueryHookOptions<
    ExternalAccountProvidersWidgetQuery,
    ExternalAccountProvidersWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<
    ExternalAccountProvidersWidgetQuery,
    ExternalAccountProvidersWidgetQueryVariables
  >(ExternalAccountProvidersWidgetDocument, options);
}
export function useExternalAccountProvidersWidgetLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    ExternalAccountProvidersWidgetQuery,
    ExternalAccountProvidersWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<
    ExternalAccountProvidersWidgetQuery,
    ExternalAccountProvidersWidgetQueryVariables
  >(ExternalAccountProvidersWidgetDocument, options);
}
export type ExternalAccountProvidersWidgetQueryHookResult = ReturnType<
  typeof useExternalAccountProvidersWidgetQuery
>;
export type ExternalAccountProvidersWidgetLazyQueryHookResult = ReturnType<
  typeof useExternalAccountProvidersWidgetLazyQuery
>;
export type ExternalAccountProvidersWidgetQueryResult = Apollo.QueryResult<
  ExternalAccountProvidersWidgetQuery,
  ExternalAccountProvidersWidgetQueryVariables
>;
export const ExternalAccountsWidgetDocument = gql`
  query ExternalAccountsWidget {
    externalAccounts {
      id
      provider {
        id
        name
      }
      displayName
      allowAuth
    }
  }
`;

/**
 * __useExternalAccountsWidgetQuery__
 *
 * To run a query within a React component, call `useExternalAccountsWidgetQuery` and pass it any options that fit your needs.
 * When your component renders, `useExternalAccountsWidgetQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useExternalAccountsWidgetQuery({
 *   variables: {
 *   },
 * });
 */
export function useExternalAccountsWidgetQuery(
  baseOptions?: Apollo.QueryHookOptions<
    ExternalAccountsWidgetQuery,
    ExternalAccountsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<ExternalAccountsWidgetQuery, ExternalAccountsWidgetQueryVariables>(
    ExternalAccountsWidgetDocument,
    options,
  );
}
export function useExternalAccountsWidgetLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    ExternalAccountsWidgetQuery,
    ExternalAccountsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<ExternalAccountsWidgetQuery, ExternalAccountsWidgetQueryVariables>(
    ExternalAccountsWidgetDocument,
    options,
  );
}
export type ExternalAccountsWidgetQueryHookResult = ReturnType<
  typeof useExternalAccountsWidgetQuery
>;
export type ExternalAccountsWidgetLazyQueryHookResult = ReturnType<
  typeof useExternalAccountsWidgetLazyQuery
>;
export type ExternalAccountsWidgetQueryResult = Apollo.QueryResult<
  ExternalAccountsWidgetQuery,
  ExternalAccountsWidgetQueryVariables
>;
export const FamilyMembersWidgetDocument = gql`
  query FamilyMembersWidget {
    family {
      info {
        id
        adminUid
      }
      members {
        avatar
        name
        isAdmin
        uid
        hasSecurePhone
      }
      kids {
        avatar
        name
        uid
      }
      invites {
        contact
        id
      }
      pay {
        userRestrictions {
          balance
          enabled
          uid
          unlim
          limitCurrency
          limit {
            value
            limitMode
          }
        }
      }
    }
    viewer {
      avatarId
      displayName
      id
    }
  }
`;

/**
 * __useFamilyMembersWidgetQuery__
 *
 * To run a query within a React component, call `useFamilyMembersWidgetQuery` and pass it any options that fit your needs.
 * When your component renders, `useFamilyMembersWidgetQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useFamilyMembersWidgetQuery({
 *   variables: {
 *   },
 * });
 */
export function useFamilyMembersWidgetQuery(
  baseOptions?: Apollo.QueryHookOptions<
    FamilyMembersWidgetQuery,
    FamilyMembersWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<FamilyMembersWidgetQuery, FamilyMembersWidgetQueryVariables>(
    FamilyMembersWidgetDocument,
    options,
  );
}
export function useFamilyMembersWidgetLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    FamilyMembersWidgetQuery,
    FamilyMembersWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<FamilyMembersWidgetQuery, FamilyMembersWidgetQueryVariables>(
    FamilyMembersWidgetDocument,
    options,
  );
}
export type FamilyMembersWidgetQueryHookResult = ReturnType<typeof useFamilyMembersWidgetQuery>;
export type FamilyMembersWidgetLazyQueryHookResult = ReturnType<
  typeof useFamilyMembersWidgetLazyQuery
>;
export type FamilyMembersWidgetQueryResult = Apollo.QueryResult<
  FamilyMembersWidgetQuery,
  FamilyMembersWidgetQueryVariables
>;
export const FamilyShortuctsWidgetDocument = gql`
  query FamilyShortuctsWidget {
    family {
      info {
        id
        adminUid
      }
      members {
        avatar
        name
        isAdmin
        uid
      }
      invites {
        contact
        id
      }
      pay {
        cardInfo {
          maskedNumber
          bound
        }
        userRestrictions {
          balance
          enabled
          hasSecurePhone
          limitCurrency
          limit {
            limitMode
            value
          }
          unlim
          uid
        }
      }
    }
    viewer {
      id
      hasFamilyPlus
    }
  }
`;

/**
 * __useFamilyShortuctsWidgetQuery__
 *
 * To run a query within a React component, call `useFamilyShortuctsWidgetQuery` and pass it any options that fit your needs.
 * When your component renders, `useFamilyShortuctsWidgetQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useFamilyShortuctsWidgetQuery({
 *   variables: {
 *   },
 * });
 */
export function useFamilyShortuctsWidgetQuery(
  baseOptions?: Apollo.QueryHookOptions<
    FamilyShortuctsWidgetQuery,
    FamilyShortuctsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<FamilyShortuctsWidgetQuery, FamilyShortuctsWidgetQueryVariables>(
    FamilyShortuctsWidgetDocument,
    options,
  );
}
export function useFamilyShortuctsWidgetLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    FamilyShortuctsWidgetQuery,
    FamilyShortuctsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<FamilyShortuctsWidgetQuery, FamilyShortuctsWidgetQueryVariables>(
    FamilyShortuctsWidgetDocument,
    options,
  );
}
export type FamilyShortuctsWidgetQueryHookResult = ReturnType<typeof useFamilyShortuctsWidgetQuery>;
export type FamilyShortuctsWidgetLazyQueryHookResult = ReturnType<
  typeof useFamilyShortuctsWidgetLazyQuery
>;
export type FamilyShortuctsWidgetQueryResult = Apollo.QueryResult<
  FamilyShortuctsWidgetQuery,
  FamilyShortuctsWidgetQueryVariables
>;
export const FinanceShortcutsWidgetDocument = gql`
  query FinanceShortcutsWidget {
    bills {
      state
    }
    billsDocuments {
      document_id
    }
    family {
      info {
        id
        adminUid
      }
      pay {
        cardInfo {
          maskedNumber
          bound
        }
        userRestrictions {
          balance
          enabled
          hasSecurePhone
          limitCurrency
          unlim
          uid
        }
      }
    }
    account {
      id
    }
  }
`;

/**
 * __useFinanceShortcutsWidgetQuery__
 *
 * To run a query within a React component, call `useFinanceShortcutsWidgetQuery` and pass it any options that fit your needs.
 * When your component renders, `useFinanceShortcutsWidgetQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useFinanceShortcutsWidgetQuery({
 *   variables: {
 *   },
 * });
 */
export function useFinanceShortcutsWidgetQuery(
  baseOptions?: Apollo.QueryHookOptions<
    FinanceShortcutsWidgetQuery,
    FinanceShortcutsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<FinanceShortcutsWidgetQuery, FinanceShortcutsWidgetQueryVariables>(
    FinanceShortcutsWidgetDocument,
    options,
  );
}
export function useFinanceShortcutsWidgetLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    FinanceShortcutsWidgetQuery,
    FinanceShortcutsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<FinanceShortcutsWidgetQuery, FinanceShortcutsWidgetQueryVariables>(
    FinanceShortcutsWidgetDocument,
    options,
  );
}
export type FinanceShortcutsWidgetQueryHookResult = ReturnType<
  typeof useFinanceShortcutsWidgetQuery
>;
export type FinanceShortcutsWidgetLazyQueryHookResult = ReturnType<
  typeof useFinanceShortcutsWidgetLazyQuery
>;
export type FinanceShortcutsWidgetQueryResult = Apollo.QueryResult<
  FinanceShortcutsWidgetQuery,
  FinanceShortcutsWidgetQueryVariables
>;
export const FuturePaymentsWidgetDocument = gql`
  query FuturePaymentsWidget {
    futurePayments {
      id
      type
      service
      nextPaymentAt
      amount
      iframeUrl
    }
  }
`;

/**
 * __useFuturePaymentsWidgetQuery__
 *
 * To run a query within a React component, call `useFuturePaymentsWidgetQuery` and pass it any options that fit your needs.
 * When your component renders, `useFuturePaymentsWidgetQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useFuturePaymentsWidgetQuery({
 *   variables: {
 *   },
 * });
 */
export function useFuturePaymentsWidgetQuery(
  baseOptions?: Apollo.QueryHookOptions<
    FuturePaymentsWidgetQuery,
    FuturePaymentsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<FuturePaymentsWidgetQuery, FuturePaymentsWidgetQueryVariables>(
    FuturePaymentsWidgetDocument,
    options,
  );
}
export function useFuturePaymentsWidgetLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    FuturePaymentsWidgetQuery,
    FuturePaymentsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<FuturePaymentsWidgetQuery, FuturePaymentsWidgetQueryVariables>(
    FuturePaymentsWidgetDocument,
    options,
  );
}
export type FuturePaymentsWidgetQueryHookResult = ReturnType<typeof useFuturePaymentsWidgetQuery>;
export type FuturePaymentsWidgetLazyQueryHookResult = ReturnType<
  typeof useFuturePaymentsWidgetLazyQuery
>;
export type FuturePaymentsWidgetQueryResult = Apollo.QueryResult<
  FuturePaymentsWidgetQuery,
  FuturePaymentsWidgetQueryVariables
>;
export const HeaderDocument = gql`
  query Header {
    viewer {
      id
      avatarId
      havePlus
    }
  }
`;

/**
 * __useHeaderQuery__
 *
 * To run a query within a React component, call `useHeaderQuery` and pass it any options that fit your needs.
 * When your component renders, `useHeaderQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useHeaderQuery({
 *   variables: {
 *   },
 * });
 */
export function useHeaderQuery(
  baseOptions?: Apollo.QueryHookOptions<HeaderQuery, HeaderQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<HeaderQuery, HeaderQueryVariables>(HeaderDocument, options);
}
export function useHeaderLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<HeaderQuery, HeaderQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<HeaderQuery, HeaderQueryVariables>(HeaderDocument, options);
}
export type HeaderQueryHookResult = ReturnType<typeof useHeaderQuery>;
export type HeaderLazyQueryHookResult = ReturnType<typeof useHeaderLazyQuery>;
export type HeaderQueryResult = Apollo.QueryResult<HeaderQuery, HeaderQueryVariables>;
export const LoginWithExternalAccountsDocument = gql`
  query LoginWithExternalAccounts {
    account {
      id
      authType
    }
    externalAccounts {
      id
      allowAuth
    }
  }
`;

/**
 * __useLoginWithExternalAccountsQuery__
 *
 * To run a query within a React component, call `useLoginWithExternalAccountsQuery` and pass it any options that fit your needs.
 * When your component renders, `useLoginWithExternalAccountsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useLoginWithExternalAccountsQuery({
 *   variables: {
 *   },
 * });
 */
export function useLoginWithExternalAccountsQuery(
  baseOptions?: Apollo.QueryHookOptions<
    LoginWithExternalAccountsQuery,
    LoginWithExternalAccountsQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<LoginWithExternalAccountsQuery, LoginWithExternalAccountsQueryVariables>(
    LoginWithExternalAccountsDocument,
    options,
  );
}
export function useLoginWithExternalAccountsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    LoginWithExternalAccountsQuery,
    LoginWithExternalAccountsQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<
    LoginWithExternalAccountsQuery,
    LoginWithExternalAccountsQueryVariables
  >(LoginWithExternalAccountsDocument, options);
}
export type LoginWithExternalAccountsQueryHookResult = ReturnType<
  typeof useLoginWithExternalAccountsQuery
>;
export type LoginWithExternalAccountsLazyQueryHookResult = ReturnType<
  typeof useLoginWithExternalAccountsLazyQuery
>;
export type LoginWithExternalAccountsQueryResult = Apollo.QueryResult<
  LoginWithExternalAccountsQuery,
  LoginWithExternalAccountsQueryVariables
>;
export const LoginWithQrDocument = gql`
  query LoginWithQR {
    account {
      ...LoginWithQRAccount
    }
  }
  ${LoginWithQrAccountFragmentDoc}
`;

/**
 * __useLoginWithQrQuery__
 *
 * To run a query within a React component, call `useLoginWithQrQuery` and pass it any options that fit your needs.
 * When your component renders, `useLoginWithQrQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useLoginWithQrQuery({
 *   variables: {
 *   },
 * });
 */
export function useLoginWithQrQuery(
  baseOptions?: Apollo.QueryHookOptions<LoginWithQrQuery, LoginWithQrQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<LoginWithQrQuery, LoginWithQrQueryVariables>(LoginWithQrDocument, options);
}
export function useLoginWithQrLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<LoginWithQrQuery, LoginWithQrQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<LoginWithQrQuery, LoginWithQrQueryVariables>(
    LoginWithQrDocument,
    options,
  );
}
export type LoginWithQrQueryHookResult = ReturnType<typeof useLoginWithQrQuery>;
export type LoginWithQrLazyQueryHookResult = ReturnType<typeof useLoginWithQrLazyQuery>;
export type LoginWithQrQueryResult = Apollo.QueryResult<
  LoginWithQrQuery,
  LoginWithQrQueryVariables
>;
export const EnableLoginWithQrDocument = gql`
  mutation EnableLoginWithQR {
    accountEnableLoginWithQR {
      account {
        ...LoginWithQRAccount
      }
    }
  }
  ${LoginWithQrAccountFragmentDoc}
`;
export type EnableLoginWithQrMutationFn = Apollo.MutationFunction<
  EnableLoginWithQrMutation,
  EnableLoginWithQrMutationVariables
>;

/**
 * __useEnableLoginWithQrMutation__
 *
 * To run a mutation, you first call `useEnableLoginWithQrMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEnableLoginWithQrMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [enableLoginWithQrMutation, { data, loading, error }] = useEnableLoginWithQrMutation({
 *   variables: {
 *   },
 * });
 */
export function useEnableLoginWithQrMutation(
  baseOptions?: Apollo.MutationHookOptions<
    EnableLoginWithQrMutation,
    EnableLoginWithQrMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<EnableLoginWithQrMutation, EnableLoginWithQrMutationVariables>(
    EnableLoginWithQrDocument,
    options,
  );
}
export type EnableLoginWithQrMutationHookResult = ReturnType<typeof useEnableLoginWithQrMutation>;
export type EnableLoginWithQrMutationResult = Apollo.MutationResult<EnableLoginWithQrMutation>;
export type EnableLoginWithQrMutationOptions = Apollo.BaseMutationOptions<
  EnableLoginWithQrMutation,
  EnableLoginWithQrMutationVariables
>;
export const DisableLoginWithQrDocument = gql`
  mutation DisableLoginWithQR {
    accountDisableLoginWithQR {
      account {
        ...LoginWithQRAccount
      }
    }
  }
  ${LoginWithQrAccountFragmentDoc}
`;
export type DisableLoginWithQrMutationFn = Apollo.MutationFunction<
  DisableLoginWithQrMutation,
  DisableLoginWithQrMutationVariables
>;

/**
 * __useDisableLoginWithQrMutation__
 *
 * To run a mutation, you first call `useDisableLoginWithQrMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDisableLoginWithQrMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [disableLoginWithQrMutation, { data, loading, error }] = useDisableLoginWithQrMutation({
 *   variables: {
 *   },
 * });
 */
export function useDisableLoginWithQrMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DisableLoginWithQrMutation,
    DisableLoginWithQrMutationVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useMutation<DisableLoginWithQrMutation, DisableLoginWithQrMutationVariables>(
    DisableLoginWithQrDocument,
    options,
  );
}
export type DisableLoginWithQrMutationHookResult = ReturnType<typeof useDisableLoginWithQrMutation>;
export type DisableLoginWithQrMutationResult = Apollo.MutationResult<DisableLoginWithQrMutation>;
export type DisableLoginWithQrMutationOptions = Apollo.BaseMutationOptions<
  DisableLoginWithQrMutation,
  DisableLoginWithQrMutationVariables
>;
export const ProfileWidgetDocument = gql`
  query ProfileWidget {
    viewer {
      id
      avatarId
      displayName
      fullName
      havePlus
      isChild
      city
      firstName
      lastName
      birthdate
    }
  }
`;

/**
 * __useProfileWidgetQuery__
 *
 * To run a query within a React component, call `useProfileWidgetQuery` and pass it any options that fit your needs.
 * When your component renders, `useProfileWidgetQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useProfileWidgetQuery({
 *   variables: {
 *   },
 * });
 */
export function useProfileWidgetQuery(
  baseOptions?: Apollo.QueryHookOptions<ProfileWidgetQuery, ProfileWidgetQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<ProfileWidgetQuery, ProfileWidgetQueryVariables>(
    ProfileWidgetDocument,
    options,
  );
}
export function useProfileWidgetLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<ProfileWidgetQuery, ProfileWidgetQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<ProfileWidgetQuery, ProfileWidgetQueryVariables>(
    ProfileWidgetDocument,
    options,
  );
}
export type ProfileWidgetQueryHookResult = ReturnType<typeof useProfileWidgetQuery>;
export type ProfileWidgetLazyQueryHookResult = ReturnType<typeof useProfileWidgetLazyQuery>;
export type ProfileWidgetQueryResult = Apollo.QueryResult<
  ProfileWidgetQuery,
  ProfileWidgetQueryVariables
>;
export const ProfileFillDocument = gql`
  query ProfileFill {
    account {
      id
      phones {
        id
      }
    }
    viewer {
      id
      avatarId
      displayName
      fullName
      havePlus
      isChild
      city
      firstName
      lastName
      birthdate
    }
    addresses {
      id
    }
  }
`;

/**
 * __useProfileFillQuery__
 *
 * To run a query within a React component, call `useProfileFillQuery` and pass it any options that fit your needs.
 * When your component renders, `useProfileFillQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useProfileFillQuery({
 *   variables: {
 *   },
 * });
 */
export function useProfileFillQuery(
  baseOptions?: Apollo.QueryHookOptions<ProfileFillQuery, ProfileFillQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<ProfileFillQuery, ProfileFillQueryVariables>(ProfileFillDocument, options);
}
export function useProfileFillLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<ProfileFillQuery, ProfileFillQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<ProfileFillQuery, ProfileFillQueryVariables>(
    ProfileFillDocument,
    options,
  );
}
export type ProfileFillQueryHookResult = ReturnType<typeof useProfileFillQuery>;
export type ProfileFillLazyQueryHookResult = ReturnType<typeof useProfileFillLazyQuery>;
export type ProfileFillQueryResult = Apollo.QueryResult<
  ProfileFillQuery,
  ProfileFillQueryVariables
>;
export const RecoveryMethodsDocument = gql`
  query RecoveryMethods {
    account {
      id
      question {
        id
        text
      }
      phones {
        id
        number
        isPrimary
        operation {
          id
          type
          inQuarantine
          finishedAt
        }
      }
      emails {
        address
        type
        isPrimary
        isConfirmed
      }
    }
  }
`;

/**
 * __useRecoveryMethodsQuery__
 *
 * To run a query within a React component, call `useRecoveryMethodsQuery` and pass it any options that fit your needs.
 * When your component renders, `useRecoveryMethodsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useRecoveryMethodsQuery({
 *   variables: {
 *   },
 * });
 */
export function useRecoveryMethodsQuery(
  baseOptions?: Apollo.QueryHookOptions<RecoveryMethodsQuery, RecoveryMethodsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<RecoveryMethodsQuery, RecoveryMethodsQueryVariables>(
    RecoveryMethodsDocument,
    options,
  );
}
export function useRecoveryMethodsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<RecoveryMethodsQuery, RecoveryMethodsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<RecoveryMethodsQuery, RecoveryMethodsQueryVariables>(
    RecoveryMethodsDocument,
    options,
  );
}
export type RecoveryMethodsQueryHookResult = ReturnType<typeof useRecoveryMethodsQuery>;
export type RecoveryMethodsLazyQueryHookResult = ReturnType<typeof useRecoveryMethodsLazyQuery>;
export type RecoveryMethodsQueryResult = Apollo.QueryResult<
  RecoveryMethodsQuery,
  RecoveryMethodsQueryVariables
>;
export const SecurityShortcutsDocument = gql`
  query SecurityShortcuts {
    account {
      id
      authType
      phones {
        id
        isPrimary
        isDefault
      }
      question {
        id
        text
      }
    }
  }
`;

/**
 * __useSecurityShortcutsQuery__
 *
 * To run a query within a React component, call `useSecurityShortcutsQuery` and pass it any options that fit your needs.
 * When your component renders, `useSecurityShortcutsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSecurityShortcutsQuery({
 *   variables: {
 *   },
 * });
 */
export function useSecurityShortcutsQuery(
  baseOptions?: Apollo.QueryHookOptions<SecurityShortcutsQuery, SecurityShortcutsQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<SecurityShortcutsQuery, SecurityShortcutsQueryVariables>(
    SecurityShortcutsDocument,
    options,
  );
}
export function useSecurityShortcutsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    SecurityShortcutsQuery,
    SecurityShortcutsQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<SecurityShortcutsQuery, SecurityShortcutsQueryVariables>(
    SecurityShortcutsDocument,
    options,
  );
}
export type SecurityShortcutsQueryHookResult = ReturnType<typeof useSecurityShortcutsQuery>;
export type SecurityShortcutsLazyQueryHookResult = ReturnType<typeof useSecurityShortcutsLazyQuery>;
export type SecurityShortcutsQueryResult = Apollo.QueryResult<
  SecurityShortcutsQuery,
  SecurityShortcutsQueryVariables
>;
export const WebsitePasswordsWidgetDocument = gql`
  query WebsitePasswordsWidget {
    viewer {
      avatarId
    }
  }
`;

/**
 * __useWebsitePasswordsWidgetQuery__
 *
 * To run a query within a React component, call `useWebsitePasswordsWidgetQuery` and pass it any options that fit your needs.
 * When your component renders, `useWebsitePasswordsWidgetQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useWebsitePasswordsWidgetQuery({
 *   variables: {
 *   },
 * });
 */
export function useWebsitePasswordsWidgetQuery(
  baseOptions?: Apollo.QueryHookOptions<
    WebsitePasswordsWidgetQuery,
    WebsitePasswordsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<WebsitePasswordsWidgetQuery, WebsitePasswordsWidgetQueryVariables>(
    WebsitePasswordsWidgetDocument,
    options,
  );
}
export function useWebsitePasswordsWidgetLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    WebsitePasswordsWidgetQuery,
    WebsitePasswordsWidgetQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<WebsitePasswordsWidgetQuery, WebsitePasswordsWidgetQueryVariables>(
    WebsitePasswordsWidgetDocument,
    options,
  );
}
export type WebsitePasswordsWidgetQueryHookResult = ReturnType<
  typeof useWebsitePasswordsWidgetQuery
>;
export type WebsitePasswordsWidgetLazyQueryHookResult = ReturnType<
  typeof useWebsitePasswordsWidgetLazyQuery
>;
export type WebsitePasswordsWidgetQueryResult = Apollo.QueryResult<
  WebsitePasswordsWidgetQuery,
  WebsitePasswordsWidgetQueryVariables
>;
export const AddressesCardsWidgetDataDocument = gql`
  query AddressesCardsWidgetData {
    addresses {
      id
      comment
      entrance
      floor
      fullText
      intercom
      previewUrl
      region
      room
      shortText
      street
      type
    }
  }
`;

/**
 * __useAddressesCardsWidgetDataQuery__
 *
 * To run a query within a React component, call `useAddressesCardsWidgetDataQuery` and pass it any options that fit your needs.
 * When your component renders, `useAddressesCardsWidgetDataQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAddressesCardsWidgetDataQuery({
 *   variables: {
 *   },
 * });
 */
export function useAddressesCardsWidgetDataQuery(
  baseOptions?: Apollo.QueryHookOptions<
    AddressesCardsWidgetDataQuery,
    AddressesCardsWidgetDataQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<AddressesCardsWidgetDataQuery, AddressesCardsWidgetDataQueryVariables>(
    AddressesCardsWidgetDataDocument,
    options,
  );
}
export function useAddressesCardsWidgetDataLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    AddressesCardsWidgetDataQuery,
    AddressesCardsWidgetDataQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<AddressesCardsWidgetDataQuery, AddressesCardsWidgetDataQueryVariables>(
    AddressesCardsWidgetDataDocument,
    options,
  );
}
export type AddressesCardsWidgetDataQueryHookResult = ReturnType<
  typeof useAddressesCardsWidgetDataQuery
>;
export type AddressesCardsWidgetDataLazyQueryHookResult = ReturnType<
  typeof useAddressesCardsWidgetDataLazyQuery
>;
export type AddressesCardsWidgetDataQueryResult = Apollo.QueryResult<
  AddressesCardsWidgetDataQuery,
  AddressesCardsWidgetDataQueryVariables
>;
export const AddressesListWidgetDataDocument = gql`
  query AddressesListWidgetData {
    addresses {
      id
      comment
      entrance
      floor
      fullText
      intercom
      region
      room
      shortText
      street
      type
    }
  }
`;

/**
 * __useAddressesListWidgetDataQuery__
 *
 * To run a query within a React component, call `useAddressesListWidgetDataQuery` and pass it any options that fit your needs.
 * When your component renders, `useAddressesListWidgetDataQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useAddressesListWidgetDataQuery({
 *   variables: {
 *   },
 * });
 */
export function useAddressesListWidgetDataQuery(
  baseOptions?: Apollo.QueryHookOptions<
    AddressesListWidgetDataQuery,
    AddressesListWidgetDataQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<AddressesListWidgetDataQuery, AddressesListWidgetDataQueryVariables>(
    AddressesListWidgetDataDocument,
    options,
  );
}
export function useAddressesListWidgetDataLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    AddressesListWidgetDataQuery,
    AddressesListWidgetDataQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<AddressesListWidgetDataQuery, AddressesListWidgetDataQueryVariables>(
    AddressesListWidgetDataDocument,
    options,
  );
}
export type AddressesListWidgetDataQueryHookResult = ReturnType<
  typeof useAddressesListWidgetDataQuery
>;
export type AddressesListWidgetDataLazyQueryHookResult = ReturnType<
  typeof useAddressesListWidgetDataLazyQuery
>;
export type AddressesListWidgetDataQueryResult = Apollo.QueryResult<
  AddressesListWidgetDataQuery,
  AddressesListWidgetDataQueryVariables
>;
export const DocumentsThumbsWidgetDataDocument = gql`
  query DocumentsThumbsWidgetData {
    documents {
      id
      type
      section
      ... on BirthCertificateDocument {
        firstName
        lastName
      }
      ... on NationalIdDocument {
        firstName
        lastName
      }
      ... on InternationalIdDocument {
        firstName
        lastName
      }
      ... on InnDocument {
        firstName
        lastName
      }
      ... on SnilsDocument {
        firstName
        lastName
      }
      ... on DriverLicenseDocument {
        firstName
        lastName
      }
      ... on MedicalInsuranceDocument {
        firstName
        lastName
      }
      ... on VoluntaryMedicalInsuranceDocument {
        firstName
        lastName
      }
      ... on VehicleRegistrationCertificateDocument {
        model
      }
    }
  }
`;

/**
 * __useDocumentsThumbsWidgetDataQuery__
 *
 * To run a query within a React component, call `useDocumentsThumbsWidgetDataQuery` and pass it any options that fit your needs.
 * When your component renders, `useDocumentsThumbsWidgetDataQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useDocumentsThumbsWidgetDataQuery({
 *   variables: {
 *   },
 * });
 */
export function useDocumentsThumbsWidgetDataQuery(
  baseOptions?: Apollo.QueryHookOptions<
    DocumentsThumbsWidgetDataQuery,
    DocumentsThumbsWidgetDataQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<DocumentsThumbsWidgetDataQuery, DocumentsThumbsWidgetDataQueryVariables>(
    DocumentsThumbsWidgetDataDocument,
    options,
  );
}
export function useDocumentsThumbsWidgetDataLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    DocumentsThumbsWidgetDataQuery,
    DocumentsThumbsWidgetDataQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<
    DocumentsThumbsWidgetDataQuery,
    DocumentsThumbsWidgetDataQueryVariables
  >(DocumentsThumbsWidgetDataDocument, options);
}
export type DocumentsThumbsWidgetDataQueryHookResult = ReturnType<
  typeof useDocumentsThumbsWidgetDataQuery
>;
export type DocumentsThumbsWidgetDataLazyQueryHookResult = ReturnType<
  typeof useDocumentsThumbsWidgetDataLazyQuery
>;
export type DocumentsThumbsWidgetDataQueryResult = Apollo.QueryResult<
  DocumentsThumbsWidgetDataQuery,
  DocumentsThumbsWidgetDataQueryVariables
>;
export const SecurityBannerDataDocument = gql`
  query SecurityBannerData {
    account {
      id
      authType
      question {
        id
      }
      phones {
        id
        isPrimary
      }
      emails {
        address
        type
        isPrimary
        isConfirmed
      }
    }
  }
`;

/**
 * __useSecurityBannerDataQuery__
 *
 * To run a query within a React component, call `useSecurityBannerDataQuery` and pass it any options that fit your needs.
 * When your component renders, `useSecurityBannerDataQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useSecurityBannerDataQuery({
 *   variables: {
 *   },
 * });
 */
export function useSecurityBannerDataQuery(
  baseOptions?: Apollo.QueryHookOptions<SecurityBannerDataQuery, SecurityBannerDataQueryVariables>,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useQuery<SecurityBannerDataQuery, SecurityBannerDataQueryVariables>(
    SecurityBannerDataDocument,
    options,
  );
}
export function useSecurityBannerDataLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    SecurityBannerDataQuery,
    SecurityBannerDataQueryVariables
  >,
) {
  const options = { ...defaultOptions, ...baseOptions };

  return Apollo.useLazyQuery<SecurityBannerDataQuery, SecurityBannerDataQueryVariables>(
    SecurityBannerDataDocument,
    options,
  );
}
export type SecurityBannerDataQueryHookResult = ReturnType<typeof useSecurityBannerDataQuery>;
export type SecurityBannerDataLazyQueryHookResult = ReturnType<
  typeof useSecurityBannerDataLazyQuery
>;
export type SecurityBannerDataQueryResult = Apollo.QueryResult<
  SecurityBannerDataQuery,
  SecurityBannerDataQueryVariables
>;
export type AccountKeySpecifier = (
  | 'authType'
  | 'canLoginWithQR'
  | 'emails'
  | 'id'
  | 'passwordInfo'
  | 'phones'
  | 'publicId'
  | 'question'
  | 'type'
  | AccountKeySpecifier
)[];
export type AccountFieldPolicy = {
  authType?: FieldPolicy<any> | FieldReadFunction<any>;
  canLoginWithQR?: FieldPolicy<any> | FieldReadFunction<any>;
  emails?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  passwordInfo?: FieldPolicy<any> | FieldReadFunction<any>;
  phones?: FieldPolicy<any> | FieldReadFunction<any>;
  publicId?: FieldPolicy<any> | FieldReadFunction<any>;
  question?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type AccountCreateBindBankCardResponseKeySpecifier = (
  | 'status'
  | 'url'
  | AccountCreateBindBankCardResponseKeySpecifier
)[];
export type AccountCreateBindBankCardResponseFieldPolicy = {
  status?: FieldPolicy<any> | FieldReadFunction<any>;
  url?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type AccountUnbindBankdCardResponseKeySpecifier = (
  | 'status'
  | AccountUnbindBankdCardResponseKeySpecifier
)[];
export type AccountUnbindBankdCardResponseFieldPolicy = {
  status?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type AddDocumentPayloadKeySpecifier = ('query' | AddDocumentPayloadKeySpecifier)[];
export type AddDocumentPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type AddDocumentProblemKeySpecifier = ('reason' | AddDocumentProblemKeySpecifier)[];
export type AddDocumentProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type AddRecoveryEmailPayloadKeySpecifier = (
  | 'query'
  | 'trackId'
  | AddRecoveryEmailPayloadKeySpecifier
)[];
export type AddRecoveryEmailPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type AddRecoveryEmailProblemKeySpecifier = (
  | 'reason'
  | 'trackId'
  | AddRecoveryEmailProblemKeySpecifier
)[];
export type AddRecoveryEmailProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type AddressKeySpecifier = (
  | 'comment'
  | 'entrance'
  | 'floor'
  | 'fullText'
  | 'id'
  | 'intercom'
  | 'previewUrl'
  | 'region'
  | 'room'
  | 'shortText'
  | 'street'
  | 'type'
  | AddressKeySpecifier
)[];
export type AddressFieldPolicy = {
  comment?: FieldPolicy<any> | FieldReadFunction<any>;
  entrance?: FieldPolicy<any> | FieldReadFunction<any>;
  floor?: FieldPolicy<any> | FieldReadFunction<any>;
  fullText?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  intercom?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  region?: FieldPolicy<any> | FieldReadFunction<any>;
  room?: FieldPolicy<any> | FieldReadFunction<any>;
  shortText?: FieldPolicy<any> | FieldReadFunction<any>;
  street?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type AvailableQuestionKeySpecifier = ('id' | 'text' | AvailableQuestionKeySpecifier)[];
export type AvailableQuestionFieldPolicy = {
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  text?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type BankCardKeySpecifier = (
  | 'cardId'
  | 'familyAdminUid'
  | 'id'
  | 'isFamilyCard'
  | 'name'
  | 'number'
  | 'proto'
  | 'system'
  | BankCardKeySpecifier
)[];
export type BankCardFieldPolicy = {
  cardId?: FieldPolicy<any> | FieldReadFunction<any>;
  familyAdminUid?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  isFamilyCard?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
  number?: FieldPolicy<any> | FieldReadFunction<any>;
  proto?: FieldPolicy<any> | FieldReadFunction<any>;
  system?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type BankCardsDataKeySpecifier = (
  | 'cards'
  | 'status'
  | 'trackId'
  | BankCardsDataKeySpecifier
)[];
export type BankCardsDataFieldPolicy = {
  cards?: FieldPolicy<any> | FieldReadFunction<any>;
  status?: FieldPolicy<any> | FieldReadFunction<any>;
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type BillKeySpecifier = (
  | 'account_number'
  | 'amount'
  | 'amount_to_pay'
  | 'bik'
  | 'bill_date'
  | 'bill_id'
  | 'dep_type'
  | 'discount_date'
  | 'discount_size'
  | 'discounted_amount'
  | 'div_id'
  | 'document_id'
  | 'fee_amount'
  | 'inn'
  | 'kbk'
  | 'kpp'
  | 'legal_act'
  | 'offense_date'
  | 'offense_name'
  | 'offense_place'
  | 'oktmo'
  | 'paid_amount'
  | 'paid_date'
  | 'payee_name'
  | 'payer_name'
  | 'payment_deadline'
  | 'purpose'
  | 'status'
  | 'supplier_bill_id'
  | 'treasure_branch'
  | 'uid'
  | BillKeySpecifier
)[];
export type BillFieldPolicy = {
  account_number?: FieldPolicy<any> | FieldReadFunction<any>;
  amount?: FieldPolicy<any> | FieldReadFunction<any>;
  amount_to_pay?: FieldPolicy<any> | FieldReadFunction<any>;
  bik?: FieldPolicy<any> | FieldReadFunction<any>;
  bill_date?: FieldPolicy<any> | FieldReadFunction<any>;
  bill_id?: FieldPolicy<any> | FieldReadFunction<any>;
  dep_type?: FieldPolicy<any> | FieldReadFunction<any>;
  discount_date?: FieldPolicy<any> | FieldReadFunction<any>;
  discount_size?: FieldPolicy<any> | FieldReadFunction<any>;
  discounted_amount?: FieldPolicy<any> | FieldReadFunction<any>;
  div_id?: FieldPolicy<any> | FieldReadFunction<any>;
  document_id?: FieldPolicy<any> | FieldReadFunction<any>;
  fee_amount?: FieldPolicy<any> | FieldReadFunction<any>;
  inn?: FieldPolicy<any> | FieldReadFunction<any>;
  kbk?: FieldPolicy<any> | FieldReadFunction<any>;
  kpp?: FieldPolicy<any> | FieldReadFunction<any>;
  legal_act?: FieldPolicy<any> | FieldReadFunction<any>;
  offense_date?: FieldPolicy<any> | FieldReadFunction<any>;
  offense_name?: FieldPolicy<any> | FieldReadFunction<any>;
  offense_place?: FieldPolicy<any> | FieldReadFunction<any>;
  oktmo?: FieldPolicy<any> | FieldReadFunction<any>;
  paid_amount?: FieldPolicy<any> | FieldReadFunction<any>;
  paid_date?: FieldPolicy<any> | FieldReadFunction<any>;
  payee_name?: FieldPolicy<any> | FieldReadFunction<any>;
  payer_name?: FieldPolicy<any> | FieldReadFunction<any>;
  payment_deadline?: FieldPolicy<any> | FieldReadFunction<any>;
  purpose?: FieldPolicy<any> | FieldReadFunction<any>;
  status?: FieldPolicy<any> | FieldReadFunction<any>;
  supplier_bill_id?: FieldPolicy<any> | FieldReadFunction<any>;
  treasure_branch?: FieldPolicy<any> | FieldReadFunction<any>;
  uid?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type BillTransactionResponseKeySpecifier = (
  | 'status'
  | 'transaction_id'
  | BillTransactionResponseKeySpecifier
)[];
export type BillTransactionResponseFieldPolicy = {
  status?: FieldPolicy<any> | FieldReadFunction<any>;
  transaction_id?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type BillsDataKeySpecifier = ('bills' | 'state' | BillsDataKeySpecifier)[];
export type BillsDataFieldPolicy = {
  bills?: FieldPolicy<any> | FieldReadFunction<any>;
  state?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type BillsDocumentKeySpecifier = (
  | 'created'
  | 'document_id'
  | 'title'
  | 'type'
  | 'updated'
  | 'value'
  | BillsDocumentKeySpecifier
)[];
export type BillsDocumentFieldPolicy = {
  created?: FieldPolicy<any> | FieldReadFunction<any>;
  document_id?: FieldPolicy<any> | FieldReadFunction<any>;
  title?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  updated?: FieldPolicy<any> | FieldReadFunction<any>;
  value?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type BirthCertificateDocumentKeySpecifier = (
  | 'birthAkt'
  | 'birthDate'
  | 'birthPlace'
  | 'docNumber'
  | 'fatherBirthDate'
  | 'fatherCitizenship'
  | 'fatherFirstName'
  | 'fatherLastName'
  | 'fatherMiddleName'
  | 'fatherNationality'
  | 'firstName'
  | 'id'
  | 'images'
  | 'issueDate'
  | 'issuePlace'
  | 'lastName'
  | 'middleName'
  | 'motherBirthDate'
  | 'motherCitizenship'
  | 'motherFirstName'
  | 'motherLastName'
  | 'motherMiddleName'
  | 'motherNationality'
  | 'originalUrl'
  | 'previewUrl'
  | 'registrationPlace'
  | 'section'
  | 'series'
  | 'type'
  | 'verificationStatus'
  | BirthCertificateDocumentKeySpecifier
)[];
export type BirthCertificateDocumentFieldPolicy = {
  birthAkt?: FieldPolicy<any> | FieldReadFunction<any>;
  birthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  birthPlace?: FieldPolicy<any> | FieldReadFunction<any>;
  docNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  fatherBirthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  fatherCitizenship?: FieldPolicy<any> | FieldReadFunction<any>;
  fatherFirstName?: FieldPolicy<any> | FieldReadFunction<any>;
  fatherLastName?: FieldPolicy<any> | FieldReadFunction<any>;
  fatherMiddleName?: FieldPolicy<any> | FieldReadFunction<any>;
  fatherNationality?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  issueDate?: FieldPolicy<any> | FieldReadFunction<any>;
  issuePlace?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  middleName?: FieldPolicy<any> | FieldReadFunction<any>;
  motherBirthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  motherCitizenship?: FieldPolicy<any> | FieldReadFunction<any>;
  motherFirstName?: FieldPolicy<any> | FieldReadFunction<any>;
  motherLastName?: FieldPolicy<any> | FieldReadFunction<any>;
  motherMiddleName?: FieldPolicy<any> | FieldReadFunction<any>;
  motherNationality?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  registrationPlace?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  series?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type CardInfoKeySpecifier = (
  | 'bound'
  | 'cardId'
  | 'currency'
  | 'maskedNumber'
  | 'paySystem'
  | CardInfoKeySpecifier
)[];
export type CardInfoFieldPolicy = {
  bound?: FieldPolicy<any> | FieldReadFunction<any>;
  cardId?: FieldPolicy<any> | FieldReadFunction<any>;
  currency?: FieldPolicy<any> | FieldReadFunction<any>;
  maskedNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  paySystem?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ConfirmByPasswordPayloadKeySpecifier = (
  | 'successful'
  | ConfirmByPasswordPayloadKeySpecifier
)[];
export type ConfirmByPasswordPayloadFieldPolicy = {
  successful?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ConfirmByPasswordProblemKeySpecifier = (
  | 'raw'
  | 'reason'
  | ConfirmByPasswordProblemKeySpecifier
)[];
export type ConfirmByPasswordProblemFieldPolicy = {
  raw?: FieldPolicy<any> | FieldReadFunction<any>;
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ConfirmRecoveryEmailByCodePayloadKeySpecifier = (
  | 'query'
  | ConfirmRecoveryEmailByCodePayloadKeySpecifier
)[];
export type ConfirmRecoveryEmailByCodePayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ConfirmRecoveryEmailByCodeProblemKeySpecifier = (
  | 'reason'
  | ConfirmRecoveryEmailByCodeProblemKeySpecifier
)[];
export type ConfirmRecoveryEmailByCodeProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ConfirmRecoveryEmailByLinkPayloadKeySpecifier = (
  | 'query'
  | ConfirmRecoveryEmailByLinkPayloadKeySpecifier
)[];
export type ConfirmRecoveryEmailByLinkPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ConfirmRecoveryEmailByLinkProblemKeySpecifier = (
  | 'reason'
  | ConfirmRecoveryEmailByLinkProblemKeySpecifier
)[];
export type ConfirmRecoveryEmailByLinkProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type CopyDocumentsFromDiskPayloadKeySpecifier = (
  | 'query'
  | CopyDocumentsFromDiskPayloadKeySpecifier
)[];
export type CopyDocumentsFromDiskPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type CountryOptionKeySpecifier = ('code' | 'name' | CountryOptionKeySpecifier)[];
export type CountryOptionFieldPolicy = {
  code?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type CreateOrUpdateAddressPayloadKeySpecifier = (
  | 'query'
  | CreateOrUpdateAddressPayloadKeySpecifier
)[];
export type CreateOrUpdateAddressPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type CreateOrUpdateAddressProblemKeySpecifier = (
  | 'reason'
  | CreateOrUpdateAddressProblemKeySpecifier
)[];
export type CreateOrUpdateAddressProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type CreateOrderResponseKeySpecifier = (
  | 'created'
  | 'order_id'
  | 'status'
  | 'updated'
  | CreateOrderResponseKeySpecifier
)[];
export type CreateOrderResponseFieldPolicy = {
  created?: FieldPolicy<any> | FieldReadFunction<any>;
  order_id?: FieldPolicy<any> | FieldReadFunction<any>;
  status?: FieldPolicy<any> | FieldReadFunction<any>;
  updated?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DefaultResponseKeySpecifier = ('status' | DefaultResponseKeySpecifier)[];
export type DefaultResponseFieldPolicy = {
  status?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DeleteAddressPayloadKeySpecifier = ('query' | DeleteAddressPayloadKeySpecifier)[];
export type DeleteAddressPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DeleteAddressProblemKeySpecifier = ('reason' | DeleteAddressProblemKeySpecifier)[];
export type DeleteAddressProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DeleteDocumentPayloadKeySpecifier = ('query' | DeleteDocumentPayloadKeySpecifier)[];
export type DeleteDocumentPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DeleteDocumentProblemKeySpecifier = ('reason' | DeleteDocumentProblemKeySpecifier)[];
export type DeleteDocumentProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DisableLoginWithQRPayloadKeySpecifier = (
  | 'account'
  | DisableLoginWithQRPayloadKeySpecifier
)[];
export type DisableLoginWithQRPayloadFieldPolicy = {
  account?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DiskItemKeySpecifier = ('name' | 'path' | 'preview' | DiskItemKeySpecifier)[];
export type DiskItemFieldPolicy = {
  name?: FieldPolicy<any> | FieldReadFunction<any>;
  path?: FieldPolicy<any> | FieldReadFunction<any>;
  preview?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DisplayNameKeySpecifier = ('defaultAvatar' | 'name' | DisplayNameKeySpecifier)[];
export type DisplayNameFieldPolicy = {
  defaultAvatar?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DocumentByIdProblemKeySpecifier = ('reason' | DocumentByIdProblemKeySpecifier)[];
export type DocumentByIdProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DocumentImageKeySpecifier = (
  | 'id'
  | 'originalHeight'
  | 'originalUri'
  | 'originalUrl'
  | 'originalWidth'
  | 'previewHeight'
  | 'previewUri'
  | 'previewUrl'
  | 'previewWidth'
  | DocumentImageKeySpecifier
)[];
export type DocumentImageFieldPolicy = {
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  originalHeight?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUri?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  originalWidth?: FieldPolicy<any> | FieldReadFunction<any>;
  previewHeight?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUri?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewWidth?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type DriverLicenseDocumentKeySpecifier = (
  | 'additionalInformation'
  | 'birthDate'
  | 'birthPlace'
  | 'birthPlaceLat'
  | 'category'
  | 'docNumber'
  | 'endDate'
  | 'firstName'
  | 'firstNameLat'
  | 'id'
  | 'images'
  | 'issueDate'
  | 'issuedBy'
  | 'issuedByLat'
  | 'issuedCity'
  | 'issuedCityLat'
  | 'lastName'
  | 'lastNameLat'
  | 'middleName'
  | 'middleNameLat'
  | 'originalUrl'
  | 'previewUrl'
  | 'section'
  | 'type'
  | 'verificationStatus'
  | DriverLicenseDocumentKeySpecifier
)[];
export type DriverLicenseDocumentFieldPolicy = {
  additionalInformation?: FieldPolicy<any> | FieldReadFunction<any>;
  birthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  birthPlace?: FieldPolicy<any> | FieldReadFunction<any>;
  birthPlaceLat?: FieldPolicy<any> | FieldReadFunction<any>;
  category?: FieldPolicy<any> | FieldReadFunction<any>;
  docNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  endDate?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  firstNameLat?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  issueDate?: FieldPolicy<any> | FieldReadFunction<any>;
  issuedBy?: FieldPolicy<any> | FieldReadFunction<any>;
  issuedByLat?: FieldPolicy<any> | FieldReadFunction<any>;
  issuedCity?: FieldPolicy<any> | FieldReadFunction<any>;
  issuedCityLat?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  lastNameLat?: FieldPolicy<any> | FieldReadFunction<any>;
  middleName?: FieldPolicy<any> | FieldReadFunction<any>;
  middleNameLat?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type EdadealDataKeySpecifier = (
  | 'amount'
  | 'hasBinding'
  | 'iframeSrc'
  | 'url'
  | EdadealDataKeySpecifier
)[];
export type EdadealDataFieldPolicy = {
  amount?: FieldPolicy<any> | FieldReadFunction<any>;
  hasBinding?: FieldPolicy<any> | FieldReadFunction<any>;
  iframeSrc?: FieldPolicy<any> | FieldReadFunction<any>;
  url?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type EmailKeySpecifier = (
  | 'address'
  | 'email'
  | 'isConfirmed'
  | 'isPrimary'
  | 'isUnsafe'
  | 'type'
  | EmailKeySpecifier
)[];
export type EmailFieldPolicy = {
  address?: FieldPolicy<any> | FieldReadFunction<any>;
  email?: FieldPolicy<any> | FieldReadFunction<any>;
  isConfirmed?: FieldPolicy<any> | FieldReadFunction<any>;
  isPrimary?: FieldPolicy<any> | FieldReadFunction<any>;
  isUnsafe?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type EnableLoginWithQRPayloadKeySpecifier = (
  | 'account'
  | EnableLoginWithQRPayloadKeySpecifier
)[];
export type EnableLoginWithQRPayloadFieldPolicy = {
  account?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ExternalAccountKeySpecifier = (
  | 'allowAuth'
  | 'displayName'
  | 'firstName'
  | 'id'
  | 'lastName'
  | 'provider'
  | ExternalAccountKeySpecifier
)[];
export type ExternalAccountFieldPolicy = {
  allowAuth?: FieldPolicy<any> | FieldReadFunction<any>;
  displayName?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  provider?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ExternalAccountProviderKeySpecifier = (
  | 'id'
  | 'name'
  | ExternalAccountProviderKeySpecifier
)[];
export type ExternalAccountProviderFieldPolicy = {
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type FamilyKeySpecifier = (
  | 'info'
  | 'invites'
  | 'kids'
  | 'members'
  | 'pay'
  | 'settings'
  | FamilyKeySpecifier
)[];
export type FamilyFieldPolicy = {
  info?: FieldPolicy<any> | FieldReadFunction<any>;
  invites?: FieldPolicy<any> | FieldReadFunction<any>;
  kids?: FieldPolicy<any> | FieldReadFunction<any>;
  members?: FieldPolicy<any> | FieldReadFunction<any>;
  pay?: FieldPolicy<any> | FieldReadFunction<any>;
  settings?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type FamilyInfoKeySpecifier = ('adminUid' | 'id' | FamilyInfoKeySpecifier)[];
export type FamilyInfoFieldPolicy = {
  adminUid?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type FamilyInviteKeySpecifier = (
  | 'contact'
  | 'id'
  | 'sendMethod'
  | FamilyInviteKeySpecifier
)[];
export type FamilyInviteFieldPolicy = {
  contact?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  sendMethod?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type FamilyKidKeySpecifier = (
  | 'avatar'
  | 'birthday'
  | 'contentRating'
  | 'gender'
  | 'musicRating'
  | 'name'
  | 'placeId'
  | 'uid'
  | 'videoRating'
  | FamilyKidKeySpecifier
)[];
export type FamilyKidFieldPolicy = {
  avatar?: FieldPolicy<any> | FieldReadFunction<any>;
  birthday?: FieldPolicy<any> | FieldReadFunction<any>;
  contentRating?: FieldPolicy<any> | FieldReadFunction<any>;
  gender?: FieldPolicy<any> | FieldReadFunction<any>;
  musicRating?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
  placeId?: FieldPolicy<any> | FieldReadFunction<any>;
  uid?: FieldPolicy<any> | FieldReadFunction<any>;
  videoRating?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type FamilyMemberKeySpecifier = (
  | 'avatar'
  | 'hasPlus'
  | 'hasSecurePhone'
  | 'isAdmin'
  | 'name'
  | 'placeId'
  | 'uid'
  | FamilyMemberKeySpecifier
)[];
export type FamilyMemberFieldPolicy = {
  avatar?: FieldPolicy<any> | FieldReadFunction<any>;
  hasPlus?: FieldPolicy<any> | FieldReadFunction<any>;
  hasSecurePhone?: FieldPolicy<any> | FieldReadFunction<any>;
  isAdmin?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
  placeId?: FieldPolicy<any> | FieldReadFunction<any>;
  uid?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type FamilyPayKeySpecifier = ('cardInfo' | 'userRestrictions' | FamilyPayKeySpecifier)[];
export type FamilyPayFieldPolicy = {
  cardInfo?: FieldPolicy<any> | FieldReadFunction<any>;
  userRestrictions?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type FamilySettingsKeySpecifier = ('maxCapacity' | 'maxKids' | FamilySettingsKeySpecifier)[];
export type FamilySettingsFieldPolicy = {
  maxCapacity?: FieldPolicy<any> | FieldReadFunction<any>;
  maxKids?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type FamilyUserKeySpecifier = ('avatar' | 'name' | 'uid' | FamilyUserKeySpecifier)[];
export type FamilyUserFieldPolicy = {
  avatar?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
  uid?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type FuturePaymentKeySpecifier = (
  | 'amount'
  | 'id'
  | 'iframeUrl'
  | 'nextPaymentAt'
  | 'service'
  | 'type'
  | FuturePaymentKeySpecifier
)[];
export type FuturePaymentFieldPolicy = {
  amount?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  iframeUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  nextPaymentAt?: FieldPolicy<any> | FieldReadFunction<any>;
  service?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type IDocumentKeySpecifier = (
  | 'id'
  | 'images'
  | 'originalUrl'
  | 'previewUrl'
  | 'section'
  | 'type'
  | 'verificationStatus'
  | IDocumentKeySpecifier
)[];
export type IDocumentFieldPolicy = {
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type InnDocumentKeySpecifier = (
  | 'birthDate'
  | 'docNumber'
  | 'firstName'
  | 'gender'
  | 'id'
  | 'images'
  | 'issueDate'
  | 'issuedBy'
  | 'lastName'
  | 'middleName'
  | 'originalUrl'
  | 'previewUrl'
  | 'section'
  | 'type'
  | 'verificationStatus'
  | InnDocumentKeySpecifier
)[];
export type InnDocumentFieldPolicy = {
  birthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  docNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  gender?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  issueDate?: FieldPolicy<any> | FieldReadFunction<any>;
  issuedBy?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  middleName?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type InternationalIdDocumentKeySpecifier = (
  | 'birthDate'
  | 'birthPlace'
  | 'birthPlaceLat'
  | 'citizenship'
  | 'citizenshipLat'
  | 'docNumber'
  | 'endDate'
  | 'firstName'
  | 'firstNameLat'
  | 'gender'
  | 'id'
  | 'images'
  | 'issueDate'
  | 'issuedBy'
  | 'lastName'
  | 'lastNameLat'
  | 'originalUrl'
  | 'previewUrl'
  | 'section'
  | 'type'
  | 'verificationStatus'
  | InternationalIdDocumentKeySpecifier
)[];
export type InternationalIdDocumentFieldPolicy = {
  birthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  birthPlace?: FieldPolicy<any> | FieldReadFunction<any>;
  birthPlaceLat?: FieldPolicy<any> | FieldReadFunction<any>;
  citizenship?: FieldPolicy<any> | FieldReadFunction<any>;
  citizenshipLat?: FieldPolicy<any> | FieldReadFunction<any>;
  docNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  endDate?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  firstNameLat?: FieldPolicy<any> | FieldReadFunction<any>;
  gender?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  issueDate?: FieldPolicy<any> | FieldReadFunction<any>;
  issuedBy?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  lastNameLat?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type LimitKeySpecifier = ('limitMode' | 'value' | LimitKeySpecifier)[];
export type LimitFieldPolicy = {
  limitMode?: FieldPolicy<any> | FieldReadFunction<any>;
  value?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type LocationsOptionsKeySpecifier = (
  | 'countries'
  | 'timezones'
  | LocationsOptionsKeySpecifier
)[];
export type LocationsOptionsFieldPolicy = {
  countries?: FieldPolicy<any> | FieldReadFunction<any>;
  timezones?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type MedicalInsuranceDocumentKeySpecifier = (
  | 'birthDate'
  | 'blank'
  | 'docNumber'
  | 'firstName'
  | 'gender'
  | 'id'
  | 'images'
  | 'lastName'
  | 'middleName'
  | 'originalUrl'
  | 'previewUrl'
  | 'section'
  | 'type'
  | 'verificationStatus'
  | MedicalInsuranceDocumentKeySpecifier
)[];
export type MedicalInsuranceDocumentFieldPolicy = {
  birthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  blank?: FieldPolicy<any> | FieldReadFunction<any>;
  docNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  gender?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  middleName?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type Mpi3dsInfoKeySpecifier = (
  | 'browser_accept_header'
  | 'browser_color_depth'
  | 'browser_ip'
  | 'browser_javascript_enabled'
  | 'browser_language'
  | 'browser_screen_height'
  | 'browser_screen_width'
  | 'browser_tz'
  | 'browser_user_agent'
  | 'window_height'
  | 'window_width'
  | Mpi3dsInfoKeySpecifier
)[];
export type Mpi3dsInfoFieldPolicy = {
  browser_accept_header?: FieldPolicy<any> | FieldReadFunction<any>;
  browser_color_depth?: FieldPolicy<any> | FieldReadFunction<any>;
  browser_ip?: FieldPolicy<any> | FieldReadFunction<any>;
  browser_javascript_enabled?: FieldPolicy<any> | FieldReadFunction<any>;
  browser_language?: FieldPolicy<any> | FieldReadFunction<any>;
  browser_screen_height?: FieldPolicy<any> | FieldReadFunction<any>;
  browser_screen_width?: FieldPolicy<any> | FieldReadFunction<any>;
  browser_tz?: FieldPolicy<any> | FieldReadFunction<any>;
  browser_user_agent?: FieldPolicy<any> | FieldReadFunction<any>;
  window_height?: FieldPolicy<any> | FieldReadFunction<any>;
  window_width?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type MutationKeySpecifier = (
  | 'accountAddRecoveryEmail'
  | 'accountBindBankCard'
  | 'accountConfirmRecoveryEmailByCode'
  | 'accountConfirmRecoveryEmailByLink'
  | 'accountDisableLoginWithPasswordAndSms'
  | 'accountDisableLoginWithQR'
  | 'accountEnableLoginWithPasswordAndSms'
  | 'accountEnableLoginWithQR'
  | 'accountRemoveRecoveryEmail'
  | 'accountSetQuestion'
  | 'accountUnbindBankCard'
  | 'addBillsDocument'
  | 'addDocument'
  | 'confirmByPassword'
  | 'copyDocumentsFromDisk'
  | 'createOrUpdateAddress'
  | 'createOrderBill'
  | 'deleteAddress'
  | 'deleteBillsDocument'
  | 'deleteDocument'
  | 'getTransaction'
  | 'profileUpdate'
  | 'restartBillsSearch'
  | 'sendCodeToBindPrimaryPhone'
  | 'sendCodeToConfirmPhone'
  | 'startOrderBill'
  | 'suggestPublicId'
  | 'toggleLoginWithExternalAccount'
  | 'unbindExternalAccount'
  | 'updateBillsDocument'
  | 'updateDocument'
  | 'updatePublicId'
  | 'validatePublicId'
  | 'verifyCodeToBindPrimaryPhone'
  | 'verifyCodeToConfirmPhone'
  | 'viewerUpdatePersonalInfo'
  | 'viewerValidatePersonalInfoField'
  | MutationKeySpecifier
)[];
export type MutationFieldPolicy = {
  accountAddRecoveryEmail?: FieldPolicy<any> | FieldReadFunction<any>;
  accountBindBankCard?: FieldPolicy<any> | FieldReadFunction<any>;
  accountConfirmRecoveryEmailByCode?: FieldPolicy<any> | FieldReadFunction<any>;
  accountConfirmRecoveryEmailByLink?: FieldPolicy<any> | FieldReadFunction<any>;
  accountDisableLoginWithPasswordAndSms?: FieldPolicy<any> | FieldReadFunction<any>;
  accountDisableLoginWithQR?: FieldPolicy<any> | FieldReadFunction<any>;
  accountEnableLoginWithPasswordAndSms?: FieldPolicy<any> | FieldReadFunction<any>;
  accountEnableLoginWithQR?: FieldPolicy<any> | FieldReadFunction<any>;
  accountRemoveRecoveryEmail?: FieldPolicy<any> | FieldReadFunction<any>;
  accountSetQuestion?: FieldPolicy<any> | FieldReadFunction<any>;
  accountUnbindBankCard?: FieldPolicy<any> | FieldReadFunction<any>;
  addBillsDocument?: FieldPolicy<any> | FieldReadFunction<any>;
  addDocument?: FieldPolicy<any> | FieldReadFunction<any>;
  confirmByPassword?: FieldPolicy<any> | FieldReadFunction<any>;
  copyDocumentsFromDisk?: FieldPolicy<any> | FieldReadFunction<any>;
  createOrUpdateAddress?: FieldPolicy<any> | FieldReadFunction<any>;
  createOrderBill?: FieldPolicy<any> | FieldReadFunction<any>;
  deleteAddress?: FieldPolicy<any> | FieldReadFunction<any>;
  deleteBillsDocument?: FieldPolicy<any> | FieldReadFunction<any>;
  deleteDocument?: FieldPolicy<any> | FieldReadFunction<any>;
  getTransaction?: FieldPolicy<any> | FieldReadFunction<any>;
  profileUpdate?: FieldPolicy<any> | FieldReadFunction<any>;
  restartBillsSearch?: FieldPolicy<any> | FieldReadFunction<any>;
  sendCodeToBindPrimaryPhone?: FieldPolicy<any> | FieldReadFunction<any>;
  sendCodeToConfirmPhone?: FieldPolicy<any> | FieldReadFunction<any>;
  startOrderBill?: FieldPolicy<any> | FieldReadFunction<any>;
  suggestPublicId?: FieldPolicy<any> | FieldReadFunction<any>;
  toggleLoginWithExternalAccount?: FieldPolicy<any> | FieldReadFunction<any>;
  unbindExternalAccount?: FieldPolicy<any> | FieldReadFunction<any>;
  updateBillsDocument?: FieldPolicy<any> | FieldReadFunction<any>;
  updateDocument?: FieldPolicy<any> | FieldReadFunction<any>;
  updatePublicId?: FieldPolicy<any> | FieldReadFunction<any>;
  validatePublicId?: FieldPolicy<any> | FieldReadFunction<any>;
  verifyCodeToBindPrimaryPhone?: FieldPolicy<any> | FieldReadFunction<any>;
  verifyCodeToConfirmPhone?: FieldPolicy<any> | FieldReadFunction<any>;
  viewerUpdatePersonalInfo?: FieldPolicy<any> | FieldReadFunction<any>;
  viewerValidatePersonalInfoField?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type NationalIdDocumentKeySpecifier = (
  | 'birthDate'
  | 'birthPlace'
  | 'docNumber'
  | 'firstName'
  | 'gender'
  | 'id'
  | 'images'
  | 'issueDate'
  | 'issuedBy'
  | 'issuerSubdivisionCode'
  | 'lastName'
  | 'middleName'
  | 'originalUrl'
  | 'previewUrl'
  | 'registrationAddress'
  | 'section'
  | 'type'
  | 'verificationStatus'
  | NationalIdDocumentKeySpecifier
)[];
export type NationalIdDocumentFieldPolicy = {
  birthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  birthPlace?: FieldPolicy<any> | FieldReadFunction<any>;
  docNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  gender?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  issueDate?: FieldPolicy<any> | FieldReadFunction<any>;
  issuedBy?: FieldPolicy<any> | FieldReadFunction<any>;
  issuerSubdivisionCode?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  middleName?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  registrationAddress?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PageInfoKeySpecifier = (
  | 'endCursor'
  | 'hasNextPage'
  | 'hasPreviousPage'
  | 'startCursor'
  | PageInfoKeySpecifier
)[];
export type PageInfoFieldPolicy = {
  endCursor?: FieldPolicy<any> | FieldReadFunction<any>;
  hasNextPage?: FieldPolicy<any> | FieldReadFunction<any>;
  hasPreviousPage?: FieldPolicy<any> | FieldReadFunction<any>;
  startCursor?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PasswordInfoKeySpecifier = ('updatedAt' | PasswordInfoKeySpecifier)[];
export type PasswordInfoFieldPolicy = {
  updatedAt?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PaymentKeySpecifier = (
  | 'cashback'
  | 'created'
  | 'currency'
  | 'fake'
  | 'initiatorUid'
  | 'isReceipt'
  | 'items'
  | 'orderId'
  | 'paymentId'
  | 'paymentTypes'
  | 'plus'
  | 'purchaseToken'
  | 'receiptUrl'
  | 'receiptsEnabled'
  | 'refundOnly'
  | 'refunds'
  | 'retailerIcon'
  | 'retailerName'
  | 'service'
  | 'serviceId'
  | 'source'
  | 'status'
  | 'total'
  | PaymentKeySpecifier
)[];
export type PaymentFieldPolicy = {
  cashback?: FieldPolicy<any> | FieldReadFunction<any>;
  created?: FieldPolicy<any> | FieldReadFunction<any>;
  currency?: FieldPolicy<any> | FieldReadFunction<any>;
  fake?: FieldPolicy<any> | FieldReadFunction<any>;
  initiatorUid?: FieldPolicy<any> | FieldReadFunction<any>;
  isReceipt?: FieldPolicy<any> | FieldReadFunction<any>;
  items?: FieldPolicy<any> | FieldReadFunction<any>;
  orderId?: FieldPolicy<any> | FieldReadFunction<any>;
  paymentId?: FieldPolicy<any> | FieldReadFunction<any>;
  paymentTypes?: FieldPolicy<any> | FieldReadFunction<any>;
  plus?: FieldPolicy<any> | FieldReadFunction<any>;
  purchaseToken?: FieldPolicy<any> | FieldReadFunction<any>;
  receiptUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  receiptsEnabled?: FieldPolicy<any> | FieldReadFunction<any>;
  refundOnly?: FieldPolicy<any> | FieldReadFunction<any>;
  refunds?: FieldPolicy<any> | FieldReadFunction<any>;
  retailerIcon?: FieldPolicy<any> | FieldReadFunction<any>;
  retailerName?: FieldPolicy<any> | FieldReadFunction<any>;
  service?: FieldPolicy<any> | FieldReadFunction<any>;
  serviceId?: FieldPolicy<any> | FieldReadFunction<any>;
  source?: FieldPolicy<any> | FieldReadFunction<any>;
  status?: FieldPolicy<any> | FieldReadFunction<any>;
  total?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PaymentItemKeySpecifier = (
  | 'alias'
  | 'amount'
  | 'currency'
  | 'hidden'
  | 'name'
  | 'nds'
  | 'price'
  | PaymentItemKeySpecifier
)[];
export type PaymentItemFieldPolicy = {
  alias?: FieldPolicy<any> | FieldReadFunction<any>;
  amount?: FieldPolicy<any> | FieldReadFunction<any>;
  currency?: FieldPolicy<any> | FieldReadFunction<any>;
  hidden?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
  nds?: FieldPolicy<any> | FieldReadFunction<any>;
  price?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PaymentRefundKeySpecifier = (
  | 'account'
  | 'currency'
  | 'items'
  | 'paymentMethod'
  | 'total'
  | PaymentRefundKeySpecifier
)[];
export type PaymentRefundFieldPolicy = {
  account?: FieldPolicy<any> | FieldReadFunction<any>;
  currency?: FieldPolicy<any> | FieldReadFunction<any>;
  items?: FieldPolicy<any> | FieldReadFunction<any>;
  paymentMethod?: FieldPolicy<any> | FieldReadFunction<any>;
  total?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PaymentTypeKeySpecifier = (
  | 'account'
  | 'currency'
  | 'method'
  | 'price'
  | PaymentTypeKeySpecifier
)[];
export type PaymentTypeFieldPolicy = {
  account?: FieldPolicy<any> | FieldReadFunction<any>;
  currency?: FieldPolicy<any> | FieldReadFunction<any>;
  method?: FieldPolicy<any> | FieldReadFunction<any>;
  price?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PaymentsContextKeySpecifier = (
  | 'familyData'
  | 'plusServiceData'
  | 'services'
  | PaymentsContextKeySpecifier
)[];
export type PaymentsContextFieldPolicy = {
  familyData?: FieldPolicy<any> | FieldReadFunction<any>;
  plusServiceData?: FieldPolicy<any> | FieldReadFunction<any>;
  services?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PaymentsDataKeySpecifier = ('edges' | 'pageInfo' | PaymentsDataKeySpecifier)[];
export type PaymentsDataFieldPolicy = {
  edges?: FieldPolicy<any> | FieldReadFunction<any>;
  pageInfo?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PhoneKeySpecifier = (
  | 'id'
  | 'isDefault'
  | 'isPrimary'
  | 'number'
  | 'operation'
  | PhoneKeySpecifier
)[];
export type PhoneFieldPolicy = {
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  isDefault?: FieldPolicy<any> | FieldReadFunction<any>;
  isPrimary?: FieldPolicy<any> | FieldReadFunction<any>;
  number?: FieldPolicy<any> | FieldReadFunction<any>;
  operation?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PhoneOperationKeySpecifier = (
  | 'finishedAt'
  | 'id'
  | 'inQuarantine'
  | 'isOwner'
  | 'startedAt'
  | 'type'
  | PhoneOperationKeySpecifier
)[];
export type PhoneOperationFieldPolicy = {
  finishedAt?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  inQuarantine?: FieldPolicy<any> | FieldReadFunction<any>;
  isOwner?: FieldPolicy<any> | FieldReadFunction<any>;
  startedAt?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PlusServiceKeySpecifier = (
  | 'iconUrl'
  | 'serviceName'
  | 'splashUrl'
  | PlusServiceKeySpecifier
)[];
export type PlusServiceFieldPolicy = {
  iconUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  serviceName?: FieldPolicy<any> | FieldReadFunction<any>;
  splashUrl?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ProfileFieldValidationResultKeySpecifier = (
  | 'code'
  | ProfileFieldValidationResultKeySpecifier
)[];
export type ProfileFieldValidationResultFieldPolicy = {
  code?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ProfileUpdatePayloadKeySpecifier = ('query' | ProfileUpdatePayloadKeySpecifier)[];
export type ProfileUpdatePayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ProfileUpdateProblemKeySpecifier = ('reason' | ProfileUpdateProblemKeySpecifier)[];
export type ProfileUpdateProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PublicIdSuggestPayloadKeySpecifier = (
  | 'logins'
  | 'trackId'
  | PublicIdSuggestPayloadKeySpecifier
)[];
export type PublicIdSuggestPayloadFieldPolicy = {
  logins?: FieldPolicy<any> | FieldReadFunction<any>;
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PublicIdSuggestProblemKeySpecifier = ('reason' | PublicIdSuggestProblemKeySpecifier)[];
export type PublicIdSuggestProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PublicIdUpdatePayloadKeySpecifier = ('query' | PublicIdUpdatePayloadKeySpecifier)[];
export type PublicIdUpdatePayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PublicIdUpdateProblemKeySpecifier = ('reason' | PublicIdUpdateProblemKeySpecifier)[];
export type PublicIdUpdateProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PublicIdValidatePayloadKeySpecifier = (
  | 'trackId'
  | PublicIdValidatePayloadKeySpecifier
)[];
export type PublicIdValidatePayloadFieldPolicy = {
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type PublicIdValidateProblemKeySpecifier = (
  | 'reason'
  | PublicIdValidateProblemKeySpecifier
)[];
export type PublicIdValidateProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type QueryKeySpecifier = (
  | 'account'
  | 'accountAvailableQuestions'
  | 'accountBankCards'
  | 'addresses'
  | 'bills'
  | 'billsDocuments'
  | 'document'
  | 'documents'
  | 'edadealData'
  | 'externalAccountProviders'
  | 'externalAccounts'
  | 'family'
  | 'findDocuments'
  | 'futurePayments'
  | 'locationOptions'
  | 'paymentById'
  | 'paymentsContext'
  | 'paymentsData'
  | 'receiptsByToken'
  | 'viewer'
  | QueryKeySpecifier
)[];
export type QueryFieldPolicy = {
  account?: FieldPolicy<any> | FieldReadFunction<any>;
  accountAvailableQuestions?: FieldPolicy<any> | FieldReadFunction<any>;
  accountBankCards?: FieldPolicy<any> | FieldReadFunction<any>;
  addresses?: FieldPolicy<any> | FieldReadFunction<any>;
  bills?: FieldPolicy<any> | FieldReadFunction<any>;
  billsDocuments?: FieldPolicy<any> | FieldReadFunction<any>;
  document?: FieldPolicy<any> | FieldReadFunction<any>;
  documents?: FieldPolicy<any> | FieldReadFunction<any>;
  edadealData?: FieldPolicy<any> | FieldReadFunction<any>;
  externalAccountProviders?: FieldPolicy<any> | FieldReadFunction<any>;
  externalAccounts?: FieldPolicy<any> | FieldReadFunction<any>;
  family?: FieldPolicy<any> | FieldReadFunction<any>;
  findDocuments?: FieldPolicy<any> | FieldReadFunction<any>;
  futurePayments?: FieldPolicy<any> | FieldReadFunction<any>;
  locationOptions?: FieldPolicy<any> | FieldReadFunction<any>;
  paymentById?: FieldPolicy<any> | FieldReadFunction<any>;
  paymentsContext?: FieldPolicy<any> | FieldReadFunction<any>;
  paymentsData?: FieldPolicy<any> | FieldReadFunction<any>;
  receiptsByToken?: FieldPolicy<any> | FieldReadFunction<any>;
  viewer?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type QuestionKeySpecifier = ('id' | 'text' | QuestionKeySpecifier)[];
export type QuestionFieldPolicy = {
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  text?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ReceiptKeySpecifier = ('amount' | 'timestamp' | 'type' | 'url' | ReceiptKeySpecifier)[];
export type ReceiptFieldPolicy = {
  amount?: FieldPolicy<any> | FieldReadFunction<any>;
  timestamp?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  url?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type RemoveRecoveryEmailPayloadKeySpecifier = (
  | 'query'
  | RemoveRecoveryEmailPayloadKeySpecifier
)[];
export type RemoveRecoveryEmailPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type RemoveRecoveryEmailProblemKeySpecifier = (
  | 'reason'
  | 'trackId'
  | RemoveRecoveryEmailProblemKeySpecifier
)[];
export type RemoveRecoveryEmailProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type RestrictionKeySpecifier = (
  | 'allowAllServices'
  | 'balance'
  | 'enabled'
  | 'hasSecurePhone'
  | 'limit'
  | 'limitCurrency'
  | 'uid'
  | 'unlim'
  | RestrictionKeySpecifier
)[];
export type RestrictionFieldPolicy = {
  allowAllServices?: FieldPolicy<any> | FieldReadFunction<any>;
  balance?: FieldPolicy<any> | FieldReadFunction<any>;
  enabled?: FieldPolicy<any> | FieldReadFunction<any>;
  hasSecurePhone?: FieldPolicy<any> | FieldReadFunction<any>;
  limit?: FieldPolicy<any> | FieldReadFunction<any>;
  limitCurrency?: FieldPolicy<any> | FieldReadFunction<any>;
  uid?: FieldPolicy<any> | FieldReadFunction<any>;
  unlim?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type SendCodeToBindPrimaryPhonePayloadKeySpecifier = (
  | 'expiryTimestamp'
  | 'number'
  | 'trackId'
  | SendCodeToBindPrimaryPhonePayloadKeySpecifier
)[];
export type SendCodeToBindPrimaryPhonePayloadFieldPolicy = {
  expiryTimestamp?: FieldPolicy<any> | FieldReadFunction<any>;
  number?: FieldPolicy<any> | FieldReadFunction<any>;
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type SendCodeToBindPrimaryPhoneProblemKeySpecifier = (
  | 'reason'
  | SendCodeToBindPrimaryPhoneProblemKeySpecifier
)[];
export type SendCodeToBindPrimaryPhoneProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type SendCodeToConfirmPhonePayloadKeySpecifier = (
  | 'expiryTimestamp'
  | 'number'
  | 'trackId'
  | SendCodeToConfirmPhonePayloadKeySpecifier
)[];
export type SendCodeToConfirmPhonePayloadFieldPolicy = {
  expiryTimestamp?: FieldPolicy<any> | FieldReadFunction<any>;
  number?: FieldPolicy<any> | FieldReadFunction<any>;
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type SendCodeToConfirmPhoneProblemKeySpecifier = (
  | 'reason'
  | SendCodeToConfirmPhoneProblemKeySpecifier
)[];
export type SendCodeToConfirmPhoneProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ServiceKeySpecifier = (
  | 'help'
  | 'i18nKeyName'
  | 'iconUrl'
  | 'id'
  | 'name'
  | 'splashUrl'
  | 'url'
  | ServiceKeySpecifier
)[];
export type ServiceFieldPolicy = {
  help?: FieldPolicy<any> | FieldReadFunction<any>;
  i18nKeyName?: FieldPolicy<any> | FieldReadFunction<any>;
  iconUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
  splashUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  url?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type SetQuestionPayloadKeySpecifier = ('query' | SetQuestionPayloadKeySpecifier)[];
export type SetQuestionPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type SetQuestionProblemKeySpecifier = (
  | 'reason'
  | 'trackId'
  | SetQuestionProblemKeySpecifier
)[];
export type SetQuestionProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type SnilsDocumentKeySpecifier = (
  | 'birthDate'
  | 'birthPlace'
  | 'docNumber'
  | 'firstName'
  | 'gender'
  | 'id'
  | 'images'
  | 'issueDate'
  | 'lastName'
  | 'middleName'
  | 'originalUrl'
  | 'previewUrl'
  | 'section'
  | 'type'
  | 'verificationStatus'
  | SnilsDocumentKeySpecifier
)[];
export type SnilsDocumentFieldPolicy = {
  birthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  birthPlace?: FieldPolicy<any> | FieldReadFunction<any>;
  docNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  gender?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  issueDate?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  middleName?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type StartOrderBillResponseKeySpecifier = (
  | 'transaction'
  | StartOrderBillResponseKeySpecifier
)[];
export type StartOrderBillResponseFieldPolicy = {
  transaction?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type TimezoneOptionKeySpecifier = ('code' | 'name' | TimezoneOptionKeySpecifier)[];
export type TimezoneOptionFieldPolicy = {
  code?: FieldPolicy<any> | FieldReadFunction<any>;
  name?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ToggleLoginWithExternalAccountPayloadKeySpecifier = (
  | 'query'
  | ToggleLoginWithExternalAccountPayloadKeySpecifier
)[];
export type ToggleLoginWithExternalAccountPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ToggleLoginWithExternalAccountProblemKeySpecifier = (
  | 'reason'
  | ToggleLoginWithExternalAccountProblemKeySpecifier
)[];
export type ToggleLoginWithExternalAccountProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ToggleLoginWithPasswordAndSmsPayloadKeySpecifier = (
  | 'account'
  | ToggleLoginWithPasswordAndSmsPayloadKeySpecifier
)[];
export type ToggleLoginWithPasswordAndSmsPayloadFieldPolicy = {
  account?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ToggleLoginWithPasswordAndSmsProblemKeySpecifier = (
  | 'reason'
  | ToggleLoginWithPasswordAndSmsProblemKeySpecifier
)[];
export type ToggleLoginWithPasswordAndSmsProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type TrancsactionKeySpecifier = (
  | 'acs_url'
  | 'amount'
  | 'created'
  | 'mpi_3ds_info'
  | 'order_id'
  | 'payer_full_name'
  | 'payment_method'
  | 'payment_token'
  | 'return_url'
  | 'status'
  | 'transaction_id'
  | 'updated'
  | TrancsactionKeySpecifier
)[];
export type TrancsactionFieldPolicy = {
  acs_url?: FieldPolicy<any> | FieldReadFunction<any>;
  amount?: FieldPolicy<any> | FieldReadFunction<any>;
  created?: FieldPolicy<any> | FieldReadFunction<any>;
  mpi_3ds_info?: FieldPolicy<any> | FieldReadFunction<any>;
  order_id?: FieldPolicy<any> | FieldReadFunction<any>;
  payer_full_name?: FieldPolicy<any> | FieldReadFunction<any>;
  payment_method?: FieldPolicy<any> | FieldReadFunction<any>;
  payment_token?: FieldPolicy<any> | FieldReadFunction<any>;
  return_url?: FieldPolicy<any> | FieldReadFunction<any>;
  status?: FieldPolicy<any> | FieldReadFunction<any>;
  transaction_id?: FieldPolicy<any> | FieldReadFunction<any>;
  updated?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type UnbindExternalAccountPayloadKeySpecifier = (
  | 'query'
  | UnbindExternalAccountPayloadKeySpecifier
)[];
export type UnbindExternalAccountPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type UnbindExternalAccountProblemKeySpecifier = (
  | 'reason'
  | UnbindExternalAccountProblemKeySpecifier
)[];
export type UnbindExternalAccountProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type UpdateDocumentPayloadKeySpecifier = ('query' | UpdateDocumentPayloadKeySpecifier)[];
export type UpdateDocumentPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type UpdateDocumentProblemKeySpecifier = ('reason' | UpdateDocumentProblemKeySpecifier)[];
export type UpdateDocumentProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type UpdatePersonalInfoPayloadKeySpecifier = (
  | 'query'
  | UpdatePersonalInfoPayloadKeySpecifier
)[];
export type UpdatePersonalInfoPayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type UpdatePersonalInfoProblemKeySpecifier = (
  | 'reason'
  | UpdatePersonalInfoProblemKeySpecifier
)[];
export type UpdatePersonalInfoProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type VehicleRegistrationCertificateDocumentKeySpecifier = (
  | 'additionalInformation'
  | 'bodyNumber'
  | 'carNumber'
  | 'category'
  | 'color'
  | 'docNumber'
  | 'ecoClass'
  | 'firstName'
  | 'firstNameLat'
  | 'id'
  | 'images'
  | 'issueDate'
  | 'issuerSubdivisionCode'
  | 'lastName'
  | 'lastNameLat'
  | 'maxWeight'
  | 'middleName'
  | 'model'
  | 'modelLat'
  | 'originalUrl'
  | 'power'
  | 'previewUrl'
  | 'pts'
  | 'registrationAddress'
  | 'section'
  | 'shasiNumber'
  | 'temporaryReg'
  | 'type'
  | 'vehicleType'
  | 'verificationStatus'
  | 'vin'
  | 'withoutLoadWeight'
  | 'year'
  | VehicleRegistrationCertificateDocumentKeySpecifier
)[];
export type VehicleRegistrationCertificateDocumentFieldPolicy = {
  additionalInformation?: FieldPolicy<any> | FieldReadFunction<any>;
  bodyNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  carNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  category?: FieldPolicy<any> | FieldReadFunction<any>;
  color?: FieldPolicy<any> | FieldReadFunction<any>;
  docNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  ecoClass?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  firstNameLat?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  issueDate?: FieldPolicy<any> | FieldReadFunction<any>;
  issuerSubdivisionCode?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  lastNameLat?: FieldPolicy<any> | FieldReadFunction<any>;
  maxWeight?: FieldPolicy<any> | FieldReadFunction<any>;
  middleName?: FieldPolicy<any> | FieldReadFunction<any>;
  model?: FieldPolicy<any> | FieldReadFunction<any>;
  modelLat?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  power?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  pts?: FieldPolicy<any> | FieldReadFunction<any>;
  registrationAddress?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  shasiNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  temporaryReg?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  vehicleType?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
  vin?: FieldPolicy<any> | FieldReadFunction<any>;
  withoutLoadWeight?: FieldPolicy<any> | FieldReadFunction<any>;
  year?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type VerifyCodeToBindPrimaryPhonePayloadKeySpecifier = (
  | 'query'
  | 'trackId'
  | VerifyCodeToBindPrimaryPhonePayloadKeySpecifier
)[];
export type VerifyCodeToBindPrimaryPhonePayloadFieldPolicy = {
  query?: FieldPolicy<any> | FieldReadFunction<any>;
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type VerifyCodeToBindPrimaryPhoneProblemKeySpecifier = (
  | 'reason'
  | VerifyCodeToBindPrimaryPhoneProblemKeySpecifier
)[];
export type VerifyCodeToBindPrimaryPhoneProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type VerifyCodeToConfirmPhonePayloadKeySpecifier = (
  | 'trackId'
  | VerifyCodeToConfirmPhonePayloadKeySpecifier
)[];
export type VerifyCodeToConfirmPhonePayloadFieldPolicy = {
  trackId?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type VerifyCodeToConfirmPhoneProblemKeySpecifier = (
  | 'reason'
  | VerifyCodeToConfirmPhoneProblemKeySpecifier
)[];
export type VerifyCodeToConfirmPhoneProblemFieldPolicy = {
  reason?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type ViewerKeySpecifier = (
  | 'avatarId'
  | 'birthdate'
  | 'city'
  | 'country'
  | 'displayName'
  | 'firstName'
  | 'fullName'
  | 'gender'
  | 'hasFamilyPlus'
  | 'hasPublicIdSet'
  | 'havePlus'
  | 'id'
  | 'isChild'
  | 'lastName'
  | 'publicId'
  | 'timezone'
  | ViewerKeySpecifier
)[];
export type ViewerFieldPolicy = {
  avatarId?: FieldPolicy<any> | FieldReadFunction<any>;
  birthdate?: FieldPolicy<any> | FieldReadFunction<any>;
  city?: FieldPolicy<any> | FieldReadFunction<any>;
  country?: FieldPolicy<any> | FieldReadFunction<any>;
  displayName?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  fullName?: FieldPolicy<any> | FieldReadFunction<any>;
  gender?: FieldPolicy<any> | FieldReadFunction<any>;
  hasFamilyPlus?: FieldPolicy<any> | FieldReadFunction<any>;
  hasPublicIdSet?: FieldPolicy<any> | FieldReadFunction<any>;
  havePlus?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  isChild?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  publicId?: FieldPolicy<any> | FieldReadFunction<any>;
  timezone?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type VoluntaryMedicalInsuranceDocumentKeySpecifier = (
  | 'birthDate'
  | 'docNumber'
  | 'endDate'
  | 'firstName'
  | 'gender'
  | 'id'
  | 'images'
  | 'insurerOrg'
  | 'issueDate'
  | 'lastName'
  | 'middleName'
  | 'originalUrl'
  | 'previewUrl'
  | 'section'
  | 'type'
  | 'verificationStatus'
  | VoluntaryMedicalInsuranceDocumentKeySpecifier
)[];
export type VoluntaryMedicalInsuranceDocumentFieldPolicy = {
  birthDate?: FieldPolicy<any> | FieldReadFunction<any>;
  docNumber?: FieldPolicy<any> | FieldReadFunction<any>;
  endDate?: FieldPolicy<any> | FieldReadFunction<any>;
  firstName?: FieldPolicy<any> | FieldReadFunction<any>;
  gender?: FieldPolicy<any> | FieldReadFunction<any>;
  id?: FieldPolicy<any> | FieldReadFunction<any>;
  images?: FieldPolicy<any> | FieldReadFunction<any>;
  insurerOrg?: FieldPolicy<any> | FieldReadFunction<any>;
  issueDate?: FieldPolicy<any> | FieldReadFunction<any>;
  lastName?: FieldPolicy<any> | FieldReadFunction<any>;
  middleName?: FieldPolicy<any> | FieldReadFunction<any>;
  originalUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  previewUrl?: FieldPolicy<any> | FieldReadFunction<any>;
  section?: FieldPolicy<any> | FieldReadFunction<any>;
  type?: FieldPolicy<any> | FieldReadFunction<any>;
  verificationStatus?: FieldPolicy<any> | FieldReadFunction<any>;
};
export type StrictTypedTypePolicies = {
  Account?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | AccountKeySpecifier | (() => undefined | AccountKeySpecifier);
    fields?: AccountFieldPolicy;
  };
  AccountCreateBindBankCardResponse?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | AccountCreateBindBankCardResponseKeySpecifier
      | (() => undefined | AccountCreateBindBankCardResponseKeySpecifier);
    fields?: AccountCreateBindBankCardResponseFieldPolicy;
  };
  AccountUnbindBankdCardResponse?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | AccountUnbindBankdCardResponseKeySpecifier
      | (() => undefined | AccountUnbindBankdCardResponseKeySpecifier);
    fields?: AccountUnbindBankdCardResponseFieldPolicy;
  };
  AddDocumentPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | AddDocumentPayloadKeySpecifier
      | (() => undefined | AddDocumentPayloadKeySpecifier);
    fields?: AddDocumentPayloadFieldPolicy;
  };
  AddDocumentProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | AddDocumentProblemKeySpecifier
      | (() => undefined | AddDocumentProblemKeySpecifier);
    fields?: AddDocumentProblemFieldPolicy;
  };
  AddRecoveryEmailPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | AddRecoveryEmailPayloadKeySpecifier
      | (() => undefined | AddRecoveryEmailPayloadKeySpecifier);
    fields?: AddRecoveryEmailPayloadFieldPolicy;
  };
  AddRecoveryEmailProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | AddRecoveryEmailProblemKeySpecifier
      | (() => undefined | AddRecoveryEmailProblemKeySpecifier);
    fields?: AddRecoveryEmailProblemFieldPolicy;
  };
  Address?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | AddressKeySpecifier | (() => undefined | AddressKeySpecifier);
    fields?: AddressFieldPolicy;
  };
  AvailableQuestion?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | AvailableQuestionKeySpecifier
      | (() => undefined | AvailableQuestionKeySpecifier);
    fields?: AvailableQuestionFieldPolicy;
  };
  BankCard?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | BankCardKeySpecifier | (() => undefined | BankCardKeySpecifier);
    fields?: BankCardFieldPolicy;
  };
  BankCardsData?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | BankCardsDataKeySpecifier | (() => undefined | BankCardsDataKeySpecifier);
    fields?: BankCardsDataFieldPolicy;
  };
  Bill?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | BillKeySpecifier | (() => undefined | BillKeySpecifier);
    fields?: BillFieldPolicy;
  };
  BillTransactionResponse?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | BillTransactionResponseKeySpecifier
      | (() => undefined | BillTransactionResponseKeySpecifier);
    fields?: BillTransactionResponseFieldPolicy;
  };
  BillsData?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | BillsDataKeySpecifier | (() => undefined | BillsDataKeySpecifier);
    fields?: BillsDataFieldPolicy;
  };
  BillsDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | BillsDocumentKeySpecifier | (() => undefined | BillsDocumentKeySpecifier);
    fields?: BillsDocumentFieldPolicy;
  };
  BirthCertificateDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | BirthCertificateDocumentKeySpecifier
      | (() => undefined | BirthCertificateDocumentKeySpecifier);
    fields?: BirthCertificateDocumentFieldPolicy;
  };
  CardInfo?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | CardInfoKeySpecifier | (() => undefined | CardInfoKeySpecifier);
    fields?: CardInfoFieldPolicy;
  };
  ConfirmByPasswordPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ConfirmByPasswordPayloadKeySpecifier
      | (() => undefined | ConfirmByPasswordPayloadKeySpecifier);
    fields?: ConfirmByPasswordPayloadFieldPolicy;
  };
  ConfirmByPasswordProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ConfirmByPasswordProblemKeySpecifier
      | (() => undefined | ConfirmByPasswordProblemKeySpecifier);
    fields?: ConfirmByPasswordProblemFieldPolicy;
  };
  ConfirmRecoveryEmailByCodePayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ConfirmRecoveryEmailByCodePayloadKeySpecifier
      | (() => undefined | ConfirmRecoveryEmailByCodePayloadKeySpecifier);
    fields?: ConfirmRecoveryEmailByCodePayloadFieldPolicy;
  };
  ConfirmRecoveryEmailByCodeProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ConfirmRecoveryEmailByCodeProblemKeySpecifier
      | (() => undefined | ConfirmRecoveryEmailByCodeProblemKeySpecifier);
    fields?: ConfirmRecoveryEmailByCodeProblemFieldPolicy;
  };
  ConfirmRecoveryEmailByLinkPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ConfirmRecoveryEmailByLinkPayloadKeySpecifier
      | (() => undefined | ConfirmRecoveryEmailByLinkPayloadKeySpecifier);
    fields?: ConfirmRecoveryEmailByLinkPayloadFieldPolicy;
  };
  ConfirmRecoveryEmailByLinkProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ConfirmRecoveryEmailByLinkProblemKeySpecifier
      | (() => undefined | ConfirmRecoveryEmailByLinkProblemKeySpecifier);
    fields?: ConfirmRecoveryEmailByLinkProblemFieldPolicy;
  };
  CopyDocumentsFromDiskPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | CopyDocumentsFromDiskPayloadKeySpecifier
      | (() => undefined | CopyDocumentsFromDiskPayloadKeySpecifier);
    fields?: CopyDocumentsFromDiskPayloadFieldPolicy;
  };
  CountryOption?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | CountryOptionKeySpecifier | (() => undefined | CountryOptionKeySpecifier);
    fields?: CountryOptionFieldPolicy;
  };
  CreateOrUpdateAddressPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | CreateOrUpdateAddressPayloadKeySpecifier
      | (() => undefined | CreateOrUpdateAddressPayloadKeySpecifier);
    fields?: CreateOrUpdateAddressPayloadFieldPolicy;
  };
  CreateOrUpdateAddressProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | CreateOrUpdateAddressProblemKeySpecifier
      | (() => undefined | CreateOrUpdateAddressProblemKeySpecifier);
    fields?: CreateOrUpdateAddressProblemFieldPolicy;
  };
  CreateOrderResponse?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | CreateOrderResponseKeySpecifier
      | (() => undefined | CreateOrderResponseKeySpecifier);
    fields?: CreateOrderResponseFieldPolicy;
  };
  DefaultResponse?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | DefaultResponseKeySpecifier
      | (() => undefined | DefaultResponseKeySpecifier);
    fields?: DefaultResponseFieldPolicy;
  };
  DeleteAddressPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | DeleteAddressPayloadKeySpecifier
      | (() => undefined | DeleteAddressPayloadKeySpecifier);
    fields?: DeleteAddressPayloadFieldPolicy;
  };
  DeleteAddressProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | DeleteAddressProblemKeySpecifier
      | (() => undefined | DeleteAddressProblemKeySpecifier);
    fields?: DeleteAddressProblemFieldPolicy;
  };
  DeleteDocumentPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | DeleteDocumentPayloadKeySpecifier
      | (() => undefined | DeleteDocumentPayloadKeySpecifier);
    fields?: DeleteDocumentPayloadFieldPolicy;
  };
  DeleteDocumentProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | DeleteDocumentProblemKeySpecifier
      | (() => undefined | DeleteDocumentProblemKeySpecifier);
    fields?: DeleteDocumentProblemFieldPolicy;
  };
  DisableLoginWithQRPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | DisableLoginWithQRPayloadKeySpecifier
      | (() => undefined | DisableLoginWithQRPayloadKeySpecifier);
    fields?: DisableLoginWithQRPayloadFieldPolicy;
  };
  DiskItem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | DiskItemKeySpecifier | (() => undefined | DiskItemKeySpecifier);
    fields?: DiskItemFieldPolicy;
  };
  DisplayName?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | DisplayNameKeySpecifier | (() => undefined | DisplayNameKeySpecifier);
    fields?: DisplayNameFieldPolicy;
  };
  DocumentByIdProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | DocumentByIdProblemKeySpecifier
      | (() => undefined | DocumentByIdProblemKeySpecifier);
    fields?: DocumentByIdProblemFieldPolicy;
  };
  DocumentImage?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | DocumentImageKeySpecifier | (() => undefined | DocumentImageKeySpecifier);
    fields?: DocumentImageFieldPolicy;
  };
  DriverLicenseDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | DriverLicenseDocumentKeySpecifier
      | (() => undefined | DriverLicenseDocumentKeySpecifier);
    fields?: DriverLicenseDocumentFieldPolicy;
  };
  EdadealData?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | EdadealDataKeySpecifier | (() => undefined | EdadealDataKeySpecifier);
    fields?: EdadealDataFieldPolicy;
  };
  Email?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | EmailKeySpecifier | (() => undefined | EmailKeySpecifier);
    fields?: EmailFieldPolicy;
  };
  EnableLoginWithQRPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | EnableLoginWithQRPayloadKeySpecifier
      | (() => undefined | EnableLoginWithQRPayloadKeySpecifier);
    fields?: EnableLoginWithQRPayloadFieldPolicy;
  };
  ExternalAccount?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ExternalAccountKeySpecifier
      | (() => undefined | ExternalAccountKeySpecifier);
    fields?: ExternalAccountFieldPolicy;
  };
  ExternalAccountProvider?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ExternalAccountProviderKeySpecifier
      | (() => undefined | ExternalAccountProviderKeySpecifier);
    fields?: ExternalAccountProviderFieldPolicy;
  };
  Family?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | FamilyKeySpecifier | (() => undefined | FamilyKeySpecifier);
    fields?: FamilyFieldPolicy;
  };
  FamilyInfo?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | FamilyInfoKeySpecifier | (() => undefined | FamilyInfoKeySpecifier);
    fields?: FamilyInfoFieldPolicy;
  };
  FamilyInvite?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | FamilyInviteKeySpecifier | (() => undefined | FamilyInviteKeySpecifier);
    fields?: FamilyInviteFieldPolicy;
  };
  FamilyKid?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | FamilyKidKeySpecifier | (() => undefined | FamilyKidKeySpecifier);
    fields?: FamilyKidFieldPolicy;
  };
  FamilyMember?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | FamilyMemberKeySpecifier | (() => undefined | FamilyMemberKeySpecifier);
    fields?: FamilyMemberFieldPolicy;
  };
  FamilyPay?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | FamilyPayKeySpecifier | (() => undefined | FamilyPayKeySpecifier);
    fields?: FamilyPayFieldPolicy;
  };
  FamilySettings?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | FamilySettingsKeySpecifier | (() => undefined | FamilySettingsKeySpecifier);
    fields?: FamilySettingsFieldPolicy;
  };
  FamilyUser?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | FamilyUserKeySpecifier | (() => undefined | FamilyUserKeySpecifier);
    fields?: FamilyUserFieldPolicy;
  };
  FuturePayment?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | FuturePaymentKeySpecifier | (() => undefined | FuturePaymentKeySpecifier);
    fields?: FuturePaymentFieldPolicy;
  };
  IDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | IDocumentKeySpecifier | (() => undefined | IDocumentKeySpecifier);
    fields?: IDocumentFieldPolicy;
  };
  InnDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | InnDocumentKeySpecifier | (() => undefined | InnDocumentKeySpecifier);
    fields?: InnDocumentFieldPolicy;
  };
  InternationalIdDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | InternationalIdDocumentKeySpecifier
      | (() => undefined | InternationalIdDocumentKeySpecifier);
    fields?: InternationalIdDocumentFieldPolicy;
  };
  Limit?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | LimitKeySpecifier | (() => undefined | LimitKeySpecifier);
    fields?: LimitFieldPolicy;
  };
  LocationsOptions?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | LocationsOptionsKeySpecifier
      | (() => undefined | LocationsOptionsKeySpecifier);
    fields?: LocationsOptionsFieldPolicy;
  };
  MedicalInsuranceDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | MedicalInsuranceDocumentKeySpecifier
      | (() => undefined | MedicalInsuranceDocumentKeySpecifier);
    fields?: MedicalInsuranceDocumentFieldPolicy;
  };
  Mpi3dsInfo?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | Mpi3dsInfoKeySpecifier | (() => undefined | Mpi3dsInfoKeySpecifier);
    fields?: Mpi3dsInfoFieldPolicy;
  };
  Mutation?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | MutationKeySpecifier | (() => undefined | MutationKeySpecifier);
    fields?: MutationFieldPolicy;
  };
  NationalIdDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | NationalIdDocumentKeySpecifier
      | (() => undefined | NationalIdDocumentKeySpecifier);
    fields?: NationalIdDocumentFieldPolicy;
  };
  PageInfo?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PageInfoKeySpecifier | (() => undefined | PageInfoKeySpecifier);
    fields?: PageInfoFieldPolicy;
  };
  PasswordInfo?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PasswordInfoKeySpecifier | (() => undefined | PasswordInfoKeySpecifier);
    fields?: PasswordInfoFieldPolicy;
  };
  Payment?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PaymentKeySpecifier | (() => undefined | PaymentKeySpecifier);
    fields?: PaymentFieldPolicy;
  };
  PaymentItem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PaymentItemKeySpecifier | (() => undefined | PaymentItemKeySpecifier);
    fields?: PaymentItemFieldPolicy;
  };
  PaymentRefund?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PaymentRefundKeySpecifier | (() => undefined | PaymentRefundKeySpecifier);
    fields?: PaymentRefundFieldPolicy;
  };
  PaymentType?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PaymentTypeKeySpecifier | (() => undefined | PaymentTypeKeySpecifier);
    fields?: PaymentTypeFieldPolicy;
  };
  PaymentsContext?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | PaymentsContextKeySpecifier
      | (() => undefined | PaymentsContextKeySpecifier);
    fields?: PaymentsContextFieldPolicy;
  };
  PaymentsData?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PaymentsDataKeySpecifier | (() => undefined | PaymentsDataKeySpecifier);
    fields?: PaymentsDataFieldPolicy;
  };
  Phone?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PhoneKeySpecifier | (() => undefined | PhoneKeySpecifier);
    fields?: PhoneFieldPolicy;
  };
  PhoneOperation?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PhoneOperationKeySpecifier | (() => undefined | PhoneOperationKeySpecifier);
    fields?: PhoneOperationFieldPolicy;
  };
  PlusService?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | PlusServiceKeySpecifier | (() => undefined | PlusServiceKeySpecifier);
    fields?: PlusServiceFieldPolicy;
  };
  ProfileFieldValidationResult?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ProfileFieldValidationResultKeySpecifier
      | (() => undefined | ProfileFieldValidationResultKeySpecifier);
    fields?: ProfileFieldValidationResultFieldPolicy;
  };
  ProfileUpdatePayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ProfileUpdatePayloadKeySpecifier
      | (() => undefined | ProfileUpdatePayloadKeySpecifier);
    fields?: ProfileUpdatePayloadFieldPolicy;
  };
  ProfileUpdateProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ProfileUpdateProblemKeySpecifier
      | (() => undefined | ProfileUpdateProblemKeySpecifier);
    fields?: ProfileUpdateProblemFieldPolicy;
  };
  PublicIdSuggestPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | PublicIdSuggestPayloadKeySpecifier
      | (() => undefined | PublicIdSuggestPayloadKeySpecifier);
    fields?: PublicIdSuggestPayloadFieldPolicy;
  };
  PublicIdSuggestProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | PublicIdSuggestProblemKeySpecifier
      | (() => undefined | PublicIdSuggestProblemKeySpecifier);
    fields?: PublicIdSuggestProblemFieldPolicy;
  };
  PublicIdUpdatePayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | PublicIdUpdatePayloadKeySpecifier
      | (() => undefined | PublicIdUpdatePayloadKeySpecifier);
    fields?: PublicIdUpdatePayloadFieldPolicy;
  };
  PublicIdUpdateProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | PublicIdUpdateProblemKeySpecifier
      | (() => undefined | PublicIdUpdateProblemKeySpecifier);
    fields?: PublicIdUpdateProblemFieldPolicy;
  };
  PublicIdValidatePayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | PublicIdValidatePayloadKeySpecifier
      | (() => undefined | PublicIdValidatePayloadKeySpecifier);
    fields?: PublicIdValidatePayloadFieldPolicy;
  };
  PublicIdValidateProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | PublicIdValidateProblemKeySpecifier
      | (() => undefined | PublicIdValidateProblemKeySpecifier);
    fields?: PublicIdValidateProblemFieldPolicy;
  };
  Query?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | QueryKeySpecifier | (() => undefined | QueryKeySpecifier);
    fields?: QueryFieldPolicy;
  };
  Question?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | QuestionKeySpecifier | (() => undefined | QuestionKeySpecifier);
    fields?: QuestionFieldPolicy;
  };
  Receipt?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | ReceiptKeySpecifier | (() => undefined | ReceiptKeySpecifier);
    fields?: ReceiptFieldPolicy;
  };
  RemoveRecoveryEmailPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | RemoveRecoveryEmailPayloadKeySpecifier
      | (() => undefined | RemoveRecoveryEmailPayloadKeySpecifier);
    fields?: RemoveRecoveryEmailPayloadFieldPolicy;
  };
  RemoveRecoveryEmailProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | RemoveRecoveryEmailProblemKeySpecifier
      | (() => undefined | RemoveRecoveryEmailProblemKeySpecifier);
    fields?: RemoveRecoveryEmailProblemFieldPolicy;
  };
  Restriction?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | RestrictionKeySpecifier | (() => undefined | RestrictionKeySpecifier);
    fields?: RestrictionFieldPolicy;
  };
  SendCodeToBindPrimaryPhonePayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | SendCodeToBindPrimaryPhonePayloadKeySpecifier
      | (() => undefined | SendCodeToBindPrimaryPhonePayloadKeySpecifier);
    fields?: SendCodeToBindPrimaryPhonePayloadFieldPolicy;
  };
  SendCodeToBindPrimaryPhoneProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | SendCodeToBindPrimaryPhoneProblemKeySpecifier
      | (() => undefined | SendCodeToBindPrimaryPhoneProblemKeySpecifier);
    fields?: SendCodeToBindPrimaryPhoneProblemFieldPolicy;
  };
  SendCodeToConfirmPhonePayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | SendCodeToConfirmPhonePayloadKeySpecifier
      | (() => undefined | SendCodeToConfirmPhonePayloadKeySpecifier);
    fields?: SendCodeToConfirmPhonePayloadFieldPolicy;
  };
  SendCodeToConfirmPhoneProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | SendCodeToConfirmPhoneProblemKeySpecifier
      | (() => undefined | SendCodeToConfirmPhoneProblemKeySpecifier);
    fields?: SendCodeToConfirmPhoneProblemFieldPolicy;
  };
  Service?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | ServiceKeySpecifier | (() => undefined | ServiceKeySpecifier);
    fields?: ServiceFieldPolicy;
  };
  SetQuestionPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | SetQuestionPayloadKeySpecifier
      | (() => undefined | SetQuestionPayloadKeySpecifier);
    fields?: SetQuestionPayloadFieldPolicy;
  };
  SetQuestionProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | SetQuestionProblemKeySpecifier
      | (() => undefined | SetQuestionProblemKeySpecifier);
    fields?: SetQuestionProblemFieldPolicy;
  };
  SnilsDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | SnilsDocumentKeySpecifier | (() => undefined | SnilsDocumentKeySpecifier);
    fields?: SnilsDocumentFieldPolicy;
  };
  StartOrderBillResponse?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | StartOrderBillResponseKeySpecifier
      | (() => undefined | StartOrderBillResponseKeySpecifier);
    fields?: StartOrderBillResponseFieldPolicy;
  };
  TimezoneOption?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | TimezoneOptionKeySpecifier | (() => undefined | TimezoneOptionKeySpecifier);
    fields?: TimezoneOptionFieldPolicy;
  };
  ToggleLoginWithExternalAccountPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ToggleLoginWithExternalAccountPayloadKeySpecifier
      | (() => undefined | ToggleLoginWithExternalAccountPayloadKeySpecifier);
    fields?: ToggleLoginWithExternalAccountPayloadFieldPolicy;
  };
  ToggleLoginWithExternalAccountProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ToggleLoginWithExternalAccountProblemKeySpecifier
      | (() => undefined | ToggleLoginWithExternalAccountProblemKeySpecifier);
    fields?: ToggleLoginWithExternalAccountProblemFieldPolicy;
  };
  ToggleLoginWithPasswordAndSmsPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ToggleLoginWithPasswordAndSmsPayloadKeySpecifier
      | (() => undefined | ToggleLoginWithPasswordAndSmsPayloadKeySpecifier);
    fields?: ToggleLoginWithPasswordAndSmsPayloadFieldPolicy;
  };
  ToggleLoginWithPasswordAndSmsProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | ToggleLoginWithPasswordAndSmsProblemKeySpecifier
      | (() => undefined | ToggleLoginWithPasswordAndSmsProblemKeySpecifier);
    fields?: ToggleLoginWithPasswordAndSmsProblemFieldPolicy;
  };
  Trancsaction?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | TrancsactionKeySpecifier | (() => undefined | TrancsactionKeySpecifier);
    fields?: TrancsactionFieldPolicy;
  };
  UnbindExternalAccountPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | UnbindExternalAccountPayloadKeySpecifier
      | (() => undefined | UnbindExternalAccountPayloadKeySpecifier);
    fields?: UnbindExternalAccountPayloadFieldPolicy;
  };
  UnbindExternalAccountProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | UnbindExternalAccountProblemKeySpecifier
      | (() => undefined | UnbindExternalAccountProblemKeySpecifier);
    fields?: UnbindExternalAccountProblemFieldPolicy;
  };
  UpdateDocumentPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | UpdateDocumentPayloadKeySpecifier
      | (() => undefined | UpdateDocumentPayloadKeySpecifier);
    fields?: UpdateDocumentPayloadFieldPolicy;
  };
  UpdateDocumentProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | UpdateDocumentProblemKeySpecifier
      | (() => undefined | UpdateDocumentProblemKeySpecifier);
    fields?: UpdateDocumentProblemFieldPolicy;
  };
  UpdatePersonalInfoPayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | UpdatePersonalInfoPayloadKeySpecifier
      | (() => undefined | UpdatePersonalInfoPayloadKeySpecifier);
    fields?: UpdatePersonalInfoPayloadFieldPolicy;
  };
  UpdatePersonalInfoProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | UpdatePersonalInfoProblemKeySpecifier
      | (() => undefined | UpdatePersonalInfoProblemKeySpecifier);
    fields?: UpdatePersonalInfoProblemFieldPolicy;
  };
  VehicleRegistrationCertificateDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | VehicleRegistrationCertificateDocumentKeySpecifier
      | (() => undefined | VehicleRegistrationCertificateDocumentKeySpecifier);
    fields?: VehicleRegistrationCertificateDocumentFieldPolicy;
  };
  VerifyCodeToBindPrimaryPhonePayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | VerifyCodeToBindPrimaryPhonePayloadKeySpecifier
      | (() => undefined | VerifyCodeToBindPrimaryPhonePayloadKeySpecifier);
    fields?: VerifyCodeToBindPrimaryPhonePayloadFieldPolicy;
  };
  VerifyCodeToBindPrimaryPhoneProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | VerifyCodeToBindPrimaryPhoneProblemKeySpecifier
      | (() => undefined | VerifyCodeToBindPrimaryPhoneProblemKeySpecifier);
    fields?: VerifyCodeToBindPrimaryPhoneProblemFieldPolicy;
  };
  VerifyCodeToConfirmPhonePayload?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | VerifyCodeToConfirmPhonePayloadKeySpecifier
      | (() => undefined | VerifyCodeToConfirmPhonePayloadKeySpecifier);
    fields?: VerifyCodeToConfirmPhonePayloadFieldPolicy;
  };
  VerifyCodeToConfirmPhoneProblem?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | VerifyCodeToConfirmPhoneProblemKeySpecifier
      | (() => undefined | VerifyCodeToConfirmPhoneProblemKeySpecifier);
    fields?: VerifyCodeToConfirmPhoneProblemFieldPolicy;
  };
  Viewer?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?: false | ViewerKeySpecifier | (() => undefined | ViewerKeySpecifier);
    fields?: ViewerFieldPolicy;
  };
  VoluntaryMedicalInsuranceDocument?: Omit<TypePolicy, 'fields' | 'keyFields'> & {
    keyFields?:
      | false
      | VoluntaryMedicalInsuranceDocumentKeySpecifier
      | (() => undefined | VoluntaryMedicalInsuranceDocumentKeySpecifier);
    fields?: VoluntaryMedicalInsuranceDocumentFieldPolicy;
  };
};
export type TypedTypePolicies = StrictTypedTypePolicies & TypePolicies;
