import { useState } from 'react';

import { canUseDom } from '@client/shared/libs/can-use-dom';
import { useEnvContext } from '@client/shared/libs/env';
import { useIsomorphicLayoutEffect } from '@use-platform/react/libs/isomorphic-layout-effect';
import { useMatchMedia } from '@yandex-id/components/utils';

const canShare = canUseDom && typeof navigator.share === 'function';

export function useDevice() {
  const context = useEnvContext();
  const matchedTouch = useMatchMedia('(max-width: 520px)');
  const [isTouch, setTouch] = useState(context.ua.isTouch);
  const isIos = context.ua.mobileOsFamily === 'ios';

  useIsomorphicLayoutEffect(() => {
    if (matchedTouch !== null) {
      setTouch(matchedTouch);
    }
  }, [matchedTouch]);

  return {
    isTouch,
    canShare,
    isIos,
  };
}
