import { useEffect } from 'react';

import { useClientHeight } from '@client/shared/libs/use-client-height';

import { useDevice } from './use-device';

/**
 * Небольшая надстройка над скроллокером, фиксящая поведение нижней панели на iOS.
 * Дело в том, что хотя скроллокер в Lego и содержит фикс для скролла на iOS, он
 * все же не решает проблему с поведением нижней панели, которая продолжает скрываться, в сильно
 * отдельных случаях порождая нежелательные сдвиги контента. Поскольку фиксить эту беду нужно редко,
 * решил вынести в отдельный хук и положить здесь, а не лечить во всем Lego, тем более, что тут
 * хардкорный патчинг глобальных стилей идет.
 *
 * Идея фикса взята отсюда: https://stackoverflow.com/questions/3047337/does-overflowhidden-applied-to-body-work-on-iphone-safari
 */
export const useIosBottomPanelFreeze = (active?: boolean) => {
  const clientHeight = useClientHeight();
  const { isIos } = useDevice();

  useEffect(() => {
    if (!active || !isIos) {
      return;
    }

    const initialHtmlStyle = { ...document.documentElement.style };
    const initialBodyStyle = { ...document.body.style };

    document.documentElement.style.overflow = 'hidden';
    document.documentElement.style.height = `${clientHeight}px`;
    document.documentElement.style.position = 'relative';
    document.body.style.overflow = 'hidden';
    document.body.style.height = '100%';
    document.body.style.position = 'relative';
    document.body.style.minHeight = 'initial';

    return () => {
      document.documentElement.style.overflow = 'auto';
      document.documentElement.style.height = initialHtmlStyle.height;
      document.documentElement.style.position = initialHtmlStyle.position;
      document.body.style.overflow = 'auto';
      document.body.style.height = initialBodyStyle.height;
      document.body.style.position = initialBodyStyle.position;
      document.body.style.minHeight = initialBodyStyle.minHeight;
    };
  }, [active, clientHeight, isIos]);
};
