import React, { SVGAttributes, forwardRef } from 'react';

export interface AllowProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Allow = forwardRef<SVGSVGElement, AllowProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9 15.9971C9.60498 15.9971 10.1678 16.0334 10.6893 16.1054C11.134 15.3993 11.7695 14.8254 12.5234 14.4562C11.4852 14.1489 10.3091 13.9971 9 13.9971C6.08837 13.9971 3.8345 14.7484 2.29289 16.29C1.90237 16.6805 1.90237 17.3137 2.29289 17.7042C2.68342 18.0947 3.31658 18.0947 3.70711 17.7042C4.83217 16.5791 6.5783 15.9971 9 15.9971ZM9.00102 12.7971C6.37115 12.7971 4.5 10.1048 4.5 6.96753C4.5 3.99707 6.09615 1.99707 9.00102 1.99707C11.9059 1.99707 13.5 3.99707 13.5 6.96753C13.5 10.1048 11.6309 12.7971 9.00102 12.7971ZM9.00102 10.7971C10.3075 10.7971 11.5 9.20127 11.5 6.96753C11.5 4.9581 10.6599 3.99707 9.00102 3.99707C7.34134 3.99707 6.5 4.95891 6.5 6.96753C6.5 9.20054 7.6938 10.7971 9.00102 10.7971ZM22 17.5L17 22V19.5C17 19.5 13.5 19 11.5 21C11.5 16 17 15.5 17 15.5V13L22 17.5Z"
        fill="currentColor"
      />
    </svg>
  );
});
