import React, { SVGAttributes, forwardRef } from 'react';

export interface BadgeProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Badge = forwardRef<SVGSVGElement, BadgeProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12 1C11.4477 1 11 1.44772 11 2V4H7C5.89543 4 5 4.89543 5 6V20C5 21.1046 5.89543 22 7 22H17C18.1046 22 19 21.1046 19 20V6C19 4.89543 18.1046 4 17 4H13V2C13 1.44772 12.5523 1 12 1ZM7 20V6H17V20H7ZM14.5746 7.99524C14.2487 8.05635 13.8973 7.97911 13.4854 7.88856C13.0884 7.80128 12.635 7.70163 12.094 7.70163C10.9586 7.70163 9.00617 8.48262 9.66488 10.7985L9.66641 10.8461L9.65266 10.8447C9.19642 10.8 8.98505 11.4422 9.27475 12.1138C9.44442 12.5072 9.81548 12.7905 10.0555 12.7106C10.4595 13.6808 11.1563 14.3626 12.0593 14.3626C12.9596 14.3626 13.6224 13.6849 14.0015 12.7195C14.2399 12.7436 14.5686 12.4741 14.7253 12.1107C15.0111 11.4481 14.8092 10.8141 14.3656 10.8401C14.3679 10.7703 14.369 10.7003 14.369 10.6301C14.369 10.2763 14.3165 9.93248 14.2147 9.61592C14.7346 8.93519 14.5746 7.99524 14.5746 7.99524ZM9 17C9 16.4477 9.44772 16 10 16H14C14.5523 16 15 16.4477 15 17C15 17.5523 14.5523 18 14 18H10C9.44772 18 9 17.5523 9 17Z"
        fill="#262633"
      />
    </svg>
  );
});
