import React, { SVGAttributes, forwardRef } from 'react';

export interface BusinessProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Business = forwardRef<SVGSVGElement, BusinessProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M15.5022 3H8.5022C7.67377 3 7.0022 3.67157 7.0022 4.5V6.99994H5.0022C3.89763 6.99994 3.0022 7.89537 3.0022 8.99994V18.9999C3.0022 20.1045 3.89763 20.9999 5.0022 20.9999H19.0022C20.1068 20.9999 21.0022 20.1045 21.0022 18.9999V8.99994C21.0022 7.89537 20.1068 6.99994 19.0022 6.99994H17.0022V4.5C17.0022 3.67157 16.3306 3 15.5022 3ZM9.0022 6.99994H15.0022V5H9.0022V6.99994ZM18.5022 9C18.7783 9 19.0022 9.22386 19.0022 9.5V10.9686C14.5803 13.8438 9.42413 13.8438 5.0022 10.9687V9.5C5.0022 9.22386 5.22606 9 5.5022 9H18.5022ZM14.002 14.9813C15.7082 14.7354 17.3932 14.1737 19.0022 13.2962V13.6748V18.5C19.0022 18.7761 18.7783 19 18.5022 19H5.5022C5.22605 19 5.0022 18.7761 5.0022 18.5V13.6748V13.2962C6.61122 14.1737 8.29616 14.7354 10.0024 14.9813M14.002 14.9813V14.9814V14.9813ZM14.002 14.9814C14.0021 14.9876 14.0022 14.9938 14.0022 15V16C14.0022 16.5523 13.5545 17 13.0022 17H11.0022C10.4499 17 10.0022 16.5523 10.0022 16V15C10.0022 14.9938 10.0023 14.9876 10.0024 14.9813"
        fill="currentColor"
      />
    </svg>
  );
});
