import React, { SVGAttributes, forwardRef } from 'react';

export interface CameraProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Camera = forwardRef<SVGSVGElement, CameraProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.0097 3.00195H13.9903C14.7836 3.00195 15.0674 3.04723 15.3751 3.14644C15.6827 3.24566 15.9494 3.39881 16.1901 3.61455C16.4308 3.83029 16.6129 4.0527 17.0126 4.73789L17.75 6.00195H19.2951C20.4095 6.00195 20.8137 6.11799 21.2211 6.33587C21.6285 6.55375 21.9482 6.87349 22.1661 7.2809C22.384 7.6883 22.5 8.09241 22.5 9.20681V16.7971C22.5 17.9115 22.384 18.3156 22.1661 18.723C21.9482 19.1304 21.6285 19.4502 21.2211 19.668C20.8137 19.8859 20.4095 20.002 19.2951 20.002H5.70486C4.59046 20.002 4.18635 19.8859 3.77894 19.668C3.37154 19.4502 3.0518 19.1304 2.83392 18.723C2.61603 18.3156 2.5 17.9115 2.5 16.7971V9.20681C2.5 8.09241 2.61603 7.6883 2.83392 7.2809C3.0518 6.87349 3.37154 6.55375 3.77894 6.33587C4.18635 6.11799 4.59046 6.00195 5.70486 6.00195H7.25L7.98737 4.73789C8.38707 4.0527 8.56922 3.83029 8.80993 3.61455C9.05064 3.39881 9.31728 3.24566 9.62492 3.14644C9.93256 3.04723 10.2164 3.00195 11.0097 3.00195ZM11.0097 5.00195C10.4639 5.00195 10.3459 5.01538 10.2388 5.04991C10.1978 5.06311 10.1768 5.07517 10.1448 5.10389C10.061 5.17898 9.98995 5.27417 9.71493 5.74564L8.97756 7.0097C8.61914 7.62413 7.96133 8.00195 7.25 8.00195H5.70486C5.27844 8.00195 5.01125 8.02094 4.85599 8.05093C4.79517 8.06267 4.78173 8.06762 4.72214 8.0995C4.66327 8.13098 4.62903 8.16522 4.59754 8.22409C4.56567 8.28369 4.56072 8.29712 4.54897 8.35794C4.51899 8.51321 4.5 8.7804 4.5 9.20681V16.7971C4.5 17.2235 4.51899 17.4907 4.54897 17.646C4.56072 17.7068 4.56567 17.7202 4.59754 17.7798C4.62903 17.8387 4.66327 17.8729 4.72214 17.9044C4.78173 17.9363 4.79517 17.9412 4.85599 17.953C5.01125 17.983 5.27844 18.002 5.70486 18.002H19.2951C19.7216 18.002 19.9887 17.983 20.144 17.953C20.2048 17.9412 20.2183 17.9363 20.2779 17.9044C20.3367 17.8729 20.371 17.8387 20.4025 17.7798C20.4343 17.7202 20.4393 17.7068 20.451 17.646C20.481 17.4907 20.5 17.2235 20.5 16.7971V9.20681C20.5 8.7804 20.481 8.51321 20.451 8.35794C20.4393 8.29712 20.4343 8.28369 20.4025 8.22409C20.371 8.16522 20.3367 8.13098 20.2779 8.0995C20.2183 8.06762 20.2048 8.06267 20.144 8.05093C19.9887 8.02094 19.7216 8.00195 19.2951 8.00195H17.75C17.0387 8.00195 16.3809 7.62413 16.0224 7.0097L15.2851 5.74564C15.01 5.27417 14.939 5.17898 14.8552 5.10389C14.8232 5.07517 14.8022 5.06311 14.7612 5.04991C14.6541 5.01538 14.5361 5.00195 13.9903 5.00195H11.0097ZM12.5 16.002C10.2909 16.002 8.5 14.2111 8.5 12.002C8.5 9.79281 10.2909 8.00195 12.5 8.00195C14.7091 8.00195 16.5 9.79281 16.5 12.002C16.5 14.2111 14.7091 16.002 12.5 16.002ZM12.5 14.002C13.6046 14.002 14.5 13.1065 14.5 12.002C14.5 10.8974 13.6046 10.002 12.5 10.002C11.3954 10.002 10.5 10.8974 10.5 12.002C10.5 13.1065 11.3954 14.002 12.5 14.002Z"
        fill="#361600"
      />
    </svg>
  );
});
