import React, { SVGAttributes, forwardRef } from 'react';

export interface CameraSmallProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 16
   */
  size?: 12 | 16 | 24 | 32;
}

export const CameraSmall = forwardRef<SVGSVGElement, CameraSmallProps>((props, ref) => {
  const { className, size = 16, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 17 17"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M1.91443 3.92113L3.4403 3.83394C3.78798 3.81407 4.10028 3.61476 4.26473 3.30779L4.93452 2.05751C5.28269 1.4076 5.96019 1.00195 6.69748 1.00195H10.3025C11.0398 1.00195 11.7173 1.4076 12.0655 2.05751L12.7353 3.30779C12.8997 3.61476 13.212 3.81407 13.5597 3.83394L15.0856 3.92113C15.8795 3.96649 16.5 4.6235 16.5 5.41869V13.502C16.5 14.3304 15.8284 15.002 15 15.002H2C1.17157 15.002 0.5 14.3304 0.5 13.502V5.41869C0.5 4.6235 1.12054 3.96649 1.91443 3.92113ZM2.5 5.89093V13.002H14.5V5.89093L13.4456 5.83068C12.4026 5.77108 11.4657 5.17314 10.9723 4.25223L10.3025 3.00195H6.69748L6.02769 4.25223C5.53435 5.17314 4.59744 5.77108 3.5544 5.83068L2.5 5.89093ZM10.9 8.60195C10.9 9.92744 9.82548 11.002 8.5 11.002C7.17452 11.002 6.1 9.92744 6.1 8.60195C6.1 7.27647 7.17452 6.20195 8.5 6.20195C9.82548 6.20195 10.9 7.27647 10.9 8.60195Z"
        fill="#262633"
      />
    </svg>
  );
});
