import React, { SVGAttributes, forwardRef } from 'react';

export interface ChatBubbleProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const ChatBubble = forwardRef<SVGSVGElement, ChatBubbleProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 25 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.41902 15.8158L8.40264 15.8127C7.97309 15.73 7.52884 15.8389 7.18628 16.111C6.64567 16.5403 6.17989 16.8517 5.78894 17.0452C5.9625 16.6178 6.07411 16.2028 6.12376 15.8003C6.18708 15.287 6.0133 14.7728 5.65159 14.4032L5.49344 14.2416C4.41041 13.2054 3.80208 11.8442 3.80208 10.4C3.80208 7.3399 6.54792 4.8 10.0021 4.8C13.4562 4.8 16.2021 7.3399 16.2021 10.4C16.2021 13.4601 13.4562 16 10.0021 16C9.46102 16 8.93058 15.9376 8.41902 15.8158ZM3.71182 18.949C5.52563 18.8028 6.95574 18.3421 8.00215 17.5669C8.64136 17.7191 9.3115 17.8 10.0021 17.8C14.4204 17.8 18.0021 14.4869 18.0021 10.4C18.0021 6.31309 14.4204 3 10.0021 3C5.5838 3 2.00208 6.31309 2.00208 10.4C2.00208 12.4761 2.92635 14.3525 4.41503 15.6964C4.28444 16.6123 3.91282 17.4269 3.30017 18.1402C3.12358 18.3458 3.1471 18.6556 3.35268 18.8321C3.45201 18.9174 3.58131 18.9595 3.71182 18.949ZM16.8777 17.7472C15.6149 18.4209 13.8486 18.9009 11.3258 18.9864C12.3942 19.5974 13.6535 19.95 15.0018 19.95C16.1481 19.95 17.23 19.6951 18.185 19.2434C19.0537 19.7622 20.1716 20.0768 21.5386 20.1872C21.653 20.1965 21.7663 20.1596 21.8533 20.0849C22.0336 19.9302 22.0542 19.6587 21.8996 19.4785L21.8995 19.4785C21.285 18.7625 20.9478 17.9298 20.8882 16.9806C21.5929 15.9702 22.0018 14.7668 22.0018 13.475C22.0018 11.335 20.8795 9.43748 19.1496 8.25858C19.6142 9.19263 19.922 10.2478 20.0464 11.4161C20.175 12.6227 20.1409 13.5324 19.9549 14.2728C19.8384 14.7749 19.6333 15.2637 19.3444 15.7212L19.3181 15.766C19.0359 16.2475 19.0079 16.8368 19.2433 17.3428C19.3556 17.5842 19.4988 17.8242 19.6728 18.0628C19.3566 17.9937 18.984 17.8447 18.5547 17.616C18.1226 17.3857 17.6053 17.3808 17.1689 17.6029L17.0759 17.6501C17.0105 17.683 16.9444 17.7155 16.8777 17.7472Z"
        fill="currentColor"
      />
    </svg>
  );
});
