import React, { SVGAttributes, forwardRef } from 'react';

export interface ChatOutlineProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const ChatOutline = forwardRef<SVGSVGElement, ChatOutlineProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.4866 16.3676C11.8244 16.1284 12.2282 16 12.6421 16H19.5021C19.7782 16 20.0021 15.7761 20.0021 15.5V6.5C20.0021 6.22386 19.7782 6 19.5021 6H4.50208C4.22593 6 4.00208 6.22386 4.00208 6.5V15.5C4.00208 15.7761 4.22593 16 4.50208 16H7.00208C7.55436 16 8.00208 16.4477 8.00208 17V18.834L11.4866 16.3676ZM12.6421 18H19.5021C20.8828 18 22.0021 16.8807 22.0021 15.5V6.5C22.0021 5.11929 20.8828 4 19.5021 4H4.50208C3.12136 4 2.00208 5.11929 2.00208 6.5V15.5C2.00208 16.8807 3.12136 18 4.50208 18H6.00208V21.2503C6.00208 21.8588 6.68867 22.214 7.18538 21.8624L12.6421 18Z"
        fill="currentColor"
      />
    </svg>
  );
});
