import React, { SVGAttributes, forwardRef } from 'react';

export interface CheckOutlineProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const CheckOutline = forwardRef<SVGSVGElement, CheckOutlineProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM16.6607 8.25136C16.2451 7.88754 15.6134 7.92946 15.2496 8.34498L10.7332 13.5033L8.73739 11.3245C8.36434 10.9173 7.73178 10.8896 7.32454 11.2626C6.91729 11.6357 6.88957 12.2682 7.26262 12.6755L9.63551 15.2659C10.1951 15.8767 11.1439 15.9183 11.7548 15.3588C11.7847 15.3303 11.7997 15.3161 11.8141 15.3014C11.8285 15.2866 11.8424 15.2713 11.8701 15.2408L16.7543 9.66247C17.1181 9.24695 17.0762 8.61517 16.6607 8.25136Z"
        fill="currentColor"
      />
    </svg>
  );
});
