import React, { SVGAttributes, forwardRef } from 'react';

export interface ChildProfileProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const ChildProfile = forwardRef<SVGSVGElement, ChildProfileProps>((props, ref) => {
  const { className, size = 16, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 16 16"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M3.05248 5.20794C3.18338 5.34596 3.22462 5.5463 3.15888 5.72481L2.83683 6.59926C2.61964 7.18899 2.50012 7.82828 2.50012 8.5C2.50012 11.5376 4.96256 14 8.00012 14C11.0377 14 13.5001 11.5376 13.5001 8.5C13.5001 7.82823 13.3806 7.18889 13.1634 6.59912L12.8413 5.72472C12.7756 5.54623 12.8168 5.3459 12.9477 5.20787L13.5889 4.53171C13.8455 4.26103 14 3.90071 14 3.5C14 2.67157 13.3284 2 12.5 2C12.0439 2 11.6369 2.20111 11.3587 2.52653L10.7542 3.2337C10.6307 3.37809 10.4362 3.44006 10.252 3.39365L9.3498 3.16633C8.92004 3.05804 8.46828 3 8.00012 3C7.53191 3 7.0801 3.05806 6.65029 3.16637L5.7481 3.39372C5.5639 3.44014 5.36929 3.37817 5.24586 3.23377L4.64131 2.52655C4.36313 2.20112 3.95611 2 3.5 2C2.67157 2 2 2.67157 2 3.5C2 3.90074 2.15451 4.2611 2.41122 4.53179L3.05248 5.20794ZM6.46378 1.1575C6.2778 1.19621 6.08559 1.13341 5.94993 1.00043C5.31862 0.381583 4.45387 0 3.5 0C1.567 0 0 1.567 0 3.5C0 4.32129 0.28288 5.07651 0.756523 5.67355C0.874747 5.82257 0.917062 6.02061 0.858827 6.2017C0.62591 6.92598 0.500122 7.6983 0.500122 8.5C0.500122 12.6421 3.85799 16 8.00012 16C12.1423 16 15.5001 12.6421 15.5001 8.5C15.5001 7.69823 15.3743 6.92584 15.1414 6.2015C15.0831 6.02042 15.1254 5.82238 15.2436 5.67336C15.7172 5.07636 16 4.32121 16 3.5C16 1.567 14.433 0 12.5 0C11.5461 0 10.6814 0.381569 10.0501 1.00039C9.91445 1.13337 9.72225 1.19617 9.53627 1.15746C9.04042 1.05425 8.52661 1 8.00012 1C7.47357 1 6.9597 1.05426 6.46378 1.1575ZM6.5 6.6C6.5 7.20751 6.00751 7.7 5.4 7.7C4.79249 7.7 4.3 7.20751 4.3 6.6C4.3 5.99249 4.79249 5.5 5.4 5.5C6.00751 5.5 6.5 5.99249 6.5 6.6ZM8.82498 9.59107C9.30992 9.32096 9.63563 8.86528 9.63563 8.56384C9.63563 7.87307 8.90336 7.66948 8.00004 7.66948C7.09673 7.66948 6.36445 7.87307 6.36445 8.56384C6.36445 8.86526 6.69011 9.32089 7.17498 9.59101V10.1185C6.92993 10.2849 6.68584 10.3329 6.48111 10.3383C6.34069 10.342 6.21949 10.3247 6.1359 10.3071C6.09478 10.2984 6.0648 10.2901 6.04861 10.2852L6.03691 10.2815C5.61316 10.1276 5.1432 10.3427 4.98354 10.7657C4.82266 11.192 5.0378 11.668 5.46409 11.8289L5.7554 11.057C5.46409 11.8289 5.46446 11.829 5.46485 11.8291L5.46564 11.8294L5.46732 11.8301L5.47105 11.8315L5.47997 11.8347L5.50357 11.8429C5.52181 11.8492 5.54511 11.8568 5.57306 11.8652C5.62883 11.882 5.70391 11.9023 5.79509 11.9215C5.97612 11.9597 6.22857 11.9955 6.52431 11.9877C6.95754 11.9764 7.48469 11.8701 8 11.5502C8.51531 11.8701 9.04246 11.9764 9.47569 11.9877C9.77143 11.9955 10.0239 11.9597 10.2049 11.9215C10.2961 11.9022 10.3712 11.8819 10.4269 11.8652C10.4549 11.8567 10.4782 11.8492 10.4964 11.8429L10.52 11.8347L10.5289 11.8314L10.5327 11.8301L10.5343 11.8294L10.5351 11.8291C10.5355 11.829 10.5359 11.8288 10.2446 11.057L10.5359 11.8288C10.9622 11.668 11.1773 11.1919 11.0164 10.7657C10.8568 10.3427 10.3868 10.1276 9.96308 10.2815L9.95135 10.2852C9.93516 10.2901 9.90519 10.2984 9.86407 10.3071C9.78049 10.3247 9.6593 10.342 9.5189 10.3383C9.31417 10.3329 9.07007 10.2849 8.82498 10.1185V9.59107ZM11.7 6.6C11.7 7.20751 11.2075 7.7 10.6 7.7C9.99249 7.7 9.5 7.20751 9.5 6.6C9.5 5.99249 9.99249 5.5 10.6 5.5C11.2075 5.5 11.7 5.99249 11.7 6.6Z"
        fill="currentColor"
      />
    </svg>
  );
});
