import React, { SVGAttributes, forwardRef } from 'react';

export interface CommentsOutlineProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const CommentsOutline = forwardRef<SVGSVGElement, CommentsOutlineProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.41694 15.8158L8.40056 15.8127C7.97101 15.73 7.52677 15.8389 7.1842 16.111C6.6436 16.5403 6.17782 16.8517 5.78687 17.0452C5.96042 16.6178 6.07203 16.2028 6.12168 15.8003C6.185 15.287 6.01123 14.7728 5.64952 14.4032L5.49137 14.2416C4.40834 13.2054 3.8 11.8442 3.8 10.4C3.8 7.3399 6.54584 4.8 10 4.8C13.4542 4.8 16.2 7.3399 16.2 10.4C16.2 13.4601 13.4542 16 10 16C9.45895 16 8.9285 15.9376 8.41694 15.8158ZM3.70974 18.949C5.52356 18.8028 6.95367 18.3421 8.00007 17.5669C8.63929 17.7191 9.30943 17.8 10 17.8C14.4183 17.8 18 14.4869 18 10.4C18 6.31309 14.4183 3 10 3C5.58172 3 2 6.31309 2 10.4C2 12.4761 2.92427 14.3525 4.41296 15.6964C4.28236 16.6123 3.91074 17.4269 3.29809 18.1402C3.12151 18.3458 3.14503 18.6556 3.35061 18.8321C3.44993 18.9174 3.57923 18.9595 3.70974 18.949ZM16.8756 17.7472C15.6129 18.4209 13.8465 18.9009 11.3237 18.9864C12.3921 19.5974 13.6514 19.95 14.9998 19.95C16.146 19.95 17.2279 19.6951 18.1829 19.2434C19.0516 19.7622 20.1695 20.0768 21.5366 20.1872C21.6509 20.1965 21.7642 20.1596 21.8513 20.0849C22.0315 19.9302 22.0522 19.6587 21.8975 19.4785L21.8975 19.4785C21.2829 18.7625 20.9458 17.9298 20.8861 16.9806C21.5908 15.9702 21.9998 14.7668 21.9998 13.475C21.9998 11.335 20.8774 9.43748 19.1475 8.25858C19.6121 9.19263 19.9199 10.2478 20.0444 11.4161C20.1729 12.6227 20.1388 13.5324 19.9528 14.2728C19.8363 14.7749 19.6312 15.2637 19.3423 15.7212L19.316 15.766C19.0338 16.2475 19.0059 16.8368 19.2412 17.3428C19.3536 17.5842 19.4967 17.8242 19.6707 18.0628C19.3546 17.9937 18.9819 17.8447 18.5526 17.616C18.1205 17.3857 17.6032 17.3808 17.1668 17.6029L17.0738 17.6501C17.0084 17.683 16.9423 17.7155 16.8756 17.7472Z"
        fill="currentColor"
      />
    </svg>
  );
});
