import React, { SVGAttributes, forwardRef } from 'react';

export interface CopyProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Copy = forwardRef<SVGSVGElement, CopyProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8 5.00195H10H15.7951C16.9095 5.00195 17.3137 5.11799 17.7211 5.33587C18.1285 5.55375 18.4482 5.87349 18.6661 6.2809C18.884 6.6883 19 7.09241 19 8.20681V16.002C19 16.5542 19.4477 17.002 20 17.002C20.5523 17.002 21 16.5542 21 16.002V8.12972C21 6.34669 20.8143 5.70011 20.4657 5.04826C20.1171 4.39641 19.6055 3.88483 18.9537 3.53622C18.3018 3.1876 17.6553 3.00195 15.8722 3.00195H10H8C7.44772 3.00195 7 3.44967 7 4.00195C7 4.55424 7.44772 5.00195 8 5.00195ZM6.20486 7.00195C5.32287 7.00195 4.81249 7.05053 4.27894 7.33587C3.87153 7.55375 3.5518 7.87349 3.33392 8.2809C3.04857 8.81444 3 9.32482 3 10.2068V17.7971C3 18.6791 3.04857 19.1895 3.33392 19.723C3.5518 20.1304 3.87153 20.4502 4.27894 20.668C4.81249 20.9534 5.32287 21.002 6.20486 21.002H13.7951C14.6771 21.002 15.1875 20.9534 15.7211 20.668C16.1285 20.4502 16.4482 20.1304 16.6661 19.723C16.9514 19.1895 17 18.6791 17 17.7971V10.2068C17 9.32482 16.9514 8.81444 16.6661 8.2809C16.4482 7.87349 16.1285 7.55375 15.7211 7.33587C15.1875 7.05053 14.6771 7.00195 13.7951 7.00195H6.20486ZM5.22214 9.09949C5.27244 9.07259 5.3124 9.05469 5.41912 9.03807C5.55707 9.01657 5.78184 9.00195 6.20486 9.00195H13.7951C14.2182 9.00195 14.4429 9.01657 14.5809 9.03807C14.6876 9.05469 14.7276 9.07259 14.7779 9.09949C14.8367 9.13098 14.871 9.16522 14.9025 9.22409C14.9294 9.2744 14.9473 9.31435 14.9639 9.42107C14.9854 9.55902 15 9.7838 15 10.2068V17.7971C15 18.2201 14.9854 18.4449 14.9639 18.5828C14.9473 18.6896 14.9294 18.7295 14.9025 18.7798C14.871 18.8387 14.8367 18.8729 14.7779 18.9044C14.7276 18.9313 14.6876 18.9492 14.5809 18.9658C14.4429 18.9873 14.2182 19.002 13.7951 19.002H6.20486C5.78184 19.002 5.55707 18.9873 5.41912 18.9658C5.3124 18.9492 5.27244 18.9313 5.22214 18.9044C5.16327 18.8729 5.12903 18.8387 5.09754 18.7798C5.07064 18.7295 5.05274 18.6896 5.03611 18.5828C5.01462 18.4449 5 18.2201 5 17.7971V10.2068C5 9.7838 5.01462 9.55902 5.03611 9.42107C5.05274 9.31436 5.07064 9.2744 5.09754 9.22409C5.12903 9.16522 5.16327 9.13098 5.22214 9.09949Z"
        fill="currentColor"
      />
    </svg>
  );
});
