import React, { SVGAttributes, forwardRef } from 'react';

export interface DataEraseProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const DataErase = forwardRef<SVGSVGElement, DataEraseProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.9902 2.00098H8.20385C7.08945 2.00098 6.68534 2.11701 6.27794 2.33489C5.87053 2.55278 5.55079 2.87251 5.33291 3.27992C5.11502 3.68733 4.99899 4.09143 4.99899 5.20583V12.001H6.99899V5.20583C6.99899 4.77942 7.01798 4.51223 7.04797 4.35697C7.05971 4.29614 7.06466 4.28271 7.09654 4.22312C7.12802 4.16425 7.16226 4.13 7.22113 4.09852C7.28073 4.06665 7.29416 4.06169 7.35498 4.04995C7.51025 4.01997 7.77744 4.00098 8.20385 4.00098H10.999V6.79612C10.999 7.91052 11.115 8.31463 11.3329 8.72203C11.5508 9.12944 11.8705 9.44918 12.2779 9.66706C12.6853 9.88494 13.0895 10.001 14.2038 10.001H16.999V12.001H18.999V9.00979C18.999 8.23517 18.9709 7.96721 18.9025 7.67022C18.834 7.37323 18.7252 7.11045 18.5636 6.85205C18.402 6.59365 18.2324 6.38434 17.6846 5.8366L15.1634 3.31536C14.6156 2.76761 14.4063 2.59797 14.1479 2.43637C13.8895 2.27477 13.6267 2.16592 13.3297 2.09747C13.0328 2.02902 12.7648 2.00098 11.9902 2.00098ZM16.9155 8.00098C16.9028 7.972 16.8874 7.94363 16.8679 7.91252C16.7894 7.78693 16.6872 7.66758 16.2704 7.25081L13.7492 4.72957C13.3324 4.3128 13.213 4.21061 13.0875 4.13207C13.0563 4.11262 13.028 4.09721 12.999 4.08447V6.79612C12.999 7.22253 13.018 7.48972 13.048 7.64499C13.0597 7.70581 13.0647 7.71924 13.0965 7.77884C13.128 7.83771 13.1623 7.87195 13.2211 7.90343C13.2807 7.93531 13.2942 7.94026 13.355 7.952C13.5102 7.98199 13.7774 8.00098 14.2038 8.00098H16.9155ZM6.99899 16.001H8.99899V18.001H6.99899V16.001ZM6.99899 16.001H4.99899V14.001H6.99899V16.001ZM6.99899 20.001V18.001H4.99899V20.001H6.99899ZM8.99899 20.001V18.001H10.999V20.001H8.99899ZM12.999 20.001H10.999V22.001H12.999V20.001ZM12.999 18.001V20.001H14.999V22.001H16.999V20.001H18.999V18.001H16.999V16.001H18.999V14.001H16.999V16.001H14.999V14.001H12.999V16.001H10.999V14.001H8.99899V16.001H10.999V18.001H12.999ZM14.999 18.001V20.001H16.999V18.001H14.999ZM14.999 18.001H12.999V16.001H14.999V18.001ZM8.99899 20.001H6.99899V22.001H8.99899V20.001Z"
        fill="#262633"
      />
    </svg>
  );
});
